/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling;

import com.amazonaws.xray.entities.SearchPattern;
import com.amazonaws.xray.strategy.sampling.Reservoir;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SamplingRule {
    private static final Log logger = LogFactory.getLog(SamplingRule.class);
    private String serviceName;
    private String httpMethod;
    private String urlPath;
    private int fixedTarget = -1;
    private float rate = -1.0f;
    private Reservoir reservoir;

    public SamplingRule() {
        this.reservoir = new Reservoir();
    }

    public SamplingRule(String serviceName, String httpMethod, String urlPath, int fixedTarget, float rate) {
        this.serviceName = serviceName;
        this.httpMethod = httpMethod;
        this.urlPath = urlPath;
        this.fixedTarget = fixedTarget;
        this.rate = rate;
        this.reservoir = new Reservoir(fixedTarget);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    public int getFixedTarget() {
        return this.fixedTarget;
    }

    public void setFixedTarget(int fixedTarget) {
        this.fixedTarget = fixedTarget;
        this.reservoir = new Reservoir(fixedTarget);
    }

    public float getRate() {
        return this.rate;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public Reservoir getReservoir() {
        return this.reservoir;
    }

    public String toString() {
        return "\n\tservice_name: " + this.serviceName + "\n\thttp_method: " + this.httpMethod + "\n\turl_path: " + this.urlPath + "\n\tfixed_target: " + this.fixedTarget + "\n\trate: " + this.rate;
    }

    public boolean appliesTo(String requestServiceName, String requestPath, String requestMethod) {
        return !(null != this.serviceName && !SearchPattern.wildcardMatch(this.serviceName, requestServiceName) || null != requestPath && !SearchPattern.wildcardMatch(this.urlPath, requestPath) || null != requestMethod && !SearchPattern.wildcardMatch(this.httpMethod, requestMethod));
    }
}

