/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.scala;

import com.amazonaws.scala.AggregatorModel;
import com.amazonaws.scala.Freemarker;
import com.amazonaws.scala.ModuleModel;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public final class ProjectGenerator {
    private final File baseDir;
    private final Freemarker freemarker;
    private final ObjectMapper mapper;

    public ProjectGenerator(File baseDir) {
        this(baseDir, new Freemarker(), new ObjectMapper((JsonFactory)new YAMLFactory()));
    }

    public ProjectGenerator(File baseDir, Freemarker freemarker, ObjectMapper mapper) {
        this.baseDir = baseDir;
        this.freemarker = freemarker;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, TemplateException {
        File configFile = new File(this.baseDir, "config.yaml");
        AggregatorModel aggregator = (AggregatorModel)this.mapper.readValue(configFile, AggregatorModel.class);
        File project = new File(this.baseDir, "project");
        this.mkdir(project);
        Template pom = this.freemarker.getPomTemplate();
        for (ModuleModel module : aggregator.getModules()) {
            File dir = new File(project, module.getName());
            this.mkdir(dir);
            FileWriter writer = new FileWriter(new File(dir, "pom.xml"));
            try {
                pom.process((Object)module, (Writer)writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        Template agg = this.freemarker.getAggregatorTemplate();
        FileWriter writer = new FileWriter(new File(project, "pom.xml"));
        try {
            agg.process((Object)aggregator, (Writer)writer);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    private void mkdir(File dir) throws IOException {
        if (dir.exists()) {
            for (String file : dir.list()) {
                this.delete(new File(dir, file));
            }
        } else if (!dir.mkdirs()) {
            throw new IOException("Error creating directory " + dir);
        }
    }

    private void delete(File file) throws IOException {
        if (file.isDirectory()) {
            for (String f : file.list()) {
                this.delete(new File(file, f));
            }
        }
        if (!file.delete()) {
            throw new IOException("Could not delete " + file);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("usage: generator <basedir>");
            System.exit(-1);
        }
        File baseDir = new File(args[0]);
        System.out.println("Using baseDir: " + baseDir.getAbsolutePath());
        new ProjectGenerator(baseDir).generate();
    }
}

