/*
 * Decompiled with CFR 0.152.
 */
package com.anatawa12.modPatching.resourcesDev.lib.core;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class LWClassTransformer
implements IClassTransformer {
    private static boolean isSrg = false;
    private static final int ASM_VERSION;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (!"net.minecraft.client.Minecraft".equals(transformedName)) {
            return basicClass;
        }
        ClassReader classReader = new ClassReader(basicClass);
        ClassWriter cw = new ClassWriter(0);
        classReader.accept((ClassVisitor)new MinecraftVisitor(cw), 0);
        return cw.toByteArray();
    }

    static {
        Class<Opcodes> opcodes = Opcodes.class;
        int asm_version = 327680;
        for (int i = 9; i >= 5; --i) {
            try {
                asm_version = opcodes.getField("ASM" + i).getInt(null);
                break;
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                continue;
            }
        }
        ASM_VERSION = asm_version;
    }

    private static class InitMethodVisitor
    extends MethodVisitor {
        public InitMethodVisitor(MethodVisitor mv) {
            super(ASM_VERSION, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (opcode == 182 && ("cpw/mods/fml/client/FMLClientHandler".equals(owner) || "net/minecraftforge/fml/client/FMLClientHandler".equals(owner)) && "beginMinecraftLoading".equals(name)) {
                super.visitIntInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/Minecraft", isSrg ? "field_110449_ao" : "defaultResourcePacks", "Ljava/util/List;");
                super.visitMethodInsn(184, "com/anatawa12/modPatching/resourcesDev/lib/ResourcePackManager", "init", "(Ljava/util/List;)V", false);
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }
    }

    private static class MinecraftVisitor
    extends ClassVisitor {
        public MinecraftVisitor(ClassWriter cv) {
            super(ASM_VERSION, (ClassVisitor)cv);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (mv == null) {
                return null;
            }
            if ("()V".equals(descriptor) && ("init".equals(name) || "startGame".equals(name) || "func_71384_a".equals(name))) {
                if (name.startsWith("func_")) {
                    isSrg = true;
                }
                mv = new InitMethodVisitor(mv);
            }
            return mv;
        }
    }
}

