/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.messaging.http;

import com.aoindustries.io.AoByteArrayOutputStream;
import com.aoindustries.messaging.Message;
import com.aoindustries.messaging.MessageType;
import com.aoindustries.messaging.Socket;
import com.aoindustries.messaging.base.AbstractSocket;
import com.aoindustries.messaging.base.AbstractSocketContext;
import com.aoindustries.messaging.http.HttpSocketContext;
import com.aoindustries.messaging.http.UrlSocketAddress;
import com.aoindustries.security.Identifier;
import com.aoindustries.tempfiles.TempFileContext;
import com.aoindustries.util.AtomicSequence;
import com.aoindustries.util.Sequence;
import com.aoindustries.util.concurrent.Callback;
import com.aoindustries.util.concurrent.Executor;
import com.aoindustries.util.concurrent.Executors;
import com.aoindustries.xml.XmlUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class HttpSocket
extends AbstractSocket {
    private static final Logger logger = Logger.getLogger(HttpSocket.class.getName());
    private static final boolean DEBUG = false;
    public static final String PROTOCOL = "http";
    public static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final int CONNECT_TIMEOUT = 15000;
    public static final int READ_TIMEOUT = 120000;
    private final Map<Long, Message> inQueue = new HashMap<Long, Message>();
    private long inSeq = 1L;
    private final Object lock = new Object();
    private Queue<Message> outQueue;
    private final Sequence outSeq = new AtomicSequence();
    private final Executors executors = new Executors();
    private final HttpSocketContext socketContext;
    private final URL endpoint;
    private HttpURLConnection receiveConn;

    public HttpSocket(HttpSocketContext socketContext, Identifier id, long connectTime, URL endpoint) {
        super((AbstractSocketContext)socketContext, id, connectTime, (SocketAddress)new UrlSocketAddress(endpoint));
        this.socketContext = socketContext;
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            logger.log(Level.FINE, "Notifying all on lock");
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            logger.log(Level.FINE, "Notifying all on lock completed");
            logger.log(Level.FINE, "Calling executor.dispose()");
            this.executors.dispose();
            logger.log(Level.FINE, "executor.dispose() finished");
        }
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    protected void startImpl(final Callback<? super Socket> onStart, final Callback<? super Exception> onError) throws IllegalStateException {
        this.executors.getUnbounded().submit(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        if (HttpSocket.this.isClosed()) {
                            if (onError != null) {
                                onError.call((Object)new SocketException("Socket is closed"));
                            }
                        } else {
                            final Executor unbounded = HttpSocket.this.executors.getUnbounded();
                            unbounded.submit(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                @Override
                                public void run() {
                                    try {
                                        TempFileContext tempFileContext;
                                        try {
                                            tempFileContext = new TempFileContext();
                                        }
                                        catch (SecurityException e) {
                                            logger.log(Level.WARNING, null, e);
                                            tempFileContext = null;
                                        }
                                        try {
                                            while (!HttpSocket.this.isClosed()) {
                                                HttpURLConnection receiveConn = null;
                                                Object object = HttpSocket.this.lock;
                                                synchronized (object) {
                                                    while (receiveConn == null) {
                                                        if (HttpSocket.this.isClosed()) {
                                                            return;
                                                        }
                                                        receiveConn = HttpSocket.this.receiveConn;
                                                        if (receiveConn != null) continue;
                                                        List kicker = Collections.emptyList();
                                                        HttpSocket.this.sendMessagesImpl(kicker);
                                                        HttpSocket.this.lock.wait();
                                                    }
                                                }
                                                try {
                                                    ArrayList<Message> messages;
                                                    int responseCode = receiveConn.getResponseCode();
                                                    if (responseCode != 200) {
                                                        throw new IOException("Unexpect response code: " + responseCode);
                                                    }
                                                    DocumentBuilder builder = ((HttpSocket)HttpSocket.this).socketContext.builderFactory.newDocumentBuilder();
                                                    Element document = builder.parse(receiveConn.getInputStream()).getDocumentElement();
                                                    if (!"messages".equals(document.getNodeName())) {
                                                        throw new IOException("Unexpected root node name: " + document.getNodeName());
                                                    }
                                                    Map map = HttpSocket.this.inQueue;
                                                    synchronized (map) {
                                                        Message message;
                                                        for (Element messageElem : XmlUtils.iterableChildElementsByTagName((Element)document, (String)"message")) {
                                                            String encodedMessage;
                                                            Long seq = Long.parseLong(messageElem.getAttribute("seq"));
                                                            MessageType type = MessageType.getFromTypeChar((char)messageElem.getAttribute("type").charAt(0));
                                                            Node firstChild = messageElem.getFirstChild();
                                                            if (firstChild == null) {
                                                                encodedMessage = "";
                                                            } else {
                                                                if (!(firstChild instanceof Text)) {
                                                                    throw new IllegalArgumentException("Child of message is not a Text node");
                                                                }
                                                                encodedMessage = ((Text)firstChild).getTextContent();
                                                            }
                                                            if (HttpSocket.this.inQueue.put(seq, type.decode(encodedMessage, tempFileContext)) == null) continue;
                                                            throw new IOException("Duplicate incoming sequence: " + seq);
                                                        }
                                                        messages = new ArrayList<Message>(HttpSocket.this.inQueue.size());
                                                        while ((message = (Message)HttpSocket.this.inQueue.remove(HttpSocket.this.inSeq)) != null) {
                                                            messages.add(message);
                                                            HttpSocket.this.inSeq++;
                                                        }
                                                        if (messages.isEmpty()) continue;
                                                    }
                                                    final Future future = HttpSocket.this.callOnMessages(Collections.unmodifiableList(messages));
                                                    if (tempFileContext == null || tempFileContext.getSize() == 0) continue;
                                                    final TempFileContext closeMeNow = tempFileContext;
                                                    unbounded.submit(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            try {
                                                                try {
                                                                    future.get();
                                                                }
                                                                finally {
                                                                    closeMeNow.close();
                                                                }
                                                            }
                                                            catch (IOException | InterruptedException | RuntimeException | ExecutionException e) {
                                                                logger.log(Level.SEVERE, null, e);
                                                            }
                                                        }
                                                    });
                                                    try {
                                                        tempFileContext = new TempFileContext();
                                                    }
                                                    catch (SecurityException e) {
                                                        logger.log(Level.WARNING, null, e);
                                                        tempFileContext = null;
                                                    }
                                                }
                                                finally {
                                                    object = HttpSocket.this.lock;
                                                    synchronized (object) {
                                                        if (receiveConn != HttpSocket.this.receiveConn) {
                                                            throw new AssertionError();
                                                        }
                                                        HttpSocket.this.receiveConn = null;
                                                        HttpSocket.this.lock.notify();
                                                    }
                                                }
                                            }
                                            return;
                                        }
                                        finally {
                                            if (tempFileContext != null) {
                                                tempFileContext.close();
                                            }
                                        }
                                    }
                                    catch (Exception exc) {
                                        if (HttpSocket.this.isClosed()) return;
                                        HttpSocket.this.callOnError(exc);
                                        return;
                                    }
                                    finally {
                                        try {
                                            HttpSocket.this.close();
                                        }
                                        catch (IOException e) {
                                            logger.log(Level.SEVERE, null, e);
                                        }
                                    }
                                }
                            });
                        }
                        if (onStart != null) {
                            onStart.call((Object)HttpSocket.this);
                        }
                    }
                    catch (Exception exc) {
                        if (onError == null) break block6;
                        onError.call((Object)exc);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessagesImpl(Collection<? extends Message> messages) {
        Object object = this.lock;
        synchronized (object) {
            boolean isFirst;
            if (this.outQueue == null) {
                this.outQueue = new LinkedList<Message>();
                isFirst = true;
            } else {
                isFirst = false;
            }
            this.outQueue.addAll(messages);
            if (isFirst) {
                this.executors.getUnbounded().submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block33: {
                            try {
                                ArrayList messages = new ArrayList();
                                while (!HttpSocket.this.isClosed()) {
                                    Object object = HttpSocket.this.lock;
                                    synchronized (object) {
                                        if (HttpSocket.this.outQueue.isEmpty() && HttpSocket.this.receiveConn != null) {
                                            HttpSocket.this.outQueue = null;
                                            break;
                                        }
                                        messages.addAll(HttpSocket.this.outQueue);
                                        HttpSocket.this.outQueue.clear();
                                    }
                                    int size = messages.size();
                                    try (AoByteArrayOutputStream bout = new AoByteArrayOutputStream();
                                         DataOutputStream out = new DataOutputStream((OutputStream)bout);){
                                        out.writeBytes("action=messages&id=");
                                        out.writeBytes(HttpSocket.this.getId().toString());
                                        out.writeBytes("&l=");
                                        out.writeBytes(Integer.toString(size));
                                        for (int i = 0; i < size; ++i) {
                                            String iString = Integer.toString(i);
                                            Message message = (Message)messages.get(i);
                                            out.writeBytes("&s");
                                            out.writeBytes(iString);
                                            out.write(61);
                                            out.writeBytes(Long.toString(HttpSocket.this.outSeq.getNextSequenceValue()));
                                            out.writeBytes("&t");
                                            out.writeBytes(iString);
                                            out.write(61);
                                            out.write(message.getMessageType().getTypeChar());
                                            out.writeBytes("&m");
                                            out.writeBytes(iString);
                                            out.write(61);
                                            out.writeBytes(URLEncoder.encode(message.encodeAsString(), ENCODING.name()));
                                        }
                                    }
                                    HttpURLConnection conn = (HttpURLConnection)HttpSocket.this.endpoint.openConnection();
                                    conn.setAllowUserInteraction(false);
                                    conn.setConnectTimeout(15000);
                                    conn.setDoOutput(true);
                                    conn.setFixedLengthStreamingMode(bout.size());
                                    conn.setInstanceFollowRedirects(false);
                                    conn.setReadTimeout(120000);
                                    conn.setRequestMethod("POST");
                                    conn.setUseCaches(false);
                                    try (OutputStream out = conn.getOutputStream();){
                                        out.write(bout.getInternalByteArray(), 0, bout.size());
                                        out.flush();
                                    }
                                    Object object2 = HttpSocket.this.lock;
                                    synchronized (object2) {
                                        while (HttpSocket.this.receiveConn != null) {
                                            if (HttpSocket.this.isClosed()) {
                                                return;
                                            }
                                            HttpSocket.this.lock.wait();
                                        }
                                        HttpSocket.this.receiveConn = conn;
                                        HttpSocket.this.lock.notify();
                                    }
                                    messages.clear();
                                }
                            }
                            catch (Exception exc) {
                                if (HttpSocket.this.isClosed()) break block33;
                                HttpSocket.this.callOnError(exc);
                                try {
                                    HttpSocket.this.close();
                                }
                                catch (IOException e) {
                                    logger.log(Level.SEVERE, null, e);
                                }
                            }
                        }
                    }
                });
            }
        }
    }
}

