/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.messaging.tcp.client;

import com.aoindustries.concurrent.Callback;
import com.aoindustries.concurrent.Executors;
import com.aoindustries.io.stream.StreamableInput;
import com.aoindustries.io.stream.StreamableOutput;
import com.aoindustries.lang.Throwables;
import com.aoindustries.messaging.base.AbstractSocket;
import com.aoindustries.messaging.base.AbstractSocketContext;
import com.aoindustries.messaging.tcp.TcpSocket;
import com.aoindustries.security.Identifier;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpSocketClient
extends AbstractSocketContext<TcpSocket> {
    private static final Logger logger = Logger.getLogger(TcpSocketClient.class.getName());
    private static final boolean KEEPALIVE = true;
    private static final boolean SOCKET_SO_LINGER_ENABLED = true;
    private static final int SOCKET_SO_LINGER_SECONDS = 15;
    private static final boolean TCP_NO_DELAY = true;
    private static final int CONNECT_TIMEOUT = 15000;
    private final Executors executors = new Executors();

    public void close() {
        try {
            super.close();
        }
        finally {
            this.executors.close();
        }
    }

    public void connect(SocketAddress endpoint, Callback<? super TcpSocket> onConnect, Callback<? super Throwable> onError) {
        this.executors.getUnbounded().submit(() -> {
            block23: {
                try {
                    Socket socket = new Socket();
                    socket.setKeepAlive(true);
                    socket.setSoLinger(true, 15);
                    socket.setTcpNoDelay(true);
                    long connectTime = System.currentTimeMillis();
                    socket.connect(endpoint, 15000);
                    logger.log(Level.FINEST, "Got connection");
                    boolean successful = false;
                    try {
                        StreamableInput in = new StreamableInput(socket.getInputStream());
                        logger.log(Level.FINEST, "Got in");
                        StreamableOutput out = new StreamableOutput(socket.getOutputStream());
                        logger.log(Level.FINEST, "Got out");
                        Identifier id = new Identifier(in.readLong(), in.readLong());
                        logger.log(Level.FINEST, "Got id = {0}", id);
                        TcpSocket tcpSocket = new TcpSocket((AbstractSocketContext)this, id, connectTime, socket, in, out);
                        logger.log(Level.FINEST, "Adding socket");
                        this.addSocket((AbstractSocket)tcpSocket);
                        if (onConnect != null) {
                            logger.log(Level.FINE, "Calling onConnect: {0}", tcpSocket);
                            try {
                                onConnect.call((Object)tcpSocket);
                            }
                            catch (ThreadDeath td) {
                                throw td;
                            }
                            catch (Throwable t) {
                                logger.log(Level.SEVERE, null, t);
                            }
                        } else {
                            logger.log(Level.FINE, "No onConnect: {0}", tcpSocket);
                        }
                        successful = true;
                    }
                    finally {
                        if (!successful) {
                            try {
                                socket.close();
                            }
                            catch (ThreadDeath td) {
                                throw td;
                            }
                            catch (Throwable t) {
                                logger.log(Level.SEVERE, null, t);
                            }
                        }
                    }
                }
                catch (Throwable t0) {
                    if (onError != null) {
                        logger.log(Level.FINE, "Calling onError", t0);
                        try {
                            onError.call((Object)t0);
                        }
                        catch (ThreadDeath td) {
                            t0 = Throwables.addSuppressed((Throwable)td, (Throwable)t0);
                            assert (t0 == td);
                        }
                        catch (Throwable t2) {
                            logger.log(Level.SEVERE, null, t2);
                        }
                    } else {
                        logger.log(Level.FINE, "No onError", t0);
                    }
                    if (!(t0 instanceof ThreadDeath)) break block23;
                    throw (ThreadDeath)t0;
                }
            }
        });
    }
}

