/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.tempfiles;

import com.aoindustries.tempfiles.TempFileContext;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;

public class TempFile
implements Closeable {
    private final Long contextId;
    private final AtomicReference<File> file;

    TempFile(Long contextId, File file) {
        this.contextId = contextId;
        this.file = new AtomicReference<File>(file);
    }

    public File getFile() throws IllegalStateException {
        File f = this.file.get();
        if (f == null) {
            throw new IllegalStateException("Temp file closed");
        }
        return f;
    }

    @Override
    public void close() throws IOException {
        File f = this.file.getAndSet(null);
        if (f != null) {
            TempFileContext.removeDeleteOnExit(this.contextId, f.getName());
            if (f.exists() && !f.delete()) {
                throw new IOException("Unable to delete temporary file: " + f);
            }
        }
    }
}

