/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.tempfiles;

import com.aoindustries.tempfiles.TempFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TempFileContext
implements Closeable {
    private static final Logger logger = Logger.getLogger(TempFileContext.class.getName());
    private static final AtomicInteger activeCount = new AtomicInteger();
    private static final ConcurrentMap<Long, Map<String, File>> deleteOnExits = new ConcurrentHashMap<Long, Map<String, File>>();
    private static volatile Thread shutdownHook;
    private static final AtomicLong idGenerator;
    private final Long id;
    private final File tmpDir;
    private final AtomicBoolean closed;
    private static final AtomicReference<File> systemTmpDir;

    public TempFileContext(File tmpDir) {
        block7: {
            this.id = idGenerator.getAndIncrement();
            this.closed = new AtomicBoolean();
            this.tmpDir = tmpDir;
            assert (activeCount.get() >= 0);
            int newActiveCount = activeCount.incrementAndGet();
            if (newActiveCount < 0) {
                activeCount.decrementAndGet();
                throw new IllegalStateException("activeCount integer wraparound detected");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "activeCount={0}", newActiveCount);
            }
            if (newActiveCount == 1) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Registering shutdown hook");
                }
                shutdownHook = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Iterator iterator = deleteOnExits.values().iterator();
                        while (iterator.hasNext()) {
                            Map deleteMap;
                            Map map = deleteMap = (Map)iterator.next();
                            synchronized (map) {
                                for (File file : deleteMap.values()) {
                                    if (!file.exists() || file.delete() || !logger.isLoggable(Level.WARNING)) continue;
                                    logger.log(Level.WARNING, "Unable to delete file on shutdown: {0}", file);
                                }
                            }
                        }
                    }
                };
                try {
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                }
                catch (IllegalArgumentException | IllegalStateException | SecurityException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block7;
                    logger.log(Level.WARNING, "Failed to add shutdown hook", e);
                }
            }
        }
    }

    public TempFileContext(String tmpDir) {
        this(new File(tmpDir));
    }

    private static File getSystemTmpDir() {
        File existing;
        File tmpDir = systemTmpDir.get();
        if (tmpDir == null && (existing = systemTmpDir.getAndSet(tmpDir = new File(System.getProperty("java.io.tmpdir")))) != null) {
            tmpDir = existing;
        }
        return tmpDir;
    }

    public TempFileContext() {
        this(TempFileContext.getSystemTmpDir());
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempFile createTempFile(String prefix, String suffix) throws IllegalStateException, IOException {
        Map existing;
        if (this.closed.get()) {
            throw new IllegalStateException("TempFiles is closed");
        }
        if (prefix == null) {
            prefix = "tmp_";
        } else {
            while (prefix.length() < 3) {
                prefix = prefix + '_';
            }
        }
        File tmpFile = File.createTempFile(prefix, suffix, this.tmpDir);
        Map<String, File> deleteMap = (LinkedHashMap<String, File>)deleteOnExits.get(this.id);
        if (deleteMap == null && (existing = (Map)deleteOnExits.putIfAbsent(this.id, deleteMap = new LinkedHashMap<String, File>())) != null) {
            deleteMap = existing;
        }
        LinkedHashMap<String, File> linkedHashMap = deleteMap;
        synchronized (linkedHashMap) {
            if (deleteMap.put(tmpFile.getName(), tmpFile) != null) {
                throw new IOException("Duplicate temp filename: " + tmpFile);
            }
        }
        return new TempFile(this.id, tmpFile);
    }

    public TempFile createTempFile(String prefix) throws IllegalStateException, IOException {
        return this.createTempFile(prefix, null);
    }

    public TempFile createTempFile() throws IllegalStateException, IOException {
        return this.createTempFile(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeDeleteOnExit(Long id, String name) {
        Map deleteMap = (Map)deleteOnExits.get(id);
        if (deleteMap != null) {
            Map map = deleteMap;
            synchronized (map) {
                deleteMap.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Map deleteMap = (Map)deleteOnExits.get(this.id);
        if (deleteMap != null) {
            Map map = deleteMap;
            synchronized (map) {
                return deleteMap.size();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean alreadyClosed = this.closed.getAndSet(true);
        if (!alreadyClosed) {
            Map deleteMap;
            block18: {
                deleteMap = (Map)deleteOnExits.remove(this.id);
                assert (activeCount.get() > 0);
                int newActiveCount = activeCount.decrementAndGet();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "activeCount={0}", newActiveCount);
                }
                if (newActiveCount == 0) {
                    Thread hook = shutdownHook;
                    assert (hook != null);
                    shutdownHook = null;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Removing shutdown hook");
                    }
                    try {
                        Runtime.getRuntime().removeShutdownHook(hook);
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (SecurityException e) {
                        if (!logger.isLoggable(Level.WARNING)) break block18;
                        logger.log(Level.WARNING, "Failed to removing shutdown hook", e);
                    }
                }
            }
            if (deleteMap != null) {
                LinkedHashSet<File> failedDelete = null;
                Map e = deleteMap;
                synchronized (e) {
                    for (File file : deleteMap.values()) {
                        if (!file.exists() || file.delete()) continue;
                        if (failedDelete == null) {
                            failedDelete = new LinkedHashSet<File>();
                        }
                        failedDelete.add(file);
                    }
                }
                if (failedDelete != null) {
                    if (failedDelete.size() == 1) {
                        throw new IOException("Unable to delete temporary file: " + failedDelete.iterator().next());
                    }
                    StringBuilder sb = new StringBuilder("Unable to delete temporary files:");
                    for (File file : failedDelete) {
                        sb.append("\n    ").append(file.toString());
                    }
                    throw new IOException(sb.toString());
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    static {
        idGenerator = new AtomicLong(1L);
        systemTmpDir = new AtomicReference();
    }
}

