/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.web.resources.renderer;

import com.aoindustries.html.Html;
import com.aoindustries.html.Link;
import com.aoindustries.net.EmptyURIParameters;
import com.aoindustries.net.URIParameters;
import com.aoindustries.servlet.lastmodified.AddLastModified;
import com.aoindustries.servlet.lastmodified.LastModifiedUtil;
import com.aoindustries.web.resources.registry.Group;
import com.aoindustries.web.resources.registry.Registry;
import com.aoindustries.web.resources.registry.Style;
import com.aoindustries.web.resources.registry.Styles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Renderer {
    private static final Logger logger = Logger.getLogger(Renderer.class.getName());
    private static final String APPLICATION_ATTRIBUTE = Renderer.class.getName();
    private static final String NO_REGISTRIES = "<!-- ao-web-resources-renderer: no registries -->";
    private static final String NO_ACTIVATIONS = "<!-- ao-web-resources-renderer: no activations -->";
    private static final String NO_STYLES = "<!-- ao-web-resources-renderer: no styles -->";
    private static final String NO_APPLICABLE_STYLES = "<!-- ao-web-resources-renderer: no applicable styles -->";
    private final ServletContext servletContext;

    public static Renderer get(ServletContext servletContext) {
        Renderer renderer = (Renderer)servletContext.getAttribute(APPLICATION_ATTRIBUTE);
        if (renderer == null) {
            renderer = new Renderer(servletContext);
            servletContext.setAttribute(APPLICATION_ATTRIBUTE, (Object)renderer);
        }
        return renderer;
    }

    private Renderer(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void renderStyles(HttpServletRequest request, HttpServletResponse response, Html html, String indent, boolean registeredActivations, Map<Group.Name, Boolean> activations, Iterable<Registry> registries) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("registries = " + registries);
        }
        if (registries == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(NO_REGISTRIES);
            }
            html.out.write(NO_REGISTRIES);
        } else {
            HashSet<Object> groups = new HashSet<Object>();
            if (registeredActivations) {
                boolean hasRegistry = false;
                for (Registry registry : registries) {
                    if (registry == null) continue;
                    hasRegistry = true;
                    for (Map.Entry entry : registry.getActivations().entrySet()) {
                        Group.Name name = (Group.Name)entry.getKey();
                        assert (entry.getValue() != null) : "null activations are removed, not set as an entry";
                        boolean activated = (Boolean)entry.getValue();
                        if (activated) {
                            groups.add(name);
                            continue;
                        }
                        groups.remove(name);
                    }
                }
                if (!hasRegistry) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(NO_REGISTRIES);
                    }
                    html.out.write(NO_REGISTRIES);
                    return;
                }
            }
            if (activations != null) {
                for (Map.Entry<Group.Name, Boolean> entry : activations.entrySet()) {
                    Group.Name name = entry.getKey();
                    Boolean activated = entry.getValue();
                    if (activated == null) continue;
                    if (activated.booleanValue()) {
                        groups.add(name);
                        continue;
                    }
                    groups.remove(name);
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("groups = " + groups);
            }
            if (groups.isEmpty()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(NO_ACTIVATIONS);
                }
                html.out.write(NO_ACTIVATIONS);
                return;
            }
            ArrayList<Styles> allStyles = new ArrayList<Styles>();
            boolean hasRegistry = false;
            for (Registry registry : registries) {
                if (registry == null) continue;
                hasRegistry = true;
                for (Group.Name name : groups) {
                    Group group = registry.getGroup(name, false);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("name: " + name + ", group: " + group);
                    }
                    if (group == null) continue;
                    allStyles.add(group.styles);
                }
            }
            if (!hasRegistry) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(NO_REGISTRIES);
                }
                html.out.write(NO_REGISTRIES);
                return;
            }
            int size = allStyles.size();
            if (size == 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(NO_STYLES);
                }
                html.out.write(NO_STYLES);
            } else {
                boolean bl;
                Styles styles;
                if (size == 1) {
                    styles = (Styles)allStyles.get(0);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("direct styles: " + styles);
                    }
                } else {
                    styles = Styles.union(allStyles);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("unioned styles: " + styles);
                    }
                }
                Set set = styles.getSorted();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("sorted: " + styles);
                }
                boolean bl2 = false;
                boolean didOne = false;
                Style.Direction responseDirection = null;
                for (Style style : set) {
                    boolean directionMatches;
                    bl = true;
                    Style.Direction direction = style.getDirection();
                    if (direction != null) {
                        if (responseDirection == null) {
                            responseDirection = Style.Direction.getDirection((Locale)response.getLocale());
                        }
                        directionMatches = direction == responseDirection;
                    } else {
                        directionMatches = true;
                    }
                    if (!directionMatches) continue;
                    if (!didOne) {
                        didOne = true;
                    } else {
                        html.nl();
                        if (indent != null) {
                            html.out.write(indent);
                        }
                    }
                    String ie = style.getIe();
                    if (ie != null) {
                        html.out.write("<!--[if ");
                        html.out.write(ie);
                        html.out.write(62);
                    }
                    String href = style.getUri();
                    ((Link)((Link)((Link)html.link(Link.Rel.STYLESHEET).href(href == null ? null : LastModifiedUtil.buildURL((ServletContext)this.servletContext, (HttpServletRequest)request, (HttpServletResponse)response, (String)"/", (String)href, (URIParameters)EmptyURIParameters.getInstance(), (AddLastModified)AddLastModified.AUTO, (boolean)false, (boolean)false))).media((Object)style.getMedia())).disabled(style.isDisabled())).__();
                    if (ie == null) continue;
                    html.out.write("<![endif]-->");
                }
                if (!didOne) {
                    if (!bl) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(NO_STYLES);
                        }
                        html.out.write(NO_STYLES);
                    } else {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(NO_APPLICABLE_STYLES);
                        }
                        html.out.write(NO_APPLICABLE_STYLES);
                    }
                }
            }
        }
    }

    public void renderStyles(HttpServletRequest request, HttpServletResponse response, Html html, String indent, boolean registeredActivations, Map<Group.Name, Boolean> activations, Registry ... registries) throws IOException {
        this.renderStyles(request, response, html, indent, registeredActivations, activations, registries == null ? null : Arrays.asList(registries));
    }

    @WebListener
    public static class Initializer
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent event) {
            Renderer.get(event.getServletContext());
        }

        public void contextDestroyed(ServletContextEvent event) {
        }
    }
}

