/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client;

import com.aoapps.lang.Strings;
import com.aoapps.lang.exception.ConfigurationException;
import com.aoapps.lang.util.PropertiesUtils;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoapps.net.HostAddress;
import com.aoapps.net.InetAddress;
import com.aoapps.net.Port;
import com.aoapps.net.Protocol;
import com.aoindustries.aoserv.client.account.User;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public final class AoservClientConfiguration {
    private static final PropsLock propsLock = new PropsLock();
    private static Properties props;

    private AoservClientConfiguration() {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProperty(String name) throws ConfigurationException {
        try {
            PropsLock propsLock = AoservClientConfiguration.propsLock;
            synchronized (propsLock) {
                if (props == null) {
                    props = PropertiesUtils.loadFromResource(AoservClientConfiguration.class, (String)"/com/aoindustries/aoserv/client/aoserv-client.properties");
                }
                return props.getProperty(name);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    static List<String> getProtocols() throws ConfigurationException {
        return Strings.splitCommaSpace((String)AoservClientConfiguration.getProperty("aoserv.client.protocols"));
    }

    static HostAddress getTcpHostname() throws ConfigurationException {
        try {
            return HostAddress.valueOf((String)AoservClientConfiguration.getProperty("aoserv.client.tcp.hostname"));
        }
        catch (ValidationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    static InetAddress getTcpLocalIp() throws ConfigurationException {
        String s = AoservClientConfiguration.getProperty("aoserv.client.tcp.local_ip");
        if (s == null || (s = s.trim()).length() == 0) {
            return null;
        }
        try {
            return InetAddress.valueOf((String)s);
        }
        catch (ValidationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    static Port getTcpPort() throws ConfigurationException {
        try {
            return Port.valueOf((int)Integer.parseInt(AoservClientConfiguration.getProperty("aoserv.client.tcp.port")), (Protocol)Protocol.TCP);
        }
        catch (ValidationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    static int getTcpConnectionPoolSize() throws ConfigurationException {
        return Integer.parseInt(AoservClientConfiguration.getProperty("aoserv.client.tcp.connection.pool.size"));
    }

    static long getTcpConnectionMaxAge() throws ConfigurationException {
        String s = AoservClientConfiguration.getProperty("aoserv.client.tcp.connection.max_age");
        return s == null || s.length() == 0 ? 1800000L : Long.parseLong(s);
    }

    static HostAddress getSslHostname() throws ConfigurationException {
        try {
            return HostAddress.valueOf((String)AoservClientConfiguration.getProperty("aoserv.client.ssl.hostname"));
        }
        catch (ValidationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    static InetAddress getSslLocalIp() throws ConfigurationException {
        String s = AoservClientConfiguration.getProperty("aoserv.client.ssl.local_ip");
        if (s == null || (s = s.trim()).length() == 0) {
            return null;
        }
        try {
            return InetAddress.valueOf((String)s);
        }
        catch (ValidationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    static Port getSslPort() throws ConfigurationException {
        try {
            return Port.valueOf((int)Integer.parseInt(AoservClientConfiguration.getProperty("aoserv.client.ssl.port")), (Protocol)Protocol.TCP);
        }
        catch (ValidationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    static int getSslConnectionPoolSize() throws ConfigurationException {
        return Integer.parseInt(AoservClientConfiguration.getProperty("aoserv.client.ssl.connection.pool.size"));
    }

    static long getSslConnectionMaxAge() throws ConfigurationException {
        String s = AoservClientConfiguration.getProperty("aoserv.client.ssl.connection.max_age");
        return s == null || s.length() == 0 ? 1800000L : Long.parseLong(s);
    }

    public static String getSslTruststorePath() throws ConfigurationException {
        return AoservClientConfiguration.getProperty("aoserv.client.ssl.truststore.path");
    }

    public static String getSslTruststorePassword() throws ConfigurationException {
        return AoservClientConfiguration.getProperty("aoserv.client.ssl.truststore.password");
    }

    public static User.Name getUsername() throws ConfigurationException {
        String username = AoservClientConfiguration.getProperty("aoserv.client.username");
        if (username == null || (username = username.trim()).isEmpty()) {
            return null;
        }
        try {
            return User.Name.valueOf(username);
        }
        catch (ValidationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public static String getPassword() throws ConfigurationException {
        return AoservClientConfiguration.getProperty("aoserv.client.password");
    }

    static DomainName getDaemonServer() throws ConfigurationException {
        String domainServer = AoservClientConfiguration.getProperty("aoserv.client.daemon.server");
        if (domainServer == null || (domainServer = domainServer.trim()).isEmpty()) {
            return null;
        }
        try {
            return DomainName.valueOf((String)domainServer);
        }
        catch (ValidationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private static class PropsLock {
        private PropsLock() {
        }
    }
}

