/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client;

import com.aoapps.collections.IntArrayList;
import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamWritable;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.hodgepodge.sort.ComparisonSortAlgorithm;
import com.aoapps.hodgepodge.table.TableListener;
import com.aoapps.lang.Throwables;
import com.aoapps.lang.exception.ConfigurationException;
import com.aoapps.lang.io.IoUtils;
import com.aoapps.net.DomainLabel;
import com.aoapps.net.DomainLabels;
import com.aoapps.net.DomainName;
import com.aoapps.net.Email;
import com.aoapps.net.HostAddress;
import com.aoapps.net.InetAddress;
import com.aoapps.net.MacAddress;
import com.aoapps.net.Port;
import com.aoapps.security.HashedKey;
import com.aoapps.security.HashedPassword;
import com.aoapps.security.Identifier;
import com.aoapps.sql.SQLStreamables;
import com.aoindustries.aoserv.client.AoservClientConfiguration;
import com.aoindustries.aoserv.client.AoservConnection;
import com.aoindustries.aoserv.client.AoservObject;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.AoservWritable;
import com.aoindustries.aoserv.client.SchemaParent;
import com.aoindustries.aoserv.client.SimpleAoservClient;
import com.aoindustries.aoserv.client.SslConnector;
import com.aoindustries.aoserv.client.TcpConnector;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.LinuxId;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.mysql.Database;
import com.aoindustries.aoserv.client.mysql.Schema;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.mysql.TableName;
import com.aoindustries.aoserv.client.mysql.User;
import com.aoindustries.aoserv.client.postgresql.Database;
import com.aoindustries.aoserv.client.postgresql.Server;
import com.aoindustries.aoserv.client.postgresql.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.sql.SqlComparator;
import com.aoindustries.aoserv.client.sql.SqlExpression;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AoservConnector
implements SchemaParent {
    public static final long MASTER_ENTROPY_POOL_SIZE = 0x4000000L;
    private static final long[] retryAttemptDelays = new long[]{0L, 1L, 2L, 3L, 4L, 6L, 8L, 12L, 16L, 24L, 32L, 48L, 64L, 96L, 128L, 192L, 256L, 384L, 512L, 768L, 1024L, 1536L, 2048L, 3072L};
    private static final int RETRY_ATTEMPTS = retryAttemptDelays.length + 1;
    static final ExecutorService executorService = Executors.newCachedThreadPool();
    protected final IdLock idLock = new IdLock();
    protected Identifier id = null;
    private final Logger logger;
    final HostAddress hostname;
    final InetAddress localIp;
    final Port port;
    final User.Name connectAs;
    final User.Name authenticateAs;
    final DomainName daemonServer;
    protected final String password;
    private final TestConnectLock testConnectLock = new TestConnectLock();
    private final com.aoindustries.aoserv.client.account.Schema account;
    private final com.aoindustries.aoserv.client.accounting.Schema accounting;
    private final com.aoindustries.aoserv.client.aosh.Schema aosh;
    private final com.aoindustries.aoserv.client.backup.Schema backup;
    private final com.aoindustries.aoserv.client.billing.Schema billing;
    private final com.aoindustries.aoserv.client.distribution.Schema distribution;
    private final com.aoindustries.aoserv.client.distribution.management.Schema distribution_management;
    private final com.aoindustries.aoserv.client.dns.Schema dns;
    private final com.aoindustries.aoserv.client.email.Schema email;
    private final com.aoindustries.aoserv.client.ftp.Schema ftp;
    private final com.aoindustries.aoserv.client.infrastructure.Schema infrastructure;
    private final com.aoindustries.aoserv.client.linux.Schema linux;
    private final com.aoindustries.aoserv.client.master.Schema master;
    private final Schema mysql;
    private final com.aoindustries.aoserv.client.net.Schema net;
    private final com.aoindustries.aoserv.client.payment.Schema payment;
    private final com.aoindustries.aoserv.client.pki.Schema pki;
    private final com.aoindustries.aoserv.client.postgresql.Schema postgresql;
    private final com.aoindustries.aoserv.client.reseller.Schema reseller;
    private final com.aoindustries.aoserv.client.schema.Schema schema;
    private final com.aoindustries.aoserv.client.scm.Schema scm;
    private final com.aoindustries.aoserv.client.signup.Schema signup;
    private final com.aoindustries.aoserv.client.ticket.Schema ticket;
    private final com.aoindustries.aoserv.client.web.Schema web;
    private final com.aoindustries.aoserv.client.web.jboss.Schema web_jboss;
    private final com.aoindustries.aoserv.client.web.tomcat.Schema web_tomcat;
    private final List<? extends com.aoindustries.aoserv.client.Schema> schemas;
    private final List<? extends AoservTable<?, ?>> tables;
    private final SimpleAoservClient simpleClient;
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final Random fastRandom = new Random(IoUtils.bufferToLong((byte[])secureRandom.generateSeed(8)));

    static boolean isImmediateFail(Throwable t) {
        if (t instanceof ThreadDeath || t instanceof InterruptedIOException || t instanceof InterruptedException || t instanceof ConfigurationException) {
            return true;
        }
        assert (t != null);
        String message = t.getMessage();
        return t instanceof IOException && message != null && ("Connection attempted with invalid password".equals(message) || "Connection attempted with empty password".equals(message) || "Connection attempted with empty connect username".equals(message) || message.startsWith("Unable to find Administrator: ") || message.startsWith("Not allowed to switch users from "));
    }

    public com.aoindustries.aoserv.client.account.Schema getAccount() {
        return this.account;
    }

    public com.aoindustries.aoserv.client.accounting.Schema getAccounting() {
        return this.accounting;
    }

    public com.aoindustries.aoserv.client.aosh.Schema getAosh() {
        return this.aosh;
    }

    public com.aoindustries.aoserv.client.backup.Schema getBackup() {
        return this.backup;
    }

    public com.aoindustries.aoserv.client.billing.Schema getBilling() {
        return this.billing;
    }

    public com.aoindustries.aoserv.client.distribution.Schema getDistribution() {
        return this.distribution;
    }

    public com.aoindustries.aoserv.client.distribution.management.Schema getDistribution_management() {
        return this.distribution_management;
    }

    public com.aoindustries.aoserv.client.dns.Schema getDns() {
        return this.dns;
    }

    public com.aoindustries.aoserv.client.email.Schema getEmail() {
        return this.email;
    }

    public com.aoindustries.aoserv.client.ftp.Schema getFtp() {
        return this.ftp;
    }

    public com.aoindustries.aoserv.client.infrastructure.Schema getInfrastructure() {
        return this.infrastructure;
    }

    public com.aoindustries.aoserv.client.linux.Schema getLinux() {
        return this.linux;
    }

    public com.aoindustries.aoserv.client.master.Schema getMaster() {
        return this.master;
    }

    public Schema getMysql() {
        return this.mysql;
    }

    public com.aoindustries.aoserv.client.net.Schema getNet() {
        return this.net;
    }

    public com.aoindustries.aoserv.client.payment.Schema getPayment() {
        return this.payment;
    }

    public com.aoindustries.aoserv.client.pki.Schema getPki() {
        return this.pki;
    }

    public com.aoindustries.aoserv.client.postgresql.Schema getPostgresql() {
        return this.postgresql;
    }

    public com.aoindustries.aoserv.client.reseller.Schema getReseller() {
        return this.reseller;
    }

    public com.aoindustries.aoserv.client.schema.Schema getSchema() {
        return this.schema;
    }

    public com.aoindustries.aoserv.client.scm.Schema getScm() {
        return this.scm;
    }

    public com.aoindustries.aoserv.client.signup.Schema getSignup() {
        return this.signup;
    }

    public com.aoindustries.aoserv.client.ticket.Schema getTicket() {
        return this.ticket;
    }

    public com.aoindustries.aoserv.client.web.Schema getWeb() {
        return this.web;
    }

    public com.aoindustries.aoserv.client.web.jboss.Schema getWeb_jboss() {
        return this.web_jboss;
    }

    public com.aoindustries.aoserv.client.web.tomcat.Schema getWeb_tomcat() {
        return this.web_tomcat;
    }

    public SimpleAoservClient getSimpleClient() {
        return this.simpleClient;
    }

    protected AoservConnector(HostAddress hostname, InetAddress localIp, Port port, User.Name connectAs, User.Name authenticateAs, String password, DomainName daemonServer) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.hostname = hostname;
        this.localIp = localIp;
        this.port = port;
        this.connectAs = connectAs;
        this.authenticateAs = authenticateAs;
        this.password = password;
        this.daemonServer = daemonServer;
        ArrayList<com.aoindustries.aoserv.client.Schema> newSchemas = new ArrayList<com.aoindustries.aoserv.client.Schema>();
        this.account = new com.aoindustries.aoserv.client.account.Schema(this);
        newSchemas.add(this.account);
        this.accounting = new com.aoindustries.aoserv.client.accounting.Schema(this);
        newSchemas.add(this.accounting);
        this.aosh = new com.aoindustries.aoserv.client.aosh.Schema(this);
        newSchemas.add(this.aosh);
        this.backup = new com.aoindustries.aoserv.client.backup.Schema(this);
        newSchemas.add(this.backup);
        this.billing = new com.aoindustries.aoserv.client.billing.Schema(this);
        newSchemas.add(this.billing);
        this.distribution = new com.aoindustries.aoserv.client.distribution.Schema(this);
        newSchemas.add(this.distribution);
        this.distribution_management = new com.aoindustries.aoserv.client.distribution.management.Schema(this);
        newSchemas.add(this.distribution_management);
        this.dns = new com.aoindustries.aoserv.client.dns.Schema(this);
        newSchemas.add(this.dns);
        this.email = new com.aoindustries.aoserv.client.email.Schema(this);
        newSchemas.add(this.email);
        this.ftp = new com.aoindustries.aoserv.client.ftp.Schema(this);
        newSchemas.add(this.ftp);
        this.infrastructure = new com.aoindustries.aoserv.client.infrastructure.Schema(this);
        newSchemas.add(this.infrastructure);
        this.linux = new com.aoindustries.aoserv.client.linux.Schema(this);
        newSchemas.add(this.linux);
        this.master = new com.aoindustries.aoserv.client.master.Schema(this);
        newSchemas.add(this.master);
        this.mysql = new Schema(this);
        newSchemas.add(this.mysql);
        this.net = new com.aoindustries.aoserv.client.net.Schema(this);
        newSchemas.add(this.net);
        this.payment = new com.aoindustries.aoserv.client.payment.Schema(this);
        newSchemas.add(this.payment);
        this.pki = new com.aoindustries.aoserv.client.pki.Schema(this);
        newSchemas.add(this.pki);
        this.postgresql = new com.aoindustries.aoserv.client.postgresql.Schema(this);
        newSchemas.add(this.postgresql);
        this.reseller = new com.aoindustries.aoserv.client.reseller.Schema(this);
        newSchemas.add(this.reseller);
        this.schema = new com.aoindustries.aoserv.client.schema.Schema(this);
        newSchemas.add(this.schema);
        this.scm = new com.aoindustries.aoserv.client.scm.Schema(this);
        newSchemas.add(this.scm);
        this.signup = new com.aoindustries.aoserv.client.signup.Schema(this);
        newSchemas.add(this.signup);
        this.ticket = new com.aoindustries.aoserv.client.ticket.Schema(this);
        newSchemas.add(this.ticket);
        this.web = new com.aoindustries.aoserv.client.web.Schema(this);
        newSchemas.add(this.web);
        this.web_jboss = new com.aoindustries.aoserv.client.web.jboss.Schema(this);
        newSchemas.add(this.web_jboss);
        this.web_tomcat = new com.aoindustries.aoserv.client.web.tomcat.Schema(this);
        newSchemas.add(this.web_tomcat);
        newSchemas.trimToSize();
        this.schemas = Collections.unmodifiableList(newSchemas);
        ArrayList<AoservTable> newTables = new ArrayList<AoservTable>();
        newTables.add(this.linux.getDaemonAcl());
        newTables.add(this.linux.getServer());
        newTables.add(this.master.getPermission());
        newTables.add(this.schema.getAoservProtocol());
        newTables.add(this.aosh.getCommand());
        newTables.add(this.distribution.getArchitecture());
        newTables.add(this.backup.getBackupPartition());
        newTables.add(this.backup.getBackupReport());
        newTables.add(this.backup.getBackupRetention());
        newTables.add(this.accounting.getBankAccount());
        newTables.add(this.accounting.getBankTransactionType());
        newTables.add(this.accounting.getBankTransaction());
        newTables.add(this.accounting.getBank());
        newTables.add(this.email.getBlackholeAddress());
        newTables.add(this.reseller.getBrand());
        newTables.add(this.account.getAdministrator());
        newTables.add(this.master.getAdministratorPermission());
        newTables.add(this.account.getProfile());
        newTables.add(this.account.getAccount());
        newTables.add(this.account.getAccountHost());
        newTables.add(this.payment.getCountryCode());
        newTables.add(this.payment.getProcessor());
        newTables.add(this.payment.getPayment());
        newTables.add(this.payment.getCreditCard());
        newTables.add(this.billing.getCurrency());
        newTables.add(this.scm.getCvsRepository());
        newTables.add(this.email.getCyrusImapdBind());
        newTables.add(this.email.getCyrusImapdServer());
        newTables.add(this.account.getDisableLog());
        newTables.add(this.distribution_management.getDistroFileType());
        newTables.add(this.distribution_management.getDistroFile());
        newTables.add(this.distribution_management.getDistroReportType());
        newTables.add(this.dns.getForbiddenZone());
        newTables.add(this.dns.getRecord());
        newTables.add(this.dns.getTopLevelDomain());
        newTables.add(this.dns.getRecordType());
        newTables.add(this.dns.getZone());
        newTables.add(this.email.getAddress());
        newTables.add(this.email.getAttachmentBlock());
        newTables.add(this.email.getAttachmentType());
        newTables.add(this.email.getDomain());
        newTables.add(this.email.getForwarding());
        newTables.add(this.email.getListAddress());
        newTables.add(this.email.getList());
        newTables.add(this.email.getPipeAddress());
        newTables.add(this.email.getPipe());
        newTables.add(this.email.getSmtpRelayType());
        newTables.add(this.email.getSmtpRelay());
        newTables.add(this.email.getSmtpSmartHostDomain());
        newTables.add(this.email.getSmtpSmartHost());
        newTables.add(this.email.getSpamAssassinMode());
        newTables.add(this.pki.getEncryptionKey());
        newTables.add(this.accounting.getExpenseCategory());
        newTables.add(this.backup.getFileReplicationLog());
        newTables.add(this.backup.getFileReplication());
        newTables.add(this.backup.getFileReplicationSchedule());
        newTables.add(this.backup.getMysqlReplication());
        newTables.add(this.backup.getFileReplicationSetting());
        newTables.add(this.net.getFirewallZone());
        newTables.add(this.ftp.getGuestUser());
        newTables.add(this.web.getHttpdBind());
        newTables.add(this.web_jboss.getSite());
        newTables.add(this.web_jboss.getVersion());
        newTables.add(this.web_tomcat.getWorkerName());
        newTables.add(this.web_tomcat.getJkProtocol());
        newTables.add(this.web.getHttpdServer());
        newTables.add(this.web_tomcat.getSharedTomcat());
        newTables.add(this.web.getLocation());
        newTables.add(this.web.getHeader());
        newTables.add(this.web.getRewriteRule());
        newTables.add(this.web.getVirtualHost());
        newTables.add(this.web.getVirtualHostName());
        newTables.add(this.web.getSite());
        newTables.add(this.web.getStaticSite());
        newTables.add(this.web_tomcat.getContext());
        newTables.add(this.web_tomcat.getContextDataSource());
        newTables.add(this.web_tomcat.getContextParameter());
        newTables.add(this.web_tomcat.getJkMount());
        newTables.add(this.web_tomcat.getSite());
        newTables.add(this.web_tomcat.getSharedTomcatSite());
        newTables.add(this.web_tomcat.getPrivateTomcatSite());
        newTables.add(this.web_tomcat.getVersion());
        newTables.add(this.web_tomcat.getWorker());
        newTables.add(this.net.getIpAddress());
        newTables.add(this.net.getMonitoring().getIpAddressMonitoring());
        newTables.add(this.net.getReputation().getLimiterClass());
        newTables.add(this.net.getReputation().getLimiterSet());
        newTables.add(this.net.getReputation().getLimiter());
        newTables.add(this.net.getReputation().getHost());
        newTables.add(this.net.getReputation().getNetwork());
        newTables.add(this.net.getReputation().getSet());
        newTables.add(this.ticket.getLanguage());
        newTables.add(this.email.getInboxAddress());
        newTables.add(this.linux.getUserType());
        newTables.add(this.linux.getUser());
        newTables.add(this.linux.getGroupUser());
        newTables.add(this.linux.getGroupType());
        newTables.add(this.linux.getGroup());
        newTables.add(this.linux.getUserServer());
        newTables.add(this.linux.getGroupServer());
        newTables.add(this.email.getMajordomoList());
        newTables.add(this.email.getMajordomoServer());
        newTables.add(this.email.getMajordomoVersion());
        newTables.add(this.master.getUserAcl());
        newTables.add(this.master.getProcess());
        newTables.add(this.master.getServerStat());
        newTables.add(this.master.getUserHost());
        newTables.add(this.master.getUser());
        newTables.add(this.billing.getMonthlyCharge());
        newTables.add(this.mysql.getDatabase());
        newTables.add(this.mysql.getDatabaseUser());
        newTables.add(this.mysql.getUserServer());
        newTables.add(this.mysql.getServer());
        newTables.add(this.mysql.getUser());
        newTables.add(this.net.getBindFirewallZone());
        newTables.add(this.net.getBind());
        newTables.add(this.net.getDeviceId());
        newTables.add(this.net.getDevice());
        newTables.add(this.net.getTcpRedirect());
        newTables.add(this.billing.getNoticeLog());
        newTables.add(this.billing.getNoticeLogBalance());
        newTables.add(this.billing.getNoticeType());
        newTables.add(this.distribution.getOperatingSystemVersion());
        newTables.add(this.distribution.getOperatingSystem());
        newTables.add(this.billing.getPackageCategory());
        newTables.add(this.billing.getPackageDefinitionLimit());
        newTables.add(this.billing.getPackageDefinition());
        newTables.add(this.billing.getPackage());
        newTables.add(this.payment.getPaymentType());
        newTables.add(this.infrastructure.getPhysicalServer());
        newTables.add(this.postgresql.getDatabase());
        newTables.add(this.postgresql.getEncoding());
        newTables.add(this.postgresql.getUserServer());
        newTables.add(this.postgresql.getServer());
        newTables.add(this.postgresql.getUser());
        newTables.add(this.postgresql.getVersion());
        newTables.add(this.ftp.getPrivateServer());
        newTables.add(this.infrastructure.getProcessorType());
        newTables.add(this.net.getAppProtocol());
        newTables.add(this.infrastructure.getRack());
        newTables.add(this.reseller.getReseller());
        newTables.add(this.billing.getResource());
        newTables.add(this.schema.getColumn());
        newTables.add(this.schema.getForeignKey());
        newTables.add(this.schema.getTable());
        newTables.add(this.schema.getType());
        newTables.add(this.email.getSendmailBind());
        newTables.add(this.email.getSendmailServer());
        newTables.add(this.infrastructure.getServerFarm());
        newTables.add(this.net.getHost());
        newTables.add(this.linux.getShell());
        newTables.add(this.signup.getOption());
        newTables.add(this.signup.getRequest());
        newTables.add(this.email.getSpamMessage());
        newTables.add(this.pki.getCertificateName());
        newTables.add(this.pki.getCertificateOtherUse());
        newTables.add(this.pki.getCertificate());
        newTables.add(this.email.getSystemAlias());
        newTables.add(this.distribution.getSoftwareCategorization());
        newTables.add(this.distribution.getSoftwareCategory());
        newTables.add(this.distribution.getSoftware());
        newTables.add(this.distribution.getSoftwareVersion());
        newTables.add(this.ticket.getActionType());
        newTables.add(this.ticket.getAction());
        newTables.add(this.ticket.getAssignment());
        newTables.add(this.reseller.getBrandCategory());
        newTables.add(this.reseller.getCategory());
        newTables.add(this.ticket.getPriority());
        newTables.add(this.ticket.getStatus());
        newTables.add(this.ticket.getTicketType());
        newTables.add(this.ticket.getTicket());
        newTables.add(this.linux.getTimeZone());
        newTables.add(this.billing.getTransactionType());
        newTables.add(this.billing.getTransaction());
        newTables.add(this.account.getUsState());
        newTables.add(this.account.getUser());
        newTables.add(this.infrastructure.getVirtualDisk());
        newTables.add(this.infrastructure.getVirtualServer());
        newTables.add(this.billing.getWhoisHistory());
        newTables.add(this.billing.getWhoisHistoryAccount());
        newTables.trimToSize();
        this.tables = Collections.unmodifiableList(newTables);
        this.simpleClient = new SimpleAoservClient(this);
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void clearCaches() {
        for (AoservTable<?, ?> table : this.tables) {
            table.clearCache();
        }
    }

    public String executeCommand(String[] args) throws IOException, SQLException {
        return Aosh.executeCommand(this, args);
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    protected abstract AoservConnection getConnection(int var1) throws InterruptedIOException, IOException;

    public static AoservConnector getConnector() throws ConfigurationException {
        User.Name username = AoservClientConfiguration.getUsername();
        DomainName daemonServer = AoservClientConfiguration.getDaemonServer();
        return AoservConnector.getConnector(username, username, AoservClientConfiguration.getPassword(), daemonServer);
    }

    public static AoservConnector getConnector(User.Name username, String password) throws ConfigurationException {
        return AoservConnector.getConnector(username, username, password, null);
    }

    public static AoservConnector getConnector(User.Name connectAs, User.Name authenticateAs, String password, DomainName daemonServer) throws ConfigurationException {
        List<String> protocols = AoservClientConfiguration.getProtocols();
        int size = protocols.size();
        for (int c = 0; c < size; ++c) {
            String protocol = protocols.get(c);
            try {
                TcpConnector connector;
                if ("tcp".equals(protocol)) {
                    connector = TcpConnector.getTcpConnector(AoservClientConfiguration.getTcpHostname(), AoservClientConfiguration.getTcpLocalIp(), AoservClientConfiguration.getTcpPort(), connectAs, authenticateAs, password, daemonServer, AoservClientConfiguration.getTcpConnectionPoolSize(), AoservClientConfiguration.getTcpConnectionMaxAge());
                } else if ("ssl".equals(protocol)) {
                    connector = SslConnector.getSslConnector(AoservClientConfiguration.getSslHostname(), AoservClientConfiguration.getSslLocalIp(), AoservClientConfiguration.getSslPort(), connectAs, authenticateAs, password, daemonServer, AoservClientConfiguration.getSslConnectionPoolSize(), AoservClientConfiguration.getSslConnectionMaxAge(), AoservClientConfiguration.getSslTruststorePath(), AoservClientConfiguration.getSslTruststorePassword());
                } else {
                    throw new ConfigurationException("Unknown protocol in aoserv.client.protocols: " + protocol);
                }
                return connector;
            }
            catch (ConfigurationException err) {
                Logger.getLogger(AoservConnector.class.getName()).log(Level.SEVERE, null, err);
                continue;
            }
        }
        throw new ConfigurationException("Unable to connect using any of the available protocols.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Identifier getConnectorId() {
        IdLock idLock = this.idLock;
        synchronized (idLock) {
            return this.id;
        }
    }

    public final HostAddress getHostname() {
        return this.hostname;
    }

    public final InetAddress getLocalIp() {
        return this.localIp;
    }

    public final Port getPort() {
        return this.port;
    }

    public abstract String getProtocol();

    public static SecureRandom getSecureRandom() {
        return secureRandom;
    }

    public static Random getFastRandom() {
        return fastRandom;
    }

    @Override
    public final List<? extends com.aoindustries.aoserv.client.Schema> getSchemas() {
        return this.schemas;
    }

    public final AoservTable<?, ?> getTable(int tableId) throws IllegalArgumentException {
        if (tableId >= 0 && tableId < this.tables.size()) {
            return this.tables.get(tableId);
        }
        throw new IllegalArgumentException("Table not found for ID=" + tableId);
    }

    public final List<? extends AoservTable<?, ?>> getTables() {
        return this.tables;
    }

    public final Administrator getCurrentAdministrator() throws SQLException, IOException {
        Administrator obj = this.account.getAdministrator().get(this.connectAs);
        if (obj == null) {
            throw new SQLException("Unable to find Administrator: " + this.connectAs);
        }
        return obj;
    }

    public void invalidateTable(final int tableId, final int server) throws IOException, SQLException {
        this.requestUpdate(true, AoservProtocol.CommandId.INVALIDATE_TABLE, new UpdateRequest(){
            private IntList tableList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(tableId);
                out.writeCompressedInt(server);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unknown response code: " + code);
                }
                this.tableList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                AoservConnector.this.tablesUpdated(this.tableList);
            }
        });
    }

    public static IntList readInvalidateList(StreamableInput in) throws IOException {
        int tableId;
        IntArrayList tableList = null;
        while ((tableId = in.readCompressedInt()) != -1) {
            if (tableList == null) {
                tableList = new IntArrayList();
            }
            tableList.add(tableId);
        }
        return tableList;
    }

    public abstract boolean isSecure() throws IOException;

    public final int ping() throws IOException, SQLException {
        long startTime = System.currentTimeMillis();
        this.requestUpdate(false, AoservProtocol.CommandId.PING, new Object[0]);
        long timeSpan = System.currentTimeMillis() - startTime;
        if (timeSpan > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)timeSpan;
    }

    public abstract void printConnectionStatsHtml(Appendable var1, boolean var2) throws IOException;

    protected abstract void release(AoservConnection var1) throws IOException;

    public final void removeFromAllTables(TableListener listener) {
        for (AoservTable<?, ?> table : this.tables) {
            table.removeTableListener(listener);
        }
    }

    static void writeParams(Object[] params, StreamableOutput out) throws IOException {
        for (Object param : params) {
            if (param == null) {
                throw new NullPointerException("param is null");
            }
            if (param instanceof Integer) {
                out.writeCompressedInt(((Integer)param).intValue());
                continue;
            }
            if (param instanceof Table.TableId) {
                out.writeCompressedInt(((Table.TableId)((Object)param)).ordinal());
                continue;
            }
            if (param instanceof String) {
                out.writeUTF((String)param);
                continue;
            }
            if (param instanceof Float) {
                out.writeFloat(((Float)param).floatValue());
                continue;
            }
            if (param instanceof Long) {
                out.writeLong(((Long)param).longValue());
                continue;
            }
            if (param instanceof Boolean) {
                out.writeBoolean(((Boolean)param).booleanValue());
                continue;
            }
            if (param instanceof Short) {
                out.writeShort((int)((Short)param).shortValue());
                continue;
            }
            if (param instanceof Byte) {
                out.writeByte((int)((Byte)param).byteValue());
                continue;
            }
            if (param instanceof Timestamp) {
                SQLStreamables.writeTimestamp((Timestamp)((Timestamp)param), (DataOutputStream)out);
                continue;
            }
            if (param instanceof Enum) {
                out.writeEnum((Enum)param);
                continue;
            }
            if (param instanceof byte[]) {
                byte[] bytes = (byte[])param;
                out.writeCompressedInt(bytes.length);
                out.write(bytes, 0, bytes.length);
                continue;
            }
            if (param instanceof Account.Name) {
                out.writeUTF(((Account.Name)param).toString());
                continue;
            }
            if (param instanceof Email) {
                out.writeUTF(((Email)param).toString());
                continue;
            }
            if (param instanceof HostAddress) {
                out.writeUTF(((HostAddress)param).toString());
                continue;
            }
            if (param instanceof InetAddress) {
                out.writeUTF(((InetAddress)param).toString());
                continue;
            }
            if (param instanceof PosixPath) {
                out.writeUTF(((PosixPath)param).toString());
                continue;
            }
            if (param instanceof User.Name) {
                out.writeUTF(((User.Name)param).toString());
                continue;
            }
            if (param instanceof DomainLabel) {
                out.writeUTF(((DomainLabel)param).toString());
                continue;
            }
            if (param instanceof DomainLabels) {
                out.writeUTF(((DomainLabels)param).toString());
                continue;
            }
            if (param instanceof DomainName) {
                out.writeUTF(((DomainName)param).toString());
                continue;
            }
            if (param instanceof User.Gecos) {
                out.writeUTF(((User.Gecos)param).toString());
                continue;
            }
            if (param instanceof Group.Name) {
                out.writeUTF(((Group.Name)param).toString());
                continue;
            }
            if (param instanceof HashedKey) {
                out.writeUTF(((HashedKey)param).toString());
                continue;
            }
            if (param instanceof HashedPassword) {
                out.writeUTF(((HashedPassword)param).toString());
                continue;
            }
            if (param instanceof LinuxId) {
                out.writeCompressedInt(((LinuxId)param).getId());
                continue;
            }
            if (param instanceof User.Name) {
                out.writeUTF(((User.Name)param).toString());
                continue;
            }
            if (param instanceof MacAddress) {
                out.writeUTF(((MacAddress)param).toString());
                continue;
            }
            if (param instanceof Database.Name) {
                out.writeUTF(((Database.Name)param).toString());
                continue;
            }
            if (param instanceof Server.Name) {
                out.writeUTF(((Server.Name)param).toString());
                continue;
            }
            if (param instanceof TableName) {
                out.writeUTF(((TableName)param).toString());
                continue;
            }
            if (param instanceof User.Name) {
                out.writeUTF(((User.Name)param).toString());
                continue;
            }
            if (param instanceof Port) {
                Port port = (Port)param;
                out.writeCompressedInt(port.getPort());
                out.writeEnum((Enum)port.getProtocol());
                continue;
            }
            if (param instanceof Database.Name) {
                out.writeUTF(((Database.Name)param).toString());
                continue;
            }
            if (param instanceof Server.Name) {
                out.writeUTF(((Server.Name)param).toString());
                continue;
            }
            if (param instanceof User.Name) {
                out.writeUTF(((User.Name)param).toString());
                continue;
            }
            if (param instanceof AoservWritable) {
                ((AoservWritable)param).write(out, AoservProtocol.Version.CURRENT_VERSION);
                continue;
            }
            if (param instanceof StreamWritable) {
                ((StreamWritable)param).write(out, AoservProtocol.Version.CURRENT_VERSION.getVersion());
                continue;
            }
            throw new IOException("Unknown class for param: " + param.getClass().getName());
        }
    }

    public final <T> T requestResult(boolean allowRetry, AoservProtocol.CommandId commandId, ResultRequest<T> resultRequest) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                try (AoservConnection connection = this.getConnection(1);){
                    try {
                        StreamableOutput out = connection.getRequestOut(commandId);
                        resultRequest.writeRequest(out);
                        out.flush();
                        resultRequest.readResponse(connection.getResponseIn());
                    }
                    catch (IOException | Error | RuntimeException err) {
                        throw (IOException)Throwables.wrap((Throwable)connection.abort(err), IOException.class, IOException::new);
                    }
                }
                return resultRequest.afterRelease();
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted() || attempt >= attempts || AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
            }
        }
        assert (Thread.currentThread().isInterrupted());
        throw new InterruptedIOException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean requestBooleanQuery(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                if ($assertionsDisabled) throw new InterruptedIOException();
                if (Thread.currentThread().isInterrupted()) throw new InterruptedIOException();
                throw new AssertionError();
            }
            try (AoservConnection connection = this.getConnection(1);){
                StreamableOutput out = connection.getRequestOut(commandId);
                AoservConnector.writeParams(params, out);
                out.flush();
                StreamableInput in = connection.getResponseIn();
                byte code = in.readByte();
                if (code == 1) {
                    boolean bl = in.readBoolean();
                    return bl;
                }
                AoservProtocol.checkResult(code, in);
                throw new IOException("Unexpected response code: " + code);
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted()) throw err;
                if (attempt >= attempts) throw err;
                if (AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    public final boolean requestBooleanQueryInvalidating(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                IntList invalidateList;
                boolean result;
                block16: {
                    try (AoservConnection connection = this.getConnection(1);){
                        try {
                            StreamableOutput out = connection.getRequestOut(commandId);
                            AoservConnector.writeParams(params, out);
                            out.flush();
                            StreamableInput in = connection.getResponseIn();
                            byte code = in.readByte();
                            if (code == 1) {
                                result = in.readBoolean();
                                invalidateList = AoservConnector.readInvalidateList(in);
                                break block16;
                            }
                            AoservProtocol.checkResult(code, in);
                            throw new IOException("Unexpected response code: " + code);
                        }
                        catch (IOException | Error | RuntimeException err) {
                            throw (IOException)Throwables.wrap((Throwable)connection.abort(err), IOException.class, IOException::new);
                        }
                    }
                }
                this.tablesUpdated(invalidateList);
                return result;
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted() || attempt >= attempts || AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
            }
        }
        assert (Thread.currentThread().isInterrupted());
        throw new InterruptedIOException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int requestIntQuery(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                if ($assertionsDisabled) throw new InterruptedIOException();
                if (Thread.currentThread().isInterrupted()) throw new InterruptedIOException();
                throw new AssertionError();
            }
            try (AoservConnection connection = this.getConnection(1);){
                StreamableOutput out = connection.getRequestOut(commandId);
                AoservConnector.writeParams(params, out);
                out.flush();
                StreamableInput in = connection.getResponseIn();
                byte code = in.readByte();
                if (code == 1) {
                    int n2 = in.readCompressedInt();
                    return n2;
                }
                AoservProtocol.checkResult(code, in);
                throw new IOException("Unexpected response code: " + code);
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted()) throw err;
                if (attempt >= attempts) throw err;
                if (AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    public final int requestIntQueryInvalidating(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                IntList invalidateList;
                int result;
                block16: {
                    try (AoservConnection connection = this.getConnection(1);){
                        try {
                            StreamableOutput out = connection.getRequestOut(commandId);
                            AoservConnector.writeParams(params, out);
                            out.flush();
                            StreamableInput in = connection.getResponseIn();
                            byte code = in.readByte();
                            if (code == 1) {
                                result = in.readCompressedInt();
                                invalidateList = AoservConnector.readInvalidateList(in);
                                break block16;
                            }
                            AoservProtocol.checkResult(code, in);
                            throw new IOException("Unexpected response code: " + code);
                        }
                        catch (IOException | Error | RuntimeException err) {
                            throw (IOException)Throwables.wrap((Throwable)connection.abort(err), IOException.class, IOException::new);
                        }
                    }
                }
                this.tablesUpdated(invalidateList);
                return result;
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted() || attempt >= attempts || AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
            }
        }
        assert (Thread.currentThread().isInterrupted());
        throw new InterruptedIOException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long requestLongQuery(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                if ($assertionsDisabled) throw new InterruptedIOException();
                if (Thread.currentThread().isInterrupted()) throw new InterruptedIOException();
                throw new AssertionError();
            }
            try (AoservConnection connection = this.getConnection(1);){
                StreamableOutput out = connection.getRequestOut(commandId);
                AoservConnector.writeParams(params, out);
                out.flush();
                StreamableInput in = connection.getResponseIn();
                byte code = in.readByte();
                if (code == 1) {
                    long l = in.readLong();
                    return l;
                }
                AoservProtocol.checkResult(code, in);
                throw new IOException("Unexpected response code: " + code);
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted()) throw err;
                if (attempt >= attempts) throw err;
                if (AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final short requestShortQuery(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                if ($assertionsDisabled) throw new InterruptedIOException();
                if (Thread.currentThread().isInterrupted()) throw new InterruptedIOException();
                throw new AssertionError();
            }
            try (AoservConnection connection = this.getConnection(1);){
                StreamableOutput out = connection.getRequestOut(commandId);
                AoservConnector.writeParams(params, out);
                out.flush();
                StreamableInput in = connection.getResponseIn();
                byte code = in.readByte();
                if (code == 1) {
                    short s = in.readShort();
                    return s;
                }
                AoservProtocol.checkResult(code, in);
                throw new IOException("Unexpected response code: " + code);
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted()) throw err;
                if (attempt >= attempts) throw err;
                if (AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    public final short requestShortQueryInvalidating(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                IntList invalidateList;
                short result;
                block16: {
                    try (AoservConnection connection = this.getConnection(1);){
                        try {
                            StreamableOutput out = connection.getRequestOut(commandId);
                            AoservConnector.writeParams(params, out);
                            out.flush();
                            StreamableInput in = connection.getResponseIn();
                            byte code = in.readByte();
                            if (code == 1) {
                                result = in.readShort();
                                invalidateList = AoservConnector.readInvalidateList(in);
                                break block16;
                            }
                            AoservProtocol.checkResult(code, in);
                            throw new IOException("Unexpected response code: " + code);
                        }
                        catch (IOException | Error | RuntimeException err) {
                            throw (IOException)Throwables.wrap((Throwable)connection.abort(err), IOException.class, IOException::new);
                        }
                    }
                }
                this.tablesUpdated(invalidateList);
                return result;
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted() || attempt >= attempts || AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
            }
        }
        assert (Thread.currentThread().isInterrupted());
        throw new InterruptedIOException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String requestStringQuery(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                if ($assertionsDisabled) throw new InterruptedIOException();
                if (Thread.currentThread().isInterrupted()) throw new InterruptedIOException();
                throw new AssertionError();
            }
            try (AoservConnection connection = this.getConnection(1);){
                StreamableOutput out = connection.getRequestOut(commandId);
                AoservConnector.writeParams(params, out);
                out.flush();
                StreamableInput in = connection.getResponseIn();
                byte code = in.readByte();
                if (code == 1) {
                    String string = in.readUTF();
                    return string;
                }
                AoservProtocol.checkResult(code, in);
                throw new IOException("Unexpected response code: " + code);
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted()) throw err;
                if (attempt >= attempts) throw err;
                if (AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String requestLongStringQuery(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                if ($assertionsDisabled) throw new InterruptedIOException();
                if (Thread.currentThread().isInterrupted()) throw new InterruptedIOException();
                throw new AssertionError();
            }
            try (AoservConnection connection = this.getConnection(1);){
                StreamableOutput out = connection.getRequestOut(commandId);
                AoservConnector.writeParams(params, out);
                out.flush();
                StreamableInput in = connection.getResponseIn();
                byte code = in.readByte();
                if (code == 1) {
                    String string = in.readLongUTF();
                    return string;
                }
                AoservProtocol.checkResult(code, in);
                throw new IOException("Unexpected response code: " + code);
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted()) throw err;
                if (attempt >= attempts) throw err;
                if (AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String requestNullLongStringQuery(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                if ($assertionsDisabled) throw new InterruptedIOException();
                if (Thread.currentThread().isInterrupted()) throw new InterruptedIOException();
                throw new AssertionError();
            }
            try (AoservConnection connection = this.getConnection(1);){
                StreamableOutput out = connection.getRequestOut(commandId);
                AoservConnector.writeParams(params, out);
                out.flush();
                StreamableInput in = connection.getResponseIn();
                byte code = in.readByte();
                if (code == 1) {
                    String string = in.readNullLongUTF();
                    return string;
                }
                AoservProtocol.checkResult(code, in);
                throw new IOException("Unexpected response code: " + code);
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted()) throw err;
                if (attempt >= attempts) throw err;
                if (AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    public final void requestUpdate(boolean allowRetry, AoservProtocol.CommandId commandId, UpdateRequest updateRequest) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                try (AoservConnection connection = this.getConnection(1);){
                    try {
                        StreamableOutput out = connection.getRequestOut(commandId);
                        updateRequest.writeRequest(out);
                        out.flush();
                        updateRequest.readResponse(connection.getResponseIn());
                    }
                    catch (IOException | Error | RuntimeException err) {
                        throw (IOException)Throwables.wrap((Throwable)connection.abort(err), IOException.class, IOException::new);
                    }
                }
                updateRequest.afterRelease();
                return;
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted() || attempt >= attempts || AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
            }
        }
        assert (Thread.currentThread().isInterrupted());
        throw new InterruptedIOException();
    }

    public final void requestUpdate(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                try (AoservConnection connection = this.getConnection(1);){
                    try {
                        StreamableOutput out = connection.getRequestOut(commandId);
                        AoservConnector.writeParams(params, out);
                        out.flush();
                        StreamableInput in = connection.getResponseIn();
                        byte code = in.readByte();
                        if (code != 1) {
                            AoservProtocol.checkResult(code, in);
                        }
                    }
                    catch (IOException | Error | RuntimeException err) {
                        throw (IOException)Throwables.wrap((Throwable)connection.abort(err), IOException.class, IOException::new);
                    }
                }
                return;
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted() || attempt >= attempts || AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
            }
        }
        assert (Thread.currentThread().isInterrupted());
        throw new InterruptedIOException();
    }

    public final void requestUpdateInvalidating(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        int attempts;
        int attempt = 1;
        int n = attempts = allowRetry ? RETRY_ATTEMPTS : 1;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                IntList invalidateList;
                block16: {
                    try (AoservConnection connection = this.getConnection(1);){
                        try {
                            StreamableOutput out = connection.getRequestOut(commandId);
                            AoservConnector.writeParams(params, out);
                            out.flush();
                            StreamableInput in = connection.getResponseIn();
                            byte code = in.readByte();
                            if (code == 1) {
                                invalidateList = AoservConnector.readInvalidateList(in);
                                break block16;
                            }
                            AoservProtocol.checkResult(code, in);
                            throw new IOException("Unexpected response code: " + code);
                        }
                        catch (IOException | Error | RuntimeException err) {
                            throw (IOException)Throwables.wrap((Throwable)connection.abort(err), IOException.class, IOException::new);
                        }
                    }
                }
                this.tablesUpdated(invalidateList);
                return;
            }
            catch (IOException | Error | RuntimeException | SQLException err) {
                if (Thread.currentThread().isInterrupted() || attempt >= attempts || AoservConnector.isImmediateFail(err)) {
                    throw err;
                }
                try {
                    Thread.sleep(retryAttemptDelays[attempt - 1]);
                }
                catch (InterruptedException err2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err2);
                    throw ioErr;
                }
                ++attempt;
            }
        }
        assert (Thread.currentThread().isInterrupted());
        throw new InterruptedIOException();
    }

    public abstract AoservConnector switchUsers(User.Name var1) throws IOException;

    public final void tablesUpdated(IntList invalidateList) {
        if (invalidateList != null) {
            int tableId;
            int c;
            int size = invalidateList.size();
            for (c = 0; c < size; ++c) {
                tableId = invalidateList.getInt(c);
                this.tables.get(tableId).clearCache();
            }
            for (c = 0; c < size; ++c) {
                tableId = invalidateList.getInt(c);
                this.tables.get(tableId).tableUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testConnect() throws IOException, SQLException {
        TestConnectLock testConnectLock = this.testConnectLock;
        synchronized (testConnectLock) {
            this.requestUpdate(true, AoservProtocol.CommandId.TEST_CONNECTION, new UpdateRequest(){

                @Override
                public void writeRequest(StreamableOutput out) {
                }

                @Override
                public void readResponse(StreamableInput in) throws IOException, SQLException {
                    byte code = in.readByte();
                    if (code != 1) {
                        AoservProtocol.checkResult(code, in);
                        throw new IOException("Unexpected response code: " + code);
                    }
                }

                @Override
                public void afterRelease() {
                }
            });
        }
    }

    public final String toString() {
        return this.getClass().getName() + "?protocol=" + this.getProtocol() + "&hostname=" + this.hostname + "&local_ip=" + this.localIp + "&port=" + this.port + "&connectAs=" + this.connectAs + "&authenticateAs=" + this.authenticateAs;
    }

    void addingTableListener() {
    }

    public int getMasterEntropy(final byte[] buff, final int numBytes) throws IOException, SQLException {
        return this.requestResult(true, AoservProtocol.CommandId.GET_MASTER_ENTROPY, new ResultRequest<Integer>(){
            private int numObtained;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(numBytes);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code == 1) {
                    this.numObtained = in.readCompressedInt();
                    for (int c = 0; c < this.numObtained; ++c) {
                        buff[c] = in.readByte();
                    }
                } else {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
            }

            @Override
            public Integer afterRelease() {
                return this.numObtained;
            }
        });
    }

    public long getMasterEntropyNeeded() throws IOException, SQLException {
        return this.requestLongQuery(true, AoservProtocol.CommandId.GET_MASTER_ENTROPY_NEEDED, new Object[0]);
    }

    public long addMasterEntropy(final byte[] buff, final int numBytes) throws IOException, SQLException {
        return this.requestResult(true, AoservProtocol.CommandId.ADD_MASTER_ENTROPY, new ResultRequest<Long>(){
            private long entropyNeeded;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(numBytes);
                out.write(buff, 0, numBytes);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.entropyNeeded = in.readLong();
            }

            @Override
            public Long afterRelease() {
                return this.entropyNeeded;
            }
        });
    }

    public <K, T extends AoservObject<K, T>> void sort(ComparisonSortAlgorithm<? super T> sortAlgorithm, T[] list, SqlExpression[] sortExpressions, boolean[] sortOrders) {
        sortAlgorithm.sort((Object[])list, new SqlComparator(this, sortExpressions, sortOrders));
    }

    public <K, T extends AoservObject<K, T>> void sort(ComparisonSortAlgorithm<? super T> sortAlgorithm, List<T> list, SqlExpression[] sortExpressions, boolean[] sortOrders) {
        sortAlgorithm.sort(list, new SqlComparator(this, sortExpressions, sortOrders));
    }

    public static interface UpdateRequest {
        public void writeRequest(StreamableOutput var1) throws IOException;

        public void readResponse(StreamableInput var1) throws IOException, SQLException;

        public void afterRelease();
    }

    public static interface ResultRequest<T> {
        public void writeRequest(StreamableOutput var1) throws IOException;

        public void readResponse(StreamableInput var1) throws IOException, SQLException;

        public T afterRelease();
    }

    private static class TestConnectLock {
        private TestConnectLock() {
        }
    }

    protected static class IdLock {
        protected IdLock() {
        }
    }
}

