/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.hodgepodge.table.Row;
import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.exception.WrappedException;
import com.aoapps.lang.util.ComparatorUtils;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainLabel;
import com.aoapps.net.DomainName;
import com.aoapps.net.Email;
import com.aoapps.net.HostAddress;
import com.aoapps.net.MacAddress;
import com.aoapps.net.Protocol;
import com.aoapps.net.dto.DomainLabels;
import com.aoapps.net.dto.InetAddress;
import com.aoapps.net.dto.Port;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservStreamable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.dto.AccountName;
import com.aoindustries.aoserv.client.dto.Gecos;
import com.aoindustries.aoserv.client.dto.HashedKey;
import com.aoindustries.aoserv.client.dto.HashedPassword;
import com.aoindustries.aoserv.client.dto.LinuxGroupName;
import com.aoindustries.aoserv.client.dto.LinuxUserName;
import com.aoindustries.aoserv.client.dto.MysqlDatabaseName;
import com.aoindustries.aoserv.client.dto.MysqlServerName;
import com.aoindustries.aoserv.client.dto.MysqlUserName;
import com.aoindustries.aoserv.client.dto.PostgresDatabaseName;
import com.aoindustries.aoserv.client.dto.PostgresServerName;
import com.aoindustries.aoserv.client.dto.PostgresUserName;
import com.aoindustries.aoserv.client.dto.UserName;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.LinuxId;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.mysql.Database;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.mysql.User;
import com.aoindustries.aoserv.client.postgresql.Database;
import com.aoindustries.aoserv.client.postgresql.Server;
import com.aoindustries.aoserv.client.postgresql.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.schema.Type;
import com.aoindustries.aoserv.client.sql.SqlExpression;
import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class AoservObject<K, T extends AoservObject<K, T>>
implements Row,
AoservStreamable {
    public static final boolean USE_SQL_DATA = false;
    public static final boolean USE_SQL_DATA_WRITE = false;
    public static final boolean USE_ARRAY_OF_DOMAIN = false;

    @Deprecated
    protected AoservObject() {
    }

    @Deprecated
    public static int compareIgnoreCaseConsistentWithEquals(String s1, String s2) {
        return ComparatorUtils.compareIgnoreCaseConsistentWithEquals((String)s1, (String)s2);
    }

    @Deprecated
    public static int compare(int i1, int i2) {
        return ComparatorUtils.compare((int)i1, (int)i2);
    }

    @Deprecated
    public static int compare(short s1, short s2) {
        return ComparatorUtils.compare((short)s1, (short)s2);
    }

    @Deprecated
    public static int compare(long l1, long l2) {
        return ComparatorUtils.compare((long)l1, (long)l2);
    }

    public static <T extends Comparable<T>> int compare(T obj1, T obj2) {
        if (obj1 != null) {
            return obj2 != null ? obj1.compareTo(obj2) : -1;
        }
        return obj2 != null ? 1 : 0;
    }

    public final int compareTo(AoservConnector conn, AoservObject<?, ?> other, SqlExpression[] sortExpressions, boolean[] sortOrders) throws IllegalArgumentException, SQLException, UnknownHostException, IOException {
        int len = sortExpressions.length;
        for (int c = 0; c < len; ++c) {
            SqlExpression expr = sortExpressions[c];
            Type type = expr.getType();
            Object value1 = null;
            boolean value1Set = false;
            Object value2 = null;
            boolean value2Set = false;
            try {
                value1 = expr.evaluate(conn, this);
                value1Set = true;
                value2 = expr.evaluate(conn, other);
                value2Set = true;
                int diff = type.compareTo(value1, value2);
                if (diff == 0) continue;
                return sortOrders[c] ? diff : -diff;
            }
            catch (RuntimeException e) {
                String getString2;
                String getString1;
                if (!value1Set) {
                    getString1 = "<unset>";
                } else if (value1 == null) {
                    getString1 = "[NULL]";
                } else {
                    try {
                        getString1 = type.getString(value1, -1);
                    }
                    catch (RuntimeException e2) {
                        getString1 = value1.toString();
                    }
                }
                if (!value2Set) {
                    getString2 = "<unset>";
                } else if (value2 == null) {
                    getString2 = "[NULL]";
                } else {
                    try {
                        getString2 = type.getString(value2, -1);
                    }
                    catch (RuntimeException e2) {
                        getString2 = value2.toString();
                    }
                }
                throw new SQLException("expr......: " + expr + "\ntype......: " + type + "\nthis......: " + this + "\nother.....: " + other + "\nthisKey...: " + this.getKey() + "\notherKey..: " + other.getKey() + "\nthisValue.: " + getString1 + "\notherValue: " + getString2, e);
            }
        }
        return 0;
    }

    public final int compareTo(AoservConnector conn, Comparable<?> value, SqlExpression[] sortExpressions, boolean[] sortOrders) throws IllegalArgumentException, SQLException, UnknownHostException, IOException {
        int len = sortExpressions.length;
        for (int c = 0; c < len; ++c) {
            SqlExpression expr = sortExpressions[c];
            Type type = expr.getType();
            int diff = type.compareTo(expr.evaluate(conn, this), value);
            if (diff == 0) continue;
            return sortOrders[c] ? diff : -diff;
        }
        return 0;
    }

    public final int compareTo(AoservConnector conn, Object[] objects, SqlExpression[] sortExpressions, boolean[] sortOrders) throws IllegalArgumentException, SQLException, UnknownHostException, IOException {
        int len = sortExpressions.length;
        if (len != objects.length) {
            throw new IllegalArgumentException("Array length mismatch when comparing AoservObject to Object[]: sortExpressions.length=" + len + ", objects.length=" + objects.length);
        }
        for (int c = 0; c < len; ++c) {
            SqlExpression expr = sortExpressions[c];
            Type type = expr.getType();
            int diff = type.compareTo(expr.evaluate(conn, this), objects[c]);
            if (diff == 0) continue;
            return sortOrders[c] ? diff : -diff;
        }
        return 0;
    }

    protected static <B> B getDto(DtoFactory<B> dtoFactory) {
        return (B)(dtoFactory == null ? null : dtoFactory.getDto());
    }

    protected static Account.Name getAccountingCode(AccountName accounting) throws ValidationException {
        if (accounting == null) {
            return null;
        }
        return Account.Name.valueOf(accounting.getAccounting());
    }

    protected static DomainLabel getDomainLabel(com.aoapps.net.dto.DomainLabel domainLabel) throws ValidationException {
        if (domainLabel == null) {
            return null;
        }
        return DomainLabel.valueOf((String)domainLabel.getLabel());
    }

    protected static com.aoapps.net.DomainLabels getDomainLabels(DomainLabels domainLabels) throws ValidationException {
        if (domainLabels == null) {
            return null;
        }
        return com.aoapps.net.DomainLabels.valueOf((String)domainLabels.getLabels());
    }

    protected static DomainName getDomainName(com.aoapps.net.dto.DomainName domainName) throws ValidationException {
        if (domainName == null) {
            return null;
        }
        return DomainName.valueOf((String)domainName.getDomain());
    }

    protected static Email getEmail(com.aoapps.net.dto.Email email) throws ValidationException {
        if (email == null) {
            return null;
        }
        return Email.valueOf((String)email.getLocalPart(), (DomainName)DomainName.valueOf((String)email.getDomain().getDomain()));
    }

    protected static User.Gecos getGecos(Gecos gecos) throws ValidationException {
        if (gecos == null) {
            return null;
        }
        return User.Gecos.valueOf(gecos.getValue());
    }

    protected static Group.Name getGroupId(LinuxGroupName gid) throws ValidationException {
        if (gid == null) {
            return null;
        }
        return Group.Name.valueOf(gid.getName());
    }

    protected static com.aoapps.security.HashedKey getHashedKey(HashedKey hashedKey) throws IllegalArgumentException {
        if (hashedKey == null) {
            return null;
        }
        return com.aoapps.security.HashedKey.valueOf((String)hashedKey.getHashedKey());
    }

    protected static com.aoapps.security.HashedPassword getHashedPassword(HashedPassword hashedPassword) throws IllegalArgumentException {
        if (hashedPassword == null) {
            return null;
        }
        return com.aoapps.security.HashedPassword.valueOf((String)hashedPassword.getHashedPassword());
    }

    protected static HostAddress getHostname(com.aoapps.net.dto.HostAddress hostname) throws ValidationException {
        if (hostname == null) {
            return null;
        }
        return HostAddress.valueOf((String)hostname.getAddress());
    }

    protected static com.aoapps.net.InetAddress getInetAddress(InetAddress inetAddress) throws ValidationException {
        if (inetAddress == null) {
            return null;
        }
        return com.aoapps.net.InetAddress.valueOf((String)inetAddress.getAddress());
    }

    protected static LinuxId getLinuxId(com.aoindustries.aoserv.client.dto.LinuxId lid) throws ValidationException {
        if (lid == null) {
            return null;
        }
        return LinuxId.valueOf(lid.getId());
    }

    protected static User.Name getLinuxUserName(LinuxUserName linuxUserName) throws ValidationException {
        if (linuxUserName == null) {
            return null;
        }
        return User.Name.valueOf(linuxUserName.getName());
    }

    protected static MacAddress getMacAddress(com.aoapps.net.dto.MacAddress macAddress) throws ValidationException {
        if (macAddress == null) {
            return null;
        }
        return MacAddress.valueOf((String)macAddress.getAddress());
    }

    protected static Database.Name getMysqlDatabaseName(MysqlDatabaseName databaseName) throws ValidationException {
        if (databaseName == null) {
            return null;
        }
        return Database.Name.valueOf(databaseName.getName());
    }

    protected static Server.Name getMysqlServerName(MysqlServerName serverName) throws ValidationException {
        if (serverName == null) {
            return null;
        }
        return Server.Name.valueOf(serverName.getName());
    }

    protected static User.Name getMysqlUserName(MysqlUserName mysqlUserId) throws ValidationException {
        if (mysqlUserId == null) {
            return null;
        }
        return User.Name.valueOf(mysqlUserId.getName());
    }

    protected static com.aoapps.net.Port getPort(Port port) throws ValidationException {
        if (port == null) {
            return null;
        }
        return com.aoapps.net.Port.valueOf((int)port.getPort(), (Protocol)Protocol.valueOf((String)port.getProtocol()));
    }

    protected static Database.Name getPostgresDatabaseName(PostgresDatabaseName databaseName) throws ValidationException {
        if (databaseName == null) {
            return null;
        }
        return Database.Name.valueOf(databaseName.getName());
    }

    protected static Server.Name getPostgresServerName(PostgresServerName serverName) throws ValidationException {
        if (serverName == null) {
            return null;
        }
        return Server.Name.valueOf(serverName.getName());
    }

    protected static User.Name getPostgresUserId(PostgresUserName postgresUserId) throws ValidationException {
        if (postgresUserId == null) {
            return null;
        }
        return User.Name.valueOf(postgresUserId.getName());
    }

    protected static Long getTimeMillis(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    protected static Long getTimeMillis(Calendar datetime) {
        if (datetime == null) {
            return null;
        }
        return datetime.getTimeInMillis();
    }

    protected static PosixPath getUnixPath(com.aoindustries.aoserv.client.dto.PosixPath unixPath) throws ValidationException {
        if (unixPath == null) {
            return null;
        }
        return PosixPath.valueOf(unixPath.getPath());
    }

    protected static User.Name getUserId(UserName userId) throws ValidationException {
        if (userId == null) {
            return null;
        }
        return User.Name.valueOf(userId.getName());
    }

    public boolean equals(Object obj) {
        Class<?> class2;
        if (obj == null) {
            return false;
        }
        Class<?> class1 = this.getClass();
        if (class1 == (class2 = obj.getClass())) {
            K pkey1 = this.getKey();
            K pkey2 = ((AoservObject)obj).getKey();
            if (pkey1 == null || pkey2 == null) {
                throw new NullPointerException("No primary key available.");
            }
            return pkey1.equals(pkey2);
        }
        return false;
    }

    public final Object getColumn(int i) {
        try {
            return this.getColumnImpl(i);
        }
        catch (IOException | SQLException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    protected abstract Object getColumnImpl(int var1) throws IOException, SQLException;

    public final List<Object> getColumns(AoservConnector connector) throws IOException, SQLException {
        int len = this.getTableSchema(connector).getSchemaColumns(connector).size();
        ArrayList<Object> buff = new ArrayList<Object>(len);
        for (int c = 0; c < len; ++c) {
            buff.add(this.getColumn(c));
        }
        return buff;
    }

    public final int getColumns(AoservConnector connector, List<Object> buff) throws IOException, SQLException {
        int len = this.getTableSchema(connector).getSchemaColumns(connector).size();
        for (int c = 0; c < len; ++c) {
            buff.add(this.getColumn(c));
        }
        return len;
    }

    public abstract K getKey();

    public abstract Table.TableId getTableId();

    public final Table getTableSchema(AoservConnector connector) throws IOException, SQLException {
        return connector.getSchema().getTable().get(this.getTableId());
    }

    public int hashCode() {
        K pkey = this.getKey();
        if (pkey == null) {
            throw new NullPointerException("No primary key available.");
        }
        return pkey.hashCode();
    }

    public abstract void init(ResultSet var1) throws SQLException;

    @Override
    @Deprecated
    public final void read(StreamableInput in, String protocolVersion) throws IOException {
        this.read(in, AoservProtocol.Version.getVersion(protocolVersion));
    }

    @Override
    public abstract void read(StreamableInput var1, AoservProtocol.Version var2) throws IOException;

    public final String toString() {
        try {
            return this.toStringImpl();
        }
        catch (IOException | SQLException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    public String toStringImpl() throws IOException, SQLException {
        K pkey = this.getKey();
        if (pkey == null) {
            return super.toString();
        }
        return pkey.toString();
    }

    @Override
    @Deprecated
    public final void write(StreamableOutput out, String protocolVersion) throws IOException {
        this.write(out, AoservProtocol.Version.getVersion(protocolVersion));
    }

    @Override
    public abstract void write(StreamableOutput var1, AoservProtocol.Version var2) throws IOException;
}

