/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.hodgepodge.sort.ComparisonSortAlgorithm;
import com.aoapps.hodgepodge.sort.JavaSort;
import com.aoapps.hodgepodge.table.TableListener;
import com.aoapps.lang.Throwables;
import com.aoapps.lang.exception.WrappedException;
import com.aoapps.sql.SQLUtility;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservObject;
import com.aoindustries.aoserv.client.AoservWritable;
import com.aoindustries.aoserv.client.EntrySet;
import com.aoindustries.aoserv.client.KeySet;
import com.aoindustries.aoserv.client.ProgressListener;
import com.aoindustries.aoserv.client.SingleTableObject;
import com.aoindustries.aoserv.client.TableLoadListener;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Column;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.schema.Type;
import com.aoindustries.aoserv.client.sql.Parser;
import com.aoindustries.aoserv.client.sql.SqlExpression;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;

public abstract class AoservTable<K, V extends AoservObject<K, V>>
implements Iterable<V>,
com.aoapps.hodgepodge.table.Table<V> {
    protected final AoservConnector connector;
    final Class<V> clazz;
    private final TableListenersLock tableListenersLock = new TableListenersLock();
    private List<TableListenerEntry> tableListeners;
    final EventLock eventLock = new EventLock();
    private TableEventThread thread;
    final List<ProgressListener> progressListeners = new ArrayList<ProgressListener>();
    final List<TableLoadListenerEntry> loadListeners = new ArrayList<TableLoadListenerEntry>();
    public static final boolean ASCENDING = true;
    public static final boolean DESCENDING = false;
    private final Map<K, V> map = new Map<K, V>(){

        @Override
        public V get(Object key) {
            try {
                return AoservTable.this.get(key);
            }
            catch (IOException | SQLException err) {
                throw new WrappedException((Throwable)err);
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            try {
                return new EntrySet(AoservTable.this.getRows());
            }
            catch (IOException | SQLException err) {
                throw new WrappedException((Throwable)err);
            }
        }

        @Override
        public Collection<V> values() {
            try {
                return AoservTable.this.getRows();
            }
            catch (IOException | SQLException err) {
                throw new WrappedException((Throwable)err);
            }
        }

        @Override
        public Set<K> keySet() {
            try {
                return new KeySet(AoservTable.this.getRows());
            }
            catch (IOException | SQLException err) {
                throw new WrappedException((Throwable)err);
            }
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            if (!AoservTable.this.clazz.isInstance(value)) {
                return false;
            }
            return this.containsKey(((AoservObject)AoservTable.this.clazz.cast(value)).getKey());
        }

        @Override
        public boolean containsKey(Object key) {
            try {
                return AoservTable.this.get(key) != null;
            }
            catch (IOException | SQLException err) {
                throw new WrappedException((Throwable)err);
            }
        }

        @Override
        public boolean isEmpty() {
            try {
                return AoservTable.this.isEmpty();
            }
            catch (IOException | SQLException err) {
                throw new WrappedException((Throwable)err);
            }
        }

        @Override
        public int size() {
            try {
                return AoservTable.this.size();
            }
            catch (IOException | SQLException err) {
                throw new WrappedException((Throwable)err);
            }
        }
    };

    protected AoservTable(AoservConnector connector, Class<V> clazz) {
        this.connector = connector;
        this.clazz = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addProgressListener(ProgressListener listener) {
        List<ProgressListener> list = this.progressListeners;
        synchronized (list) {
            this.progressListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasAnyTableListener() {
        TableListenersLock tableListenersLock = this.tableListenersLock;
        synchronized (tableListenersLock) {
            return this.tableListeners != null && !this.tableListeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasTableListener(TableListener listener) {
        TableListenersLock tableListenersLock = this.tableListenersLock;
        synchronized (tableListenersLock) {
            if (this.tableListeners == null) {
                return false;
            }
            for (TableListenerEntry tableListenerEntry : this.tableListeners) {
                if (tableListenerEntry.listener != listener) continue;
                return true;
            }
            return false;
        }
    }

    public final void addTableListener(TableListener listener) {
        this.addTableListener(listener, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTableListener(TableListener listener, long batchTime) {
        if (batchTime < 0L) {
            throw new IllegalArgumentException("batchTime<0: " + batchTime);
        }
        Object object = this.tableListenersLock;
        synchronized (object) {
            if (this.tableListeners == null) {
                this.tableListeners = new ArrayList<TableListenerEntry>();
            }
            this.tableListeners.add(new TableListenerEntry(listener, batchTime));
        }
        object = this.eventLock;
        synchronized (object) {
            if (batchTime > 0L && this.thread == null) {
                this.thread = new TableEventThread();
                this.thread.start();
            }
            this.eventLock.notifyAll();
        }
        this.connector.addingTableListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTableLoadListener(TableLoadListener listener, Object param) {
        List<TableLoadListenerEntry> list = this.loadListeners;
        synchronized (list) {
            this.loadListeners.add(new TableLoadListenerEntry(listener, param));
        }
    }

    public void clearCache() {
    }

    public final AoservConnector getConnector() {
        return this.connector;
    }

    protected abstract OrderBy[] getDefaultOrderBy();

    public final SqlExpression[] getDefaultOrderBySqlExpressions() throws SQLException, IOException {
        OrderBy[] orderBys = this.getDefaultOrderBy();
        if (orderBys == null) {
            return null;
        }
        int len = orderBys.length;
        SqlExpression[] exprs = new SqlExpression[len];
        for (int c = 0; c < len; ++c) {
            exprs[c] = Parser.parseSqlExpression(this, orderBys[c].getExpression());
        }
        return exprs;
    }

    protected V getNewObject() throws IOException {
        try {
            try {
                return (V)((AoservObject)this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw cause == null ? e : cause;
            }
        }
        catch (Throwable t) {
            throw (IOException)Throwables.wrap((Throwable)t, IOException.class, IOException::new);
        }
    }

    protected V getObject(boolean allowRetry, AoservProtocol.CommandId commandId, final Object ... params) throws IOException, SQLException {
        return (V)((AoservObject)this.connector.requestResult(allowRetry, commandId, new AoservConnector.ResultRequest<V>(){
            private V result;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                AoservConnector.writeParams(params, out);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code == 0) {
                    Object obj = AoservTable.this.getNewObject();
                    ((AoservObject)obj).read(in, AoservProtocol.Version.CURRENT_VERSION);
                    if (obj instanceof SingleTableObject) {
                        SingleTableObject sto = (SingleTableObject)obj;
                        sto.setTable(AoservTable.this);
                    }
                    this.result = obj;
                } else {
                    AoservProtocol.checkResult(code, in);
                    this.result = null;
                }
            }

            @Override
            public V afterRelease() {
                return this.result;
            }
        }));
    }

    protected List<V> getObjects(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        ArrayList list = new ArrayList();
        this.getObjects(allowRetry, list, commandId, params);
        return list;
    }

    private void getObjects(boolean allowRetry, final boolean withProgress, final List<V> list, AoservProtocol.CommandId commandId, final Object ... params) throws IOException, SQLException {
        TableLoadListenerEntry entry;
        int c;
        int[] lastProgresses;
        int[] progressScales;
        int progCount;
        final int initialSize = list.size();
        final ProgressListener[] progListeners = withProgress ? this.getProgressListeners() : null;
        int n = progCount = progListeners == null ? 0 : progListeners.length;
        if (progListeners != null) {
            progressScales = new int[progCount];
            for (int c2 = 0; c2 < progCount; ++c2) {
                progressScales[c2] = progListeners[c2].getScale();
            }
            lastProgresses = new int[progCount];
        } else {
            progressScales = null;
            lastProgresses = null;
        }
        final TableLoadListenerEntry[] myLoadListeners = this.getTableLoadListeners();
        final int loadCount = myLoadListeners == null ? 0 : myLoadListeners.length;
        for (c = 0; c < progCount; ++c) {
            progListeners[c].onProgressChanged(this, 0, progressScales[c]);
        }
        for (c = 0; c < loadCount; ++c) {
            entry = myLoadListeners[c];
            entry.param = entry.listener.onTableLoadStarted(this, entry.param);
        }
        try {
            try {
                this.connector.requestUpdate(allowRetry, commandId, new AoservConnector.UpdateRequest(){

                    @Override
                    public void writeRequest(StreamableOutput out) throws IOException {
                        if (withProgress) {
                            out.writeBoolean(progListeners != null);
                        }
                        AoservConnector.writeParams(params, out);
                    }

                    @Override
                    public void readResponse(StreamableInput in) throws IOException, SQLException {
                        byte code;
                        if (initialSize == 0) {
                            list.clear();
                        } else {
                            while (list.size() > initialSize) {
                                list.remove(list.size() - 1);
                            }
                        }
                        for (int c = 0; c < progCount; ++c) {
                            if (lastProgresses[c] == 0) continue;
                            lastProgresses[c] = 0;
                            progListeners[c].onProgressChanged(AoservTable.this, 0, progressScales[c]);
                        }
                        byte by = code = progListeners == null ? (byte)0 : in.readByte();
                        if (code == 0) {
                            long size = progListeners == null ? -1L : in.readLong();
                            for (int c = 0; c < loadCount; ++c) {
                                TableLoadListenerEntry entry = myLoadListeners[c];
                                entry.param = entry.listener.onTableLoadRowCount(AoservTable.this, entry.param, size == -1L ? null : Long.valueOf(size));
                            }
                            long objCount = 0L;
                            while ((code = in.readByte()) == 0) {
                                int c;
                                Object obj = AoservTable.this.getNewObject();
                                ((AoservObject)obj).read(in, AoservProtocol.Version.CURRENT_VERSION);
                                if (obj instanceof SingleTableObject) {
                                    SingleTableObject sto = (SingleTableObject)obj;
                                    sto.setTable(AoservTable.this);
                                }
                                list.add(obj);
                                ++objCount;
                                for (c = 0; c < progCount; ++c) {
                                    int currentProgress = (int)(objCount * (long)progressScales[c] / size);
                                    if (currentProgress == lastProgresses[c]) continue;
                                    lastProgresses[c] = currentProgress;
                                    progListeners[c].onProgressChanged(AoservTable.this, lastProgresses[c], progressScales[c]);
                                }
                                for (c = 0; c < loadCount; ++c) {
                                    TableLoadListenerEntry entry = myLoadListeners[c];
                                    entry.param = entry.listener.onTableRowLoaded(AoservTable.this, entry.param, objCount - 1L, (AoservObject<?, ?>)obj);
                                }
                            }
                            AoservProtocol.checkResult(code, in);
                            if (size != -1L && size != objCount) {
                                throw new IOException("Unexpected number of objects returned: expected = " + size + ", returned = " + objCount);
                            }
                        } else {
                            AoservProtocol.checkResult(code, in);
                            throw new IOException("Unexpected response code: " + code);
                        }
                    }

                    @Override
                    public void afterRelease() {
                        try {
                            AoservTable.this.sortIfNeeded(list);
                        }
                        catch (IOException | SQLException err) {
                            throw new WrappedException((Throwable)err);
                        }
                    }
                });
                for (c = 0; c < progCount; ++c) {
                    if (lastProgresses[c] == progressScales[c]) continue;
                    lastProgresses[c] = progressScales[c];
                    progListeners[c].onProgressChanged(this, lastProgresses[c], progressScales[c]);
                }
            }
            catch (WrappedException err) {
                Throwable cause = err.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw err;
            }
        }
        catch (IOException | Error | RuntimeException | SQLException e) {
            for (int c3 = 0; c3 < loadCount; ++c3) {
                TableLoadListenerEntry entry2 = myLoadListeners[c3];
                entry2.param = entry2.listener.onTableLoadFailed(this, entry2.param, e);
            }
            throw e;
        }
        for (c = 0; c < loadCount; ++c) {
            entry = myLoadListeners[c];
            entry.param = entry.listener.onTableLoadCompleted(this, entry.param);
        }
    }

    protected void getObjects(boolean allowRetry, List<V> list, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        this.getObjects(allowRetry, true, list, commandId, params);
    }

    protected List<V> getObjects(boolean allowRetry, AoservProtocol.CommandId commandId, AoservWritable param1) throws IOException, SQLException {
        ArrayList list = new ArrayList();
        this.getObjects(allowRetry, list, commandId, param1);
        return list;
    }

    protected void getObjectsNoProgress(boolean allowRetry, List<V> list, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        this.getObjects(allowRetry, false, list, commandId, params);
    }

    protected List<V> getObjectsNoProgress(boolean allowRetry, AoservProtocol.CommandId commandId, Object ... params) throws IOException, SQLException {
        ArrayList list = new ArrayList();
        this.getObjectsNoProgress(allowRetry, list, commandId, params);
        return list;
    }

    protected ComparisonSortAlgorithm<Object> getSortAlgorithm() {
        return JavaSort.getInstance();
    }

    protected void sortIfNeeded(List<V> list) throws SQLException, IOException {
        SqlExpression[] sortExpressions = this.getDefaultOrderBySqlExpressions();
        if (sortExpressions != null) {
            OrderBy[] orderBys = this.getDefaultOrderBy();
            boolean[] sortOrders = new boolean[orderBys.length];
            for (int c = 0; c < orderBys.length; ++c) {
                sortOrders[c] = orderBys[c].getOrder();
            }
            this.connector.sort(this.getSortAlgorithm(), list, sortExpressions, sortOrders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressListener[] getProgressListeners() {
        List<ProgressListener> list = this.progressListeners;
        synchronized (list) {
            int size = this.progressListeners.size();
            if (size == 0) {
                return null;
            }
            return this.progressListeners.toArray(new ProgressListener[size]);
        }
    }

    public int getCachedRowCount() throws IOException, SQLException {
        return this.size();
    }

    public List<V> getRows() throws IOException, SQLException {
        return Collections.unmodifiableList(this.getRowsCopy());
    }

    public abstract List<V> getRowsCopy() throws IOException, SQLException;

    public abstract Table.TableId getTableId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableLoadListenerEntry[] getTableLoadListeners() {
        List<TableLoadListenerEntry> list = this.loadListeners;
        synchronized (list) {
            int size = this.loadListeners.size();
            if (size == 0) {
                return null;
            }
            return this.loadListeners.toArray(new TableLoadListenerEntry[size]);
        }
    }

    public final Table getTableSchema() throws IOException, SQLException {
        return this.connector.getSchema().getTable().get(this.getTableId());
    }

    public final String getTableName() throws IOException, SQLException {
        return this.getTableSchema().getName();
    }

    public final List<V> getIndexedRows(int col, int value) throws IOException, SQLException {
        return this.getIndexedRows(col, (Object)value);
    }

    public List<V> getIndexedRows(int col, Object value) throws IOException, SQLException {
        throw new UnsupportedOperationException("getIndexedRows now supported by table implementation");
    }

    public final V getUniqueRow(int col, int value) throws IOException, SQLException {
        return this.getUniqueRowImpl(col, value);
    }

    public final V getUniqueRow(int col, long value) throws IOException, SQLException {
        return this.getUniqueRowImpl(col, value);
    }

    public final V getUniqueRow(int col, Object value) throws IOException, SQLException {
        if (value == null) {
            return null;
        }
        return this.getUniqueRowImpl(col, value);
    }

    public final V getUniqueRow(int col, short value) throws IOException, SQLException {
        return this.getUniqueRowImpl(col, value);
    }

    protected abstract V getUniqueRowImpl(int var1, Object var2) throws IOException, SQLException;

    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IOException, SQLException {
        return false;
    }

    public boolean isLoaded() {
        return false;
    }

    public final void printTable(AoservConnector conn, PrintWriter out, boolean isInteractive) throws IOException, SQLException {
        Table schemaTable = this.getTableSchema();
        List<Column> columns = schemaTable.getSchemaColumns(conn);
        final int numCols = columns.size();
        Object[] titles = new String[numCols];
        final Type[] types = new Type[numCols];
        int supportsAnyPrecisionCount = 0;
        boolean[] alignRights = new boolean[numCols];
        for (int c = 0; c < numCols; ++c) {
            Column column = columns.get(c);
            titles[c] = column.getName();
            types[c] = column.getType(conn);
            Type type = types[c];
            if (type.supportsPrecision()) {
                ++supportsAnyPrecisionCount;
            }
            alignRights[c] = type.alignRight();
        }
        final List<V> rows = this.getRows();
        final int numRows = rows.size();
        final int[] precisions = new int[numCols];
        Arrays.fill(precisions, -1);
        if (supportsAnyPrecisionCount > 0) {
            int precisionsNotMaxedCount = supportsAnyPrecisionCount;
            block1: for (AoservObject row : rows) {
                for (int col = 0; col < numCols; ++col) {
                    int precision;
                    Type type = types[col];
                    if (!type.supportsPrecision()) continue;
                    int maxPrecision = type.getMaxPrecision();
                    int current = precisions[col];
                    if (maxPrecision != -1 && current != -1 && current >= maxPrecision || (precision = type.getPrecision(row.getColumn(col))) == -1 || current != -1 && precision <= current) continue;
                    precisions[col] = precision;
                    if (maxPrecision != -1 && precision >= maxPrecision && --precisionsNotMaxedCount <= 0) break block1;
                }
            }
        }
        SQLUtility.printTable((Object[])titles, () -> new Iterator<String[]>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < numRows;
            }

            @Override
            public String[] next() throws NoSuchElementException {
                if (this.index >= rows.size()) {
                    throw new NoSuchElementException();
                }
                AoservObject row = (AoservObject)rows.get(this.index);
                String[] strings = new String[numCols];
                for (int col = 0; col < numCols; ++col) {
                    strings[col] = types[col].getString(row.getColumn(col), precisions[col]);
                }
                ++this.index;
                return strings;
            }
        }, (Appendable)out, (boolean)isInteractive, (boolean[])alignRights);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeProgressListener(ProgressListener listener) {
        List<ProgressListener> list = this.progressListeners;
        synchronized (list) {
            for (int i = this.progressListeners.size() - 1; i >= 0; --i) {
                ProgressListener pl = this.progressListeners.get(i);
                if (pl != listener) continue;
                this.progressListeners.remove(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTableListener(TableListener listener) {
        TableEventThread myThread;
        EventLock eventLock = this.eventLock;
        synchronized (eventLock) {
            myThread = this.thread;
        }
        boolean stopThread = false;
        Object object = this.tableListenersLock;
        synchronized (object) {
            if (this.tableListeners != null) {
                int size = this.tableListeners.size();
                for (int i = size - 1; i >= 0; --i) {
                    TableListenerEntry entry = this.tableListeners.get(i);
                    if (entry.listener != listener) continue;
                    this.tableListeners.remove(i);
                    --size;
                    if (entry.delay <= 0L || myThread == null) break;
                    boolean foundDelayed = false;
                    for (int j = 0; j < size; ++j) {
                        TableListenerEntry tle = this.tableListeners.get(j);
                        if (tle.delay <= 0L) continue;
                        foundDelayed = true;
                        break;
                    }
                    if (foundDelayed) break;
                    stopThread = true;
                    break;
                }
            }
        }
        object = this.eventLock;
        synchronized (object) {
            if (stopThread) {
                this.thread = null;
            }
            this.eventLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTableLoadListener(TableLoadListener listener) {
        List<TableLoadListenerEntry> list = this.loadListeners;
        synchronized (list) {
            int size = this.loadListeners.size();
            for (int c = 0; c < size; ++c) {
                TableLoadListenerEntry entry = this.loadListeners.get(c);
                if (entry.listener != listener) continue;
                this.loadListeners.remove(c);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tableUpdated() {
        ArrayList<TableListenerEntry> tableListenersSnapshot;
        TableListenersLock tableListenersLock = this.tableListenersLock;
        synchronized (tableListenersLock) {
            tableListenersSnapshot = this.tableListeners == null ? null : new ArrayList<TableListenerEntry>(this.tableListeners);
        }
        if (tableListenersSnapshot != null) {
            for (TableListenerEntry entry : tableListenersSnapshot) {
                if (entry.delay > 0L) continue;
                AoservConnector.executorService.submit(() -> entry.listener.tableUpdated((com.aoapps.hodgepodge.table.Table)this));
            }
            EventLock eventLock = this.eventLock;
            synchronized (eventLock) {
                int size = tableListenersSnapshot.size();
                boolean modified = false;
                for (int c = 0; c < size; ++c) {
                    TableListenerEntry entry = (TableListenerEntry)tableListenersSnapshot.get(c);
                    if (entry.delay <= 0L || entry.delayStart != -1L) continue;
                    entry.delayStart = System.currentTimeMillis();
                    modified = true;
                }
                if (modified) {
                    this.eventLock.notifyAll();
                }
            }
        }
    }

    public final String toString() {
        try {
            return this.getTableSchema().getDisplay();
        }
        catch (IOException | SQLException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public Iterator<V> iterator() {
        try {
            return this.getRows().iterator();
        }
        catch (IOException | SQLException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    public Map<K, V> getMap() {
        return this.map;
    }

    @Deprecated
    public abstract V get(Object var1) throws IOException, SQLException;

    public boolean isEmpty() throws IOException, SQLException {
        return this.getRows().isEmpty();
    }

    public int size() throws IOException, SQLException {
        return this.getRows().size();
    }

    public final int getSize() throws IOException, SQLException {
        return this.size();
    }

    public static class OrderBy {
        private final String expression;
        private final boolean order;

        public OrderBy(String expression, boolean order) {
            this.expression = expression;
            this.order = order;
        }

        String getExpression() {
            return this.expression;
        }

        boolean getOrder() {
            return this.order;
        }
    }

    private static final class TableLoadListenerEntry {
        private final TableLoadListener listener;
        private Object param;

        private TableLoadListenerEntry(TableLoadListener listener, Object param) {
            this.listener = listener;
            this.param = param;
        }
    }

    private final class TableEventThread
    extends Thread {
        private TableEventThread() {
            this.setName("TableEventThread #" + this.getId() + " (" + (Object)((Object)AoservTable.this.getTableId()) + ") - " + AoservTable.this.getClass().getName());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: while (!Thread.currentThread().isInterrupted()) {
                try {
                    EventLock eventLock = AoservTable.this.eventLock;
                    synchronized (eventLock) {
                        while (!Thread.currentThread().isInterrupted()) {
                            ArrayList tableListenersSnapshot;
                            if (AoservTable.this.thread != this) {
                                break block10;
                            }
                            long time = System.currentTimeMillis();
                            long minTime = Long.MAX_VALUE;
                            TableListenersLock tableListenersLock = AoservTable.this.tableListenersLock;
                            synchronized (tableListenersLock) {
                                tableListenersSnapshot = AoservTable.this.tableListeners == null ? null : new ArrayList(AoservTable.this.tableListeners);
                            }
                            if (tableListenersSnapshot != null) {
                                int size = tableListenersSnapshot.size();
                                for (TableListenerEntry entry : tableListenersSnapshot) {
                                    long endTime;
                                    long delayStart;
                                    long delay = entry.delay;
                                    if (delay <= 0L || (delayStart = entry.delayStart) == -1L) continue;
                                    if (delayStart > time) {
                                        delayStart = entry.delayStart = time;
                                    }
                                    if (time >= (endTime = delayStart + delay)) {
                                        entry.delayStart = -1L;
                                        AoservConnector.executorService.submit(() -> entry.listener.tableUpdated((com.aoapps.hodgepodge.table.Table)AoservTable.this));
                                        continue;
                                    }
                                    long remaining = endTime - time;
                                    if (remaining >= minTime) continue;
                                    minTime = remaining;
                                }
                            }
                            if (minTime == Long.MAX_VALUE) {
                                AoservTable.this.eventLock.wait();
                                continue;
                            }
                            AoservTable.this.eventLock.wait(minTime);
                        }
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (InterruptedException e) {
                    AoservTable.this.connector.getLogger().log(Level.WARNING, null, e);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    AoservTable.this.connector.getLogger().log(Level.SEVERE, null, t);
                }
            }
        }
    }

    class EventLock {
        EventLock() {
        }

        public String toString() {
            return "EventLock - " + (Object)((Object)AoservTable.this.getTableId());
        }
    }

    private static final class TableListenerEntry {
        private final TableListener listener;
        private final long delay;
        long delayStart = -1L;

        private TableListenerEntry(TableListener listener, long delay) {
            this.listener = listener;
            this.delay = delay;
        }
    }

    private class TableListenersLock {
        private TableListenersLock() {
        }

        public String toString() {
            return "tableListenersLock - " + (Object)((Object)AoservTable.this.getTableId());
        }
    }
}

