/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client;

import com.aoapps.collections.AoCollections;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedObject;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CachedTable<K, V extends CachedObject<K, V>>
extends AoservTable<K, V> {
    private long lastLoaded = -1L;
    private List<Map<Object, V>> columnHashes;
    private BitSet columnsHashed;
    private List<Map<Object, List<V>>> indexHashes;
    private BitSet indexesHashed;
    private List<V> tableData;

    protected CachedTable(AoservConnector connector, Class<V> clazz) {
        super(connector, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> getIndexedRows(int col, Object value) throws IOException, SQLException {
        CachedTable cachedTable = this;
        synchronized (cachedTable) {
            List<V> list;
            this.validateCache();
            int minLength = col + 1;
            if (this.indexHashes == null) {
                this.indexHashes = new ArrayList<Map<Object, List<V>>>(minLength);
                this.indexesHashed = new BitSet(minLength);
            }
            while (this.indexHashes.size() < minLength) {
                this.indexHashes.add(null);
            }
            Map map = this.indexHashes.get(col);
            if (map == null) {
                map = new HashMap<Object, List<V>>();
                this.indexHashes.set(col, map);
            }
            if (!this.indexesHashed.get(col)) {
                HashMap<Object, ArrayList<CachedObject>> modifiableIndexes = new HashMap<Object, ArrayList<CachedObject>>();
                for (CachedObject obj : this.tableData) {
                    Object cvalue = obj.getColumn(col);
                    ArrayList<CachedObject> list2 = (ArrayList<CachedObject>)modifiableIndexes.get(cvalue);
                    if (list2 == null) {
                        list2 = new ArrayList<CachedObject>();
                        modifiableIndexes.put(cvalue, list2);
                    }
                    list2.add(obj);
                }
                map.clear();
                for (Object key : modifiableIndexes.keySet()) {
                    List list3 = (List)modifiableIndexes.get(key);
                    map.put(key, Collections.unmodifiableList(list3));
                }
                this.indexesHashed.set(col);
            }
            if ((list = map.get(value)) == null) {
                return Collections.emptyList();
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final V getUniqueRowImpl(int col, Object value) throws IOException, SQLException {
        if (value == null) {
            return null;
        }
        CachedTable cachedTable = this;
        synchronized (cachedTable) {
            this.validateCache();
            int minLength = col + 1;
            if (this.columnHashes == null) {
                this.columnHashes = new ArrayList<Map<Object, V>>(minLength);
                this.columnsHashed = new BitSet(minLength);
            }
            while (this.columnHashes.size() < minLength) {
                this.columnHashes.add(null);
            }
            HashMap map = this.columnHashes.get(col);
            if (!this.columnsHashed.get(col)) {
                List<V> table = this.tableData;
                int size = table.size();
                if (map == null) {
                    map = AoCollections.newHashMap((int)(size * 5 >> 2));
                    this.columnHashes.set(col, map);
                } else {
                    map.clear();
                }
                for (int c = 0; c < size; ++c) {
                    CachedObject old;
                    CachedObject row = (CachedObject)table.get(c);
                    Object cvalue = row.getColumn(col);
                    if (cvalue == null || (old = map.put(cvalue, row)) == null) continue;
                    throw new SQLException("Duplicate unique entry for table #" + (Object)((Object)this.getTableId()) + " (" + this.getTableName() + "), column " + col + ": " + cvalue);
                }
                this.columnsHashed.set(col);
            }
            return (V)((CachedObject)map.get(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> getRows() throws IOException, SQLException {
        CachedTable cachedTable = this;
        synchronized (cachedTable) {
            this.validateCache();
            return this.tableData;
        }
    }

    @Override
    public List<V> getRowsCopy() throws IOException, SQLException {
        return new ArrayList<V>(this.getRows());
    }

    boolean isHashed(int uniqueColumn) {
        return this.columnsHashed != null && this.columnsHashed.get(uniqueColumn);
    }

    boolean isIndexed(int uniqueColumn) {
        return this.indexesHashed != null && this.indexesHashed.get(uniqueColumn);
    }

    @Override
    public final boolean isLoaded() {
        return this.lastLoaded != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        CachedTable cachedTable = this;
        synchronized (cachedTable) {
            Map<Object, Object> map;
            int c;
            int len;
            this.lastLoaded = -1L;
            if (this.columnHashes != null) {
                len = this.columnHashes.size();
                for (c = 0; c < len; ++c) {
                    map = this.columnHashes.get(c);
                    if (map == null) continue;
                    map.clear();
                }
            }
            if (this.columnsHashed != null) {
                this.columnsHashed.clear();
            }
            if (this.indexHashes != null) {
                len = this.indexHashes.size();
                for (c = 0; c < len; ++c) {
                    map = this.indexHashes.get(c);
                    if (map == null) continue;
                    map.clear();
                }
            }
            if (this.indexesHashed != null) {
                this.indexesHashed.clear();
            }
        }
    }

    private void validateCache() throws IOException, SQLException {
        long currentTime = System.currentTimeMillis();
        if (this.lastLoaded == -1L || currentTime < this.lastLoaded) {
            Map<Object, Object> map;
            int c;
            int len;
            this.tableData = Collections.unmodifiableList(this.getObjects(true, AoservProtocol.CommandId.GET_TABLE, new Object[]{this.getTableId()}));
            this.lastLoaded = currentTime;
            if (this.columnHashes != null) {
                len = this.columnHashes.size();
                for (c = 0; c < len; ++c) {
                    map = this.columnHashes.get(c);
                    if (map == null) continue;
                    map.clear();
                }
            }
            if (this.columnsHashed != null) {
                this.columnsHashed.clear();
            }
            if (this.indexHashes != null) {
                len = this.indexHashes.size();
                for (c = 0; c < len; ++c) {
                    map = this.indexHashes.get(c);
                    if (map == null) continue;
                    map.clear();
                }
            }
            if (this.indexesHashed != null) {
                this.indexesHashed.clear();
            }
        }
    }
}

