/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client;

import com.aoapps.hodgepodge.io.FileList;
import com.aoapps.hodgepodge.io.FileListObjectFactory;
import com.aoapps.hodgepodge.sort.ComparisonSortAlgorithm;
import com.aoapps.hodgepodge.sort.FastQSort;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.FilesystemCachedObject;
import com.aoindustries.aoserv.client.SingleTableObject;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Column;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.sql.SqlColumnValue;
import com.aoindustries.aoserv.client.sql.SqlComparator;
import com.aoindustries.aoserv.client.sql.SqlExpression;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class FilesystemCachedTable<K, V extends FilesystemCachedObject<K, V>>
extends AoservTable<K, V>
implements FileListObjectFactory<V> {
    private long lastLoaded = -1L;
    private List<List<V>> columnLists;
    private FileList<V> tableList;
    private List<V> unmodifiableTableList;

    protected FilesystemCachedTable(AoservConnector connector, Class<V> clazz) {
        super(connector, clazz);
    }

    protected abstract int getRecordLength();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        FilesystemCachedTable filesystemCachedTable = this;
        synchronized (filesystemCachedTable) {
            this.lastLoaded = -1L;
            this.tableList = null;
            this.unmodifiableTableList = null;
            if (this.columnLists != null) {
                this.columnLists.clear();
            }
        }
    }

    private void validateCache() throws IOException, SQLException {
        assert (Thread.holdsLock(this));
        long currentTime = System.currentTimeMillis();
        if (this.lastLoaded == -1L || currentTime < this.lastLoaded) {
            Table schemaTable = this.getTableSchema();
            FileList newTableList = new FileList(schemaTable.getName(), "rows", this.getRecordLength(), (FileListObjectFactory)this);
            this.getObjects(true, newTableList, AoservProtocol.CommandId.GET_TABLE, new Object[]{this.getTableId()});
            this.tableList = newTableList;
            this.unmodifiableTableList = Collections.unmodifiableList(this.tableList);
            this.lastLoaded = currentTime;
            if (this.columnLists != null) {
                this.columnLists.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<V> getRows() throws IOException, SQLException {
        FilesystemCachedTable filesystemCachedTable = this;
        synchronized (filesystemCachedTable) {
            this.validateCache();
            return this.unmodifiableTableList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> getRowsCopy() throws IOException, SQLException {
        FilesystemCachedTable filesystemCachedTable = this;
        synchronized (filesystemCachedTable) {
            this.validateCache();
            Table schemaTable = this.getTableSchema();
            FileList newCopyList = new FileList(schemaTable.getName(), "rowsCopy", this.tableList.getRecordLength(), (FileListObjectFactory)this);
            newCopyList.addAll(this.tableList);
            return newCopyList;
        }
    }

    @Override
    protected ComparisonSortAlgorithm<Object> getSortAlgorithm() {
        return FastQSort.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final V getUniqueRowImpl(int col, Object value) throws IOException, SQLException {
        if (value == null) {
            return null;
        }
        Table schemaTable = this.getTableSchema();
        Column schemaColumn = schemaTable.getSchemaColumn(this.connector, col);
        SqlComparator sortComparator = new SqlComparator(this.connector, new SqlExpression[]{new SqlColumnValue(this.connector, schemaColumn)}, new boolean[]{true});
        SqlComparator searchComparator = new SqlComparator(this.connector, new SqlExpression[]{new SqlColumnValue(this.connector, schemaColumn)}, new boolean[]{true});
        FilesystemCachedTable filesystemCachedTable = this;
        synchronized (filesystemCachedTable) {
            int index;
            this.validateCache();
            int minLength = col + 1;
            if (this.columnLists == null) {
                this.columnLists = new ArrayList<List<V>>(minLength);
            } else {
                while (this.columnLists.size() < minLength) {
                    this.columnLists.add(null);
                }
            }
            List<Object> unmodifiableSortedList = this.columnLists.get(col);
            if (unmodifiableSortedList == null) {
                FileList sortedFileList = new FileList(schemaTable.getName() + '.' + schemaColumn.getName(), "unique", this.getRecordLength(), this.tableList.getObjectFactory());
                sortedFileList.addAll(this.tableList);
                this.getSortAlgorithm().sort((List)sortedFileList, sortComparator);
                unmodifiableSortedList = Collections.unmodifiableList(sortedFileList);
                this.columnLists.set(col, unmodifiableSortedList);
            }
            FilesystemCachedObject filesystemCachedObject = (index = Collections.binarySearch(unmodifiableSortedList, value, searchComparator)) < 0 ? null : (FilesystemCachedObject)unmodifiableSortedList.get(index);
            return (V)filesystemCachedObject;
        }
    }

    boolean isSorted(int uniqueColumn) {
        return this.columnLists != null && this.columnLists.size() > uniqueColumn && this.columnLists.get(uniqueColumn) != null;
    }

    @Override
    public final boolean isLoaded() {
        return this.lastLoaded != -1L;
    }

    public V createInstance() throws IOException {
        FilesystemCachedObject obj = (FilesystemCachedObject)this.getNewObject();
        if (obj instanceof SingleTableObject) {
            obj.setTable(this);
        }
        return (V)obj;
    }
}

