/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client;

import com.aoapps.collections.AoCollections;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.GlobalObject;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class GlobalTable<K, V extends GlobalObject<K, V>>
extends AoservTable<K, V> {
    private static final int numTables;
    private static final Lock[] locks;
    private static final long[] lastLoadeds;
    private static final List<List<Map<Object, GlobalObject>>> tableHashes;
    private static final BitSet[] hashLoadeds;
    private static final List<List<Map<Object, List<GlobalObject<?, ?>>>>> indexHashes;
    private static final BitSet[] indexLoadeds;
    private static final List<List<GlobalObject<?, ?>>> tableObjs;

    protected GlobalTable(AoservConnector connector, Class<V> clazz) {
        super(connector, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getGlobalRowCount() {
        List<GlobalObject<?, ?>> objs;
        int ordinal = this.getTableId().ordinal();
        Lock lock = locks[ordinal];
        synchronized (lock) {
            List<List<GlobalObject<?, ?>>> list = tableObjs;
            synchronized (list) {
                objs = tableObjs.get(ordinal);
            }
        }
        if (objs != null) {
            return objs.size();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<V> getIndexedRows(int col, Object value) throws IOException, SQLException {
        Table.TableId tableId = this.getTableId();
        int ordinal = tableId.ordinal();
        Lock lock = locks[ordinal];
        synchronized (lock) {
            List<GlobalObject<?, ?>> list;
            List<Map<Object, List<GlobalObject<?, ?>>>> tableValues;
            this.validateCache();
            BitSet tableLoadeds = indexLoadeds[ordinal];
            if (tableLoadeds == null) {
                GlobalTable.indexLoadeds[ordinal] = tableLoadeds = new BitSet(col + 1);
            }
            boolean isHashed = tableLoadeds.get(col);
            List<List<Map<Object, List<GlobalObject<?, ?>>>>> list2 = indexHashes;
            synchronized (list2) {
                tableValues = indexHashes.get(ordinal);
                if (tableValues == null) {
                    tableValues = new ArrayList(col + 1);
                    indexHashes.set(ordinal, tableValues);
                }
            }
            while (tableValues.size() <= col) {
                tableValues.add(null);
            }
            Map<Object, List<GlobalObject<?, ?>>> colIndexes = tableValues.get(col);
            if (colIndexes == null) {
                colIndexes = new HashMap();
                tableValues.set(col, colIndexes);
            }
            if (!isHashed) {
                HashMap<Object, ArrayList<GlobalObject>> modifiableIndexes = new HashMap<Object, ArrayList<GlobalObject>>();
                for (GlobalObject row : this.getRows()) {
                    Object cvalue = row.getColumn(col);
                    ArrayList<GlobalObject> list3 = (ArrayList<GlobalObject>)modifiableIndexes.get(cvalue);
                    if (list3 == null) {
                        list3 = new ArrayList<GlobalObject>();
                        modifiableIndexes.put(cvalue, list3);
                    }
                    list3.add(row);
                }
                colIndexes.clear();
                for (Object key : modifiableIndexes.keySet()) {
                    List list4 = (List)modifiableIndexes.get(key);
                    colIndexes.put(key, Collections.unmodifiableList(list4));
                }
                tableLoadeds.set(col);
            }
            if ((list = colIndexes.get(value)) == null) {
                return Collections.emptyList();
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final V getUniqueRowImpl(int col, Object value) throws SQLException, IOException {
        if (value == null) {
            return null;
        }
        Table.TableId tableId = this.getTableId();
        int ordinal = tableId.ordinal();
        Lock lock = locks[ordinal];
        synchronized (lock) {
            List<Map<Object, GlobalObject>> tableValues;
            this.validateCache();
            BitSet tableLoadeds = hashLoadeds[ordinal];
            if (tableLoadeds == null) {
                GlobalTable.hashLoadeds[ordinal] = tableLoadeds = new BitSet(col + 1);
            }
            boolean isHashed = tableLoadeds.get(col);
            List<V> table = this.getRows();
            int size = table.size();
            List<List<Map<Object, GlobalObject>>> list = tableHashes;
            synchronized (list) {
                List<Map<Object, GlobalObject>> existing = tableHashes.get(ordinal);
                if (existing != null) {
                    tableValues = existing;
                } else {
                    List<Map<Object, GlobalObject>> toCache = tableValues = new ArrayList<Map<Object, GlobalObject>>(col + 1);
                    tableHashes.set(ordinal, toCache);
                }
            }
            while (tableValues.size() <= col) {
                tableValues.add(null);
            }
            HashMap colValues = tableValues.get(col);
            if (colValues == null) {
                colValues = AoCollections.newHashMap((int)(size * 5 >> 2));
                tableValues.set(col, colValues);
            }
            if (!isHashed) {
                colValues.clear();
                for (int c = 0; c < size; ++c) {
                    GlobalObject old;
                    GlobalObject row = (GlobalObject)table.get(c);
                    Object cvalue = row.getColumn(col);
                    if (cvalue == null || (old = colValues.put(cvalue, row)) == null) continue;
                    throw new SQLException("Duplicate pkey entry for table " + (Object)((Object)this.getTableId()) + " (" + this.getTableName() + "), column #" + col + ": " + cvalue);
                }
                tableLoadeds.set(col);
            }
            return (V)colValues.get(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> getRows() throws IOException, SQLException {
        Table.TableId tableId = this.getTableId();
        int ordinal = tableId.ordinal();
        Lock lock = locks[ordinal];
        synchronized (lock) {
            this.validateCache();
            List<List<GlobalObject<?, ?>>> list = tableObjs;
            synchronized (list) {
                List<GlobalObject<?, ?>> objs = tableObjs.get(ordinal);
                return objs;
            }
        }
    }

    @Override
    public List<V> getRowsCopy() throws IOException, SQLException {
        return new ArrayList<V>(this.getRows());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isHashed(int column) {
        int ordinal = this.getTableId().ordinal();
        Lock lock = locks[ordinal];
        synchronized (lock) {
            BitSet table = hashLoadeds[ordinal];
            return table != null && table.get(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIndexed(int column) {
        int ordinal = this.getTableId().ordinal();
        Lock lock = locks[ordinal];
        synchronized (lock) {
            BitSet table = indexLoadeds[ordinal];
            return table != null && table.get(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLoaded() {
        Table.TableId tableId = this.getTableId();
        int ordinal = tableId.ordinal();
        Lock lock = locks[ordinal];
        synchronized (lock) {
            return lastLoadeds[ordinal] != -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        Table.TableId tableId = this.getTableId();
        int ordinal = tableId.ordinal();
        Lock lock = locks[ordinal];
        synchronized (lock) {
            GlobalTable.lastLoadeds[ordinal] = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCache() throws IOException, SQLException {
        Table.TableId tableId = this.getTableId();
        int ordinal = tableId.ordinal();
        Lock lock = locks[ordinal];
        synchronized (lock) {
            long currentTime = System.currentTimeMillis();
            long lastLoaded = lastLoadeds[ordinal];
            if (lastLoaded == -1L) {
                BitSet indexed;
                List list = this.getObjects(true, AoservProtocol.CommandId.GET_TABLE, ordinal);
                List<List<GlobalObject<?, ?>>> list2 = tableObjs;
                synchronized (list2) {
                    tableObjs.set(ordinal, Collections.unmodifiableList(list));
                }
                BitSet loaded = hashLoadeds[ordinal];
                if (loaded != null) {
                    loaded.clear();
                }
                if ((indexed = indexLoadeds[ordinal]) != null) {
                    indexed.clear();
                }
                GlobalTable.lastLoadeds[ordinal] = currentTime;
            }
        }
    }

    static {
        int c;
        numTables = Table.TableId.values().length;
        locks = new Lock[numTables];
        for (c = 0; c < locks.length; ++c) {
            GlobalTable.locks[c] = new Lock();
        }
        lastLoadeds = new long[numTables];
        Arrays.fill(lastLoadeds, -1L);
        tableHashes = new ArrayList<List<Map<Object, GlobalObject>>>(numTables);
        for (c = 0; c < numTables; ++c) {
            tableHashes.add(null);
        }
        hashLoadeds = new BitSet[numTables];
        indexHashes = new ArrayList(numTables);
        for (c = 0; c < numTables; ++c) {
            indexHashes.add(null);
        }
        indexLoadeds = new BitSet[numTables];
        tableObjs = new ArrayList(numTables);
        for (c = 0; c < numTables; ++c) {
            tableObjs.add(null);
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

