/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.lang.util.BufferManager;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public final class NestedInputStream
extends InputStream {
    private final StreamableInput in;
    private boolean isDone;
    private byte[] buffer = BufferManager.getBytes();
    private int bufferFilled;
    private int bufferRead;

    public NestedInputStream(StreamableInput in) {
        this.in = in;
    }

    @Override
    public synchronized int available() {
        return this.bufferRead - this.bufferFilled;
    }

    private void loadNextBlock() throws IOException {
        while (!this.isDone && this.bufferRead >= this.bufferFilled) {
            int code = this.in.read();
            if (code == 0) {
                this.bufferFilled = this.in.readShort();
                this.in.readFully(this.buffer, 0, this.bufferFilled);
                this.bufferRead = 0;
                continue;
            }
            this.isDone = true;
            this.bufferRead = 0;
            this.bufferFilled = 0;
            try {
                AoservProtocol.checkResult(code, this.in);
            }
            catch (SQLException err) {
                throw new IOException(err.toString());
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isDone) {
            int code;
            while ((code = this.in.read()) == 0) {
                int skipped;
                for (int len = this.in.readShort(); len > 0; len -= skipped) {
                    skipped = (int)this.in.skip((long)len);
                }
            }
            this.isDone = true;
            this.bufferRead = 0;
            this.bufferFilled = 0;
            if (this.buffer != null) {
                BufferManager.release((byte[])this.buffer, (boolean)false);
                this.buffer = null;
            }
            try {
                AoservProtocol.checkResult(code, this.in);
            }
            catch (SQLException err) {
                throw new IOException(err.toString());
            }
        }
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.isDone) {
            return -1;
        }
        this.loadNextBlock();
        if (this.isDone) {
            return -1;
        }
        return this.buffer[this.bufferRead++] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.isDone) {
            return -1;
        }
        this.loadNextBlock();
        if (this.isDone) {
            return -1;
        }
        int bufferLeft = this.bufferFilled - this.bufferRead;
        if (bufferLeft > len) {
            bufferLeft = len;
        }
        System.arraycopy(this.buffer, this.bufferRead, b, off, bufferLeft);
        this.bufferRead += bufferLeft;
        return bufferLeft;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (this.isDone) {
            return -1L;
        }
        this.loadNextBlock();
        if (this.isDone) {
            return -1L;
        }
        int bufferLeft = this.bufferFilled - this.bufferRead;
        if ((long)bufferLeft > n) {
            bufferLeft = (int)n;
        }
        this.bufferRead += bufferLeft;
        return bufferLeft;
    }
}

