/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client;

import com.aoapps.collections.SortedArrayList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.Strings;
import com.aoapps.lang.Throwables;
import com.aoapps.lang.exception.WrappedException;
import com.aoapps.lang.i18n.Money;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoapps.net.Email;
import com.aoapps.net.HostAddress;
import com.aoapps.net.InetAddress;
import com.aoapps.net.Port;
import com.aoapps.security.UnixCrypt;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.StreamHandler;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.AccountHost;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.account.Profile;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.backup.BackupPartition;
import com.aoindustries.aoserv.client.backup.FileReplication;
import com.aoindustries.aoserv.client.backup.FileReplicationSetting;
import com.aoindustries.aoserv.client.billing.NoticeType;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.billing.PackageDefinition;
import com.aoindustries.aoserv.client.billing.Transaction;
import com.aoindustries.aoserv.client.billing.TransactionType;
import com.aoindustries.aoserv.client.distribution.Architecture;
import com.aoindustries.aoserv.client.distribution.OperatingSystem;
import com.aoindustries.aoserv.client.distribution.OperatingSystemVersion;
import com.aoindustries.aoserv.client.distribution.SoftwareVersion;
import com.aoindustries.aoserv.client.dns.Record;
import com.aoindustries.aoserv.client.dns.RecordType;
import com.aoindustries.aoserv.client.dns.Zone;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.BlackholeAddress;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.email.Forwarding;
import com.aoindustries.aoserv.client.email.InboxAddress;
import com.aoindustries.aoserv.client.email.InboxAttributes;
import com.aoindustries.aoserv.client.email.List;
import com.aoindustries.aoserv.client.email.ListAddress;
import com.aoindustries.aoserv.client.email.MajordomoList;
import com.aoindustries.aoserv.client.email.MajordomoServer;
import com.aoindustries.aoserv.client.email.MajordomoVersion;
import com.aoindustries.aoserv.client.email.Pipe;
import com.aoindustries.aoserv.client.email.PipeAddress;
import com.aoindustries.aoserv.client.email.SmtpRelay;
import com.aoindustries.aoserv.client.email.SmtpRelayType;
import com.aoindustries.aoserv.client.email.SpamAssassinMode;
import com.aoindustries.aoserv.client.ftp.GuestUser;
import com.aoindustries.aoserv.client.infrastructure.ServerFarm;
import com.aoindustries.aoserv.client.infrastructure.VirtualDisk;
import com.aoindustries.aoserv.client.infrastructure.VirtualServer;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.GroupType;
import com.aoindustries.aoserv.client.linux.GroupUser;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.Shell;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.linux.UserType;
import com.aoindustries.aoserv.client.mysql.Database;
import com.aoindustries.aoserv.client.mysql.DatabaseUser;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.mysql.User;
import com.aoindustries.aoserv.client.net.AppProtocol;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.net.Device;
import com.aoindustries.aoserv.client.net.FirewallZone;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.net.reputation.Set;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.password.PasswordGenerator;
import com.aoindustries.aoserv.client.payment.CreditCard;
import com.aoindustries.aoserv.client.payment.PaymentType;
import com.aoindustries.aoserv.client.payment.Processor;
import com.aoindustries.aoserv.client.pki.Certificate;
import com.aoindustries.aoserv.client.postgresql.Database;
import com.aoindustries.aoserv.client.postgresql.Encoding;
import com.aoindustries.aoserv.client.postgresql.Server;
import com.aoindustries.aoserv.client.postgresql.User;
import com.aoindustries.aoserv.client.postgresql.UserServer;
import com.aoindustries.aoserv.client.postgresql.Version;
import com.aoindustries.aoserv.client.reseller.Category;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.scm.CvsRepository;
import com.aoindustries.aoserv.client.ticket.Language;
import com.aoindustries.aoserv.client.ticket.Priority;
import com.aoindustries.aoserv.client.ticket.TicketType;
import com.aoindustries.aoserv.client.web.HttpdServer;
import com.aoindustries.aoserv.client.web.Location;
import com.aoindustries.aoserv.client.web.Site;
import com.aoindustries.aoserv.client.web.VirtualHost;
import com.aoindustries.aoserv.client.web.VirtualHostName;
import com.aoindustries.aoserv.client.web.tomcat.Context;
import com.aoindustries.aoserv.client.web.tomcat.ContextDataSource;
import com.aoindustries.aoserv.client.web.tomcat.ContextParameter;
import com.aoindustries.aoserv.client.web.tomcat.JkMount;
import com.aoindustries.aoserv.client.web.tomcat.PrivateTomcatSite;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;

public final class SimpleAoservClient {
    final AoservConnector connector;
    private static final int numTables = Table.TableId.values().length;

    public SimpleAoservClient(AoservConnector connector) {
        this.connector = connector;
    }

    private Architecture getArchitecture(String architecture) throws IllegalArgumentException, IOException, SQLException {
        Architecture ar = this.connector.getDistribution().getArchitecture().get(architecture);
        if (ar == null) {
            throw new IllegalArgumentException("Unable to find Architecture: " + architecture);
        }
        return ar;
    }

    private Server getLinuxServer(String hostname) throws IllegalArgumentException, IOException, SQLException {
        try {
            Server ao;
            Server server = ao = DomainName.validate((String)hostname).isValid() ? this.connector.getLinux().getServer().get(DomainName.valueOf((String)hostname)) : null;
            if (ao == null) {
                throw new IllegalArgumentException("net.Host is not a linux.Server: " + hostname);
            }
            return ao;
        }
        catch (ValidationException e) {
            throw new WrappedException((Throwable)e);
        }
    }

    private Account getAccount(Account.Name name) throws IllegalArgumentException, IOException, SQLException {
        Account account = this.connector.getAccount().getAccount().get(name);
        if (account == null) {
            throw new IllegalArgumentException("Unable to find Account: " + name);
        }
        return account;
    }

    private Zone getZone(String zone) throws IllegalArgumentException, IOException, SQLException {
        Zone dz = this.connector.getDns().getZone().get(zone);
        if (dz == null) {
            throw new IllegalArgumentException("Unable to find Zone: " + zone);
        }
        return dz;
    }

    private Address getEmailAddress(String aoServer, DomainName domain, String address) throws IllegalArgumentException, IOException, SQLException {
        Address ea = this.getEmailDomain(aoServer, domain).getEmailAddress(address);
        if (ea == null) {
            throw new IllegalArgumentException("Unable to find EmailAddress: " + address + '@' + domain + " on " + aoServer);
        }
        return ea;
    }

    private Domain getEmailDomain(String aoServer, DomainName domain) throws IllegalArgumentException, IOException, SQLException {
        Domain ed = this.getLinuxServer(aoServer).getEmailDomain(domain);
        if (ed == null) {
            throw new IllegalArgumentException("Unable to find EmailDomain: " + domain + " on " + aoServer);
        }
        return ed;
    }

    private List getEmailList(String aoServer, PosixPath path) throws IllegalArgumentException, IOException, SQLException {
        List el = this.getLinuxServer(aoServer).getEmailList(path);
        if (el == null) {
            throw new IllegalArgumentException("Unable to find EmailList: " + path + " on " + aoServer);
        }
        return el;
    }

    private SpamAssassinMode getEmailSpamAssassinIntegrationMode(String mode) throws IllegalArgumentException, IOException, SQLException {
        SpamAssassinMode esaim = this.connector.getEmail().getSpamAssassinMode().get(mode);
        if (esaim == null) {
            throw new IllegalArgumentException("Unable to find EmailSpamAssassinIntegrationMode: " + mode);
        }
        return esaim;
    }

    private FileReplication getFailoverFileReplication(String fromServer, String toServer, String path) throws IllegalArgumentException, IOException, SQLException {
        Host fromSe = this.getHost(fromServer);
        BackupPartition bp = this.getLinuxServer(toServer).getBackupPartitionForPath(path);
        if (bp == null) {
            throw new IllegalArgumentException("Unable to find BackupPartition: " + path + " on " + toServer);
        }
        FileReplication replication = null;
        for (FileReplication ffr : fromSe.getFailoverFileReplications()) {
            if (!ffr.getBackupPartition().equals(bp)) continue;
            replication = ffr;
            break;
        }
        if (replication == null) {
            throw new IllegalArgumentException("Unable to find FailoverFileReplication: From " + fromServer + " to " + toServer + " at " + path);
        }
        return replication;
    }

    private HttpdServer getHttpdServer(String aoServer, String name) throws IllegalArgumentException, IOException, SQLException {
        for (HttpdServer hs : this.getLinuxServer(aoServer).getHttpdServers()) {
            if (!Objects.equals(name, hs.getName())) continue;
            return hs;
        }
        throw new IllegalArgumentException("Unable to find HttpdServer: " + (name == null ? "\"\"" : name) + " on " + aoServer);
    }

    private SharedTomcat getHttpdSharedTomcat(String aoServer, String name) throws IllegalArgumentException, IOException, SQLException {
        SharedTomcat hst = this.getLinuxServer(aoServer).getHttpdSharedTomcat(name);
        if (hst == null) {
            throw new IllegalArgumentException("Unable to find HttpdSharedTomcat: " + name + " on " + aoServer);
        }
        return hst;
    }

    private Site getHttpdSite(String aoServer, String siteName) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getLinuxServer(aoServer).getHttpdSite(siteName);
        if (hs == null) {
            throw new IllegalArgumentException("Unable to find Site: " + siteName + " on " + aoServer);
        }
        return hs;
    }

    private IpAddress getIpAddress(String server, String netDevice, InetAddress ipAddress) throws IllegalArgumentException, SQLException, IOException {
        IpAddress ia = this.getNetDevice(server, netDevice).getIpAddress(ipAddress);
        if (ia == null) {
            throw new IllegalArgumentException("Unable to find IpAddress: " + ipAddress + " on " + netDevice + " on " + server);
        }
        return ia;
    }

    private Language getLanguage(String code) throws IllegalArgumentException, IOException, SQLException {
        Language la = this.connector.getTicket().getLanguage().get(code);
        if (la == null) {
            throw new IllegalArgumentException("Unable to find Language: " + code);
        }
        return la;
    }

    private com.aoindustries.aoserv.client.linux.User getLinuxAccount(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.linux.User la = this.connector.getLinux().getUser().get(username);
        if (la == null) {
            throw new IllegalArgumentException("Unable to find LinuxAccount: " + username);
        }
        return la;
    }

    private Group getLinuxGroup(Group.Name name) throws IllegalArgumentException, IOException, SQLException {
        Group lg = this.connector.getLinux().getGroup().get(name);
        if (lg == null) {
            throw new IllegalArgumentException("Unable to find LinuxGroup: " + name);
        }
        return lg;
    }

    private com.aoindustries.aoserv.client.linux.UserServer getLinuxServerAccount(String aoServer, User.Name username) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.linux.UserServer lsa = this.getLinuxServer(aoServer).getLinuxServerAccount(username);
        if (lsa == null) {
            throw new IllegalArgumentException("Unable to find LinuxServerAccount: " + username + " on " + aoServer);
        }
        return lsa;
    }

    private GroupServer getLinuxServerGroup(String server, Group.Name name) throws IllegalArgumentException, IOException, SQLException {
        GroupServer lsg = this.getLinuxServer(server).getLinuxServerGroup(name);
        if (lsg == null) {
            throw new IllegalArgumentException("Unable to find LinuxServerGroup: " + name + " on " + server);
        }
        return lsg;
    }

    private com.aoindustries.aoserv.client.mysql.Server getMysqlServer(String aoServer, Server.Name name) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.mysql.Server ms = this.getLinuxServer(aoServer).getMysqlServer(name);
        if (ms == null) {
            throw new IllegalArgumentException("Unable to find MysqlServer: " + name + " on " + aoServer);
        }
        return ms;
    }

    private Database getMysqlDatabase(String aoServer, Server.Name mysqlServer, Database.Name name) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.mysql.Server ms = this.getMysqlServer(aoServer, mysqlServer);
        Database md = ms.getMysqlDatabase(name);
        if (md == null) {
            throw new IllegalArgumentException("Unable to find MysqlDatabase: " + name + " on " + mysqlServer + " on " + aoServer);
        }
        return md;
    }

    private com.aoindustries.aoserv.client.mysql.UserServer getMysqlServerUser(String aoServer, Server.Name mysqlServer, User.Name username) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.mysql.UserServer msu = this.getMysqlServer(aoServer, mysqlServer).getMysqlServerUser(username);
        if (msu == null) {
            throw new IllegalArgumentException("Unable to find MysqlServerUser: " + username + " on " + aoServer);
        }
        return msu;
    }

    private User getMysqlUser(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        User mu = this.connector.getMysql().getUser().get(username);
        if (mu == null) {
            throw new IllegalArgumentException("Unable to find MysqlUser: " + username);
        }
        return mu;
    }

    private Bind getNetBind(int pkey) throws IllegalArgumentException, IOException, SQLException {
        Bind nb = this.connector.getNet().getBind().get(pkey);
        if (nb == null) {
            throw new IllegalArgumentException("Unable to find NetBind: " + pkey);
        }
        return nb;
    }

    private Device getNetDevice(String server, String netDevice) throws IllegalArgumentException, SQLException, IOException {
        Device nd = this.getHost(server).getNetDevice(netDevice);
        if (nd == null) {
            throw new IllegalArgumentException("Unable to find NetDevice: " + netDevice + " on " + server);
        }
        return nd;
    }

    private OperatingSystem getOperatingSystem(String name) throws IllegalArgumentException, IOException, SQLException {
        OperatingSystem os = this.connector.getDistribution().getOperatingSystem().get(name);
        if (os == null) {
            throw new IllegalArgumentException("Unable to find OperatingSystem: " + name);
        }
        return os;
    }

    private OperatingSystemVersion getOperatingSystemVersion(String name, String version, Architecture architecture) throws IllegalArgumentException, IOException, SQLException {
        OperatingSystemVersion ov = this.getOperatingSystem(name).getOperatingSystemVersion(this.connector, version, architecture);
        if (ov == null) {
            throw new IllegalArgumentException("Unable to find OperatingSystemVersion: " + name + " version " + version + " for architecture of " + architecture);
        }
        return ov;
    }

    private PackageDefinition getPackageDefinition(int packageDefinition) throws IllegalArgumentException, IOException, SQLException {
        PackageDefinition pd = this.connector.getBilling().getPackageDefinition().get(packageDefinition);
        if (pd == null) {
            throw new IllegalArgumentException("Unable to find PackageDefinition: " + packageDefinition);
        }
        return pd;
    }

    private Package getPackage(Account.Name name) throws IllegalArgumentException, IOException, SQLException {
        Package pk = this.connector.getBilling().getPackage().get(name);
        if (pk == null) {
            throw new IllegalArgumentException("Unable to find Package: " + name);
        }
        return pk;
    }

    private com.aoindustries.aoserv.client.postgresql.Database getPostgresDatabase(String aoServer, Server.Name postgresServer, Database.Name name) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.postgresql.Server ps = this.getPostgresServer(aoServer, postgresServer);
        com.aoindustries.aoserv.client.postgresql.Database pd = ps.getPostgresDatabase(name);
        if (pd == null) {
            throw new IllegalArgumentException("Unable to find PostgresDatabase: " + name + " on " + postgresServer + " on " + aoServer);
        }
        return pd;
    }

    private com.aoindustries.aoserv.client.postgresql.Server getPostgresServer(String aoServer, Server.Name name) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.postgresql.Server ps = this.getLinuxServer(aoServer).getPostgresServer(name);
        if (ps == null) {
            throw new IllegalArgumentException("Unable to find PostgresServer: " + name + " on " + aoServer);
        }
        return ps;
    }

    private UserServer getPostgresServerUser(String aoServer, Server.Name postgresServer, User.Name username) throws IllegalArgumentException, IOException, SQLException {
        UserServer psu = this.getPostgresServer(aoServer, postgresServer).getPostgresServerUser(username);
        if (psu == null) {
            throw new IllegalArgumentException("Unable to find PostgresServerUser: " + username + " on " + postgresServer + " on " + aoServer);
        }
        return psu;
    }

    private com.aoindustries.aoserv.client.postgresql.User getPostgresUser(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.postgresql.User pu = this.connector.getPostgresql().getUser().get(username);
        if (pu == null) {
            throw new IllegalArgumentException("Unable to find PostgresUser: " + username);
        }
        return pu;
    }

    private Host getHost(String server) throws IllegalArgumentException, SQLException, IOException {
        Host se = this.connector.getNet().getHost().get(server);
        if (se == null) {
            throw new IllegalArgumentException("Unable to find Host: " + server);
        }
        return se;
    }

    private ServerFarm getServerFarm(String name) throws IllegalArgumentException, SQLException, IOException {
        ServerFarm sf = this.connector.getInfrastructure().getServerFarm().get(name);
        if (sf == null) {
            throw new IllegalArgumentException("Unable to find ServerFarm: " + name);
        }
        return sf;
    }

    private Certificate getSslCertificate(String aoServer, String keyFileOrCertbotName) throws IllegalArgumentException, SQLException, IOException {
        for (Certificate cert : this.getLinuxServer(aoServer).getSslCertificates()) {
            if (!cert.getKeyFile().toString().equals(keyFileOrCertbotName) && !keyFileOrCertbotName.equals(cert.getCertbotName())) continue;
            return cert;
        }
        throw new IllegalArgumentException("Unable to find SslCertificate: " + keyFileOrCertbotName + " on " + aoServer);
    }

    private Category getTicketCategory(String path) throws IllegalArgumentException, IOException, SQLException {
        Category tc = null;
        for (String name : Strings.split((String)path, (char)'/')) {
            Category newTc = this.connector.getReseller().getCategory().getTicketCategory(tc, name);
            if (newTc == null) {
                if (tc == null) {
                    throw new IllegalArgumentException("Unable to find top-level TicketCategory: " + name);
                }
                throw new IllegalArgumentException("Unable to TicketCategory: " + name + " in " + tc);
            }
            tc = newTc;
        }
        if (tc == null) {
            throw new IllegalArgumentException("Unable to find TicketCategory: " + path);
        }
        return tc;
    }

    private Priority getTicketPriority(String priority) throws IllegalArgumentException, IOException, SQLException {
        Priority tp = this.connector.getTicket().getPriority().get(priority);
        if (tp == null) {
            throw new IllegalArgumentException("Unable to find TicketPriority: " + priority);
        }
        return tp;
    }

    private TicketType getTicketType(String type) throws IllegalArgumentException, IOException, SQLException {
        TicketType tt = this.connector.getTicket().getTicketType().get(type);
        if (tt == null) {
            throw new IllegalArgumentException("Unable to find TicketType: " + type);
        }
        return tt;
    }

    private com.aoindustries.aoserv.client.account.User getUsername(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.account.User un = this.connector.getAccount().getUser().get(username);
        if (un == null) {
            throw new IllegalArgumentException("Unable to find User: " + username);
        }
        return un;
    }

    private VirtualServer getVirtualServer(String virtualServer) throws IllegalArgumentException, SQLException, IOException {
        Host se = this.getHost(virtualServer);
        VirtualServer vs = se.getVirtualServer();
        if (vs == null) {
            throw new IllegalArgumentException("Unable to find VirtualServer: " + virtualServer);
        }
        return vs;
    }

    private VirtualDisk getVirtualDisk(String virtualServer, String device) throws IllegalArgumentException, SQLException, IOException {
        VirtualServer vs = this.getVirtualServer(virtualServer);
        VirtualDisk vd = vs.getVirtualDisk(device);
        if (vd == null) {
            throw new IllegalArgumentException("Unable to find VirtualDisk: " + virtualServer + ":/dev/" + device);
        }
        return vd;
    }

    private Set getIpReputationSet(String identifier) throws IllegalArgumentException, SQLException, IOException {
        Set set = this.connector.getNet().getReputation().getSet().get(identifier);
        if (set == null) {
            throw new IllegalArgumentException("Unable to find IpReputationSet: " + identifier);
        }
        return set;
    }

    public int addBackupHost(String hostname, String farm, Account.Name owner, String description, int backupHour, String osType, String osVersion, String architecture, User.Name username, String password, String contactPhone, String contactEmail) throws IllegalArgumentException, IOException, SQLException {
        return this.connector.getNet().getHost().addBackupHost(hostname, this.getServerFarm(farm), this.getPackage(owner), description, backupHour, this.getOperatingSystemVersion(osType, osVersion, this.getArchitecture(architecture)), username, password, contactPhone, contactEmail);
    }

    public void addAccount(Account.Name accounting, String contractVersion, String defaultServer, Account.Name parent, boolean canAddBackupServers, boolean canAddBusinesses, boolean canSeePrices, boolean billParent) throws IllegalArgumentException, SQLException, IOException {
        if (contractVersion != null && contractVersion.length() == 0) {
            contractVersion = null;
        }
        this.getHost(defaultServer).addAccount(accounting, contractVersion, this.getAccount(parent), canAddBackupServers, canAddBusinesses, canSeePrices, billParent);
    }

    public void addAdministrator(User.Name username, String name, String title, Date birthday, boolean isPrivate, String workPhone, String homePhone, String cellPhone, String fax, Email email, String address1, String address2, String city, String state, String country, String zip, boolean enableEmailSupport) throws IllegalArgumentException, IOException, SQLException {
        this.getUsername(username).addAdministrator(name, title, birthday, isPrivate, workPhone, homePhone, cellPhone, fax, email, address1, address2, city, state, country, zip, enableEmailSupport);
    }

    public int addProfile(Account.Name business, String name, boolean isPrivate, String phone, String fax, String address1, String address2, String city, String state, String country, String zip, boolean sendInvoice, String billingContact, java.util.Set<Email> billingEmail, String billingEmailFormat, String technicalContact, java.util.Set<Email> technicalEmail, String technicalEmailFormat) throws IllegalArgumentException, IOException, SQLException {
        return this.getAccount(business).addProfile(name, isPrivate, phone, fax, address1, address2, city, state, country, zip, sendInvoice, billingContact, billingEmail, Profile.EmailFormat.valueOf(billingEmailFormat.toUpperCase(Locale.ROOT)), technicalContact, technicalEmail, Profile.EmailFormat.valueOf(technicalEmailFormat.toUpperCase(Locale.ROOT)));
    }

    public int addAccountHost(Account.Name accounting, String host) throws IllegalArgumentException, SQLException, IOException {
        return this.getAccount(accounting).addAccountHost(this.getHost(host));
    }

    public int addCvsRepository(String aoServer, PosixPath path, User.Name username, Group.Name group, long mode) throws IllegalArgumentException, IOException, SQLException {
        Server ao = this.getLinuxServer(aoServer);
        return ao.addCvsRepository(path, this.getLinuxServerAccount(aoServer, username), this.getLinuxServerGroup(aoServer, group), mode);
    }

    public int addDnsRecord(String zone, String domain, String type, int priority, int weight, int port, short flag, String tag, String destination, int ttl) throws IllegalArgumentException, IOException, SQLException {
        Zone nz = this.getZone(zone);
        RecordType nt = this.connector.getDns().getRecordType().get(type);
        if (nt == null) {
            throw new IllegalArgumentException("Unable to find RecordType: " + type);
        }
        if (nt.hasPriority()) {
            if (priority == -1) {
                throw new IllegalArgumentException("priority required for type=" + type);
            }
            if (priority <= 0) {
                throw new IllegalArgumentException("Invalid priority: " + priority);
            }
        } else if (priority != -1) {
            throw new IllegalArgumentException("No priority allowed for type=" + type);
        }
        if (nt.hasWeight()) {
            if (weight == -1) {
                throw new IllegalArgumentException("weight required for type=" + type);
            }
            if (weight <= 0) {
                throw new IllegalArgumentException("Invalid weight: " + weight);
            }
        } else if (weight != -1) {
            throw new IllegalArgumentException("No weight allowed for type=" + type);
        }
        if (nt.hasPort()) {
            if (port == -1) {
                throw new IllegalArgumentException("port required for type=" + type);
            }
            if (port < 1 || port > 65535) {
                throw new IllegalArgumentException("Invalid port: " + port);
            }
        } else if (port != -1) {
            throw new IllegalArgumentException("No port allowed for type=" + type);
        }
        if (nt.hasFlag()) {
            if (flag == -1) {
                throw new IllegalArgumentException("flag required for type=" + type);
            }
            if (flag < 0 || flag > 255) {
                throw new IllegalArgumentException("Invalid flag: " + flag);
            }
        } else if (flag != -1) {
            throw new IllegalArgumentException("No flag allowed for type=" + type);
        }
        if (nt.hasTag()) {
            if (tag == null) {
                throw new IllegalArgumentException("tag required for type=" + type);
            }
        } else if (tag != null) {
            throw new IllegalArgumentException("No tag allowed for type=" + type);
        }
        nt.checkDestination(tag, destination);
        return nz.addDnsRecord(domain, nt, priority, weight, port, flag, tag, destination, ttl);
    }

    public void addDnsZone(Account.Name packageName, String zone, InetAddress ip, int ttl) throws IllegalArgumentException, IOException, SQLException {
        if (!this.connector.getDns().getZone().checkDnsZone(zone)) {
            throw new IllegalArgumentException("Invalid zone: " + zone);
        }
        this.getPackage(packageName).addDnsZone(zone, ip, ttl);
    }

    public int addEmailForwarding(String address, DomainName domain, String aoServer, Email destination) throws IllegalArgumentException, IOException, SQLException {
        Domain sd = this.getEmailDomain(aoServer, domain);
        Address ea = sd.getEmailAddress(address);
        boolean added = false;
        if (ea == null) {
            ea = this.connector.getEmail().getAddress().get(sd.addEmailAddress(address));
            added = true;
        }
        try {
            return ea.addEmailForwarding(destination);
        }
        catch (IOException | Error | RuntimeException | SQLException e) {
            block8: {
                try {
                    if (added && !ea.isUsed()) {
                        ea.remove();
                    }
                }
                catch (ThreadDeath td) {
                    Throwable t = Throwables.addSuppressed((Throwable)td, (Throwable)e);
                    assert (t == td);
                    throw td;
                }
                catch (Throwable t) {
                    Throwable t2 = Throwables.addSuppressed((Throwable)e, (Throwable)t);
                    if ($assertionsDisabled || t2 == e) break block8;
                    throw new AssertionError();
                }
            }
            throw e;
        }
    }

    public int addEmailList(String aoServer, PosixPath path, User.Name username, Group.Name group) throws IllegalArgumentException, IOException, SQLException {
        return this.connector.getEmail().getList().addEmailList(path, this.getLinuxServerAccount(aoServer, username), this.getLinuxServerGroup(aoServer, group));
    }

    public int addEmailListAddress(String address, DomainName domain, PosixPath path, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        Domain sd = this.getEmailDomain(aoServer, domain);
        List el = this.getEmailList(aoServer, path);
        Address ea = sd.getEmailAddress(address);
        boolean added = false;
        if (ea == null) {
            ea = this.connector.getEmail().getAddress().get(this.connector.getEmail().getAddress().addEmailAddress(address, sd));
            added = true;
        }
        try {
            return el.addEmailAddress(ea);
        }
        catch (IOException | Error | RuntimeException | SQLException e) {
            block8: {
                try {
                    if (added && !ea.isUsed()) {
                        ea.remove();
                    }
                }
                catch (ThreadDeath td) {
                    Throwable t = Throwables.addSuppressed((Throwable)td, (Throwable)e);
                    assert (t == td);
                    throw td;
                }
                catch (Throwable t) {
                    Throwable t2 = Throwables.addSuppressed((Throwable)e, (Throwable)t);
                    if ($assertionsDisabled || t2 == e) break block8;
                    throw new AssertionError();
                }
            }
            throw e;
        }
    }

    public int addEmailPipe(String aoServer, String command, Account.Name packageName) throws IllegalArgumentException, IOException, SQLException {
        return this.connector.getEmail().getPipe().addEmailPipe(this.getLinuxServer(aoServer), command, this.getPackage(packageName));
    }

    public int addEmailPipeAddress(String address, DomainName domain, int pkey) throws IllegalArgumentException, IOException, SQLException {
        Pipe ep = this.connector.getEmail().getPipe().get(pkey);
        if (ep == null) {
            throw new IllegalArgumentException("Unable to find EmailPipe: " + ep);
        }
        Server ao = ep.getLinuxServer();
        Domain sd = ao.getEmailDomain(domain);
        if (sd == null) {
            throw new IllegalArgumentException("Unable to find EmailDomain: " + domain + " on " + ao.getHostname());
        }
        Address ea = sd.getEmailAddress(address);
        boolean added = false;
        if (ea == null) {
            ea = this.connector.getEmail().getAddress().get(sd.addEmailAddress(address));
            added = true;
        }
        try {
            return ep.addEmailAddress(ea);
        }
        catch (IOException | Error | RuntimeException | SQLException e) {
            block10: {
                try {
                    if (added && !ea.isUsed()) {
                        ea.remove();
                    }
                }
                catch (ThreadDeath td) {
                    Throwable t = Throwables.addSuppressed((Throwable)td, (Throwable)e);
                    assert (t == td);
                    throw td;
                }
                catch (Throwable t) {
                    Throwable t2 = Throwables.addSuppressed((Throwable)e, (Throwable)t);
                    if ($assertionsDisabled || t2 == e) break block10;
                    throw new AssertionError();
                }
            }
            throw e;
        }
    }

    public int addFileBackupSetting(int replication, String path, boolean backupEnabled, boolean required) throws IllegalArgumentException, IOException, SQLException {
        FileReplication ffr = this.getConnector().getBackup().getFileReplication().get(replication);
        if (ffr == null) {
            throw new IllegalArgumentException("Unable to find FailoverFileReplication: " + replication);
        }
        return ffr.addFileBackupSetting(path, backupEnabled, required);
    }

    public void addFtpGuestUser(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxAccount(username).addFtpGuestUser();
    }

    private SoftwareVersion findPhpVersion(Server aoServer, String phpVersion) throws IllegalArgumentException, IOException, SQLException {
        if (phpVersion == null || phpVersion.isEmpty()) {
            return null;
        }
        String prefix = phpVersion;
        if (!prefix.endsWith(".")) {
            prefix = prefix + '.';
        }
        int osvId = aoServer.getHost().getOperatingSystemVersion_id();
        ArrayList<SoftwareVersion> matches = new ArrayList<SoftwareVersion>();
        for (SoftwareVersion tv : this.connector.getDistribution().getSoftwareVersion()) {
            if (tv.getOperatingSystemVersion_id() != osvId || !tv.getTechnologyName_name().equals("php") || !tv.getVersion().equals(phpVersion) && !tv.getVersion().startsWith(prefix)) continue;
            matches.add(tv);
        }
        if (matches.isEmpty()) {
            throw new IllegalArgumentException("Unable to find PHP version: " + phpVersion);
        }
        if (matches.size() > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("Found more than one matching PHP version, please be more specific: ");
            boolean didOne = false;
            for (SoftwareVersion match : matches) {
                if (didOne) {
                    sb.append(", ");
                } else {
                    didOne = true;
                }
                sb.append(match.getVersion());
            }
            throw new IllegalArgumentException(sb.toString());
        }
        return (SoftwareVersion)matches.get(0);
    }

    private com.aoindustries.aoserv.client.web.tomcat.Version findTomcatVersion(Server aoServer, String version) throws IllegalArgumentException, IOException, SQLException {
        String prefix = version;
        if (!prefix.endsWith(".")) {
            prefix = prefix + '.';
        }
        int osvId = aoServer.getHost().getOperatingSystemVersion_id();
        ArrayList<com.aoindustries.aoserv.client.web.tomcat.Version> matches = new ArrayList<com.aoindustries.aoserv.client.web.tomcat.Version>();
        for (com.aoindustries.aoserv.client.web.tomcat.Version htv : this.connector.getWeb_tomcat().getVersion()) {
            SoftwareVersion tv = htv.getTechnologyVersion(this.connector);
            if (tv.getOperatingSystemVersion_id() != osvId || !tv.getVersion().equals(version) && !tv.getVersion().startsWith(prefix)) continue;
            matches.add(htv);
        }
        if (matches.isEmpty()) {
            throw new IllegalArgumentException("Unable to find Tomcat version: " + version);
        }
        if (matches.size() > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("Found more than one matching Tomcat version, please be more specific: ");
            boolean didOne = false;
            for (com.aoindustries.aoserv.client.web.tomcat.Version match : matches) {
                if (didOne) {
                    sb.append(", ");
                } else {
                    didOne = true;
                }
                sb.append(match.getTechnologyVersion(this.connector).getVersion());
            }
            throw new IllegalArgumentException(sb.toString());
        }
        return (com.aoindustries.aoserv.client.web.tomcat.Version)matches.get(0);
    }

    public int addHttpdJbossSite(String aoServer, String siteName, Account.Name packageName, User.Name jvmUsername, Group.Name groupName, Email serverAdmin, boolean useApache, InetAddress ipAddress, String netDevice, DomainName primaryHttpHostname, DomainName[] altHttpHostnames, String jbossVersion) throws IllegalArgumentException, SQLException, IOException {
        IpAddress ip;
        Server ao = this.getLinuxServer(aoServer);
        SimpleAoservClient.checkSiteName(siteName);
        if (netDevice != null && (netDevice = netDevice.trim()).length() == 0) {
            netDevice = null;
        }
        if (ipAddress != null && netDevice != null) {
            ip = this.getIpAddress(aoServer, netDevice, ipAddress);
        } else if (ipAddress == null && netDevice == null) {
            ip = null;
        } else {
            throw new IllegalArgumentException("ip_address and net_device must both be null or both be not null");
        }
        com.aoindustries.aoserv.client.web.jboss.Version hjv = this.connector.getWeb_jboss().getVersion().getHttpdJbossVersion(jbossVersion, ao.getHost().getOperatingSystemVersion());
        if (hjv == null) {
            throw new IllegalArgumentException("Unable to find HttpdJbossVersion: " + jbossVersion);
        }
        return ao.addHttpdJbossSite(siteName, this.getPackage(packageName), this.getLinuxServerAccount(aoServer, jvmUsername).getLinuxAccount(), this.getLinuxServerGroup(aoServer, groupName).getLinuxGroup(), serverAdmin, useApache, ip, primaryHttpHostname, altHttpHostnames, hjv);
    }

    public int addHttpdSharedTomcat(String name, String aoServer, String version, User.Name linuxServerAccount, Group.Name linuxServerGroup) throws IllegalArgumentException, SQLException, IOException {
        Server ao = this.getLinuxServer(aoServer);
        return ao.addHttpdSharedTomcat(name, this.findTomcatVersion(ao, version), this.getLinuxServerAccount(aoServer, linuxServerAccount), this.getLinuxServerGroup(aoServer, linuxServerGroup));
    }

    public int addVirtualHostName(int hsbPkey, DomainName hostname) throws IllegalArgumentException, IOException, SQLException {
        VirtualHost hsb = this.connector.getWeb().getVirtualHost().get(hsbPkey);
        if (hsb == null) {
            throw new IllegalArgumentException("Unable to find HttpdSiteBind: " + hsbPkey);
        }
        return hsb.addVirtualHostName(hostname);
    }

    public int addHttpdSiteAuthenticatedLocation(String siteName, String aoServer, String path, boolean isRegularExpression, String authName, PosixPath authGroupFile, PosixPath authUserFile, String require, String handler) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getLinuxServer(aoServer).getHttpdSite(siteName);
        if (hs == null) {
            throw new IllegalArgumentException("Unable to find HttpdSite: " + siteName + " on " + aoServer);
        }
        return hs.addHttpdSiteAuthenticatedLocation(path, isRegularExpression, authName, authGroupFile, authUserFile, require, handler);
    }

    public void setHttpdSiteAuthenticatedLocationAttributes(String siteName, String aoServer, String path, boolean isRegularExpression, String authName, PosixPath authGroupFile, PosixPath authUserFile, String require, String handler) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getLinuxServer(aoServer).getHttpdSite(siteName);
        if (hs == null) {
            throw new IllegalArgumentException("Unable to find HttpdSite: " + siteName + " on " + aoServer);
        }
        Location hsal = null;
        for (Location location : hs.getHttpdSiteAuthenticatedLocations()) {
            if (!path.equals(location.getPath())) continue;
            hsal = location;
            break;
        }
        if (hsal == null) {
            throw new IllegalArgumentException("Unable to find HttpdSiteAuthenticatedLocation: " + siteName + " on " + aoServer + " at " + path);
        }
        hsal.setAttributes(path, isRegularExpression, authName, authGroupFile, authUserFile, require, handler);
    }

    public int addHttpdTomcatContext(String siteName, String aoServer, String className, boolean cookies, boolean crossContext, PosixPath docBase, boolean override, String path, boolean privileged, boolean reloadable, boolean useNaming, String wrapperClass, int debug, PosixPath workDir, boolean serverXmlConfigured) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        return hts.addHttpdTomcatContext(className == null || (className = className.trim()).length() == 0 ? null : className, cookies, crossContext, docBase, override, path, privileged, reloadable, useNaming, wrapperClass == null || (wrapperClass = wrapperClass.trim()).length() == 0 ? null : wrapperClass, debug, workDir, serverXmlConfigured);
    }

    public int addHttpdTomcatDataSource(String siteName, String aoServer, String path, String name, String driverClassName, String url, String username, String password, int maxActive, int maxIdle, int maxWait, String validationQuery) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        Context htc = hts.getHttpdTomcatContext(path);
        if (htc == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatContext: " + siteName + " on " + aoServer + " path='" + path + '\'');
        }
        return htc.addHttpdTomcatDataSource(name, driverClassName, url, username, password, maxActive, maxIdle, maxWait, validationQuery);
    }

    public int addHttpdTomcatParameter(String siteName, String aoServer, String path, String name, String value, boolean override, String description) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        Context htc = hts.getHttpdTomcatContext(path);
        if (htc == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatContext: " + siteName + " on " + aoServer + " path='" + path + '\'');
        }
        return htc.addHttpdTomcatParameter(name, value, override, description);
    }

    public int addHttpdTomcatSiteJkMount(String siteName, String aoServer, String path, boolean mount) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        return hts.addJkMount(path, mount);
    }

    public void removeHttpdTomcatSiteJkMount(String siteName, String aoServer, String path) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        JkMount match = null;
        for (JkMount htsjm : hts.getJkMounts()) {
            if (!htsjm.getPath().equals(path)) continue;
            match = htsjm;
            break;
        }
        if (match == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSiteJkMount: " + siteName + " on " + aoServer + " at " + path);
        }
        match.remove();
    }

    public int addHttpdTomcatSharedSite(String aoServer, String siteName, Account.Name packageName, User.Name jvmUsername, Group.Name groupName, Email serverAdmin, boolean useApache, InetAddress ipAddress, String netDevice, DomainName primaryHttpHostname, DomainName[] altHttpHostnames, String sharedTomcatName) throws IllegalArgumentException, SQLException, IOException {
        IpAddress ip;
        Server ao = this.getLinuxServer(aoServer);
        SimpleAoservClient.checkSiteName(siteName);
        if (netDevice != null && (netDevice = netDevice.trim()).length() == 0) {
            netDevice = null;
        }
        if (ipAddress != null && netDevice != null) {
            ip = this.getIpAddress(aoServer, netDevice, ipAddress);
        } else if (ipAddress == null && netDevice == null) {
            ip = null;
        } else {
            throw new IllegalArgumentException("ip_address and net_device must both be null or both be not null");
        }
        SharedTomcat sht = ao.getHttpdSharedTomcat(sharedTomcatName);
        if (sht == null) {
            throw new IllegalArgumentException("Unable to find HttpdSharedTomcat: " + sharedTomcatName + " on " + aoServer);
        }
        return ao.addHttpdTomcatSharedSite(siteName, this.getPackage(packageName), this.getLinuxServerAccount(aoServer, jvmUsername).getLinuxAccount(), this.getLinuxServerGroup(aoServer, groupName).getLinuxGroup(), serverAdmin, useApache, ip, primaryHttpHostname, altHttpHostnames, sharedTomcatName);
    }

    public int addHttpdTomcatStdSite(String aoServer, String siteName, Account.Name packageName, User.Name jvmUsername, Group.Name groupName, Email serverAdmin, boolean useApache, InetAddress ipAddress, String netDevice, DomainName primaryHttpHostname, DomainName[] altHttpHostnames, String tomcatVersion) throws IllegalArgumentException, SQLException, IOException {
        IpAddress ip;
        Server ao = this.getLinuxServer(aoServer);
        SimpleAoservClient.checkSiteName(siteName);
        if (netDevice != null && (netDevice = netDevice.trim()).length() == 0) {
            netDevice = null;
        }
        if (ipAddress != null && netDevice != null) {
            ip = this.getIpAddress(aoServer, netDevice, ipAddress);
        } else if (ipAddress == null && netDevice == null) {
            ip = null;
        } else {
            throw new IllegalArgumentException("ip_address and net_device must both be null or both be not null");
        }
        return ao.addHttpdTomcatStdSite(siteName, this.getPackage(packageName), this.getLinuxServerAccount(aoServer, jvmUsername).getLinuxAccount(), this.getLinuxServerGroup(aoServer, groupName).getLinuxGroup(), serverAdmin, useApache, ip, primaryHttpHostname, altHttpHostnames, this.findTomcatVersion(ao, tomcatVersion));
    }

    public int addLinuxAccAddress(String address, DomainName domain, String aoServer, User.Name username) throws IllegalArgumentException, IOException, SQLException {
        boolean added;
        Domain sd = this.getEmailDomain(aoServer, domain);
        com.aoindustries.aoserv.client.linux.UserServer lsa = this.getLinuxServerAccount(aoServer, username);
        Address ea = sd.getEmailAddress(address);
        if (ea == null) {
            ea = this.connector.getEmail().getAddress().get(sd.addEmailAddress(address));
            added = true;
        } else {
            added = false;
        }
        try {
            return lsa.addEmailAddress(ea);
        }
        catch (IOException | Error | RuntimeException | SQLException e) {
            block9: {
                try {
                    if (added && !ea.isUsed()) {
                        ea.remove();
                    }
                }
                catch (ThreadDeath td) {
                    Throwable t = Throwables.addSuppressed((Throwable)td, (Throwable)e);
                    assert (t == td);
                    throw td;
                }
                catch (Throwable t) {
                    Throwable t2 = Throwables.addSuppressed((Throwable)e, (Throwable)t);
                    if ($assertionsDisabled || t2 == e) break block9;
                    throw new AssertionError();
                }
            }
            throw e;
        }
    }

    public void addLinuxAccount(User.Name username, Group.Name primaryGroup, User.Gecos name, User.Gecos officeLocation, User.Gecos officePhone, User.Gecos homePhone, String type, PosixPath shell) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.account.User un = this.getUsername(username);
        Group lg = this.getLinuxGroup(primaryGroup);
        UserType lat = this.connector.getLinux().getUserType().get(type);
        if (lat == null) {
            throw new IllegalArgumentException("Unable to find LinuxAccountType: " + type);
        }
        Shell sh = this.connector.getLinux().getShell().get(shell);
        if (sh == null) {
            throw new IllegalArgumentException("Unable to find Shell: " + shell);
        }
        un.addLinuxAccount(primaryGroup, name, officeLocation, officePhone, homePhone, type, shell);
    }

    public void addLinuxGroup(Group.Name name, Account.Name packageName, String type) throws IllegalArgumentException, IOException, SQLException {
        GroupType lgt = this.connector.getLinux().getGroupType().get(type);
        if (lgt == null) {
            throw new IllegalArgumentException("Unable to find LinuxGroupType: " + type);
        }
        this.connector.getLinux().getGroup().addLinuxGroup(name, this.getPackage(packageName), type);
    }

    public int addLinuxGroupAccount(Group.Name group, User.Name username) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxGroup(group).addLinuxAccount(this.getLinuxAccount(username));
    }

    public int addLinuxServerAccount(User.Name username, String aoServer, PosixPath home) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.linux.User la = this.getLinuxAccount(username);
        Server ao = this.getLinuxServer(aoServer);
        if (home == null) {
            home = com.aoindustries.aoserv.client.linux.UserServer.getDefaultHomeDirectory(username);
        }
        return la.addLinuxServerAccount(ao, home);
    }

    public int addLinuxServerGroup(Group.Name group, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxGroup(group).addLinuxServerGroup(this.getLinuxServer(aoServer));
    }

    public int addMajordomoList(DomainName domain, String aoServer, String listName) throws IllegalArgumentException, IOException, SQLException {
        Domain ed = this.getEmailDomain(aoServer, domain);
        MajordomoServer ms = ed.getMajordomoServer();
        if (ms == null) {
            throw new IllegalArgumentException("Unable to find MajordomoServer: " + domain + " on " + aoServer);
        }
        SimpleAoservClient.checkMajordomoListName(listName);
        return ms.addMajordomoList(listName);
    }

    public void addMajordomoServer(DomainName domain, String aoServer, User.Name linuxAccount, Group.Name linuxGroup, String version) throws IllegalArgumentException, IOException, SQLException {
        Domain ed = this.getEmailDomain(aoServer, domain);
        MajordomoVersion mv = this.connector.getEmail().getMajordomoVersion().get(version);
        if (mv == null) {
            throw new IllegalArgumentException("Unable to find MajordomoVersion: " + version);
        }
        ed.addMajordomoServer(this.getLinuxServerAccount(aoServer, linuxAccount), this.getLinuxServerGroup(aoServer, linuxGroup), mv);
    }

    public int addMysqlDatabase(Database.Name name, Server.Name mysqlServer, String aoServer, Account.Name packageName) throws IllegalArgumentException, IOException, SQLException {
        return this.connector.getMysql().getDatabase().addMysqlDatabase(name, this.getMysqlServer(aoServer, mysqlServer), this.getPackage(packageName));
    }

    public int addMysqlDbUser(Database.Name name, Server.Name mysqlServer, String aoServer, User.Name username, boolean canSelect, boolean canInsert, boolean canUpdate, boolean canDelete, boolean canCreate, boolean canDrop, boolean canReference, boolean canIndex, boolean canAlter, boolean canCreateTempTable, boolean canLockTables, boolean canCreateView, boolean canShowView, boolean canCreateRoutine, boolean canAlterRoutine, boolean canExecute, boolean canEvent, boolean canTrigger) throws IllegalArgumentException, IOException, SQLException {
        Database md = this.getMysqlDatabase(aoServer, mysqlServer, name);
        return this.connector.getMysql().getDatabaseUser().addMysqlDbUser(md, this.getMysqlServerUser(aoServer, mysqlServer, username), canSelect, canInsert, canUpdate, canDelete, canCreate, canDrop, canReference, canIndex, canAlter, canCreateTempTable, canLockTables, canCreateView, canShowView, canCreateRoutine, canAlterRoutine, canExecute, canEvent, canTrigger);
    }

    public int addMysqlServerUser(User.Name username, Server.Name mysqlServer, String aoServer, String host) throws IllegalArgumentException, IOException, SQLException {
        return this.getMysqlUser(username).addMysqlServerUser(this.getMysqlServer(aoServer, mysqlServer), host == null || host.length() == 0 ? null : host);
    }

    public void addMysqlUser(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        this.getUsername(username).addMysqlUser();
    }

    public int addNetBind(String server, Account.Name packageName, InetAddress ipAddress, String netDevice, Port port, String appProtocol, boolean monitoringEnabled, java.util.Set<FirewallZone.Name> firewalldZoneNames) throws IllegalArgumentException, SQLException, IOException {
        IpAddress ia = this.getIpAddress(server, netDevice, ipAddress);
        AppProtocol appProt = this.connector.getNet().getAppProtocol().get(appProtocol);
        if (appProt == null) {
            throw new IllegalArgumentException("Unable to find Protocol: " + appProtocol);
        }
        return this.getHost(server).addNetBind(this.getPackage(packageName), ia, port, appProt, monitoringEnabled, firewalldZoneNames);
    }

    public int addNoticeLog(Account.Name accounting, String billingContact, Email emailAddress, String type, int transid) throws IllegalArgumentException, IOException, SQLException {
        Transaction trans;
        Account account = this.getAccount(accounting);
        NoticeType nt = this.connector.getBilling().getNoticeType().get(type);
        if (nt == null) {
            throw new IllegalArgumentException("Unable to find NoticeType: " + type);
        }
        if (transid != -1) {
            trans = this.connector.getBilling().getTransaction().get(transid);
            if (trans == null) {
                throw new IllegalArgumentException("Unable to find Transaction: " + transid);
            }
        } else {
            trans = null;
        }
        return this.connector.getBilling().getNoticeLog().addNoticeLog(account, billingContact, emailAddress, nt, trans);
    }

    public int addPackage(Account.Name packageName, Account.Name accounting, int packageDefinition) throws IllegalArgumentException, IOException, SQLException {
        Account business = this.getAccount(accounting);
        PackageDefinition pd = this.getPackageDefinition(packageDefinition);
        return business.addPackage(packageName, pd);
    }

    public int addPostgresDatabase(Database.Name name, Server.Name postgresServer, String aoServer, User.Name datdba, String encoding, boolean enablePostgis) throws IllegalArgumentException, SQLException, IOException {
        UserServer psu = this.getPostgresServerUser(aoServer, postgresServer, datdba);
        com.aoindustries.aoserv.client.postgresql.Server ps = psu.getPostgresServer();
        Version pv = ps.getVersion();
        Encoding pe = pv.getPostgresEncoding(this.connector, encoding);
        if (pe == null) {
            throw new IllegalArgumentException("Unable to find PostgresEncoding for PostgresVersion " + pv.getTechnologyVersion(this.connector).getVersion() + ": " + encoding);
        }
        if (enablePostgis && pv.getPostgisVersion(this.connector) == null) {
            throw new IllegalArgumentException("Unable to enable PostGIS, PostgresVersion " + pv.getTechnologyVersion(this.connector).getVersion() + " doesn't support PostGIS");
        }
        return ps.addPostgresDatabase(name, psu, pe, enablePostgis);
    }

    public int addPostgresServerUser(User.Name username, Server.Name postgresServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getPostgresUser(username).addPostgresServerUser(this.getPostgresServer(aoServer, postgresServer));
    }

    public void addPostgresUser(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        this.getUsername(username).addPostgresUser();
    }

    public int addEmailDomain(DomainName domain, String aoServer, Account.Name packageName) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxServer(aoServer).addEmailDomain(domain, this.getPackage(packageName));
    }

    public int addEmailSmtpRelay(Account.Name packageName, String aoServer, HostAddress host, String type, long duration) throws IllegalArgumentException, SQLException, IOException {
        if (aoServer != null && (aoServer = aoServer.trim()).length() == 0) {
            aoServer = null;
        }
        Server ao = aoServer == null ? null : this.getLinuxServer(aoServer);
        SmtpRelayType esrt = this.connector.getEmail().getSmtpRelayType().get(type);
        if (esrt == null) {
            throw new SQLException("Unable to find EmailSmtpRelayType: " + type);
        }
        return this.getPackage(packageName).addEmailSmtpRelay(ao, host, esrt, duration);
    }

    public int addSpamEmailMessage(int emailRelay, String message) throws IllegalArgumentException, IOException, SQLException {
        SmtpRelay esr = this.connector.getEmail().getSmtpRelay().get(emailRelay);
        if (esr == null) {
            throw new IllegalArgumentException("Unable to find EmailSmtpRelay: " + emailRelay);
        }
        return esr.addSpamEmailMessage(message);
    }

    public int addTransaction(int timeType, Timestamp time, Account.Name accountName, Account.Name sourceAccountName, User.Name administrator, String type, String description, int quantity, Money rate, String paymentType, String paymentInfo, String processor, byte paymentConfirmed) throws IllegalArgumentException, IOException, SQLException {
        Processor ccProcessor;
        PaymentType pt;
        Account account = this.getAccount(accountName);
        Account sourceAccount = this.getAccount(sourceAccountName);
        Administrator pe = this.connector.getAccount().getAdministrator().get(administrator);
        if (pe == null) {
            throw new IllegalArgumentException("Unable to find Administrator: " + administrator);
        }
        TransactionType tt = this.connector.getBilling().getTransactionType().get(type);
        if (tt == null) {
            throw new IllegalArgumentException("Unable to find TransactionType: " + type);
        }
        if (paymentType == null || paymentType.length() == 0) {
            pt = null;
        } else {
            pt = this.connector.getPayment().getPaymentType().get(paymentType);
            if (pt == null) {
                throw new IllegalArgumentException("Unable to find PaymentType: " + paymentType);
            }
        }
        if (paymentInfo != null && paymentInfo.length() == 0) {
            paymentInfo = null;
        }
        if (processor == null || processor.length() == 0) {
            ccProcessor = null;
        } else {
            ccProcessor = this.connector.getPayment().getProcessor().get(processor);
            if (ccProcessor == null) {
                throw new IllegalArgumentException("Unable to find CreditCardProcessor: " + processor);
            }
        }
        return this.connector.getBilling().getTransaction().add(timeType, time, account, sourceAccount, pe, tt, description, quantity, rate, pt, paymentInfo, ccProcessor, paymentConfirmed);
    }

    public void addUsername(Account.Name packageName, User.Name username) throws IllegalArgumentException, IOException, SQLException {
        this.getPackage(packageName).addUsername(username);
    }

    public int areLinuxAccountPasswordsSet(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxAccount(username).arePasswordsSet();
    }

    public int areMysqlUserPasswordsSet(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        return this.getMysqlUser(username).arePasswordsSet();
    }

    public int arePostgresUserPasswordsSet(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        return this.getPostgresUser(username).arePasswordsSet();
    }

    public int areUsernamePasswordsSet(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        return this.getUsername(username).arePasswordsSet();
    }

    public void cancelAccount(Account.Name accounting, String reason) throws IllegalArgumentException, IOException, SQLException {
        this.getAccount(accounting).cancel(reason);
    }

    public static java.util.List<PasswordChecker.Result> checkAdministratorPassword(User.Name username, String password) throws IOException {
        return Administrator.checkPassword(username, password);
    }

    public void checkDnsZone(String zone) throws IllegalArgumentException, IOException, SQLException {
        if (!this.connector.getDns().getZone().checkDnsZone(zone)) {
            throw new IllegalArgumentException("Invalid DNS zone: " + zone);
        }
    }

    public void checkEmailListPath(String aoServer, PosixPath path) throws IllegalArgumentException, IOException, SQLException {
        Server ao = this.getLinuxServer(aoServer);
        if (!List.isValidRegularPath(path, ao.getHost().getOperatingSystemVersion_id())) {
            throw new IllegalArgumentException("Invalid EmailList path: " + path + " on " + ao);
        }
    }

    public java.util.List<PasswordChecker.Result> checkLinuxAccountPassword(User.Name username, String password) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxAccount(username).checkPassword(password);
    }

    public static java.util.List<PasswordChecker.Result> checkMysqlPassword(User.Name username, String password) throws IOException {
        return User.checkPassword(username, password);
    }

    public static java.util.List<PasswordChecker.Result> checkPostgresPassword(User.Name username, String password) throws IOException {
        return com.aoindustries.aoserv.client.postgresql.User.checkPassword(username, password);
    }

    public static void checkMajordomoListName(String listName) throws IllegalArgumentException {
        if (!MajordomoList.isValidListName(listName)) {
            throw new IllegalArgumentException("Invalid Majordomo list name: " + listName);
        }
    }

    public static void checkSharedTomcatName(String tomcatName) throws IllegalArgumentException {
        if (!SharedTomcat.isValidSharedTomcatName(tomcatName)) {
            throw new IllegalArgumentException("Invalid shared Tomcat name: " + tomcatName);
        }
    }

    public static void checkSiteName(String siteName) throws IllegalArgumentException {
        if (!Site.isValidSiteName(siteName)) {
            throw new IllegalArgumentException("Invalid site name: " + siteName);
        }
    }

    public java.util.List<PasswordChecker.Result> checkUsernamePassword(User.Name username, String password) throws IllegalArgumentException, IOException, SQLException {
        return this.getUsername(username).checkPassword(password);
    }

    public boolean compareLinuxServerAccountPassword(User.Name username, String aoServer, String password) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxServerAccount(aoServer, username).passwordMatches(password);
    }

    public long copyHomeDirectory(User.Name username, String fromAoServer, String toAoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxServerAccount(fromAoServer, username).copyHomeDirectory(this.getLinuxServer(toAoServer));
    }

    public void copyLinuxServerAccountPassword(User.Name fromUsername, String fromAoServer, User.Name toUsername, String toAoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServerAccount(fromAoServer, fromUsername).copyPassword(this.getLinuxServerAccount(toAoServer, toUsername));
    }

    @Deprecated
    public static String crypt(String password, String salt) {
        if (password == null || password.isEmpty()) {
            return "*";
        }
        return salt == null || salt.isEmpty() ? UnixCrypt.crypt((String)password) : UnixCrypt.crypt((String)password, (String)salt);
    }

    public void declineCreditCard(int pkey, String reason) throws IllegalArgumentException, IOException, SQLException {
        CreditCard card = this.connector.getPayment().getCreditCard().get(pkey);
        if (card == null) {
            throw new IllegalArgumentException("Unable to find CreditCard: " + pkey);
        }
        card.declined(reason);
    }

    public int disableAccount(Account.Name accounting, String disableReason) throws IllegalArgumentException, IOException, SQLException {
        Account bu = this.getAccount(accounting);
        DisableLog dl = this.connector.getAccount().getDisableLog().get(bu.addDisableLog(disableReason));
        for (Package pk : bu.getPackages()) {
            if (pk.isDisabled()) continue;
            this.disablePackage(dl, pk);
        }
        bu.disable(dl);
        return dl.getPkey();
    }

    public int disablePackage(Account.Name name, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        Package pk = this.getPackage(name);
        DisableLog dl = this.connector.getAccount().getDisableLog().get(pk.getAccount().addDisableLog(disableReason));
        this.disablePackage(dl, pk);
        return dl.getPkey();
    }

    private void disablePackage(DisableLog dl, Package pk) throws IOException, SQLException {
        Server ao;
        for (List el : pk.getEmailLists()) {
            if (el.isDisabled()) continue;
            el.disable(dl);
        }
        for (Pipe ep : pk.getEmailPipes()) {
            if (ep.isDisabled()) continue;
            ep.disable(dl);
        }
        for (SmtpRelay ssr : pk.getEmailSmtpRelays()) {
            if (ssr.isDisabled()) continue;
            ssr.disable(dl);
        }
        SortedArrayList httpdServers = new SortedArrayList();
        for (SharedTomcat hst : pk.getHttpdSharedTomcats()) {
            if (hst.isDisabled()) continue;
            hst.disable(dl);
            ao = hst.getLinuxServer();
            if (httpdServers.contains(ao)) continue;
            httpdServers.add(ao);
        }
        for (Site hs : pk.getHttpdSites()) {
            if (hs.isDisabled()) continue;
            this.disableHttpdSite(dl, hs);
            ao = hs.getLinuxServer();
            if (httpdServers.contains(ao)) continue;
            httpdServers.add(ao);
        }
        for (Server httpdServer : httpdServers) {
            httpdServer.waitForHttpdSiteRebuild();
        }
        for (com.aoindustries.aoserv.client.account.User un : pk.getUsernames()) {
            if (un.isDisabled()) continue;
            this.disableUsername(dl, un);
        }
        pk.disable(dl);
    }

    public int disableHttpdSharedTomcat(String name, String aoServer, String disableReason) throws IllegalArgumentException, IOException, SQLException {
        SharedTomcat hst = this.getHttpdSharedTomcat(aoServer, name);
        DisableLog dl = this.connector.getAccount().getDisableLog().get(hst.getLinuxServerGroup().getLinuxGroup().getPackage().getAccount().addDisableLog(disableReason));
        hst.disable(dl);
        return dl.getPkey();
    }

    public int disableEmailPipe(int pkey, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        Pipe ep = this.connector.getEmail().getPipe().get(pkey);
        if (ep == null) {
            throw new IllegalArgumentException("Unable to find EmailPipe: " + pkey);
        }
        DisableLog dl = this.connector.getAccount().getDisableLog().get(ep.getPackage().getAccount().addDisableLog(disableReason));
        ep.disable(dl);
        return dl.getPkey();
    }

    public int disableHttpdSite(String name, String aoServer, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        Site hs = this.getHttpdSite(aoServer, name);
        DisableLog dl = this.connector.getAccount().getDisableLog().get(hs.getPackage().getAccount().addDisableLog(disableReason));
        this.disableHttpdSite(dl, hs);
        return dl.getPkey();
    }

    private void disableHttpdSite(DisableLog dl, Site hs) throws IOException, SQLException {
        for (VirtualHost hsb : hs.getHttpdSiteBinds()) {
            if (hsb.isDisabled()) continue;
            hsb.disable(dl);
        }
        hs.disable(dl);
    }

    public int disableHttpdSiteBind(int pkey, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        VirtualHost hsb = this.connector.getWeb().getVirtualHost().get(pkey);
        if (hsb == null) {
            throw new IllegalArgumentException("Unable to find HttpdSiteBind: " + pkey);
        }
        DisableLog dl = this.connector.getAccount().getDisableLog().get(hsb.getHttpdSite().getPackage().getAccount().addDisableLog(disableReason));
        hsb.disable(dl);
        return dl.getPkey();
    }

    public int disableEmailList(PosixPath path, String aoServer, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        List el = this.getEmailList(aoServer, path);
        DisableLog dl = this.connector.getAccount().getDisableLog().get(el.getLinuxServerGroup().getLinuxGroup().getPackage().getAccount().addDisableLog(disableReason));
        el.disable(dl);
        return dl.getPkey();
    }

    public int disableEmailSmtpRelay(int pkey, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        SmtpRelay ssr = this.connector.getEmail().getSmtpRelay().get(pkey);
        if (ssr == null) {
            throw new IllegalArgumentException("Unable to find EmailSmtpRelay: " + pkey);
        }
        DisableLog dl = this.connector.getAccount().getDisableLog().get(ssr.getPackage().getAccount().addDisableLog(disableReason));
        ssr.disable(dl);
        return dl.getPkey();
    }

    public int disableUsername(User.Name username, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        com.aoindustries.aoserv.client.account.User un = this.getUsername(username);
        DisableLog dl = this.connector.getAccount().getDisableLog().get(un.getPackage().getAccount().addDisableLog(disableReason));
        this.disableUsername(dl, un);
        return dl.getPkey();
    }

    private void disableUsername(DisableLog dl, com.aoindustries.aoserv.client.account.User un) throws IOException, SQLException {
        com.aoindustries.aoserv.client.postgresql.User pu;
        User mu;
        com.aoindustries.aoserv.client.linux.User la = un.getLinuxAccount();
        if (la != null && !la.isDisabled()) {
            this.disableLinuxAccount(dl, la);
        }
        if ((mu = un.getMysqlUser()) != null && !mu.isDisabled()) {
            this.disableMysqlUser(dl, mu);
        }
        if ((pu = un.getPostgresUser()) != null && !pu.isDisabled()) {
            this.disablePostgresUser(dl, pu);
        }
        un.disable(dl);
    }

    public int disableLinuxAccount(User.Name username, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        com.aoindustries.aoserv.client.linux.User la = this.getLinuxAccount(username);
        DisableLog dl = this.connector.getAccount().getDisableLog().get(la.getUsername().getPackage().getAccount().addDisableLog(disableReason));
        this.disableLinuxAccount(dl, la);
        return dl.getPkey();
    }

    private void disableLinuxAccount(DisableLog dl, com.aoindustries.aoserv.client.linux.User la) throws IOException, SQLException {
        for (com.aoindustries.aoserv.client.linux.UserServer lsa : la.getLinuxServerAccounts()) {
            if (lsa.isDisabled()) continue;
            this.disableLinuxServerAccount(dl, lsa);
        }
        la.disable(dl);
    }

    public int disableLinuxServerAccount(User.Name username, String aoServer, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        com.aoindustries.aoserv.client.linux.UserServer lsa = this.getLinuxServerAccount(aoServer, username);
        DisableLog dl = this.connector.getAccount().getDisableLog().get(lsa.getLinuxAccount().getUsername().getPackage().getAccount().addDisableLog(disableReason));
        this.disableLinuxServerAccount(dl, lsa);
        return dl.getPkey();
    }

    private void disableLinuxServerAccount(DisableLog dl, com.aoindustries.aoserv.client.linux.UserServer lsa) throws IOException, SQLException {
        for (CvsRepository cr : lsa.getCvsRepositories()) {
            if (cr.isDisabled()) continue;
            cr.disable(dl);
        }
        lsa.disable(dl);
    }

    public int disableCvsRepository(int pkey, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        CvsRepository cr = this.connector.getScm().getCvsRepository().get(pkey);
        if (cr == null) {
            throw new IllegalArgumentException("Unable to find CvsRepository: " + pkey);
        }
        DisableLog dl = this.connector.getAccount().getDisableLog().get(cr.getLinuxServerAccount().getLinuxAccount().getUsername().getPackage().getAccount().addDisableLog(disableReason));
        cr.disable(dl);
        return dl.getPkey();
    }

    public int disableMysqlUser(User.Name username, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        User mu = this.getMysqlUser(username);
        DisableLog dl = this.connector.getAccount().getDisableLog().get(mu.getUsername().getPackage().getAccount().addDisableLog(disableReason));
        this.disableMysqlUser(dl, mu);
        return dl.getPkey();
    }

    private void disableMysqlUser(DisableLog dl, User mu) throws IOException, SQLException {
        for (com.aoindustries.aoserv.client.mysql.UserServer msu : mu.getMysqlServerUsers()) {
            if (msu.isDisabled()) continue;
            msu.disable(dl);
        }
        mu.disable(dl);
    }

    public int disableMysqlServerUser(User.Name username, Server.Name mysqlServer, String aoServer, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        com.aoindustries.aoserv.client.mysql.UserServer msu = this.getMysqlServerUser(aoServer, mysqlServer, username);
        DisableLog dl = this.connector.getAccount().getDisableLog().get(msu.getMysqlUser().getUsername().getPackage().getAccount().addDisableLog(disableReason));
        msu.disable(dl);
        return dl.getPkey();
    }

    public int disablePostgresUser(User.Name username, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        com.aoindustries.aoserv.client.postgresql.User pu = this.getPostgresUser(username);
        DisableLog dl = this.connector.getAccount().getDisableLog().get(pu.getUsername().getPackage().getAccount().addDisableLog(disableReason));
        this.disablePostgresUser(dl, pu);
        return dl.getPkey();
    }

    private void disablePostgresUser(DisableLog dl, com.aoindustries.aoserv.client.postgresql.User pu) throws IOException, SQLException {
        for (UserServer psu : pu.getPostgresServerUsers()) {
            if (psu.isDisabled()) continue;
            psu.disable(dl);
        }
        pu.disable(dl);
    }

    public int disablePostgresServerUser(User.Name username, Server.Name postgresServer, String aoServer, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        UserServer psu = this.getPostgresServerUser(aoServer, postgresServer, username);
        DisableLog dl = this.connector.getAccount().getDisableLog().get(psu.getPostgresUser().getUsername().getPackage().getAccount().addDisableLog(disableReason));
        psu.disable(dl);
        return dl.getPkey();
    }

    public int disableAdministrator(User.Name username, String disableReason) throws IllegalArgumentException, SQLException, IOException {
        com.aoindustries.aoserv.client.account.User un = this.getUsername(username);
        Administrator administrator = un.getAdministrator();
        if (administrator == null) {
            throw new IllegalArgumentException("Unable to find Administrator: " + username);
        }
        DisableLog dl = this.connector.getAccount().getDisableLog().get(un.getPackage().getAccount().addDisableLog(disableReason));
        administrator.disable(dl);
        return dl.getPkey();
    }

    public void enableAccount(Account.Name accounting) throws IllegalArgumentException, IOException, SQLException {
        Account bu = this.getAccount(accounting);
        DisableLog dl = bu.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("Account not disabled: " + accounting);
        }
        bu.enable();
        for (Package pk : bu.getPackages()) {
            if (!dl.equals(pk.getDisableLog())) continue;
            this.enablePackage(dl, pk);
        }
    }

    public void enablePackage(Account.Name name) throws IllegalArgumentException, SQLException, IOException {
        Package pk = this.getPackage(name);
        DisableLog dl = pk.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("Package not disabled: " + name);
        }
        this.enablePackage(dl, pk);
    }

    private void enablePackage(DisableLog dl, Package pk) throws IOException, SQLException {
        pk.enable();
        for (List el : pk.getEmailLists()) {
            if (!dl.equals(el.getDisableLog())) continue;
            el.enable();
        }
        for (Pipe ep : pk.getEmailPipes()) {
            if (!dl.equals(ep.getDisableLog())) continue;
            ep.enable();
        }
        for (SmtpRelay ssr : pk.getEmailSmtpRelays()) {
            if (!dl.equals(ssr.getDisableLog())) continue;
            ssr.enable();
        }
        SortedArrayList linuxAccountServers = new SortedArrayList();
        SortedArrayList mysqlServers = new SortedArrayList();
        SortedArrayList postgresServers = new SortedArrayList();
        for (com.aoindustries.aoserv.client.account.User un : pk.getUsernames()) {
            if (!dl.equals(un.getDisableLog())) continue;
            this.enableUsername(dl, un, (java.util.List<Server>)linuxAccountServers, (java.util.List<Server>)mysqlServers, (java.util.List<Server>)postgresServers);
        }
        for (Server linuxAccountServer : linuxAccountServers) {
            linuxAccountServer.waitForLinuxAccountRebuild();
        }
        for (Server mysqlServer : mysqlServers) {
            mysqlServer.waitForMysqlUserRebuild();
        }
        for (Server postgresServer : postgresServers) {
            postgresServer.waitForPostgresUserRebuild();
        }
        for (SharedTomcat hst : pk.getHttpdSharedTomcats()) {
            if (!dl.equals(hst.getDisableLog())) continue;
            hst.enable();
        }
        for (Site hs : pk.getHttpdSites()) {
            if (hs.getDisableLog_pkey() == null || hs.getDisableLog_pkey().intValue() != dl.getPkey()) continue;
            this.enableHttpdSite(dl, hs);
        }
    }

    public void enableHttpdSharedTomcat(String name, String aoServer) throws IllegalArgumentException, SQLException, IOException {
        SharedTomcat hst = this.getHttpdSharedTomcat(aoServer, name);
        DisableLog dl = hst.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("HttpdSharedTomcat not disabled: " + name + " on " + aoServer);
        }
        hst.enable();
    }

    public void enableEmailPipe(int pkey) throws IllegalArgumentException, SQLException, IOException {
        Pipe ep = this.connector.getEmail().getPipe().get(pkey);
        if (ep == null) {
            throw new IllegalArgumentException("Unable to find EmailPipe: " + pkey);
        }
        DisableLog dl = ep.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("EmailPipe not disabled: " + pkey);
        }
        ep.enable();
    }

    public void enableHttpdSite(String name, String aoServer) throws IllegalArgumentException, SQLException, IOException {
        Site hs = this.getHttpdSite(aoServer, name);
        DisableLog dl = hs.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("HttpdSite not disabled: " + name + " on " + aoServer);
        }
        this.enableHttpdSite(dl, hs);
    }

    private void enableHttpdSite(DisableLog dl, Site hs) throws IOException, SQLException {
        hs.enable();
        for (VirtualHost hsb : hs.getHttpdSiteBinds()) {
            if (!dl.equals(hsb.getDisableLog())) continue;
            hsb.enable();
        }
    }

    public void enableHttpdSiteBind(int pkey) throws IllegalArgumentException, SQLException, IOException {
        VirtualHost hsb = this.connector.getWeb().getVirtualHost().get(pkey);
        if (hsb == null) {
            throw new IllegalArgumentException("Unable to find HttpdSiteBind: " + pkey);
        }
        DisableLog dl = hsb.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("HttpdSiteBind not disabled: " + pkey);
        }
        hsb.enable();
    }

    public void enableEmailList(PosixPath path, String aoServer) throws IllegalArgumentException, SQLException, IOException {
        List el = this.getEmailList(aoServer, path);
        DisableLog dl = el.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("EmailList not disabled: " + path + " on " + aoServer);
        }
        el.enable();
    }

    public void enableEmailSmtpRelay(int pkey) throws IllegalArgumentException, IOException, SQLException {
        SmtpRelay ssr = this.connector.getEmail().getSmtpRelay().get(pkey);
        if (ssr == null) {
            throw new IllegalArgumentException("Unable to find EmailSmtpRelay: " + pkey);
        }
        DisableLog dl = ssr.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("EmailSmtpRelay not disabled: " + pkey);
        }
        ssr.enable();
    }

    public void enableUsername(User.Name username) throws IllegalArgumentException, SQLException, IOException {
        com.aoindustries.aoserv.client.account.User un = this.getUsername(username);
        DisableLog dl = un.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("Username not disabled: " + username);
        }
        this.enableUsername(dl, un, null, null, null);
    }

    private void enableUsername(DisableLog dl, com.aoindustries.aoserv.client.account.User un, java.util.List<Server> linuxAccountServers, java.util.List<Server> mysqlServers, java.util.List<Server> postgresServers) throws IOException, SQLException {
        com.aoindustries.aoserv.client.postgresql.User pu;
        User mu;
        com.aoindustries.aoserv.client.linux.User la;
        un.enable();
        Administrator ba = un.getAdministrator();
        if (ba != null && dl.equals(ba.getDisableLog())) {
            ba.enable();
        }
        if ((la = un.getLinuxAccount()) != null && dl.equals(la.getDisableLog())) {
            this.enableLinuxAccount(dl, la, linuxAccountServers);
        }
        if ((mu = un.getMysqlUser()) != null && dl.equals(mu.getDisableLog())) {
            this.enableMysqlUser(dl, mu, mysqlServers);
        }
        if ((pu = un.getPostgresUser()) != null && dl.equals(pu.getDisableLog())) {
            this.enablePostgresUser(dl, pu, postgresServers);
        }
    }

    public void enableLinuxAccount(User.Name username) throws IllegalArgumentException, SQLException, IOException {
        com.aoindustries.aoserv.client.linux.User la = this.getLinuxAccount(username);
        DisableLog dl = la.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("LinuxAccount not disabled: " + username);
        }
        this.enableLinuxAccount(dl, la, null);
    }

    private void enableLinuxAccount(DisableLog dl, com.aoindustries.aoserv.client.linux.User la, java.util.List<Server> linuxAccountServers) throws SQLException, IOException {
        la.enable();
        for (com.aoindustries.aoserv.client.linux.UserServer lsa : la.getLinuxServerAccounts()) {
            Server ao;
            if (!dl.equals(lsa.getDisableLog())) continue;
            this.enableLinuxServerAccount(dl, lsa);
            if (linuxAccountServers == null || linuxAccountServers.contains(ao = lsa.getServer())) continue;
            linuxAccountServers.add(ao);
        }
    }

    public void enableLinuxServerAccount(User.Name username, String aoServer) throws IllegalArgumentException, SQLException, IOException {
        com.aoindustries.aoserv.client.linux.UserServer lsa = this.getLinuxServerAccount(aoServer, username);
        DisableLog dl = lsa.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("LinuxServerAccount not disabled: " + username + " on " + aoServer);
        }
        this.enableLinuxServerAccount(dl, lsa);
    }

    private void enableLinuxServerAccount(DisableLog dl, com.aoindustries.aoserv.client.linux.UserServer lsa) throws IOException, SQLException {
        lsa.enable();
        for (CvsRepository cr : lsa.getCvsRepositories()) {
            if (!dl.equals(cr.getDisableLog())) continue;
            cr.enable();
        }
    }

    public void enableCvsRepository(int pkey) throws IllegalArgumentException, SQLException, IOException {
        CvsRepository cr = this.connector.getScm().getCvsRepository().get(pkey);
        if (cr == null) {
            throw new IllegalArgumentException("Unable to find CvsRepository: " + pkey);
        }
        DisableLog dl = cr.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("CvsRepository not disabled: " + pkey);
        }
        cr.enable();
    }

    public void enableMysqlUser(User.Name username) throws IllegalArgumentException, SQLException, IOException {
        User mu = this.getMysqlUser(username);
        DisableLog dl = mu.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("MysqlUser not disabled: " + username);
        }
        this.enableMysqlUser(dl, mu, null);
    }

    private void enableMysqlUser(DisableLog dl, User mu, java.util.List<Server> mysqlServers) throws IOException, SQLException {
        mu.enable();
        for (com.aoindustries.aoserv.client.mysql.UserServer msu : mu.getMysqlServerUsers()) {
            Server ao;
            if (!dl.equals(msu.getDisableLog())) continue;
            msu.enable();
            if (mysqlServers == null || mysqlServers.contains(ao = msu.getMysqlServer().getLinuxServer())) continue;
            mysqlServers.add(ao);
        }
    }

    public void enableMysqlServerUser(User.Name username, Server.Name mysqlServer, String aoServer) throws IllegalArgumentException, SQLException, IOException {
        com.aoindustries.aoserv.client.mysql.UserServer msu = this.getMysqlServerUser(aoServer, mysqlServer, username);
        DisableLog dl = msu.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("MysqlServerUser not disabled: " + username + " on " + mysqlServer + " on " + aoServer);
        }
        msu.enable();
    }

    public void enablePostgresUser(User.Name username) throws IllegalArgumentException, SQLException, IOException {
        com.aoindustries.aoserv.client.postgresql.User pu = this.getPostgresUser(username);
        DisableLog dl = pu.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("PostgresUser not disabled: " + username);
        }
        this.enablePostgresUser(dl, pu, null);
    }

    private void enablePostgresUser(DisableLog dl, com.aoindustries.aoserv.client.postgresql.User pu, java.util.List<Server> postgresServers) throws IOException, SQLException {
        pu.enable();
        for (UserServer psu : pu.getPostgresServerUsers()) {
            Server ao;
            if (!dl.equals(psu.getDisableLog())) continue;
            psu.enable();
            if (postgresServers == null || postgresServers.contains(ao = psu.getPostgresServer().getLinuxServer())) continue;
            postgresServers.add(ao);
        }
    }

    public void enablePostgresServerUser(User.Name username, Server.Name postgresServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        UserServer psu = this.getPostgresServerUser(aoServer, postgresServer, username);
        DisableLog dl = psu.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("PostgresServerUser not disabled: " + username + " on " + aoServer);
        }
        psu.enable();
    }

    public void enableAdministrator(User.Name username) throws IllegalArgumentException, SQLException, IOException {
        com.aoindustries.aoserv.client.account.User un = this.getUsername(username);
        Administrator ba = un.getAdministrator();
        if (ba == null) {
            throw new IllegalArgumentException("Unable to find Administrator: " + username);
        }
        DisableLog dl = ba.getDisableLog();
        if (dl == null) {
            throw new IllegalArgumentException("Administrator not disabled: " + username);
        }
        ba.enable();
    }

    public void dumpMysqlDatabase(Database.Name name, Server.Name mysqlServer, String aoServer, Writer out) throws IllegalArgumentException, IOException, SQLException {
        this.getMysqlDatabase(aoServer, mysqlServer, name).dump(out);
    }

    public void dumpMysqlDatabase(Database.Name name, Server.Name mysqlServer, String aoServer, boolean gzip, StreamHandler streamHandler) throws IllegalArgumentException, IOException, SQLException {
        this.getMysqlDatabase(aoServer, mysqlServer, name).dump(gzip, streamHandler);
    }

    public void dumpPostgresDatabase(Database.Name name, Server.Name postgresServer, String aoServer, Writer out) throws IllegalArgumentException, IOException, SQLException {
        this.getPostgresDatabase(aoServer, postgresServer, name).dump(out);
    }

    public void dumpPostgresDatabase(Database.Name name, Server.Name postgresServer, String aoServer, boolean gzip, StreamHandler streamHandler) throws IllegalArgumentException, IOException, SQLException {
        this.getPostgresDatabase(aoServer, postgresServer, name).dump(gzip, streamHandler);
    }

    public Account.Name generateAccountingCode(Account.Name accountingTemplate) throws IOException, SQLException {
        return this.connector.getAccount().getAccount().generateAccountingCode(accountingTemplate);
    }

    public Database.Name generateMysqlDatabaseName(String templateBase, String templateAdded) throws IOException, SQLException {
        return this.connector.getMysql().getDatabase().generateMysqlDatabaseName(templateBase, templateAdded);
    }

    public Account.Name generatePackageName(Account.Name template) throws IOException, SQLException {
        return this.connector.getBilling().getPackage().generatePackageName(template);
    }

    public String generatePassword() throws IOException {
        return PasswordGenerator.generatePassword();
    }

    public Database.Name generatePostgresDatabaseName(String templateBase, String templateAdded) throws IOException, SQLException {
        return this.connector.getPostgresql().getDatabase().generatePostgresDatabaseName(templateBase, templateAdded);
    }

    public String generateSharedTomcatName(String template) throws IOException, SQLException {
        return this.connector.getWeb_tomcat().getSharedTomcat().generateSharedTomcatName(template);
    }

    public String generateSiteName(String template) throws IOException, SQLException {
        return this.connector.getWeb().getSite().generateSiteName(template);
    }

    public String getAutoresponderContent(User.Name username, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxServerAccount(aoServer, username).getAutoresponderContent();
    }

    public AoservConnector getConnector() {
        return this.connector;
    }

    public String getCronTable(User.Name username, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxServerAccount(aoServer, username).getCronTable();
    }

    public String getEmailListAddressList(PosixPath path, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getEmailList(aoServer, path).getAddressList();
    }

    public long getBackupPartitionTotalSize(String aoServer, String path) throws IllegalArgumentException, IOException, SQLException {
        BackupPartition bp = this.getLinuxServer(aoServer).getBackupPartitionForPath(path);
        if (bp == null) {
            throw new IllegalArgumentException("Unable to find BackupPartition: " + path + " on " + aoServer);
        }
        return bp.getDiskTotalSize();
    }

    public long getBackupPartitionUsedSize(String aoServer, String path) throws IllegalArgumentException, IOException, SQLException {
        BackupPartition bp = this.getLinuxServer(aoServer).getBackupPartitionForPath(path);
        if (bp == null) {
            throw new IllegalArgumentException("Unable to find BackupPartition: " + path + " on " + aoServer);
        }
        return bp.getDiskUsedSize();
    }

    public FileReplication.Activity getFailoverFileReplicationActivity(String fromServer, String toServer, String path) throws IllegalArgumentException, IOException, SQLException {
        return this.getFailoverFileReplication(fromServer, toServer, path).getActivity();
    }

    public int getHttpdServerConcurrency(String aoServer, String name) throws IllegalArgumentException, IOException, SQLException {
        return this.getHttpdServer(aoServer, name).getConcurrency();
    }

    public InboxAttributes getInboxAttributes(User.Name username, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxServerAccount(aoServer, username).getInboxAttributes();
    }

    public long[] getImapFolderSizes(User.Name username, String aoServer, String[] folderNames) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxServerAccount(aoServer, username).getImapFolderSizes(folderNames);
    }

    public String getMajordomoInfoFile(DomainName domain, String aoServer, String listName) throws IllegalArgumentException, IOException, SQLException {
        Domain ed = this.getEmailDomain(aoServer, domain);
        MajordomoServer ms = ed.getMajordomoServer();
        if (ms == null) {
            throw new IllegalArgumentException("Unable to find MajordomoServer: " + domain + " on " + aoServer);
        }
        MajordomoList ml = ms.getMajordomoList(listName);
        if (ml == null) {
            throw new IllegalArgumentException("Unable to find MajordomoList: " + listName + '@' + domain + " on " + aoServer);
        }
        return ml.getInfoFile();
    }

    public String getMajordomoIntroFile(DomainName domain, String aoServer, String listName) throws IllegalArgumentException, IOException, SQLException {
        Domain ed = this.getEmailDomain(aoServer, domain);
        MajordomoServer ms = ed.getMajordomoServer();
        if (ms == null) {
            throw new IllegalArgumentException("Unable to find MajordomoServer: " + domain + " on " + aoServer);
        }
        MajordomoList ml = ms.getMajordomoList(listName);
        if (ml == null) {
            throw new IllegalArgumentException("Unable to find MajordomoList: " + listName + '@' + domain + " on " + aoServer);
        }
        return ml.getIntroFile();
    }

    public void getMrtgFile(String aoServer, String filename, OutputStream out) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).getMrtgFile(filename, out);
    }

    public String getUpsStatus(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxServer(aoServer).getUpsStatus();
    }

    public void getAwstatsFile(String siteName, String aoServer, String path, String queryString, OutputStream out) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, siteName).getAwstatsFile(path, queryString, out);
    }

    public Account.Name getRootAccount() throws IOException, SQLException {
        return this.connector.getAccount().getAccount().getRootAccount_name();
    }

    public void invalidate(int tableId, String server) throws IllegalArgumentException, SQLException, IOException {
        Host se;
        if (tableId < 0 || tableId >= numTables) {
            throw new IllegalArgumentException("Invalid table ID: " + tableId);
        }
        if (server != null && server.length() == 0) {
            server = null;
        }
        if (server == null) {
            se = null;
        } else {
            se = this.connector.getNet().getHost().get(server);
            if (se == null) {
                throw new IllegalArgumentException("Unable to find Host: " + server);
            }
        }
        this.connector.invalidateTable(tableId, se == null ? -1 : se.pkey);
    }

    public boolean isAccountingAvailable(Account.Name accounting) throws SQLException, IOException {
        return this.connector.getAccount().getAccount().isAccountingAvailable(accounting);
    }

    public boolean isAdministratorPasswordSet(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        Administrator ba = this.connector.getAccount().getAdministrator().get(username);
        if (ba == null) {
            throw new IllegalArgumentException("Unable to find Administrator: " + username);
        }
        return ba.arePasswordsSet() == 2;
    }

    public boolean isDnsZoneAvailable(String zone) throws IOException, SQLException {
        return this.connector.getDns().getZone().isDnsZoneAvailable(zone);
    }

    public boolean isIpAddressUsed(InetAddress ipAddress, String server, String netDevice) throws IllegalArgumentException, IOException, SQLException {
        return this.getIpAddress(server, netDevice, ipAddress).isUsed();
    }

    public boolean isLinuxGroupNameAvailable(Group.Name groupname) throws IOException, SQLException {
        return this.connector.getLinux().getGroup().isLinuxGroupNameAvailable(groupname);
    }

    public boolean isLinuxServerAccountPasswordSet(User.Name username, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxServerAccount(aoServer, username).arePasswordsSet() == 2;
    }

    public int isLinuxServerAccountProcmailManual(User.Name username, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxServerAccount(aoServer, username).isProcmailManual();
    }

    public boolean isMysqlDatabaseNameAvailable(Database.Name name, Server.Name mysqlServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getMysqlServer(aoServer, mysqlServer).isMysqlDatabaseNameAvailable(name);
    }

    public boolean isMysqlServerNameAvailable(Server.Name name, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxServer(aoServer).isMysqlServerNameAvailable(name);
    }

    public boolean isMysqlServerUserPasswordSet(User.Name username, Server.Name mysqlServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getMysqlServerUser(aoServer, mysqlServer, username).arePasswordsSet() == 2;
    }

    public boolean isPackageNameAvailable(Account.Name packageName) throws IOException, SQLException {
        return this.connector.getBilling().getPackage().isPackageNameAvailable(packageName);
    }

    public boolean isPostgresDatabaseNameAvailable(Database.Name name, Server.Name postgresServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getPostgresServer(aoServer, postgresServer).isPostgresDatabaseNameAvailable(name);
    }

    public boolean isPostgresServerNameAvailable(Server.Name name, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxServer(aoServer).isPostgresServerNameAvailable(name);
    }

    public boolean isPostgresServerUserPasswordSet(User.Name username, Server.Name postgresServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getPostgresServerUser(aoServer, postgresServer, username).arePasswordsSet() == 2;
    }

    public boolean isEmailDomainAvailable(DomainName domain, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getLinuxServer(aoServer).isEmailDomainAvailable(domain);
    }

    public boolean isSharedTomcatNameAvailable(String name) throws IOException, SQLException {
        return this.connector.getWeb_tomcat().getSharedTomcat().isSharedTomcatNameAvailable(name);
    }

    public boolean isSiteNameAvailable(String siteName) throws IllegalArgumentException, IOException, SQLException {
        SimpleAoservClient.checkSiteName(siteName);
        return this.connector.getWeb().getSite().isSiteNameAvailable(siteName);
    }

    public boolean isUsernameAvailable(User.Name username) throws IOException, SQLException {
        return this.connector.getAccount().getUser().isUsernameAvailable(username);
    }

    public void moveAccount(Account.Name business, String from, String to, TerminalWriter out) throws IllegalArgumentException, IOException, SQLException {
        this.getAccount(business).move(this.getLinuxServer(from), this.getLinuxServer(to), out);
    }

    public void moveIpAddress(InetAddress ipAddress, String fromServer, String fromNetDevice, String toServer) throws IllegalArgumentException, IOException, SQLException {
        this.getIpAddress(fromServer, fromNetDevice, ipAddress).moveTo(this.getHost(toServer));
    }

    public int ping() throws IOException, SQLException {
        return this.connector.ping();
    }

    public void printZoneFile(String zone, PrintWriter out) throws IllegalArgumentException, SQLException, IOException {
        this.getZone(zone).printZoneFile(out);
    }

    public void refreshEmailSmtpRelay(int pkey, long minDuration) throws IllegalArgumentException, IOException, SQLException {
        SmtpRelay sr = this.connector.getEmail().getSmtpRelay().get(pkey);
        if (sr == null) {
            throw new IllegalArgumentException("Unable to find EmailSmtpRelay: " + pkey);
        }
        sr.refresh(minDuration);
    }

    public void removeBlackholeEmailAddress(String address, DomainName domain, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        Address addr = this.getEmailAddress(aoServer, domain, address);
        BlackholeAddress bea = addr.getBlackholeEmailAddress();
        if (bea == null) {
            throw new IllegalArgumentException("Unable to find BlackholeEmailAddress: " + address + '@' + domain + " on " + aoServer);
        }
        bea.remove();
        if (addr.getCannotRemoveReasons().isEmpty() && !addr.isUsed()) {
            addr.remove();
        }
    }

    public void removeAdministrator(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.account.User un = this.getUsername(username);
        Administrator ba = un.getAdministrator();
        if (ba == null) {
            throw new IllegalArgumentException("Unable to find Administrator: " + username);
        }
        ba.remove();
    }

    public void removeAccountHost(Account.Name accounting, String server) throws IllegalArgumentException, IOException, SQLException {
        Host se;
        Account bu = this.getAccount(accounting);
        AccountHost bs = bu.getAccountHost(se = this.getHost(server));
        if (bs == null) {
            throw new IllegalArgumentException("Unable to find AccountHost: accounting=" + accounting + " and server=" + server);
        }
        bs.remove();
    }

    public void removeCreditCard(int pkey) throws IllegalArgumentException, SQLException, IOException {
        CreditCard cc = this.connector.getPayment().getCreditCard().get(pkey);
        if (cc == null) {
            throw new IllegalArgumentException("Unable to find CreditCard: " + pkey);
        }
        cc.remove();
    }

    public void removeCvsRepository(String aoServer, PosixPath path) throws IllegalArgumentException, IOException, SQLException {
        Server ao = this.getLinuxServer(aoServer);
        CvsRepository cr = ao.getCvsRepository(path);
        if (cr == null) {
            throw new IllegalArgumentException("Unable to find CvsRepository: " + path + " on " + aoServer);
        }
        cr.remove();
    }

    public void removeDnsRecord(int pkey) throws IllegalArgumentException, IOException, SQLException {
        Record nr = this.connector.getDns().getRecord().get(pkey);
        if (nr == null) {
            throw new IllegalArgumentException("Unable to find DNSRecord: " + pkey);
        }
        nr.remove();
    }

    public void removeDnsRecord(String zone, String domain, String type, String tag, String destination) throws IllegalArgumentException, IOException, SQLException {
        Zone nz = this.getZone(zone);
        RecordType nt = this.connector.getDns().getRecordType().get(type);
        if (nt == null) {
            throw new IllegalArgumentException("Unable to find RecordType: " + type);
        }
        nt.checkDestination(tag, destination);
        Record found = null;
        for (Record rec : nz.getRecords(domain, nt)) {
            if (!Objects.equals(rec.getTag(), tag) || !rec.getDestination().equals(destination)) continue;
            if (found != null) {
                throw new AssertionError((Object)("Duplicate DNSRecord: (" + zone + ", " + domain + ", " + type + ", " + tag + ", " + destination + ")"));
            }
            found = rec;
        }
        if (found == null) {
            throw new AssertionError((Object)("Unable to find DNSRecord: (" + zone + ", " + domain + ", " + type + ", " + tag + ", " + destination + ")"));
        }
        found.remove();
    }

    public void removeDnsZone(String zone) throws IllegalArgumentException, IOException, SQLException {
        this.getZone(zone).remove();
    }

    public void setDnsZoneTtl(String zone, int ttl) throws IllegalArgumentException, IOException, SQLException {
        this.getZone(zone).setTtl(ttl);
    }

    public void removeEmailAddress(String address, DomainName domain, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getEmailAddress(aoServer, domain, address).remove();
    }

    public void removeEmailForwarding(String address, DomainName domain, String aoServer, Email destination) throws IllegalArgumentException, IOException, SQLException {
        Address addr = this.getEmailAddress(aoServer, domain, address);
        Forwarding ef = addr.getEmailForwarding(destination);
        if (ef == null) {
            throw new IllegalArgumentException("Unable to find EmailForwarding: " + address + '@' + domain + "->" + destination + " on " + aoServer);
        }
        ef.remove();
        if (addr.getCannotRemoveReasons().isEmpty() && !addr.isUsed()) {
            addr.remove();
        }
    }

    public void removeEmailList(PosixPath path, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getEmailList(aoServer, path).remove();
    }

    public void removeEmailListAddress(String address, DomainName domain, PosixPath path, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        List el;
        Address addr = this.getEmailAddress(aoServer, domain, address);
        ListAddress ela = addr.getEmailListAddress(el = this.getEmailList(aoServer, path));
        if (ela == null) {
            throw new IllegalArgumentException("Unable to find EmailListAddress: " + address + '@' + domain + "->" + path + " on " + aoServer);
        }
        ela.remove();
        if (addr.getCannotRemoveReasons().isEmpty() && !addr.isUsed()) {
            addr.remove();
        }
    }

    public void removeEmailPipe(int pkey) throws IllegalArgumentException, IOException, SQLException {
        Pipe ep = this.connector.getEmail().getPipe().get(pkey);
        if (ep == null) {
            throw new IllegalArgumentException("Unable to find EmailPipe: " + pkey);
        }
        ep.remove();
    }

    public void removeEmailPipeAddress(String address, DomainName domain, int pipe) throws IllegalArgumentException, IOException, SQLException {
        Pipe ep = this.connector.getEmail().getPipe().get(pipe);
        if (ep == null) {
            throw new IllegalArgumentException("Unable to find EmailPipe: " + pipe);
        }
        Server ao = ep.getLinuxServer();
        Domain sd = ao.getEmailDomain(domain);
        if (sd == null) {
            throw new IllegalArgumentException("Unable to find EmailDomain: " + domain + " on " + ao.getHostname());
        }
        Address addr = this.connector.getEmail().getAddress().getEmailAddress(address, sd);
        if (addr == null) {
            throw new IllegalArgumentException("Unable to find EmailAddress: " + address + "@" + domain + " on " + ao.getHostname());
        }
        PipeAddress epa = addr.getEmailPipeAddress(ep);
        if (epa == null) {
            throw new IllegalArgumentException("Unable to find EmailPipeAddress: " + address + "@" + domain + "->" + ep);
        }
        epa.remove();
        if (addr.getCannotRemoveReasons().isEmpty() && !addr.isUsed()) {
            addr.remove();
        }
    }

    public void removeFtpGuestUser(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        GuestUser ftpUser = this.connector.getFtp().getGuestUser().get(username);
        if (ftpUser == null) {
            throw new IllegalArgumentException("Unable to find FtpGuestUser: " + username);
        }
        ftpUser.remove();
    }

    public void removeHttpdSharedTomcat(String name, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSharedTomcat(aoServer, name).remove();
    }

    public void removeHttpdSite(String name, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, name).remove();
    }

    public void removeVirtualHostName(int pkey) throws IllegalArgumentException, IOException, SQLException {
        VirtualHostName hsu = this.connector.getWeb().getVirtualHostName().get(pkey);
        if (hsu == null) {
            throw new IllegalArgumentException("Unable to find HttpdSiteURL: " + pkey);
        }
        hsu.remove();
    }

    public void removeHttpdTomcatContext(int pkey) throws IllegalArgumentException, IOException, SQLException {
        Context htc = this.connector.getWeb_tomcat().getContext().get(pkey);
        if (htc == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatContext: " + pkey);
        }
        htc.remove();
    }

    public void removeHttpdTomcatDataSource(int pkey) throws IllegalArgumentException, IOException, SQLException {
        ContextDataSource htds = this.connector.getWeb_tomcat().getContextDataSource().get(pkey);
        if (htds == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatDataSource: " + pkey);
        }
        htds.remove();
    }

    public void removeHttpdTomcatParameter(int pkey) throws IllegalArgumentException, IOException, SQLException {
        ContextParameter htp = this.connector.getWeb_tomcat().getContextParameter().get(pkey);
        if (htp == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatParameter: " + pkey);
        }
        htp.remove();
    }

    public void removeLinuxAccAddress(String address, DomainName domain, String aoServer, User.Name username) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.linux.UserServer lsa;
        Address addr = this.getEmailAddress(aoServer, domain, address);
        InboxAddress laa = addr.getLinuxAccAddress(lsa = this.getLinuxServerAccount(aoServer, username));
        if (laa == null) {
            throw new IllegalArgumentException("Unable to find LinuxAccAddress: " + address + '@' + domain + "->" + username + " on " + aoServer);
        }
        laa.remove();
        if (addr.getCannotRemoveReasons().isEmpty() && !addr.isUsed()) {
            addr.remove();
        }
    }

    public void removeLinuxAccount(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxAccount(username).remove();
    }

    public void removeLinuxGroup(Group.Name name) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxGroup(name).remove();
    }

    public void removeLinuxGroupAccount(Group.Name group, User.Name username) throws IllegalArgumentException, IOException, SQLException {
        Group lg = this.getLinuxGroup(group);
        com.aoindustries.aoserv.client.linux.User la = this.getLinuxAccount(username);
        java.util.List<GroupUser> lgas = this.connector.getLinux().getGroupUser().getLinuxGroupAccounts(group, username);
        if (lgas.isEmpty()) {
            throw new IllegalArgumentException(username + " is not part of the " + group + " group");
        }
        for (GroupUser lga : lgas) {
            lga.remove();
        }
    }

    public void removeLinuxServerAccount(User.Name username, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServerAccount(aoServer, username).remove();
    }

    public void removeLinuxServerGroup(Group.Name group, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServerGroup(aoServer, group).remove();
    }

    public void removeMysqlDatabase(Database.Name name, Server.Name mysqlServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getMysqlDatabase(aoServer, mysqlServer, name).remove();
    }

    public void removeMysqlDbUser(Database.Name name, Server.Name mysqlServer, String aoServer, User.Name username) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.mysql.UserServer msu;
        Database md = this.getMysqlDatabase(aoServer, mysqlServer, name);
        DatabaseUser mdu = md.getMysqlDbUser(msu = this.getMysqlServerUser(aoServer, mysqlServer, username));
        if (mdu == null) {
            throw new IllegalArgumentException("Unable to find MysqlDbUser on MysqlServer " + mysqlServer + " on Server " + aoServer + " for MysqlDatabase named " + name + " and MysqlServerUser named " + username);
        }
        mdu.remove();
    }

    public void removeMysqlServerUser(User.Name username, Server.Name mysqlServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getMysqlServerUser(aoServer, mysqlServer, username).remove();
    }

    public void removeMysqlUser(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        this.getMysqlUser(username).remove();
    }

    public void removeNetBind(int pkey) throws IllegalArgumentException, IOException, SQLException {
        this.getNetBind(pkey).remove();
    }

    public void removePostgresDatabase(Database.Name name, Server.Name postgresServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getPostgresDatabase(aoServer, postgresServer, name).remove();
    }

    public void removePostgresServerUser(User.Name username, Server.Name postgresServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getPostgresServerUser(aoServer, postgresServer, username).remove();
    }

    public void removePostgresUser(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        this.getPostgresUser(username).remove();
    }

    public void removeEmailDomain(DomainName domain, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getEmailDomain(aoServer, domain).remove();
    }

    public void removeEmailSmtpRelay(int pkey) throws IllegalArgumentException, IOException, SQLException {
        SmtpRelay sr = this.connector.getEmail().getSmtpRelay().get(pkey);
        if (sr == null) {
            throw new IllegalArgumentException("Unable to find EmailSmtpRelay: " + pkey);
        }
        sr.remove();
    }

    public void removeFileBackupSetting(int replication, String path) throws IllegalArgumentException, IOException, SQLException {
        FileReplication ffr = this.getConnector().getBackup().getFileReplication().get(replication);
        if (ffr == null) {
            throw new IllegalArgumentException("Unable to find FailoverFileReplication: " + replication);
        }
        FileReplicationSetting fbs = ffr.getFileBackupSetting(path);
        if (fbs == null) {
            throw new IllegalArgumentException("Unable to find FileBackupSetting: " + path + " on " + replication);
        }
        fbs.remove();
    }

    public void removeMajordomoServer(DomainName domain, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        Domain sd = this.getEmailDomain(aoServer, domain);
        MajordomoServer ms = sd.getMajordomoServer();
        if (ms == null) {
            throw new IllegalArgumentException("Unable to find MajordomoServer: " + domain + " on " + aoServer);
        }
        ms.remove();
    }

    public void removeUsername(User.Name username) throws IllegalArgumentException, IOException, SQLException {
        this.getUsername(username).remove();
    }

    public void restartApache(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).restartApache();
    }

    public void restartCron(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).restartCron();
    }

    public void restartMysql(Server.Name mysqlServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getMysqlServer(aoServer, mysqlServer).restartMysql();
    }

    public void restartPostgresql(Server.Name postgresServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getPostgresServer(aoServer, postgresServer).restartPostgresql();
    }

    public void restartXfs(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).restartXfs();
    }

    public void restartXvfb(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).restartXvfb();
    }

    public void setAutoresponder(User.Name username, String aoServer, String address, DomainName domain, String subject, String content, boolean enabled) throws IllegalArgumentException, IOException, SQLException {
        InboxAddress laa;
        Address ea;
        com.aoindustries.aoserv.client.linux.UserServer lsa = this.getLinuxServerAccount(aoServer, username);
        if (address == null) {
            address = "";
        }
        if (domain == null) {
            if (address.length() > 0) {
                throw new IllegalArgumentException("Cannot have an address without a domain: " + address);
            }
            ea = null;
        } else {
            Domain sd = this.getEmailDomain(aoServer, domain);
            ea = sd.getEmailAddress(address);
            if (ea == null) {
                throw new IllegalArgumentException("Unable to find EmailAddress: " + address + '@' + domain + " on " + aoServer);
            }
        }
        if (subject != null && subject.length() == 0) {
            subject = null;
        }
        if (content != null && content.length() == 0) {
            content = null;
        }
        InboxAddress inboxAddress = laa = ea == null ? null : ea.getLinuxAccAddress(lsa);
        if (laa == null) {
            throw new IllegalArgumentException("Unable to find LinuxAccAddress: " + address + " on " + aoServer);
        }
        lsa.setAutoresponder(laa, subject, content, enabled);
    }

    public void setAccountAccounting(Account.Name oldAccounting, Account.Name newAccounting) throws IllegalArgumentException, IOException, SQLException {
        this.getAccount(oldAccounting).setName(newAccounting);
    }

    public void setAdministratorPassword(User.Name username, String password) throws IllegalArgumentException, IOException, SQLException {
        Administrator pe = this.connector.getAccount().getAdministrator().get(username);
        if (pe == null) {
            throw new IllegalArgumentException("Unable to find Administrator: " + username);
        }
        pe.setPassword(password);
    }

    public void setAdministratorProfile(User.Name username, String name, String title, Date birthday, boolean isPrivate, String workPhone, String homePhone, String cellPhone, String fax, Email email, String address1, String address2, String city, String state, String country, String zip) throws IllegalArgumentException, IOException, SQLException {
        Administrator administrator = this.connector.getAccount().getAdministrator().get(username);
        if (administrator == null) {
            throw new IllegalArgumentException("Unable to find Administrator: " + username);
        }
        administrator.setProfile(name, title, birthday, isPrivate, workPhone, homePhone, cellPhone, fax, email, address1, address2, city, state, country, zip);
    }

    public void setCronTable(User.Name username, String aoServer, String cronTable) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServerAccount(aoServer, username).setCronTable(cronTable);
    }

    public void setCvsRepositoryMode(String aoServer, PosixPath path, long mode) throws IllegalArgumentException, IOException, SQLException {
        Server ao = this.getLinuxServer(aoServer);
        CvsRepository cr = ao.getCvsRepository(path);
        if (cr == null) {
            throw new IllegalArgumentException("Unable to find CvsRepository: " + path + " on " + aoServer);
        }
        cr.setMode(mode);
    }

    public void setDefaultAccountHost(Account.Name accounting, String server) throws IllegalArgumentException, SQLException, IOException {
        Host se;
        Account bu = this.getAccount(accounting);
        AccountHost bs = bu.getAccountHost(se = this.getHost(server));
        if (bs == null) {
            throw new IllegalArgumentException("Unable to find AccountHost: accounting=" + accounting + " and server=" + server);
        }
        bs.setAsDefault();
    }

    public void setEmailListAddressList(PosixPath path, String aoServer, String addresses) throws IllegalArgumentException, IOException, SQLException {
        this.getEmailList(aoServer, path).setAddressList(addresses);
    }

    public void setFileBackupSetting(int replication, String path, boolean backupEnabled, boolean required) throws IllegalArgumentException, IOException, SQLException {
        FileReplication ffr = this.getConnector().getBackup().getFileReplication().get(replication);
        if (ffr == null) {
            throw new IllegalArgumentException("Unable to find FailoverFileReplication: " + replication);
        }
        FileReplicationSetting fbs = ffr.getFileBackupSetting(path);
        if (fbs == null) {
            throw new IllegalArgumentException("Unable to find FileBackupSetting: " + path + " on " + replication);
        }
        fbs.setSettings(path, backupEnabled, required);
    }

    public void setHttpdSharedTomcatIsManual(String name, String aoServer, boolean isManual) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSharedTomcat(aoServer, name).setIsManual(isManual);
    }

    public void setHttpdSharedTomcatMaxPostSize(String name, String aoServer, int maxPostSize) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSharedTomcat(aoServer, name).setMaxPostSize(maxPostSize);
    }

    public void setHttpdSharedTomcatUnpackWars(String name, String aoServer, boolean unpackWars) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSharedTomcat(aoServer, name).setUnpackWars(unpackWars);
    }

    public void setHttpdSharedTomcatAutoDeploy(String name, String aoServer, boolean autoDeploy) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSharedTomcat(aoServer, name).setAutoDeploy(autoDeploy);
    }

    public void setHttpdSharedTomcatTomcatAuthentication(String name, String aoServer, boolean autoDeploy) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSharedTomcat(aoServer, name).setTomcatAuthentication(autoDeploy);
    }

    public void setHttpdSharedTomcatVersion(String name, String aoServer, String version) throws IllegalArgumentException, IOException, SQLException {
        SharedTomcat hst = this.getHttpdSharedTomcat(aoServer, name);
        hst.setHttpdTomcatVersion(this.findTomcatVersion(hst.getLinuxServer(), version));
    }

    public void setHttpdSiteBindIsManual(int pkey, boolean isManual) throws IllegalArgumentException, IOException, SQLException {
        VirtualHost hsb = this.connector.getWeb().getVirtualHost().get(pkey);
        if (hsb == null) {
            throw new IllegalArgumentException("Unable to find HttpdSiteBind: " + pkey);
        }
        hsb.setIsManual(isManual);
    }

    public void setHttpdSiteBindRedirectToPrimaryHostname(int pkey, boolean redirectToPrimaryHostname) throws IllegalArgumentException, IOException, SQLException {
        VirtualHost hsb = this.connector.getWeb().getVirtualHost().get(pkey);
        if (hsb == null) {
            throw new IllegalArgumentException("Unable to find HttpdSiteBind: " + pkey);
        }
        hsb.setRedirectToPrimaryHostname(redirectToPrimaryHostname);
    }

    public void setHttpdSiteIsManual(String siteName, String aoServer, boolean isManual) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, siteName).setIsManual(isManual);
    }

    public void setHttpdSiteServerAdmin(String siteName, String aoServer, Email emailAddress) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, siteName).setServerAdmin(emailAddress);
    }

    public void setHttpdSitePhpVersion(String siteName, String aoServer, String phpVersion) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        hs.setPhpVersion(this.findPhpVersion(hs.getLinuxServer(), phpVersion));
    }

    public void setHttpdSiteEnableCgi(String siteName, String aoServer, boolean enableCgi) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, siteName).setEnableCgi(enableCgi);
    }

    public void setHttpdSiteEnableSsi(String siteName, String aoServer, boolean enableSsi) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, siteName).setEnableSsi(enableSsi);
    }

    public void setHttpdSiteEnableHtaccess(String siteName, String aoServer, boolean enableHtaccess) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, siteName).setEnableHtaccess(enableHtaccess);
    }

    public void setHttpdSiteEnableIndexes(String siteName, String aoServer, boolean enableIndexes) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, siteName).setEnableIndexes(enableIndexes);
    }

    public void setHttpdSiteEnableFollowSymlinks(String siteName, String aoServer, boolean enableFollowSymlinks) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, siteName).setEnableFollowSymlinks(enableFollowSymlinks);
    }

    public void setHttpdSiteEnableAnonymousFtp(String siteName, String aoServer, boolean enableAnonymousFtp) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, siteName).setEnableAnonymousFtp(enableAnonymousFtp);
    }

    public void setHttpdSiteBlockTraceTrack(String siteName, String aoServer, boolean blockTraceTrack) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, siteName).setBlockTraceTrack(blockTraceTrack);
    }

    public void setHttpdSiteBlockScm(String siteName, String aoServer, boolean blockScm) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, siteName).setBlockScm(blockScm);
    }

    public void setHttpdSiteBlockCoreDumps(String siteName, String aoServer, boolean blockCoreDumps) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, siteName).setBlockCoreDumps(blockCoreDumps);
    }

    public void setHttpdSiteBlockEditorBackups(String siteName, String aoServer, boolean blockEditorBackups) throws IllegalArgumentException, IOException, SQLException {
        this.getHttpdSite(aoServer, siteName).setBlockEditorBackups(blockEditorBackups);
    }

    public void setHttpdTomcatContextAttributes(String siteName, String aoServer, String oldPath, String className, boolean cookies, boolean crossContext, PosixPath docBase, boolean override, String newPath, boolean privileged, boolean reloadable, boolean useNaming, String wrapperClass, int debug, PosixPath workDir, boolean serverXmlConfigured) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        Context htc = hts.getHttpdTomcatContext(oldPath);
        if (htc == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatContext: " + siteName + " on " + aoServer + " path='" + oldPath + '\'');
        }
        htc.setAttributes(className, cookies, crossContext, docBase, override, newPath, privileged, reloadable, useNaming, wrapperClass, debug, workDir, serverXmlConfigured);
    }

    public void setHttpdTomcatSiteBlockWebinf(String siteName, String aoServer, boolean blockWebinf) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        hts.setBlockWebinf(blockWebinf);
    }

    public void setHttpdTomcatStdSiteMaxPostSize(String siteName, String aoServer, int maxPostSize) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        PrivateTomcatSite htss = hts.getHttpdTomcatStdSite();
        if (htss == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatStdSite: " + siteName + " on " + aoServer);
        }
        htss.setMaxPostSize(maxPostSize);
    }

    public void setHttpdTomcatStdSiteUnpackWars(String siteName, String aoServer, boolean unpackWars) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        PrivateTomcatSite htss = hts.getHttpdTomcatStdSite();
        if (htss == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatStdSite: " + siteName + " on " + aoServer);
        }
        htss.setUnpackWars(unpackWars);
    }

    public void setHttpdTomcatStdSiteAutoDeploy(String siteName, String aoServer, boolean autoDeploy) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        PrivateTomcatSite htss = hts.getHttpdTomcatStdSite();
        if (htss == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatStdSite: " + siteName + " on " + aoServer);
        }
        htss.setAutoDeploy(autoDeploy);
    }

    public void setHttpdTomcatStdSiteTomcatAuthentication(String siteName, String aoServer, boolean tomcatAuthentication) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        PrivateTomcatSite htss = hts.getHttpdTomcatStdSite();
        if (htss == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatStdSite: " + siteName + " on " + aoServer);
        }
        htss.setTomcatAuthentication(tomcatAuthentication);
    }

    public void setHttpdTomcatStdSiteVersion(String siteName, String aoServer, String version) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        PrivateTomcatSite htss = hts.getHttpdTomcatStdSite();
        if (htss == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatStdSite: " + siteName + " on " + aoServer);
        }
        htss.setHttpdTomcatVersion(this.findTomcatVersion(hs.getLinuxServer(), version));
    }

    public void setIpAddressDhcpAddress(int ipAddress, InetAddress dhcpAddress) throws IllegalArgumentException, IOException, SQLException {
        IpAddress ia = this.connector.getNet().getIpAddress().get(ipAddress);
        if (ia == null) {
            throw new IllegalArgumentException("Unable to find IpAddress: " + ipAddress);
        }
        ia.setDhcpAddress(dhcpAddress);
    }

    public void setIpAddressHostname(InetAddress ipAddress, String server, String netDevice, DomainName hostname) throws IllegalArgumentException, IOException, SQLException {
        this.getIpAddress(server, netDevice, ipAddress).setHostname(hostname);
    }

    public void setIpAddressMonitoringEnabled(InetAddress ipAddress, String server, String netDevice, boolean enabled) throws IllegalArgumentException, IOException, SQLException {
        this.getIpAddress(server, netDevice, ipAddress).getMonitoring().setEnabled(enabled);
    }

    public void setIpAddressPackage(InetAddress ipAddress, String server, String netDevice, Account.Name newPackage) throws IllegalArgumentException, IOException, SQLException {
        this.getIpAddress(server, netDevice, ipAddress).setPackage(this.getPackage(newPackage));
    }

    public void setLinuxAccountHomePhone(User.Name username, User.Gecos phone) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxAccount(username).setHomePhone(phone);
    }

    public void setLinuxAccountName(User.Name username, User.Gecos name) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxAccount(username).setName(name);
    }

    public void setLinuxAccountOfficeLocation(User.Name username, User.Gecos location) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxAccount(username).setOfficeLocation(location);
    }

    public void setLinuxAccountOfficePhone(User.Name username, User.Gecos phone) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxAccount(username).setOfficePhone(phone);
    }

    public void setLinuxAccountPassword(User.Name username, String password) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxAccount(username).setPassword(password);
    }

    public void setLinuxAccountShell(User.Name username, PosixPath path) throws IllegalArgumentException, IOException, SQLException {
        com.aoindustries.aoserv.client.linux.User la = this.getLinuxAccount(username);
        Shell sh = this.connector.getLinux().getShell().get(path);
        if (sh == null) {
            throw new IllegalArgumentException("Unable to find Shell: " + path);
        }
        la.setShell(sh);
    }

    public void setLinuxServerAccountPassword(User.Name username, String aoServer, String password) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServerAccount(aoServer, username).setPassword(password);
    }

    public void setLinuxServerAccountJunkEmailRetention(User.Name username, String aoServer, int days) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServerAccount(aoServer, username).setJunkEmailRetention(days);
    }

    public void setLinuxServerAccountSpamAssassinIntegrationMode(User.Name username, String aoServer, String mode) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServerAccount(aoServer, username).setEmailSpamAssassinIntegrationMode(this.getEmailSpamAssassinIntegrationMode(mode));
    }

    public void setLinuxServerAccountSpamAssassinRequiredScore(User.Name username, String aoServer, float requiredScore) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServerAccount(aoServer, username).setSpamAssassinRequiredScore(requiredScore);
    }

    public void setLinuxServerAccountTrashEmailRetention(User.Name username, String aoServer, int days) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServerAccount(aoServer, username).setTrashEmailRetention(days);
    }

    public void setLinuxServerAccountUseInbox(User.Name username, String aoServer, boolean useInbox) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServerAccount(aoServer, username).setUseInbox(useInbox);
    }

    public void setMajordomoInfoFile(DomainName domain, String aoServer, String listName, String file) throws IllegalArgumentException, IOException, SQLException {
        Domain ed = this.getEmailDomain(aoServer, domain);
        MajordomoServer ms = ed.getMajordomoServer();
        if (ms == null) {
            throw new IllegalArgumentException("Unable to find MajordomoServer: " + domain + " on " + aoServer);
        }
        MajordomoList ml = ms.getMajordomoList(listName);
        if (ml == null) {
            throw new IllegalArgumentException("Unable to find MajordomoList: " + listName + '@' + domain + " on " + aoServer);
        }
        ml.setInfoFile(file);
    }

    public void setMajordomoIntroFile(DomainName domain, String aoServer, String listName, String file) throws IllegalArgumentException, IOException, SQLException {
        Domain ed = this.getEmailDomain(aoServer, domain);
        MajordomoServer ms = ed.getMajordomoServer();
        if (ms == null) {
            throw new IllegalArgumentException("Unable to find MajordomoServer: " + domain + " on " + aoServer);
        }
        MajordomoList ml = ms.getMajordomoList(listName);
        if (ml == null) {
            throw new IllegalArgumentException("Unable to find MajordomoList: " + listName + '@' + domain + " on " + aoServer);
        }
        ml.setIntroFile(file);
    }

    public void setMysqlServerUserPassword(User.Name username, Server.Name mysqlServer, String aoServer, String password) throws IllegalArgumentException, IOException, SQLException {
        this.getMysqlServerUser(aoServer, mysqlServer, username).setPassword(password == null || password.length() == 0 ? null : password);
    }

    public void setMysqlUserPassword(User.Name username, String password) throws IllegalArgumentException, IOException, SQLException {
        this.getMysqlUser(username).setPassword(password == null || password.length() == 0 ? null : password);
    }

    public void setNetBindFirewalldZones(int pkey, java.util.Set<FirewallZone.Name> firewalldZones) throws IllegalArgumentException, IOException, SQLException {
        this.getNetBind(pkey).setFirewalldZones(firewalldZones);
    }

    public void setNetBindMonitoringEnabled(int pkey, boolean enabled) throws IllegalArgumentException, IOException, SQLException {
        this.getNetBind(pkey).setMonitoringEnabled(enabled);
    }

    public void setPostgresServerUserPassword(User.Name username, Server.Name postgresServer, String aoServer, String password) throws IllegalArgumentException, IOException, SQLException {
        this.getPostgresServerUser(aoServer, postgresServer, username).setPassword(password == null || password.length() == 0 ? null : password);
    }

    public void setPostgresUserPassword(User.Name username, String password) throws IllegalArgumentException, IOException, SQLException {
        this.getPostgresUser(username).setPassword(password == null || password.length() == 0 ? null : password);
    }

    public void setPrimaryVirtualHostName(int pkey) throws IllegalArgumentException, IOException, SQLException {
        VirtualHostName hsu = this.connector.getWeb().getVirtualHostName().get(pkey);
        if (hsu == null) {
            throw new IllegalArgumentException("Unable to find HttpdSiteURL: " + pkey);
        }
        hsu.setAsPrimary();
    }

    public void setPrimaryLinuxGroupAccount(Group.Name groupName, User.Name username) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxAccount(username).setPrimaryLinuxGroup(this.getLinuxGroup(groupName));
    }

    public void setUsernamePassword(User.Name username, String password) throws IllegalArgumentException, IOException, SQLException {
        this.getUsername(username).setPassword(password);
    }

    public void startApache(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).startApache();
    }

    public void startCron(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).startCron();
    }

    public void startDistro(String aoServer, boolean includeUser) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).startDistro(includeUser);
    }

    public String startJvm(String siteName, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        Site site = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site tomcatSite = site.getHttpdTomcatSite();
        if (tomcatSite == null) {
            throw new IllegalArgumentException("HttpdSite " + siteName + " on " + aoServer + " is not a HttpdTomcatSite");
        }
        return tomcatSite.startJvm();
    }

    public void startMysql(Server.Name mysqlServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getMysqlServer(aoServer, mysqlServer).startMysql();
    }

    public void startPostgresql(Server.Name postgresServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getPostgresServer(aoServer, postgresServer).startPostgresql();
    }

    public void startXfs(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).startXfs();
    }

    public void startXvfb(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).startXvfb();
    }

    public void stopApache(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).stopApache();
    }

    public void stopCron(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).stopCron();
    }

    public String stopJvm(String siteName, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        Site site = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site tomcatSite = site.getHttpdTomcatSite();
        if (tomcatSite == null) {
            throw new IllegalArgumentException("HttpdSite " + siteName + " on " + aoServer + " is not a HttpdTomcatSite");
        }
        return tomcatSite.stopJvm();
    }

    public void stopMysql(Server.Name mysqlServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getMysqlServer(aoServer, mysqlServer).stopMysql();
    }

    public void stopPostgresql(Server.Name postgresServer, String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getPostgresServer(aoServer, postgresServer).stopPostgresql();
    }

    public void stopXfs(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).stopXfs();
    }

    public void stopXvfb(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).stopXvfb();
    }

    public void updateHttpdTomcatDataSource(String siteName, String aoServer, String path, String oldName, String newName, String driverClassName, String url, String username, String password, int maxActive, int maxIdle, int maxWait, String validationQuery) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        Context htc = hts.getHttpdTomcatContext(path);
        if (htc == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatContext: " + siteName + " on " + aoServer + " path='" + path + '\'');
        }
        ContextDataSource htds = htc.getHttpdTomcatDataSource(oldName);
        if (htds == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatDataSource: " + siteName + " on " + aoServer + " path='" + path + "' name='" + oldName + '\'');
        }
        htds.update(newName, driverClassName, url, username, password, maxActive, maxIdle, maxWait, validationQuery);
    }

    public void updateHttpdTomcatParameter(String siteName, String aoServer, String path, String oldName, String newName, String value, boolean override, String description) throws IllegalArgumentException, IOException, SQLException {
        Site hs = this.getHttpdSite(aoServer, siteName);
        com.aoindustries.aoserv.client.web.tomcat.Site hts = hs.getHttpdTomcatSite();
        if (hts == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatSite: " + siteName + " on " + aoServer);
        }
        Context htc = hts.getHttpdTomcatContext(path);
        if (htc == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatContext: " + siteName + " on " + aoServer + " path='" + path + '\'');
        }
        ContextParameter htp = htc.getHttpdTomcatParameter(oldName);
        if (htp == null) {
            throw new IllegalArgumentException("Unable to find HttpdTomcatParameter: " + siteName + " on " + aoServer + " path='" + path + "' name='" + oldName + '\'');
        }
        htp.update(newName, value, override, description);
    }

    public void waitForHttpdSiteRebuild(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).waitForHttpdSiteRebuild();
    }

    public void waitForLinuxAccountRebuild(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).waitForLinuxAccountRebuild();
    }

    public void waitForMysqlDatabaseRebuild(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).waitForMysqlDatabaseRebuild();
    }

    public void waitForMysqlDbUserRebuild(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).waitForMysqlDbUserRebuild();
    }

    public void waitForMysqlServerRebuild(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).waitForMysqlServerRebuild();
    }

    public void waitForMysqlUserRebuild(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).waitForMysqlUserRebuild();
    }

    public void waitForPostgresDatabaseRebuild(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).waitForPostgresDatabaseRebuild();
    }

    public void waitForPostgresServerRebuild(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).waitForPostgresServerRebuild();
    }

    public void waitForPostgresUserRebuild(String aoServer) throws IllegalArgumentException, IOException, SQLException {
        this.getLinuxServer(aoServer).waitForPostgresUserRebuild();
    }

    public java.util.List<Certificate.Check> checkSslCertificate(String aoServer, String keyFileOrCertbotName, boolean allowCached) throws IllegalArgumentException, IOException, SQLException {
        return this.getSslCertificate(aoServer, keyFileOrCertbotName).check(allowCached);
    }

    public String createVirtualServer(String virtualServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getVirtualServer(virtualServer).create();
    }

    public String rebootVirtualServer(String virtualServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getVirtualServer(virtualServer).reboot();
    }

    public String shutdownVirtualServer(String virtualServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getVirtualServer(virtualServer).shutdown();
    }

    public String destroyVirtualServer(String virtualServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getVirtualServer(virtualServer).destroy();
    }

    public String pauseVirtualServer(String virtualServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getVirtualServer(virtualServer).pause();
    }

    public String unpauseVirtualServer(String virtualServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getVirtualServer(virtualServer).unpause();
    }

    public int getVirtualServerStatus(String virtualServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getVirtualServer(virtualServer).getStatus();
    }

    public void addIpReputation(String identifier, String host, String confidence, String reputationType, short score) throws IllegalArgumentException, IOException, SQLException {
        Set set = this.getIpReputationSet(identifier);
        int hostIp = IpAddress.getIntForIpAddress(host);
        set.addReputation(hostIp, Set.ConfidenceType.valueOf(confidence.toUpperCase(Locale.ROOT)), Set.ReputationType.valueOf(reputationType.toUpperCase(Locale.ROOT)), score);
    }

    public long verifyVirtualDisk(String virtualServer, String device) throws IllegalArgumentException, IOException, SQLException {
        return this.getVirtualDisk(virtualServer, device).verify();
    }

    public String getPrimaryVirtualServer(String virtualServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getVirtualServer(virtualServer).getPrimaryPhysicalServer().toString();
    }

    public String getSecondaryVirtualServer(String virtualServer) throws IllegalArgumentException, IOException, SQLException {
        return this.getVirtualServer(virtualServer).getSecondaryPhysicalServer().toString();
    }
}

