/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.AutoCloseables;
import com.aoapps.lang.Throwables;
import com.aoapps.security.Identifier;
import com.aoapps.security.SecurityStreamables;
import com.aoindustries.aoserv.client.AoservConnection;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.TcpConnector;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class SocketConnection
extends AoservConnection {
    private final AtomicBoolean isClosed = new AtomicBoolean(true);
    private final Socket socket;
    private final StreamableOutput out;
    private final StreamableInput in;
    private final AtomicLong seq;
    private long currentSeq;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SocketConnection(TcpConnector connector) throws InterruptedIOException, IOException {
        super(connector);
        this.socket = connector.getSocket();
        try {
            boolean hadConnectorId;
            Identifier connectorId;
            this.isClosed.set(false);
            this.out = new StreamableOutput((OutputStream)new BufferedOutputStream(this.socket.getOutputStream()));
            this.in = new StreamableInput((InputStream)new BufferedInputStream(this.socket.getInputStream()));
            this.out.writeUTF(AoservProtocol.Version.CURRENT_VERSION.getVersion());
            this.out.writeNullUTF(Objects.toString(connector.daemonServer, null));
            this.out.writeUTF(connector.connectAs.toString());
            this.out.writeUTF(connector.authenticateAs.toString());
            this.out.writeUTF(connector.password);
            AoservConnector.IdLock idLock = connector.idLock;
            synchronized (idLock) {
                connectorId = connector.id;
                if (connectorId == null) {
                    SecurityStreamables.writeNullIdentifier(null, (DataOutputStream)this.out);
                    this.out.flush();
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedIOException();
                    }
                    if (!this.in.readBoolean()) {
                        throw new IOException(this.in.readUTF());
                    }
                    connector.id = connectorId = SecurityStreamables.readIdentifier((DataInputStream)this.in);
                    hadConnectorId = false;
                } else {
                    hadConnectorId = true;
                }
            }
            if (hadConnectorId) {
                SecurityStreamables.writeNullIdentifier((Identifier)connectorId, (DataOutputStream)this.out);
                this.out.flush();
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedIOException();
                }
                if (!this.in.readBoolean()) {
                    throw new IOException(this.in.readUTF());
                }
            }
            long startSeq = this.in.readLong();
            this.seq = new AtomicLong(startSeq);
        }
        catch (Throwable t) {
            throw (IOException)Throwables.wrap((Throwable)this.abort(t), IOException.class, IOException::new);
        }
    }

    @Override
    Throwable abort(Throwable t0) {
        if (!this.isClosed.getAndSet(true)) {
            try {
                this.out.writeCompressedInt(AoservProtocol.CommandId.QUIT.ordinal());
                this.out.flush();
            }
            catch (Throwable t) {
                t0 = Throwables.addSuppressed((Throwable)t0, (Throwable)t);
            }
            t0 = AutoCloseables.closeAndCatch((Throwable)t0, (AutoCloseable[])new AutoCloseable[]{this.in, this.out, this.socket});
        }
        return t0;
    }

    InetAddress getLocalInetAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    StreamableOutput getRequestOut(AoservProtocol.CommandId commandId) throws IOException {
        this.currentSeq = this.seq.getAndIncrement();
        this.out.writeLong(this.currentSeq);
        this.out.writeCompressedInt(commandId.ordinal());
        return this.out;
    }

    @Override
    StreamableInput getResponseIn() throws IOException {
        long serverSeq = this.in.readLong();
        if (serverSeq != this.currentSeq) {
            throw new IOException("Sequence mismatch: " + serverSeq + " != " + this.currentSeq);
        }
        return this.in;
    }

    boolean isClosed() {
        return this.isClosed.get();
    }
}

