/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client;

import com.aoapps.hodgepodge.io.AOPool;
import com.aoapps.hodgepodge.util.EncodingUtils;
import com.aoapps.lang.Throwables;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTable;
import com.aoindustries.aoserv.client.GlobalTable;
import com.aoindustries.aoserv.client.SocketConnection;
import com.aoindustries.aoserv.client.TcpConnector;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.sql.SQLException;
import java.util.logging.Logger;

final class SocketConnectionPool
extends AOPool<SocketConnection, IOException, InterruptedIOException> {
    public static final int DELAY_TIME = 180000;
    public static final int MAX_IDLE_TIME = 900000;
    private final TcpConnector connector;
    private static final int numTables = Table.TableId.values().length;

    SocketConnectionPool(TcpConnector connector, Logger logger) {
        super(180000, 900000, SocketConnectionPool.class.getName() + "?hostname=" + connector.hostname + "&port=" + connector.port + "&connectAs=" + connector.connectAs + "&authenticateAs=" + connector.authenticateAs, connector.poolSize, connector.maxConnectionAge, logger);
        this.connector = connector;
    }

    protected void close(SocketConnection conn) throws IOException {
        Throwable t0 = conn.abort(null);
        if (t0 != null) {
            throw (IOException)Throwables.wrap((Throwable)t0, IOException.class, IOException::new);
        }
    }

    protected void release(SocketConnection connection) throws IOException {
        super.release((AutoCloseable)connection);
    }

    protected SocketConnection getConnectionObject() throws InterruptedIOException, IOException {
        return new SocketConnection(this.connector);
    }

    protected boolean isClosed(SocketConnection conn) {
        return conn.isClosed();
    }

    protected void printConnectionStats(Appendable out, boolean isXhtml) throws IOException {
        try {
            int totalLoaded = 0;
            int totalCaches = 0;
            int totalActive = 0;
            int totalHashed = 0;
            int totalIndexed = 0;
            int totalRows = 0;
            for (AoservTable<?, ?> table : this.connector.getTables()) {
                int d;
                int columnCount;
                ++totalLoaded;
                if (table instanceof CachedTable) {
                    ++totalCaches;
                    columnCount = table.getTableSchema().getSchemaColumns(this.connector).size();
                    CachedTable cached = (CachedTable)table;
                    if (!cached.isLoaded()) continue;
                    ++totalActive;
                    for (d = 0; d < columnCount; ++d) {
                        if (cached.isHashed(d)) {
                            ++totalHashed;
                        }
                        if (!cached.isIndexed(d)) continue;
                        ++totalIndexed;
                    }
                    totalRows += cached.size();
                    continue;
                }
                if (!(table instanceof GlobalTable)) continue;
                ++totalCaches;
                columnCount = table.getTableSchema().getSchemaColumns(this.connector).size();
                GlobalTable global = (GlobalTable)table;
                if (!global.isLoaded()) continue;
                ++totalActive;
                for (d = 0; d < columnCount; ++d) {
                    if (global.isHashed(d)) {
                        ++totalHashed;
                    }
                    if (!global.isIndexed(d)) continue;
                    ++totalIndexed;
                }
                totalRows += global.size();
            }
            out.append("  <thead>\n    <tr><th colspan=\"2\"><span style=\"font-size:large\">AOServ Tables</span></th></tr>\n  </thead>\n");
            super.printConnectionStats(out, isXhtml);
            out.append("    <tr><td>Total Tables:</td><td>").append(Integer.toString(numTables)).append("</td></tr>\n    <tr><td>Loaded:</td><td>").append(Integer.toString(totalLoaded)).append("</td></tr>\n    <tr><td>Caches:</td><td>").append(Integer.toString(totalCaches)).append("</td></tr>\n    <tr><td>Active:</td><td>").append(Integer.toString(totalActive)).append("</td></tr>\n    <tr><td>Hashed:</td><td>").append(Integer.toString(totalHashed)).append("</td></tr>\n    <tr><td>Indexes:</td><td>").append(Integer.toString(totalIndexed)).append("</td></tr>\n    <tr><td>Total Rows:</td><td>").append(Integer.toString(totalRows)).append("</td></tr>\n  </tbody>\n</table>\n");
            if (isXhtml) {
                out.append("<br /><br />\n");
            } else {
                out.append("<br><br>\n");
            }
            out.append("<table class=\"ao-grid\">\n  <thead>\n    <tr><th colspan=\"2\"><span style=\"font-size:large\">TCP Connection Pool</span></th></tr>\n  </thead>\n");
            super.printConnectionStats(out, isXhtml);
            out.append("    <tr><td>Host:</td><td>");
            EncodingUtils.encodeHtml((Object)this.connector.hostname, (Appendable)out, (boolean)isXhtml);
            out.append("</td></tr>\n    <tr><td>Port:</td><td>").append(Integer.toString(this.connector.port.getPort())).append("</td></tr>\n    <tr><td>Connected As:</td><td>");
            EncodingUtils.encodeHtml((Object)this.connector.connectAs, (Appendable)out, (boolean)isXhtml);
            out.append("</td></tr>\n    <tr><td>Authenticated As:</td><td>");
            EncodingUtils.encodeHtml((Object)this.connector.authenticateAs, (Appendable)out, (boolean)isXhtml);
            out.append("</td></tr>\n    <tr><td>Password:</td><td>");
            String password = this.connector.password;
            int len = Math.max(password.length(), 8);
            for (int c = 0; c < len; ++c) {
                out.append('*');
            }
            out.append("</td></tr>\n");
        }
        catch (SQLException err) {
            throw new IOException(err);
        }
    }

    protected void resetConnection(SocketConnection conn) {
    }

    protected IOException newException(String message, Throwable cause) {
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        if (cause instanceof InterruptedException) {
            return this.newInterruptedException(message, cause);
        }
        if (message == null) {
            if (cause == null) {
                return new IOException();
            }
            return new IOException(cause);
        }
        if (cause == null) {
            return new IOException(message);
        }
        return new IOException(message, cause);
    }

    protected InterruptedIOException newInterruptedException(String message, Throwable cause) {
        Thread.currentThread().interrupt();
        if (cause instanceof InterruptedIOException) {
            return (InterruptedIOException)cause;
        }
        if (message == null) {
            if (cause == null) {
                return new InterruptedIOException();
            }
            InterruptedIOException err = new InterruptedIOException(cause.toString());
            err.initCause(cause);
            return err;
        }
        if (cause == null) {
            return new InterruptedIOException(message);
        }
        InterruptedIOException err = new InterruptedIOException(message);
        err.initCause(cause);
        return err;
    }
}

