/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client;

import com.aoapps.lang.AutoCloseables;
import com.aoapps.net.DomainName;
import com.aoapps.net.HostAddress;
import com.aoapps.net.InetAddress;
import com.aoapps.net.Port;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.TcpConnector;
import com.aoindustries.aoserv.client.account.User;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocketFactory;

public class SslConnector
extends TcpConnector {
    private static String trustStorePath;
    private static String trustStorePassword;
    public static final String SSL_PROTOCOL = "ssl";
    private static final List<SslConnector> connectors;

    protected SslConnector(HostAddress hostname, InetAddress localIp, Port port, User.Name connectAs, User.Name authenticateAs, String password, DomainName daemonServer, int poolSize, long maxConnectionAge, String trustStorePath, String trustStorePassword) {
        super(hostname, localIp, port, connectAs, authenticateAs, password, daemonServer, poolSize, maxConnectionAge);
        if (SslConnector.trustStorePath != null && !SslConnector.trustStorePath.equals(trustStorePath) || SslConnector.trustStorePassword != null && !SslConnector.trustStorePassword.equals(trustStorePassword)) {
            throw new IllegalArgumentException("Trust store path and password may only be set once, currently '" + SslConnector.trustStorePath + "', trying to set to '" + trustStorePath + "'");
        }
        if (SslConnector.trustStorePath == null) {
            SslConnector.trustStorePath = trustStorePath;
            SslConnector.trustStorePassword = trustStorePassword;
        }
    }

    @Override
    public String getProtocol() {
        return SSL_PROTOCOL;
    }

    @Override
    Socket getSocket() throws IOException {
        if (trustStorePath != null && trustStorePath.length() > 0) {
            System.setProperty("javax.net.ssl.trustStore", trustStorePath);
        }
        if (trustStorePassword != null && trustStorePassword.length() > 0) {
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        }
        SSLSocketFactory sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Socket socket = new Socket();
        try {
            socket.setKeepAlive(true);
            socket.setSoLinger(true, 15);
            socket.setTcpNoDelay(true);
            if (this.localIp != null && !this.localIp.isUnspecified()) {
                socket.bind(new InetSocketAddress(this.localIp.toString(), 0));
            }
            socket.connect(new InetSocketAddress(this.hostname.toString(), this.port.getPort()), 15000);
            return sslFact.createSocket(socket, this.hostname.toString(), this.port.getPort(), true);
        }
        catch (Throwable t) {
            throw (IOException)AutoCloseables.closeAndWrap((Throwable)t, IOException.class, IOException::new, (AutoCloseable)socket);
        }
    }

    public static synchronized SslConnector getSslConnector(HostAddress hostname, InetAddress localIp, Port port, User.Name connectAs, User.Name authenticateAs, String password, DomainName daemonServer, int poolSize, long maxConnectionAge, String trustStorePath, String trustStorePassword) {
        if (connectAs == null) {
            throw new IllegalArgumentException("connectAs is null");
        }
        if (authenticateAs == null) {
            throw new IllegalArgumentException("authenticateAs is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        int size = connectors.size();
        for (int c = 0; c < size; ++c) {
            SslConnector connector = connectors.get(c);
            if (connector == null) {
                throw new NullPointerException("connector is null");
            }
            if (connector.connectAs == null) {
                throw new NullPointerException("connector.connectAs is null");
            }
            if (connector.authenticateAs == null) {
                throw new NullPointerException("connector.authenticateAs is null");
            }
            if (connector.password == null) {
                throw new NullPointerException("connector.password is null");
            }
            if (!connector.hostname.equals((Object)hostname) || !Objects.equals(localIp, connector.localIp) || connector.port != port || !connector.connectAs.equals(connectAs) || !connector.authenticateAs.equals(authenticateAs) || !connector.password.equals(password) || !Objects.equals(daemonServer, connector.daemonServer) || connector.poolSize != poolSize || connector.maxConnectionAge != maxConnectionAge || !Objects.equals(SslConnector.trustStorePath, trustStorePath) || !Objects.equals(SslConnector.trustStorePassword, trustStorePassword)) continue;
            return connector;
        }
        SslConnector newConnector = new SslConnector(hostname, localIp, port, connectAs, authenticateAs, password, daemonServer, poolSize, maxConnectionAge, trustStorePath, trustStorePassword);
        connectors.add(newConnector);
        return newConnector;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public AoservConnector switchUsers(User.Name username) {
        if (username.equals(this.connectAs)) {
            return this;
        }
        return SslConnector.getSslConnector(this.hostname, this.localIp, this.port, username, this.authenticateAs, this.password, this.daemonServer, this.poolSize, this.maxConnectionAge, trustStorePath, trustStorePassword);
    }

    static {
        connectors = new ArrayList<SslConnector>();
    }
}

