/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client;

import com.aoapps.collections.IntArrayList;
import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.AutoCloseables;
import com.aoapps.lang.LocalizedIllegalStateException;
import com.aoapps.lang.Throwables;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.net.DomainName;
import com.aoapps.net.HostAddress;
import com.aoapps.net.Port;
import com.aoapps.net.Protocol;
import com.aoindustries.aoserv.client.AoservConnection;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.SocketConnection;
import com.aoindustries.aoserv.client.SocketConnectionPool;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class TcpConnector
extends AoservConnector {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, TcpConnector.class);
    private static final long MAX_IDLE_LISTEN_CACHES = 5400000L;
    public static final String TCP_PROTOCOL = "tcp";
    private final SocketConnectionPool pool;
    private static final List<TcpConnector> connectors = new ArrayList<TcpConnector>();
    final int poolSize;
    final long maxConnectionAge;
    private final CacheMonitorLock cacheMonitorLock = new CacheMonitorLock();
    private long connectionLastUsed;
    private CacheMonitor cacheMonitor;

    protected TcpConnector(HostAddress hostname, com.aoapps.net.InetAddress localIp, Port port, User.Name connectAs, User.Name authenticateAs, String password, DomainName daemonServer, int poolSize, long maxConnectionAge) {
        super(hostname, localIp, port, connectAs, authenticateAs, password, daemonServer);
        if (port.getProtocol() != Protocol.TCP) {
            throw new IllegalArgumentException("Only TCP supported: " + port);
        }
        this.poolSize = poolSize;
        this.maxConnectionAge = maxConnectionAge;
        this.pool = new SocketConnectionPool(this, this.getLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCacheMonitor() {
        CacheMonitorLock cacheMonitorLock = this.cacheMonitorLock;
        synchronized (cacheMonitorLock) {
            this.connectionLastUsed = System.currentTimeMillis();
            if (this.cacheMonitor == null) {
                this.cacheMonitor = new CacheMonitor();
                this.cacheMonitor.start();
            }
        }
    }

    @Override
    protected final SocketConnection getConnection(int maxConnections) throws InterruptedIOException, IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getLogger().log(Level.WARNING, null, (Throwable)new LocalizedIllegalStateException(RESOURCES, "getConnection.isEventDispatchThread"));
        }
        this.startCacheMonitor();
        SocketConnection conn = (SocketConnection)this.pool.getConnection(maxConnections);
        return conn;
    }

    @Override
    public String getProtocol() {
        return TCP_PROTOCOL;
    }

    Socket getSocket() throws InterruptedIOException, IOException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException();
        }
        Socket socket = new Socket();
        try {
            socket.setKeepAlive(true);
            socket.setSoLinger(true, 15);
            socket.setTcpNoDelay(true);
            if (this.localIp != null && !this.localIp.isUnspecified()) {
                socket.bind(new InetSocketAddress(this.localIp.toString(), 0));
            }
            socket.connect(new InetSocketAddress(this.hostname.toString(), this.port.getPort()), 15000);
            return socket;
        }
        catch (Throwable t) {
            throw (IOException)AutoCloseables.closeAndWrap((Throwable)t, IOException.class, IOException::new, (AutoCloseable)socket);
        }
    }

    public static synchronized TcpConnector getTcpConnector(HostAddress hostname, com.aoapps.net.InetAddress localIp, Port port, User.Name connectAs, User.Name authenticateAs, String password, DomainName daemonServer, int poolSize, long maxConnectionAge) {
        if (connectAs == null) {
            throw new IllegalArgumentException("connectAs is null");
        }
        if (authenticateAs == null) {
            throw new IllegalArgumentException("authenticateAs is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        int size = connectors.size();
        for (int c = 0; c < size; ++c) {
            TcpConnector connector = connectors.get(c);
            if (connector == null) {
                throw new NullPointerException("connector is null");
            }
            if (connector.connectAs == null) {
                throw new NullPointerException("connector.connectAs is null");
            }
            if (connector.authenticateAs == null) {
                throw new NullPointerException("connector.authenticateAs is null");
            }
            if (connector.password == null) {
                throw new NullPointerException("connector.password is null");
            }
            if (!connector.hostname.equals((Object)hostname) || !Objects.equals(localIp, connector.localIp) || connector.port != port || !connector.connectAs.equals(connectAs) || !connector.authenticateAs.equals(authenticateAs) || !connector.password.equals(password) || !Objects.equals(daemonServer, connector.daemonServer) || connector.poolSize != poolSize || connector.maxConnectionAge != maxConnectionAge) continue;
            return connector;
        }
        TcpConnector newConnector = new TcpConnector(hostname, localIp, port, connectAs, authenticateAs, password, daemonServer, poolSize, maxConnectionAge);
        connectors.add(newConnector);
        return newConnector;
    }

    @Override
    public boolean isSecure() throws UnknownHostException, IOException {
        boolean bl;
        block8: {
            byte[] address = InetAddress.getByName(this.hostname.toString()).getAddress();
            if (address[0] == 127 || address[0] == 10 || address[0] == -64 && address[1] == -88) {
                return true;
            }
            SocketConnection conn = this.getConnection(1);
            try {
                InetAddress ia = conn.getLocalInetAddress();
                byte[] localAddress = ia.getAddress();
                boolean bl2 = bl = address[0] == localAddress[0] && address[1] == localAddress[1] && address[2] == localAddress[2];
                if (conn == null) break block8;
            }
            catch (Throwable t) {
                try {
                    throw (IOException)Throwables.wrap((Throwable)conn.abort(t), IOException.class, IOException::new);
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            conn.close();
        }
        return bl;
    }

    @Override
    public final void printConnectionStatsHtml(Appendable out, boolean isXhtml) throws IOException {
        this.pool.printStatisticsHtml(out, isXhtml);
    }

    @Override
    protected final void release(AoservConnection conn) throws IOException {
        this.pool.release((SocketConnection)conn);
    }

    @Override
    public AoservConnector switchUsers(User.Name username) throws IOException {
        if (username.equals(this.connectAs)) {
            return this;
        }
        return TcpConnector.getTcpConnector(this.hostname, this.localIp, this.port, username, this.authenticateAs, this.password, this.daemonServer, this.poolSize, this.maxConnectionAge);
    }

    @Override
    void addingTableListener() {
        this.startCacheMonitor();
    }

    private static class CacheMonitorLock {
        private CacheMonitorLock() {
        }
    }

    class CacheMonitor
    extends Thread {
        CacheMonitor() {
            super("TcpConnector - CacheMonitor");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean runMore = true;
                while (runMore && !Thread.currentThread().isInterrupted()) {
                    try {
                        SocketConnection conn = TcpConnector.this.getConnection(1);
                        try {
                            Throwable t0;
                            try {
                                StreamableOutput out = conn.getRequestOut(AoservProtocol.CommandId.LISTEN_CACHES);
                                out.flush();
                                StreamableInput in = conn.getResponseIn();
                                IntArrayList tableList = new IntArrayList();
                                while (runMore && !Thread.currentThread().isInterrupted()) {
                                    CacheMonitorLock cacheMonitorLock = TcpConnector.this.cacheMonitorLock;
                                    synchronized (cacheMonitorLock) {
                                        long currentTime = System.currentTimeMillis();
                                        long timeSince = currentTime - TcpConnector.this.connectionLastUsed;
                                        if (timeSince < 0L) {
                                            TcpConnector.this.connectionLastUsed = currentTime;
                                        } else if (timeSince >= 5400000L) {
                                            boolean foundListener = false;
                                            for (AoservTable<?, ?> table : TcpConnector.this.getTables()) {
                                                if (!table.hasAnyTableListener()) continue;
                                                foundListener = true;
                                                break;
                                            }
                                            if (foundListener) {
                                                TcpConnector.this.connectionLastUsed = currentTime;
                                            } else {
                                                runMore = false;
                                            }
                                        }
                                    }
                                    if (!runMore) continue;
                                    tableList.clear();
                                    boolean isSynchronous = in.readBoolean();
                                    int size = in.readCompressedInt();
                                    if (size != -1) {
                                        for (int c = 0; c < size; ++c) {
                                            int tableId = in.readCompressedInt();
                                            tableList.add(tableId);
                                        }
                                    }
                                    if (!tableList.isEmpty()) {
                                        TcpConnector.this.tablesUpdated((IntList)tableList);
                                    }
                                    if (!isSynchronous) continue;
                                    out.writeBoolean(true);
                                    out.flush();
                                }
                                t0 = conn.abort(null);
                                if (t0 == null) continue;
                            }
                            catch (Throwable throwable) {
                                Throwable t02 = conn.abort(null);
                                if (t02 != null) {
                                    TcpConnector.this.getLogger().log(t02 instanceof SocketException ? Level.FINE : Level.WARNING, null, t02);
                                }
                                throw throwable;
                            }
                            TcpConnector.this.getLogger().log(t0 instanceof SocketException ? Level.FINE : Level.WARNING, null, t0);
                        }
                        finally {
                            if (conn == null) continue;
                            conn.close();
                        }
                    }
                    catch (EOFException err) {
                        if (AoservConnector.isImmediateFail(err)) {
                            runMore = false;
                            continue;
                        }
                        TcpConnector.this.getLogger().log(Level.INFO, null, err);
                        try {
                            CacheMonitor.sleep(AoservConnector.getFastRandom().nextInt(50000) + 10000);
                        }
                        catch (InterruptedException err2) {
                            TcpConnector.this.getLogger().log(Level.WARNING, null, err2);
                            Thread.currentThread().interrupt();
                        }
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        if (AoservConnector.isImmediateFail(t)) {
                            runMore = false;
                            continue;
                        }
                        TcpConnector.this.getLogger().log(Level.SEVERE, null, t);
                        try {
                            CacheMonitor.sleep(AoservConnector.getFastRandom().nextInt(50000) + 10000);
                        }
                        catch (InterruptedException err2) {
                            TcpConnector.this.getLogger().log(Level.WARNING, null, err2);
                            Thread.currentThread().interrupt();
                        }
                    }
                    finally {
                        TcpConnector.this.clearCaches();
                    }
                }
            }
            finally {
                CacheMonitorLock cacheMonitorLock = TcpConnector.this.cacheMonitorLock;
                synchronized (cacheMonitorLock) {
                    if (TcpConnector.this.cacheMonitor == this) {
                        TcpConnector.this.cacheMonitor = null;
                        TcpConnector.this.clearCaches();
                    }
                }
            }
        }
    }
}

