/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.account;

import com.aoapps.collections.AoCollections;
import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.exception.NotImplementedException;
import com.aoapps.lang.i18n.Money;
import com.aoapps.lang.i18n.Monies;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.io.FastExternalizable;
import com.aoapps.lang.io.FastObjectInput;
import com.aoapps.lang.io.FastObjectOutput;
import com.aoapps.lang.util.ComparatorUtils;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoapps.net.Email;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.SimpleAoservClient;
import com.aoindustries.aoserv.client.account.AccountHost;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.CachedObjectAccountNameKey;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.account.Profile;
import com.aoindustries.aoserv.client.billing.MonthlyCharge;
import com.aoindustries.aoserv.client.billing.NoticeLog;
import com.aoindustries.aoserv.client.billing.NoticeType;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.billing.PackageCategory;
import com.aoindustries.aoserv.client.billing.PackageDefinition;
import com.aoindustries.aoserv.client.billing.Transaction;
import com.aoindustries.aoserv.client.billing.TransactionType;
import com.aoindustries.aoserv.client.billing.WhoisHistoryAccount;
import com.aoindustries.aoserv.client.dto.AccountName;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.email.Forwarding;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.payment.CountryCode;
import com.aoindustries.aoserv.client.payment.CreditCard;
import com.aoindustries.aoserv.client.payment.Payment;
import com.aoindustries.aoserv.client.payment.PaymentType;
import com.aoindustries.aoserv.client.payment.Processor;
import com.aoindustries.aoserv.client.pki.EncryptionKey;
import com.aoindustries.aoserv.client.reseller.Brand;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.ticket.Ticket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Account
extends CachedObjectAccountNameKey<Account>
implements Disablable,
Comparable<Account> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, Account.class);
    static final int COLUMN_ACCOUNTING = 0;
    static final String COLUMN_ACCOUNTING_name = "accounting";
    public static final int MAXIMUM_BUSINESS_TREE_DEPTH = 7;
    private String contractVersion;
    private UnmodifiableTimestamp created;
    private UnmodifiableTimestamp canceled;
    private String cancelReason;
    private Name parent;
    private boolean canAddBackupServer;
    private boolean canAddBusinesses;
    private boolean canSeePrices;
    private int disableLog;
    private String doNotDisableReason;
    private boolean autoEnable;
    private boolean billParent;

    @Deprecated
    public Account() {
    }

    public int addProfile(String name, boolean isPrivate, String phone, String fax, String address1, String address2, String city, String state, String country, String zip, boolean sendInvoice, String billingContact, Set<Email> billingEmail, Profile.EmailFormat billingEmailFormat, String technicalContact, Set<Email> technicalEmail, Profile.EmailFormat technicalEmailFormat) throws IOException, SQLException {
        return this.table.getConnector().getAccount().getProfile().addProfile(this, name, isPrivate, phone, fax, address1, address2, city, state, country, zip, sendInvoice, billingContact, billingEmail, billingEmailFormat, technicalContact, technicalEmail, technicalEmailFormat);
    }

    public int addAccountHost(Host server) throws IOException, SQLException {
        return this.table.getConnector().getAccount().getAccountHost().addAccountHost(this, server);
    }

    public int addCreditCard(Processor processor, String groupName, String cardInfo, byte expirationMonth, short expirationYear, String providerUniqueId, String firstName, String lastName, String companyName, Email email, String phone, String fax, String customerId, String customerTaxId, String streetAddress1, String streetAddress2, String city, String state, String postalCode, CountryCode countryCode, String principalName, String description, String cardNumber) throws IOException, SQLException {
        return this.table.getConnector().getPayment().getCreditCard().addCreditCard(processor, this, groupName, cardInfo, expirationMonth, expirationYear, providerUniqueId, firstName, lastName, companyName, email, phone, fax, customerId, customerTaxId, streetAddress1, streetAddress2, city, state, postalCode, countryCode, principalName, description, cardNumber);
    }

    @Deprecated
    public int addPayment(Processor processor, String groupName, boolean testMode, int duplicateWindow, String orderNumber, Money amount, Money taxAmount, boolean taxExempt, Money shippingAmount, Money dutyAmount, String shippingFirstName, String shippingLastName, String shippingCompanyName, String shippingStreetAddress1, String shippingStreetAddress2, String shippingCity, String shippingState, String shippingPostalCode, String shippingCountryCode, boolean emailCustomer, Email merchantEmail, String invoiceNumber, String purchaseOrderNumber, String description, Administrator creditCardCreatedBy, String creditCardPrincipalName, Account creditCardAccount, String creditCardGroupName, String creditCardProviderUniqueId, String creditCardMaskedCardNumber, Byte creditCard_expirationMonth, Short creditCard_expirationYear, String creditCardFirstName, String creditCardLastName, String creditCardCompanyName, Email creditCardEmail, String creditCardPhone, String creditCardFax, String creditCardCustomerId, String creditCardCustomerTaxId, String creditCardStreetAddress1, String creditCardStreetAddress2, String creditCardCity, String creditCardState, String creditCardPostalCode, String creditCardCountryCode, String creditCardComments, long authorizationTime, String authorizationPrincipalName) throws IOException, SQLException {
        return this.table.getConnector().getPayment().getPayment().addPayment(processor, this, groupName, testMode, duplicateWindow, orderNumber, amount, taxAmount, taxExempt, shippingAmount, dutyAmount, shippingFirstName, shippingLastName, shippingCompanyName, shippingStreetAddress1, shippingStreetAddress2, shippingCity, shippingState, shippingPostalCode, shippingCountryCode, emailCustomer, merchantEmail, invoiceNumber, purchaseOrderNumber, description, creditCardCreatedBy, creditCardPrincipalName, creditCardAccount, creditCardGroupName, creditCardProviderUniqueId, creditCardMaskedCardNumber, creditCard_expirationMonth, creditCard_expirationYear, creditCardFirstName, creditCardLastName, creditCardCompanyName, creditCardEmail, creditCardPhone, creditCardFax, creditCardCustomerId, creditCardCustomerTaxId, creditCardStreetAddress1, creditCardStreetAddress2, creditCardCity, creditCardState, creditCardPostalCode, creditCardCountryCode, creditCardComments, authorizationTime, authorizationPrincipalName);
    }

    public int addDisableLog(String disableReason) throws IOException, SQLException {
        return this.table.getConnector().getAccount().getDisableLog().addDisableLog(this, disableReason);
    }

    @Deprecated
    public void addNoticeLog(String billingContact, Email emailAddress, String type, int transid) throws IOException, SQLException {
        Transaction trans;
        AoservConnector connector = this.table.getConnector();
        NoticeType nt = connector.getBilling().getNoticeType().get(type);
        if (nt == null) {
            throw new IllegalArgumentException("Unable to find NoticeType: " + type);
        }
        if (transid != -1) {
            trans = connector.getBilling().getTransaction().get(transid);
            if (trans == null) {
                throw new IllegalArgumentException("Unable to find Transaction: " + transid);
            }
        } else {
            trans = null;
        }
        connector.getBilling().getNoticeLog().addNoticeLog(this, billingContact, emailAddress, nt, trans);
    }

    public int addPackage(Name name, PackageDefinition packageDefinition) throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackage().addPackage(name, this, packageDefinition);
    }

    @Deprecated
    public int addTransaction(int timeType, Timestamp time, Account sourceAccount, Administrator administrator, TransactionType type, String description, int quantity, Money rate, PaymentType paymentType, String paymentInfo, Processor processor, byte paymentConfirmed) throws IOException, SQLException {
        return this.table.getConnector().getBilling().getTransaction().add(timeType, time, this, sourceAccount, administrator, type, description, quantity, rate, paymentType, paymentInfo, processor, paymentConfirmed);
    }

    public boolean canAddBackupServer() {
        return this.canAddBackupServer;
    }

    public boolean canAddAccounts() {
        return this.canAddBusinesses;
    }

    public void cancel(String cancelReason) throws IllegalArgumentException, IOException, SQLException {
        if (this.disableLog == -1) {
            new SimpleAoservClient(this.table.getConnector()).disableAccount(this.pkey, "Account canceled");
        }
        if (cancelReason != null && (cancelReason = cancelReason.trim()).length() == 0) {
            cancelReason = null;
        }
        final String finalCancelReason = cancelReason;
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.CANCEL_BUSINESS, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeUTF(Account.this.pkey.toString());
                out.writeNullUTF(finalCancelReason);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                Account.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    public boolean canCancel() throws IOException, SQLException {
        if (this.canceled != null) {
            return false;
        }
        if (this.isRootAccount()) {
            return false;
        }
        for (Account child : this.getChildAccounts()) {
            if (child.getCanceled() != null) continue;
            return false;
        }
        return true;
    }

    public boolean isRootAccount() throws IOException, SQLException {
        return this.pkey.equals(this.table.getConnector().getAccount().getAccount().getRootAccount_name());
    }

    @Override
    public boolean canDisable() throws IOException, SQLException {
        if (this.disableLog != -1) {
            return false;
        }
        if (this.isRootAccount()) {
            return false;
        }
        for (Package pk : this.getPackages()) {
            if (pk.isDisabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        if (this.canceled != null) {
            return false;
        }
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable();
    }

    public boolean canSeePrices() {
        return this.canSeePrices;
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.BUSINESSES, dl.getPkey(), this.pkey.toString()});
    }

    @Override
    public void enable() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.BUSINESSES, this.pkey.toString()});
    }

    @Deprecated
    public Monies getAccountBalance() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getTransaction().getAccountBalance(this);
    }

    @Deprecated
    public Monies getAccountBalance(Timestamp before) throws IOException, SQLException {
        return this.table.getConnector().getBilling().getTransaction().getAccountBalance(this, before);
    }

    @Deprecated
    public String getAccountBalanceString() throws IOException, SQLException {
        return this.getAccountBalance().toString();
    }

    @Deprecated
    public String getAccountBalanceString(Timestamp before) throws IOException, SQLException {
        return this.getAccountBalance(before).toString();
    }

    public Name getName() {
        return this.pkey;
    }

    public boolean getAutoEnable() {
        return this.autoEnable;
    }

    public boolean billParent() {
        return this.billParent;
    }

    public Monies getAutoEnableMinimumPayment() throws IOException, SQLException {
        ArrayList<Money> minimums = new ArrayList<Money>();
        for (Money accountBalance : this.getAccountBalance()) {
            if (accountBalance.getUnscaledValue() < 0L) continue;
            Currency currency = accountBalance.getCurrency();
            BigDecimal balance = accountBalance.getValue();
            BigDecimal minimum = balance.divide(BigDecimal.valueOf(2L), RoundingMode.UP);
            com.aoindustries.aoserv.client.billing.Currency billingCurrency = this.getTable().getConnector().getBilling().getCurrency().get(currency);
            if (billingCurrency == null) {
                throw new SQLException("billing.Currency not found: " + currency);
            }
            BigDecimal minimumPayment = billingCurrency.getAutoEnableMinimumPayment().getValue();
            if (minimum.compareTo(minimumPayment) < 0) {
                minimum = minimumPayment;
            }
            if (minimum.compareTo(balance) > 0) {
                minimum = balance;
            }
            minimums.add(new Money(currency, minimum));
        }
        return Monies.of(minimums);
    }

    public String getDoNotDisableReason() {
        return this.doNotDisableReason;
    }

    public Account getTopLevelAccount() throws IOException, SQLException {
        Account tempParent;
        Name rootAccount_name = this.table.getConnector().getAccount().getAccount().getRootAccount_name();
        Account bu = this;
        while ((tempParent = bu.getParent()) != null && !tempParent.getName().equals(rootAccount_name)) {
            bu = tempParent;
        }
        return bu;
    }

    public Account getBillingAccount() throws SQLException, IOException {
        Account bu = this;
        while (bu.billParent) {
            if ((bu = bu.getParent()) != null) continue;
            throw new SQLException("Unable to find the billing account for '" + this.pkey + '\'');
        }
        return bu;
    }

    public Profile getProfile() throws IOException, SQLException {
        return this.table.getConnector().getAccount().getProfile().getProfile(this);
    }

    public List<Profile> getProfiles() throws IOException, SQLException {
        return this.table.getConnector().getAccount().getProfile().getProfiles(this);
    }

    public AccountHost getAccountHost(Host host) throws IOException, SQLException {
        return this.table.getConnector().getAccount().getAccountHost().getAccountHost(this, host);
    }

    public List<AccountHost> getAccountHosts() throws IOException, SQLException {
        return this.table.getConnector().getAccount().getAccountHost().getAccountHosts(this);
    }

    public UnmodifiableTimestamp getCanceled() {
        return this.canceled;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    public List<Account> getChildAccounts() throws IOException, SQLException {
        return this.table.getConnector().getAccount().getAccount().getChildAccounts(this);
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.contractVersion;
            }
            case 2: {
                return this.created;
            }
            case 3: {
                return this.canceled;
            }
            case 4: {
                return this.cancelReason;
            }
            case 5: {
                return this.parent;
            }
            case 6: {
                return this.canAddBackupServer;
            }
            case 7: {
                return this.canAddBusinesses;
            }
            case 8: {
                return this.canSeePrices;
            }
            case 9: {
                return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
            }
            case 10: {
                return this.doNotDisableReason;
            }
            case 11: {
                return this.autoEnable;
            }
            case 12: {
                return this.billParent;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Deprecated
    public Monies getConfirmedAccountBalance() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getTransaction().getConfirmedAccountBalance(this);
    }

    @Deprecated
    public Monies getConfirmedAccountBalance(Timestamp before) throws IOException, SQLException {
        return this.table.getConnector().getBilling().getTransaction().getConfirmedAccountBalance(this, before);
    }

    public String getContractVersion() {
        return this.contractVersion;
    }

    public UnmodifiableTimestamp getCreated() {
        return this.created;
    }

    public List<Processor> getCreditCardProcessors() throws IOException, SQLException {
        return this.table.getConnector().getPayment().getProcessor().getCreditCardProcessors(this);
    }

    public List<CreditCard> getCreditCards() throws IOException, SQLException {
        return this.table.getConnector().getPayment().getCreditCard().getCreditCards(this);
    }

    public Host getDefaultHost() throws IOException, SQLException {
        return this.table.getConnector().getAccount().getAccountHost().getDefaultHost(this);
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public List<Forwarding> getEmailForwarding() throws SQLException, IOException {
        return this.table.getConnector().getEmail().getForwarding().getEmailForwarding(this);
    }

    public List<com.aoindustries.aoserv.client.email.List> getEmailLists() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getList().getEmailLists(this);
    }

    public GroupServer getLinuxServerGroup(Server aoServer) throws IOException, SQLException {
        return this.table.getConnector().getLinux().getGroupServer().getLinuxServerGroup(aoServer, this);
    }

    public List<User> getMailAccounts() throws IOException, SQLException {
        return this.table.getConnector().getLinux().getUser().getMailAccounts(this);
    }

    public CreditCard getMonthlyCreditCard() throws IOException, SQLException {
        return this.table.getConnector().getPayment().getCreditCard().getMonthlyCreditCard(this);
    }

    public List<MonthlyCharge> getMonthlyCharges() throws SQLException, IOException {
        return this.table.getConnector().getBilling().getMonthlyCharge().getMonthlyCharges(this, null);
    }

    public List<MonthlyCharge> getBillingMonthlyCharges() throws SQLException, IOException {
        return this.table.getConnector().getBilling().getMonthlyCharge().getMonthlyCharges(null, this);
    }

    public Monies getMonthlyRate() throws SQLException, IOException {
        Monies totalMonthlyRate = Monies.of();
        for (MonthlyCharge monthlyCharge : this.getMonthlyCharges()) {
            if (!monthlyCharge.isActive()) continue;
            Money amount = monthlyCharge.getAmount();
            if (amount == null) {
                return null;
            }
            totalMonthlyRate = totalMonthlyRate.add(amount);
        }
        return totalMonthlyRate;
    }

    public Monies getBillingMonthlyRate() throws SQLException, IOException {
        Monies totalMonthlyRate = Monies.of();
        for (MonthlyCharge monthlyCharge : this.getBillingMonthlyCharges()) {
            if (!monthlyCharge.isActive()) continue;
            Money amount = monthlyCharge.getAmount();
            if (amount == null) {
                return null;
            }
            totalMonthlyRate = totalMonthlyRate.add(amount);
        }
        return totalMonthlyRate;
    }

    public List<NoticeLog> getNoticeLogs() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getNoticeLog().getNoticeLogs(this);
    }

    public List<Package> getPackages() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackage().getPackages(this);
    }

    public Name getParent_name() {
        return this.parent;
    }

    public Account getParent() throws IOException, SQLException {
        if (this.parent == null) {
            return null;
        }
        return this.table.getConnector().getAccount().getAccount().get(this.parent);
    }

    public List<Domain> getEmailDomains() throws SQLException, IOException {
        return this.table.getConnector().getEmail().getDomain().getEmailDomains(this);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BUSINESSES;
    }

    @Deprecated
    public List<Transaction> getTransactions() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getTransaction().getTransactions(this);
    }

    @Deprecated
    public List<Transaction> getTransactionsFrom() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getTransaction().getTransactionsFrom(this);
    }

    public List<WhoisHistoryAccount> getWhoisHistoryAccounts() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getWhoisHistoryAccount().getWhoisHistoryAccounts(this);
    }

    @Deprecated
    public boolean isAccountOrParent(Account other) throws IOException, SQLException {
        return this.isAccountOrParentOf(other);
    }

    public boolean isAccountOrParentOf(Account other) throws IOException, SQLException {
        while (other != null) {
            if (this.equals(other)) {
                return true;
            }
            other = other.getParent();
        }
        return false;
    }

    public boolean isParentOf(Account other) throws IOException, SQLException {
        if (other != null) {
            for (other = other.getParent(); other != null; other = other.getParent()) {
                if (!this.equals(other)) continue;
                return true;
            }
        }
        return false;
    }

    public void move(Server from, Server to, TerminalWriter out) throws IOException, SQLException {
        throw new NotImplementedException("TODO: Finish implementation");
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = Name.valueOf(result.getString(1));
            this.contractVersion = result.getString(2);
            this.created = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(3));
            this.canceled = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(4));
            this.cancelReason = result.getString(5);
            this.parent = Name.valueOf(result.getString(6));
            this.canAddBackupServer = result.getBoolean(7);
            this.canAddBusinesses = result.getBoolean(8);
            this.canSeePrices = result.getBoolean(9);
            this.disableLog = result.getInt(10);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
            this.doNotDisableReason = result.getString(11);
            this.autoEnable = result.getBoolean(12);
            this.billParent = result.getBoolean(13);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = Name.valueOf(in.readUTF()).intern();
            this.contractVersion = InternUtils.intern((String)in.readNullUTF());
            this.created = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.canceled = SQLStreamables.readNullUnmodifiableTimestamp((DataInputStream)in);
            this.cancelReason = in.readNullUTF();
            this.parent = (Name)InternUtils.intern((Internable)Name.valueOf(in.readNullUTF()));
            this.canAddBackupServer = in.readBoolean();
            this.canAddBusinesses = in.readBoolean();
            this.canSeePrices = in.readBoolean();
            this.disableLog = in.readCompressedInt();
            this.doNotDisableReason = in.readNullUTF();
            this.autoEnable = in.readBoolean();
            this.billParent = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public void setName(Name name) throws SQLException, IOException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_BUSINESS_ACCOUNTING, this.pkey.toString(), name.toString());
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey.toString());
        out.writeBoolean(this.contractVersion != null);
        if (this.contractVersion != null) {
            out.writeUTF(this.contractVersion);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.created.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.created, (DataOutputStream)out);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.canceled == null ? -1L : this.canceled.getTime());
        } else {
            SQLStreamables.writeNullTimestamp((Timestamp)this.canceled, (DataOutputStream)out);
        }
        out.writeNullUTF(this.cancelReason);
        out.writeNullUTF(Objects.toString(this.parent, null));
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_102) >= 0) {
            out.writeBoolean(this.canAddBackupServer);
        }
        out.writeBoolean(this.canAddBusinesses);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_122) <= 0) {
            out.writeBoolean(false);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_103) >= 0) {
            out.writeBoolean(this.canSeePrices);
        }
        out.writeCompressedInt(this.disableLog);
        out.writeNullUTF(this.doNotDisableReason);
        out.writeBoolean(this.autoEnable);
        out.writeBoolean(this.billParent);
    }

    public List<Ticket> getTickets() throws SQLException, IOException {
        return this.table.getConnector().getTicket().getTicket().getTickets(this);
    }

    public List<EncryptionKey> getEncryptionKeys() throws IOException, SQLException {
        return this.table.getConnector().getPki().getEncryptionKey().getEncryptionKeys(this);
    }

    public void setUseMonthlyCreditCard(CreditCard creditCard) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_CREDIT_CARD_USE_MONTHLY, this.pkey.toString(), creditCard == null ? -1 : creditCard.getPkey());
    }

    public Payment getLastCreditCardTransaction() throws IOException, SQLException {
        return this.table.getConnector().getPayment().getPayment().getLastCreditCardTransaction(this);
    }

    public Brand getBrand() throws IOException, SQLException {
        return this.table.getConnector().getReseller().getBrand().getBrand(this);
    }

    @Deprecated
    public int addPackageDefinition(PackageCategory category, String name, String version, String display, String description, Money setupFee, TransactionType setupFeeTransactionType, Money monthlyRate, TransactionType monthlyRateTransactionType) throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackageDefinition().addPackageDefinition(this, category, name, version, display, description, setupFee, setupFeeTransactionType, monthlyRate, monthlyRateTransactionType);
    }

    public PackageDefinition getPackageDefinition(PackageCategory category, String name, String version) throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackageDefinition().getPackageDefinition(this, category, name, version);
    }

    public List<PackageDefinition> getPackageDefinitions(PackageCategory category) throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackageDefinition().getPackageDefinitions(this, category);
    }

    public Map<PackageCategory, List<PackageDefinition>> getActivePackageDefinitions() throws IOException, SQLException {
        List allCategories = this.table.getConnector().getBilling().getPackageCategory().getRows();
        LinkedHashMap categories = AoCollections.newLinkedHashMap((int)allCategories.size());
        for (PackageCategory category : allCategories) {
            List<PackageDefinition> allDefinitions = this.getPackageDefinitions(category);
            ArrayList<PackageDefinition> definitions = new ArrayList<PackageDefinition>(allDefinitions.size());
            for (PackageDefinition definition : allDefinitions) {
                if (!definition.isActive()) continue;
                definitions.add(definition);
            }
            if (definitions.isEmpty()) continue;
            categories.put(category, Collections.unmodifiableList(definitions));
        }
        return Collections.unmodifiableMap(categories);
    }

    @Override
    public int compareTo(Account o) {
        return this.pkey.compareTo(o.pkey);
    }

    public static final class Name
    implements Comparable<Name>,
    FastExternalizable,
    DtoFactory<AccountName>,
    Internable<Name> {
        public static final int MIN_LENGTH = 2;
        public static final int MAX_LENGTH = 32;
        private static final ConcurrentMap<String, Name> interned = new ConcurrentHashMap<String, Name>();
        private String name;
        private String upperName;
        private static final long serialVersionUID = -4701364475901418693L;

        public static ValidationResult validate(String name) {
            if (name == null) {
                return new InvalidResult(RESOURCES, "Name.validate.isNull");
            }
            int len = name.length();
            if (len < 2) {
                return new InvalidResult(RESOURCES, "Name.validate.tooShort", new Serializable[]{Integer.valueOf(2), Integer.valueOf(len)});
            }
            if (len > 32) {
                return new InvalidResult(RESOURCES, "Name.validate.tooLong", new Serializable[]{Integer.valueOf(32), Integer.valueOf(len)});
            }
            char ch = name.charAt(0);
            if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                return new InvalidResult(RESOURCES, "Name.validate.mustStartAlpha");
            }
            ch = name.charAt(len - 1);
            if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9')) {
                return new InvalidResult(RESOURCES, "Name.validate.mustEndAlphanumeric");
            }
            for (int pos = 1; pos < len - 1; ++pos) {
                ch = name.charAt(pos);
                if (ch == '_') {
                    if (name.charAt(pos - 1) != '_') continue;
                    return new InvalidResult(RESOURCES, "Name.validate.consecutiveUnderscores", new Serializable[]{Integer.valueOf(pos - 1)});
                }
                if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') continue;
                return new InvalidResult(RESOURCES, "Name.validate.invalidCharacter", new Serializable[]{Character.valueOf(ch), Integer.valueOf(pos)});
            }
            return ValidResult.getInstance();
        }

        public static Name valueOf(String name) throws ValidationException {
            if (name == null) {
                return null;
            }
            return new Name(name);
        }

        private Name(String name) throws ValidationException {
            this.name = name;
            this.upperName = name.toUpperCase(Locale.ROOT);
            this.validate();
        }

        private Name(String name, String upperName) {
            ValidationResult result;
            assert ((result = Name.validate(name)).isValid()) : result.toString();
            assert (name.toUpperCase(Locale.ROOT).equals(upperName));
            this.name = name;
            this.upperName = upperName;
        }

        private void validate() throws ValidationException {
            ValidationResult result = Name.validate(this.name);
            if (!result.isValid()) {
                throw new ValidationException(result);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof Name && this.upperName.equals(((Name)obj).upperName);
        }

        public int hashCode() {
            return this.upperName.hashCode();
        }

        @Override
        public int compareTo(Name other) {
            return this == other ? 0 : ComparatorUtils.compareIgnoreCaseConsistentWithEquals((String)this.name, (String)other.name);
        }

        public String toString() {
            return this.name;
        }

        public String toUpperCase() {
            return this.upperName;
        }

        public Name intern() {
            Name existing = (Name)interned.get(this.name);
            if (existing == null) {
                String internedName = this.name.intern();
                String internedUpperName = this.upperName.intern();
                Name addMe = this.name == internedName && this.upperName == internedUpperName ? this : new Name(internedName, internedUpperName);
                existing = interned.putIfAbsent(internedName, addMe);
                if (existing == null) {
                    existing = addMe;
                }
            }
            return existing;
        }

        public AccountName getDto() {
            return new AccountName(this.name);
        }

        @Deprecated
        public Name() {
        }

        public long getSerialVersionUID() {
            return -4701364475901418693L;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            FastObjectOutput fastOut = FastObjectOutput.wrap((ObjectOutput)out);
            try {
                fastOut.writeFastUTF(this.name);
            }
            finally {
                fastOut.unwrap();
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            if (this.name != null) {
                throw new IllegalStateException();
            }
            FastObjectInput fastIn = FastObjectInput.wrap((ObjectInput)in);
            try {
                this.name = fastIn.readFastUTF();
                this.upperName = this.name.toUpperCase(Locale.ROOT);
            }
            finally {
                fastIn.unwrap();
            }
            try {
                this.validate();
            }
            catch (ValidationException err) {
                InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
                newErr.initCause(err);
                throw newErr;
            }
        }
    }
}

