/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.account;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.email.Pipe;
import com.aoindustries.aoserv.client.email.SmtpRelay;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.net.Device;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.postgresql.Database;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.Site;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class AccountHost
extends CachedObjectIntegerKey<AccountHost>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_ACCOUNTING = 1;
    static final int COLUMN_SERVER = 2;
    static final String COLUMN_ACCOUNTING_name = "accounting";
    static final String COLUMN_SERVER_name = "server";
    private Account.Name accounting;
    private int server;
    private boolean isDefault;
    private boolean canControlApache;
    private boolean canControlCron;
    private boolean canControlMysql;
    private boolean canControlPostgresql;
    private boolean canControlXfs;
    private boolean canControlXvfb;
    private boolean canVncConsole;
    private boolean canControlVirtualServer;

    @Deprecated
    public AccountHost() {
    }

    public boolean canControlApache() {
        return this.canControlApache;
    }

    public boolean canControlCron() {
        return this.canControlCron;
    }

    public boolean canControlMysql() {
        return this.canControlMysql;
    }

    public boolean canControlPostgresql() {
        return this.canControlPostgresql;
    }

    public boolean canControlXfs() {
        return this.canControlXfs;
    }

    public boolean canControlXvfb() {
        return this.canControlXvfb;
    }

    public boolean canVncConsole() {
        return this.canVncConsole;
    }

    public boolean canControlVirtualServer() {
        return this.canControlVirtualServer;
    }

    public Account.Name getAccount_name() {
        return this.accounting;
    }

    public Account getAccount() throws IOException, SQLException {
        Account obj = this.table.getConnector().getAccount().getAccount().get(this.accounting);
        if (obj == null) {
            throw new SQLException("Unable to find Account: " + this.accounting);
        }
        return obj;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.accounting;
            }
            case 2: {
                return this.server;
            }
            case 3: {
                return this.isDefault;
            }
            case 4: {
                return this.canControlApache;
            }
            case 5: {
                return this.canControlCron;
            }
            case 6: {
                return this.canControlMysql;
            }
            case 7: {
                return this.canControlPostgresql;
            }
            case 8: {
                return this.canControlXfs;
            }
            case 9: {
                return this.canControlXvfb;
            }
            case 10: {
                return this.canVncConsole;
            }
            case 11: {
                return this.canControlVirtualServer;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getHost_id() {
        return this.server;
    }

    public Host getHost() throws IOException, SQLException {
        Host obj = this.table.getConnector().getNet().getHost().get(this.server);
        if (obj == null) {
            throw new SQLException("Unable to find Host: " + this.server);
        }
        return obj;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BUSINESS_SERVERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.accounting = Account.Name.valueOf(result.getString(2));
            this.server = result.getInt(3);
            this.isDefault = result.getBoolean(4);
            this.canControlApache = result.getBoolean(5);
            this.canControlCron = result.getBoolean(6);
            this.canControlMysql = result.getBoolean(7);
            this.canControlPostgresql = result.getBoolean(8);
            this.canControlXfs = result.getBoolean(9);
            this.canControlXvfb = result.getBoolean(10);
            this.canVncConsole = result.getBoolean(11);
            this.canControlVirtualServer = result.getBoolean(12);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.accounting = Account.Name.valueOf(in.readUTF()).intern();
            this.server = in.readCompressedInt();
            this.isDefault = in.readBoolean();
            this.canControlApache = in.readBoolean();
            this.canControlCron = in.readBoolean();
            this.canControlMysql = in.readBoolean();
            this.canControlPostgresql = in.readBoolean();
            this.canControlXfs = in.readBoolean();
            this.canControlXvfb = in.readBoolean();
            this.canVncConsole = in.readBoolean();
            this.canControlVirtualServer = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() throws SQLException, IOException {
        ArrayList reasons = new ArrayList();
        Account bu = this.getAccount();
        if (this.isDefault && bu.getAccountHosts().size() > 1) {
            reasons.add(new CannotRemoveReason<Account>("Not allowed to remove access to the default host while access to other hosts remains", bu));
        }
        Host se = this.getHost();
        com.aoindustries.aoserv.client.linux.Server ao = se.getLinuxServer();
        List bus = this.table.getConnector().getAccount().getAccount().getRows();
        for (int c = 0; c < bus.size(); ++c) {
            if (!bu.isAccountOrParentOf((Account)bus.get(c))) continue;
            Account bu2 = (Account)bus.get(c);
            if (!bu.equals(bu2) && bu2.getAccountHost(se) != null) {
                reasons.add(new CannotRemoveReason<Account>("Child business " + bu2.getName() + " still has access to " + se, bu2));
            }
            List<Package> pks = bu2.getPackages();
            for (int d = 0; d < pks.size(); ++d) {
                Package pk = pks.get(d);
                for (Bind nb : pk.getNetBinds()) {
                    if (!nb.getHost().equals(se)) continue;
                    String details = nb.getDetails();
                    if (details != null) {
                        reasons.add(new CannotRemoveReason<Bind>("Used for " + details + " on " + se.toStringImpl(), nb));
                        continue;
                    }
                    IpAddress ia = nb.getIpAddress();
                    Device nd = ia.getDevice();
                    if (nd != null) {
                        reasons.add(new CannotRemoveReason<Bind>("Used for port " + nb.getPort() + " on " + ia.getInetAddress() + " on " + nd.getDeviceId().getName() + " on " + se.toStringImpl(), nb));
                        continue;
                    }
                    reasons.add(new CannotRemoveReason<Bind>("Used for port " + nb.getPort() + " on " + ia.getInetAddress() + " on " + se.toStringImpl(), nb));
                }
                for (IpAddress ia : pk.getIpAddresses()) {
                    Device nd = ia.getDevice();
                    if (nd == null || !se.equals(nd.getHost())) continue;
                    reasons.add(new CannotRemoveReason<IpAddress>("Used by IP address " + ia.getInetAddress() + " on " + nd.getDeviceId().getName() + " on " + se.toStringImpl(), ia));
                }
                if (ao == null) continue;
                for (Pipe ep : pk.getEmailPipes()) {
                    if (!ep.getLinuxServer().equals(ao)) continue;
                    reasons.add(new CannotRemoveReason<Pipe>("Used by email pipe '" + ep.getCommand() + "' on " + ao.getHostname(), ep));
                }
                for (Site hs : pk.getHttpdSites()) {
                    if (!hs.getLinuxServer().equals(ao)) continue;
                    reasons.add(new CannotRemoveReason<Site>("Used by website " + hs.getInstallDirectory() + " on " + ao.getHostname(), hs));
                }
                for (User un : pk.getUsernames()) {
                    com.aoindustries.aoserv.client.postgresql.User pu;
                    com.aoindustries.aoserv.client.mysql.User mu;
                    UserServer lsa;
                    com.aoindustries.aoserv.client.linux.User la = un.getLinuxAccount();
                    if (la != null && (lsa = la.getLinuxServerAccount(ao)) != null) {
                        reasons.add(new CannotRemoveReason<UserServer>("Used by Linux account " + un.getUsername() + " on " + ao.getHostname(), lsa));
                    }
                    if ((mu = un.getMysqlUser()) != null) {
                        for (Server ms : ao.getMysqlServers()) {
                            com.aoindustries.aoserv.client.mysql.UserServer msu = mu.getMysqlServerUser(ms);
                            if (msu == null) continue;
                            reasons.add(new CannotRemoveReason<com.aoindustries.aoserv.client.mysql.UserServer>("Used by MySQL user " + un.getUsername() + " on " + ms.getName() + " on " + ao.getHostname(), msu));
                        }
                    }
                    if ((pu = un.getPostgresUser()) == null) continue;
                    for (com.aoindustries.aoserv.client.postgresql.Server ps : ao.getPostgresServers()) {
                        com.aoindustries.aoserv.client.postgresql.UserServer psu = pu.getPostgresServerUser(ps);
                        if (psu == null) continue;
                        reasons.add(new CannotRemoveReason<com.aoindustries.aoserv.client.postgresql.UserServer>("Used by PostgreSQL user " + un.getUsername() + " on " + ps.getName() + " on " + ao.getHostname(), psu));
                    }
                }
                for (Group lg : pk.getLinuxGroups()) {
                    GroupServer lsg = lg.getLinuxServerGroup(ao);
                    if (lsg == null) continue;
                    reasons.add(new CannotRemoveReason<GroupServer>("Used by Linux group " + lg.getName() + " on " + ao.getHostname(), lsg));
                }
                for (com.aoindustries.aoserv.client.mysql.Database md : pk.getMysqlDatabases()) {
                    Server ms = md.getMysqlServer();
                    if (!ms.getLinuxServer().equals(ao)) continue;
                    reasons.add(new CannotRemoveReason<com.aoindustries.aoserv.client.mysql.Database>("Used by MySQL database " + md.getName() + " on " + ms.getName() + " on " + ao.getHostname(), md));
                }
                for (Database pd : pk.getPostgresDatabases()) {
                    com.aoindustries.aoserv.client.postgresql.Server ps = pd.getPostgresServer();
                    if (!ps.getLinuxServer().equals(ao)) continue;
                    reasons.add(new CannotRemoveReason<Database>("Used by PostgreSQL database " + pd.getName() + " on " + ps.getName() + " on " + ao.getHostname(), pd));
                }
                for (Domain ed : pk.getEmailDomains()) {
                    if (!ed.getLinuxServer().equals(ao)) continue;
                    reasons.add(new CannotRemoveReason<Domain>("Used by email domain " + ed.getDomain() + " on " + ao.getHostname(), ed));
                }
                for (SmtpRelay esr : pk.getEmailSmtpRelays()) {
                    if (!esr.getLinuxServer().equals(ao)) continue;
                    reasons.add(new CannotRemoveReason<SmtpRelay>("Used by email SMTP rule " + esr, esr));
                }
            }
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.BUSINESS_SERVERS, this.pkey});
    }

    public void setAsDefault() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_DEFAULT_BUSINESS_SERVER, this.pkey);
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.accounting.toString());
        out.writeCompressedInt(this.server);
        out.writeBoolean(this.isDefault);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.canControlApache);
        out.writeBoolean(this.canControlCron);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.canControlMysql);
        out.writeBoolean(this.canControlPostgresql);
        out.writeBoolean(this.canControlXfs);
        out.writeBoolean(this.canControlXvfb);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_51) >= 0) {
            out.writeBoolean(this.canVncConsole);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_64) >= 0) {
            out.writeBoolean(this.canControlVirtualServer);
        }
    }
}

