/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.account;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.AccountHost;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class AccountHostTable
extends CachedTableIntegerKey<AccountHost> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("accounting", true), new AoservTable.OrderBy("server.package.name", true), new AoservTable.OrderBy("server.name", true)};

    AccountHostTable(AoservConnector connector) {
        super(connector, AccountHost.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addAccountHost(Account business, Host server) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.BUSINESS_SERVERS, business.getName().toString(), server.getPkey()});
    }

    @Override
    public AccountHost get(int pkey) throws IOException, SQLException {
        return (AccountHost)this.getUniqueRow(0, pkey);
    }

    List<AccountHost> getAccountHosts(Account bu) throws IOException, SQLException {
        return this.getIndexedRows(1, bu.getName());
    }

    List<AccountHost> getAccountHosts(Host server) throws IOException, SQLException {
        return this.getIndexedRows(2, server.getPkey());
    }

    public List<Account> getAccounts(Host server) throws IOException, SQLException {
        List<AccountHost> cached = this.getAccountHosts(server);
        int size = cached.size();
        ArrayList<Account> businesses = new ArrayList<Account>(size);
        for (int c = 0; c < size; ++c) {
            businesses.add(cached.get(c).getAccount());
        }
        return businesses;
    }

    AccountHost getAccountHost(Account account, Host host) throws IOException, SQLException {
        int host_id = host.getPkey();
        List<AccountHost> cached = this.getAccountHosts(account);
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            AccountHost bs = cached.get(c);
            if (bs.getHost_id() != host_id) continue;
            return bs;
        }
        return null;
    }

    Host getDefaultHost(Account business) throws IOException, SQLException {
        List<AccountHost> cached = this.getAccountHosts(business);
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            AccountHost bs = cached.get(c);
            if (!bs.isDefault()) continue;
            return bs.getHost();
        }
        return null;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BUSINESS_SERVERS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_business_server")) {
            if (Aosh.checkParamCount("add_business_server", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addAccountHost(Aosh.parseAccountingCode(args[1], "business"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_business_server")) {
            if (Aosh.checkParamCount("remove_business_server", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeAccountHost(Aosh.parseAccountingCode(args[1], "business"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_default_business_server")) {
            if (Aosh.checkParamCount("set_default_business_server", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setDefaultAccountHost(Aosh.parseAccountingCode(args[1], "business"), args[2]);
            }
            return true;
        }
        return false;
    }
}

