/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.account;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.hodgepodge.tree.Node;
import com.aoapps.hodgepodge.tree.Tree;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.CachedTableAccountNameKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AccountTable
extends CachedTableAccountNameKey<Account> {
    private Account.Name rootAccounting;
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("accounting", true)};
    private final Tree<Account> tree = () -> {
        List<Account> topLevelAccounts = this.getTopLevelAccounts();
        int size = topLevelAccounts.size();
        switch (size) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                AccountTreeNode singleNode = new AccountTreeNode(topLevelAccounts.get(0));
                return Collections.singletonList(singleNode);
            }
        }
        ArrayList<AccountTreeNode> rootNodes = new ArrayList<AccountTreeNode>(size);
        for (Account topLevelAccount : topLevelAccounts) {
            rootNodes.add(new AccountTreeNode(topLevelAccount));
        }
        return Collections.unmodifiableList(rootNodes);
    };

    AccountTable(AoservConnector connector) {
        super(connector, Account.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public void addAccount(final Account.Name accounting, final String contractNumber, final Host defaultServer, final Account.Name parent, final boolean canAddBackupServers, final boolean canAddAccounts, final boolean canSeePrices, final boolean billParent) throws IOException, SQLException {
        this.connector.requestUpdate(true, AoservProtocol.CommandId.ADD, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.BUSINESSES.ordinal());
                out.writeUTF(accounting.toString());
                out.writeBoolean(contractNumber != null);
                if (contractNumber != null) {
                    out.writeUTF(contractNumber);
                }
                out.writeCompressedInt(defaultServer.getPkey());
                out.writeUTF(parent.toString());
                out.writeBoolean(canAddBackupServers);
                out.writeBoolean(canAddAccounts);
                out.writeBoolean(canSeePrices);
                out.writeBoolean(billParent);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                AccountTable.this.connector.tablesUpdated(this.invalidateList);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        AccountTable accountTable = this;
        synchronized (accountTable) {
            this.rootAccounting = null;
        }
    }

    public Account.Name generateAccountingCode(Account.Name template) throws IOException, SQLException {
        try {
            return Account.Name.valueOf(this.connector.requestStringQuery(true, AoservProtocol.CommandId.GENERATE_ACCOUNTING_CODE, template.toString()));
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Account get(Account.Name accounting) throws IOException, SQLException {
        return (Account)this.getUniqueRow(0, accounting);
    }

    List<Account> getChildAccounts(Account business) throws IOException, SQLException {
        Account.Name accounting = business.getName();
        List cached = this.getRows();
        ArrayList<Account> matches = new ArrayList<Account>();
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            Account bu = (Account)cached.get(c);
            if (!accounting.equals(bu.getParent_name())) continue;
            matches.add(bu);
        }
        return matches;
    }

    public synchronized Account.Name getRootAccount_name() throws IOException, SQLException {
        if (this.rootAccounting == null) {
            try {
                this.rootAccounting = Account.Name.valueOf(this.connector.requestStringQuery(true, AoservProtocol.CommandId.GET_ROOT_BUSINESS, new Object[0]));
            }
            catch (ValidationException e) {
                throw new IOException(e);
            }
        }
        return this.rootAccounting;
    }

    public Account getRootAccount() throws IOException, SQLException {
        Account.Name accounting = this.getRootAccount_name();
        Account bu = this.get(accounting);
        if (bu == null) {
            throw new SQLException("Unable to find Account: " + accounting);
        }
        return bu;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BUSINESSES;
    }

    public List<Account> getTopLevelAccounts() throws IOException, SQLException {
        List cached = this.getRows();
        ArrayList<Account> matches = new ArrayList<Account>();
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            Account bu = (Account)cached.get(c);
            if (bu.getParent_name() != null && this.getUniqueRow(0, bu.getParent_name()) != null) continue;
            matches.add(bu);
        }
        return matches;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_business")) {
            if (Aosh.checkParamCount("add_business", args, 8, (PrintWriter)err)) {
                try {
                    this.connector.getSimpleClient().addAccount(Aosh.parseAccountingCode(args[1], "accounting_code"), args[2], args[3], Aosh.parseAccountingCode(args[4], "parent_business"), Aosh.parseBoolean(args[5], "can_add_backup_servers"), Aosh.parseBoolean(args[6], "can_add_businesses"), Aosh.parseBoolean(args[7], "can_see_prices"), Aosh.parseBoolean(args[8], "bill_parent"));
                }
                catch (IllegalArgumentException iae) {
                    err.print("aosh: add_business: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("cancel_business")) {
            if (Aosh.checkParamCount("cancel_business", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().cancelAccount(Aosh.parseAccountingCode(args[1], "accounting_code"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_accounting")) {
            if (Aosh.checkParamCount("check_accounting", args, 1, (PrintWriter)err)) {
                ValidationResult validationResult = Account.Name.validate(args[1]);
                out.println(validationResult.isValid());
                out.flush();
                if (!validationResult.isValid()) {
                    err.print("aosh: check_accounting: ");
                    err.println(validationResult.toString());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_business")) {
            if (Aosh.checkParamCount("disable_business", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disableAccount(Aosh.parseAccountingCode(args[1], "accounting"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_business")) {
            if (Aosh.checkParamCount("enable_business", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().enableAccount(Aosh.parseAccountingCode(args[1], "accounting"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("generate_accounting")) {
            if (Aosh.checkParamCount("generate_accounting", args, 1, (PrintWriter)err)) {
                out.println((Object)this.connector.getSimpleClient().generateAccountingCode(Aosh.parseAccountingCode(args[1], "template")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("get_root_business")) {
            if (Aosh.checkParamCount("get_root_business", args, 0, (PrintWriter)err)) {
                out.println((Object)this.connector.getSimpleClient().getRootAccount());
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_accounting_available")) {
            if (Aosh.checkParamCount("is_accounting_available", args, 1, (PrintWriter)err)) {
                try {
                    out.println(this.connector.getSimpleClient().isAccountingAvailable(Aosh.parseAccountingCode(args[1], "accounting_code")));
                    out.flush();
                }
                catch (IllegalArgumentException iae) {
                    err.print("aosh: is_accounting_available: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("move_business")) {
            if (Aosh.checkParamCount("move_business", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().moveAccount(Aosh.parseAccountingCode(args[1], "business"), args[2], args[3], (TerminalWriter)(isInteractive ? out : null));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_business_accounting")) {
            if (Aosh.checkParamCount("set_business_accounting", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setAccountAccounting(Aosh.parseAccountingCode(args[1], "old_accounting"), Aosh.parseAccountingCode(args[2], "new_accounting"));
            }
            return true;
        }
        return false;
    }

    public boolean isAccountingAvailable(Account.Name accounting) throws SQLException, IOException {
        return this.connector.requestBooleanQuery(true, AoservProtocol.CommandId.IS_ACCOUNTING_AVAILABLE, accounting.toString());
    }

    public Tree<Account> getTree() {
        return this.tree;
    }

    static class AccountTreeNode
    implements Node<Account> {
        private final Account business;

        AccountTreeNode(Account business) {
            this.business = business;
        }

        public List<Node<Account>> getChildren() throws IOException, SQLException {
            List<Account> children = this.business.getChildAccounts();
            int size = children.size();
            switch (size) {
                case 0: {
                    if (this.business.canAddAccounts()) {
                        return Collections.emptyList();
                    }
                    return null;
                }
                case 1: {
                    AccountTreeNode singleNode = new AccountTreeNode(children.get(0));
                    return Collections.singletonList(singleNode);
                }
            }
            ArrayList<AccountTreeNode> childNodes = new ArrayList<AccountTreeNode>(size);
            for (Account child : children) {
                childNodes.add(new AccountTreeNode(child));
            }
            return Collections.unmodifiableList(childNodes);
        }

        public Account getValue() {
            return this.business;
        }
    }
}

