/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.account;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.Email;
import com.aoapps.security.HashedPassword;
import com.aoapps.security.SecurityStreamables;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.CachedObjectUserNameKey;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.billing.MonthlyCharge;
import com.aoindustries.aoserv.client.billing.Transaction;
import com.aoindustries.aoserv.client.master.AdministratorPermission;
import com.aoindustries.aoserv.client.master.Permission;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.password.PasswordProtected;
import com.aoindustries.aoserv.client.payment.CountryCode;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.ticket.Action;
import com.aoindustries.aoserv.client.ticket.Assignment;
import com.aoindustries.aoserv.client.ticket.Ticket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public final class Administrator
extends CachedObjectUserNameKey<Administrator>
implements PasswordProtected,
Removable,
Disablable,
Comparable<Administrator> {
    static final int COLUMN_USERNAME = 0;
    static final String COLUMN_USERNAME_name = "username";
    private HashedPassword password;
    private String name;
    private String title;
    private long birthday;
    private boolean isPreferred;
    private boolean isPrivate;
    private UnmodifiableTimestamp created;
    private String workPhone;
    private String homePhone;
    private String cellPhone;
    private String fax;
    private Email email;
    private String address1;
    private String address2;
    private String city;
    private String state;
    private String country;
    private String zip;
    private int disableLog;
    private boolean canSwitchUsers;
    private String supportCode;

    @Deprecated
    public Administrator() {
    }

    @Override
    public int arePasswordsSet() throws IOException, SQLException {
        return this.table.getConnector().requestBooleanQuery(true, AoservProtocol.CommandId.IS_BUSINESS_ADMINISTRATOR_PASSWORD_SET, this.pkey) ? 2 : 0;
    }

    @Override
    public boolean canDisable() throws SQLException, IOException {
        return this.disableLog == -1 && !this.equals(this.table.getConnector().getCurrentAdministrator());
    }

    public boolean canSwitchUsers() {
        return this.canSwitchUsers;
    }

    public String getSupportCode() {
        return this.supportCode;
    }

    public boolean canSwitchUser(Administrator other) throws SQLException, IOException {
        Account otherAccount;
        if (this.isDisabled() || other.isDisabled()) {
            return false;
        }
        Account account = this.getUsername().getPackage().getAccount();
        return !account.equals(otherAccount = other.getUsername().getPackage().getAccount()) && account.isAccountOrParentOf(otherAccount);
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable();
    }

    @Override
    public List<PasswordChecker.Result> checkPassword(String password) throws IOException {
        return Administrator.checkPassword(this.pkey, password);
    }

    public static List<PasswordChecker.Result> checkPassword(User.Name username, String password) throws IOException {
        return PasswordChecker.checkPassword(username, password, PasswordChecker.PasswordStrength.STRICT);
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.BUSINESS_ADMINISTRATORS, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.BUSINESS_ADMINISTRATORS, this.pkey});
    }

    public List<Action> getTicketActions() throws IOException, SQLException {
        return this.table.getConnector().getTicket().getAction().getActions(this);
    }

    public List<Assignment> getTicketAssignments() throws IOException, SQLException {
        return this.table.getConnector().getTicket().getAssignment().getTicketAssignments(this);
    }

    public String getAddress1() {
        return this.address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public Date getBirthday() {
        return this.birthday == -1L ? null : new Date(this.birthday);
    }

    public String getCellPhone() {
        return this.cellPhone;
    }

    public String getCity() {
        return this.city;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.password;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.title;
            }
            case 4: {
                return this.getBirthday();
            }
            case 5: {
                return this.isPreferred;
            }
            case 6: {
                return this.isPrivate;
            }
            case 7: {
                return this.created;
            }
            case 8: {
                return this.workPhone;
            }
            case 9: {
                return this.homePhone;
            }
            case 10: {
                return this.cellPhone;
            }
            case 11: {
                return this.fax;
            }
            case 12: {
                return this.email;
            }
            case 13: {
                return this.address1;
            }
            case 14: {
                return this.address2;
            }
            case 15: {
                return this.city;
            }
            case 16: {
                return this.state;
            }
            case 17: {
                return this.country;
            }
            case 18: {
                return this.zip;
            }
            case 19: {
                return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
            }
            case 20: {
                return this.canSwitchUsers;
            }
            case 21: {
                return this.supportCode;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public CountryCode getCountry() throws SQLException, IOException {
        if (this.country == null) {
            return null;
        }
        CountryCode countryCode = this.table.getConnector().getPayment().getCountryCode().get(this.country);
        if (countryCode == null) {
            throw new SQLException("CountryCode not found: " + this.country);
        }
        return countryCode;
    }

    public UnmodifiableTimestamp getCreated() {
        return this.created;
    }

    public List<Ticket> getCreatedTickets() throws IOException, SQLException {
        return this.table.getConnector().getTicket().getTicket().getCreatedTickets(this);
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public Email getEmail() {
        return this.email;
    }

    public String getFax() {
        return this.fax;
    }

    public String getHomePhone() {
        return this.homePhone;
    }

    public com.aoindustries.aoserv.client.master.User getMasterUser() throws IOException, SQLException {
        return this.table.getConnector().getMaster().getUser().get(this.pkey);
    }

    public List<MonthlyCharge> getMonthlyCharges() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getMonthlyCharge().getMonthlyCharges(this, null, null);
    }

    public String getName() {
        return this.name;
    }

    public HashedPassword getPassword() {
        return this.password;
    }

    public String getState() {
        return this.state;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BUSINESS_ADMINISTRATORS;
    }

    public String getTitle() {
        return this.title;
    }

    @Deprecated
    public List<Transaction> getTransactions() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getTransaction().getTransactions(this);
    }

    public User.Name getUsername_userId() {
        return this.pkey;
    }

    public User getUsername() throws SQLException, IOException {
        User usernameObject = this.table.getConnector().getAccount().getUser().get(this.pkey);
        if (usernameObject == null) {
            throw new SQLException("Username not found: " + this.pkey);
        }
        return usernameObject;
    }

    public String getWorkPhone() {
        return this.workPhone;
    }

    public String getZip() {
        return this.zip;
    }

    public boolean isActiveAccounting() throws IOException, SQLException {
        com.aoindustries.aoserv.client.master.User user = this.getMasterUser();
        return user != null && user.isActive() && user.canAccessAccounting();
    }

    public boolean isActiveBankAccounting() throws IOException, SQLException {
        com.aoindustries.aoserv.client.master.User user = this.getMasterUser();
        return user != null && user.isActive() && user.canAccessBankAccount();
    }

    public boolean isActiveDnsAdmin() throws IOException, SQLException {
        com.aoindustries.aoserv.client.master.User user = this.getMasterUser();
        return user != null && user.isActive() && user.isDnsAdmin();
    }

    public boolean isActiveTableInvalidator() throws IOException, SQLException {
        com.aoindustries.aoserv.client.master.User user = this.getMasterUser();
        return user != null && user.isActive() && user.canInvalidateTables();
    }

    public boolean isActiveWebAdmin() throws IOException, SQLException {
        com.aoindustries.aoserv.client.master.User user = this.getMasterUser();
        return user != null && user.isActive() && user.isWebAdmin();
    }

    public boolean isPreferred() {
        return this.isPreferred;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = User.Name.valueOf(result.getString(COLUMN_USERNAME_name));
            this.password = HashedPassword.valueOf((HashedPassword.Algorithm)HashedPassword.Algorithm.findAlgorithm((String)result.getString("password.algorithm")), (byte[])result.getBytes("password.salt"), (int)result.getInt("password.iterations"), (byte[])result.getBytes("password.hash"));
            this.name = result.getString("name");
            this.title = result.getString("title");
            Date d = result.getDate("birthday");
            this.birthday = d == null ? -1L : d.getTime();
            this.isPreferred = result.getBoolean("is_preferred");
            this.isPrivate = result.getBoolean("private");
            this.created = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp("created"));
            this.workPhone = result.getString("work_phone");
            this.homePhone = result.getString("home_phone");
            this.cellPhone = result.getString("cell_phone");
            this.fax = result.getString("fax");
            this.email = Email.valueOf((String)result.getString("email"));
            this.address1 = result.getString("address1");
            this.address2 = result.getString("address2");
            this.city = result.getString("city");
            this.state = result.getString("state");
            this.country = result.getString("country");
            this.zip = result.getString("zip");
            this.disableLog = result.getInt("disable_log");
            if (result.wasNull()) {
                this.disableLog = -1;
            }
            this.canSwitchUsers = result.getBoolean("can_switch_users");
            this.supportCode = result.getString("support_code");
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = User.Name.valueOf(in.readUTF()).intern();
            this.password = SecurityStreamables.readHashedPassword((DataInputStream)in);
            this.name = in.readUTF();
            this.title = in.readNullUTF();
            this.birthday = in.readLong();
            this.isPreferred = in.readBoolean();
            this.isPrivate = in.readBoolean();
            this.created = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.workPhone = in.readUTF();
            this.homePhone = in.readNullUTF();
            this.cellPhone = in.readNullUTF();
            this.fax = in.readNullUTF();
            this.email = Email.valueOf((String)in.readUTF());
            this.address1 = in.readNullUTF();
            this.address2 = in.readNullUTF();
            this.city = in.readNullUTF();
            this.state = InternUtils.intern((String)in.readNullUTF());
            this.country = InternUtils.intern((String)in.readNullUTF());
            this.zip = in.readNullUTF();
            this.disableLog = in.readCompressedInt();
            this.canSwitchUsers = in.readBoolean();
            this.supportCode = in.readNullUTF();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() throws SQLException, IOException {
        List<Transaction> trs;
        List<Ticket> tickets;
        List<Action> actions;
        ArrayList reasons = new ArrayList();
        AoservConnector conn = this.table.getConnector();
        if (this.equals(conn.getCurrentAdministrator())) {
            reasons.add(new CannotRemoveReason<Administrator>("Not allowed to remove self", this));
        }
        if (!(actions = this.getTicketActions()).isEmpty()) {
            reasons.add(new CannotRemoveReason<Action>("Author of " + actions.size() + " ticket " + (actions.size() == 1 ? "action" : "actions"), actions));
        }
        if (!(tickets = this.getCreatedTickets()).isEmpty()) {
            reasons.add(new CannotRemoveReason<Ticket>("Author of " + tickets.size() + ' ' + (tickets.size() == 1 ? "ticket" : "tickets"), tickets));
        }
        if (!(trs = this.getTransactions()).isEmpty()) {
            reasons.add(new CannotRemoveReason<Transaction>("Created " + trs.size() + ' ' + (trs.size() == 1 ? "transaction" : "transactions"), trs));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.BUSINESS_ADMINISTRATORS, this.pkey});
    }

    @Override
    public void setPassword(String plaintext) throws IOException, SQLException {
        AoservConnector connector = this.table.getConnector();
        if (!connector.isSecure()) {
            throw new IOException("Passwords for business_administrators may only be set when using secure protocols.  Currently using the " + connector.getProtocol() + " protocol, which is not secure.");
        }
        connector.requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_BUSINESS_ADMINISTRATOR_PASSWORD, this.pkey, plaintext);
    }

    public void setProfile(final String name, String title, final Date birthday, final boolean isPrivate, final String workPhone, String homePhone, String cellPhone, String fax, final Email email, String address1, String address2, String city, String state, String country, String zip) throws IOException, SQLException {
        if (title != null && title.length() == 0) {
            title = null;
        }
        final String finalTitle = title;
        if (homePhone != null && homePhone.length() == 0) {
            homePhone = null;
        }
        final String finalHomePhone = homePhone;
        if (cellPhone != null && cellPhone.length() == 0) {
            cellPhone = null;
        }
        final String finalCellPhone = cellPhone;
        if (fax != null && fax.length() == 0) {
            fax = null;
        }
        final String finalFax = fax;
        if (address1 != null && address1.length() == 0) {
            address1 = null;
        }
        final String finalAddress1 = address1;
        if (address2 != null && address2.length() == 0) {
            address2 = null;
        }
        final String finalAddress2 = address2;
        if (city != null && city.length() == 0) {
            city = null;
        }
        final String finalCity = city;
        if (state != null && state.length() == 0) {
            state = null;
        }
        final String finalState = state;
        if (country != null && country.length() == 0) {
            country = null;
        }
        final String finalCountry = country;
        if (zip != null && zip.length() == 0) {
            zip = null;
        }
        final String finalZip = zip;
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_BUSINESS_ADMINISTRATOR_PROFILE, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeUTF(Administrator.this.pkey.toString());
                out.writeUTF(name);
                out.writeBoolean(finalTitle != null);
                if (finalTitle != null) {
                    out.writeUTF(finalTitle);
                }
                out.writeLong(birthday == null ? -1L : birthday.getTime());
                out.writeBoolean(isPrivate);
                out.writeUTF(workPhone);
                out.writeBoolean(finalHomePhone != null);
                if (finalHomePhone != null) {
                    out.writeUTF(finalHomePhone);
                }
                out.writeBoolean(finalCellPhone != null);
                if (finalCellPhone != null) {
                    out.writeUTF(finalCellPhone);
                }
                out.writeBoolean(finalFax != null);
                if (finalFax != null) {
                    out.writeUTF(finalFax);
                }
                out.writeUTF(email.toString());
                out.writeBoolean(finalAddress1 != null);
                if (finalAddress1 != null) {
                    out.writeUTF(finalAddress1);
                }
                out.writeBoolean(finalAddress2 != null);
                if (finalAddress2 != null) {
                    out.writeUTF(finalAddress2);
                }
                out.writeBoolean(finalCity != null);
                if (finalCity != null) {
                    out.writeUTF(finalCity);
                }
                out.writeBoolean(finalState != null);
                if (finalState != null) {
                    out.writeUTF(finalState);
                }
                out.writeBoolean(finalCountry != null);
                if (finalCountry != null) {
                    out.writeUTF(finalCountry);
                }
                out.writeBoolean(finalZip != null);
                if (finalZip != null) {
                    out.writeUTF(finalZip);
                }
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                Administrator.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_68) <= 0) {
            if (this.password == null) {
                out.writeUTF("*");
            } else {
                HashedPassword.Algorithm algorithm = this.password.getAlgorithm();
                if (algorithm == HashedPassword.Algorithm.CRYPT || algorithm == HashedPassword.Algorithm.SHA_1) {
                    out.writeUTF(this.password.toString());
                } else {
                    out.writeUTF("*");
                }
            }
        } else if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_2) <= 0) {
            if (this.password == null) {
                out.writeNullUTF(null);
            } else {
                HashedPassword.Algorithm algorithm = this.password.getAlgorithm();
                if (algorithm == HashedPassword.Algorithm.CRYPT || algorithm == HashedPassword.Algorithm.SHA_1) {
                    out.writeNullUTF(this.password.toString());
                } else {
                    out.writeNullUTF("*");
                }
            }
        } else {
            SecurityStreamables.writeHashedPassword((HashedPassword)this.password, (DataOutputStream)out);
        }
        out.writeUTF(this.name);
        out.writeNullUTF(this.title);
        out.writeLong(this.birthday);
        out.writeBoolean(this.isPreferred);
        out.writeBoolean(this.isPrivate);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.created.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.created, (DataOutputStream)out);
        }
        out.writeUTF(this.workPhone);
        out.writeNullUTF(this.homePhone);
        out.writeNullUTF(this.cellPhone);
        out.writeNullUTF(this.fax);
        out.writeUTF(this.email.toString());
        out.writeNullUTF(this.address1);
        out.writeNullUTF(this.address2);
        out.writeNullUTF(this.city);
        out.writeNullUTF(this.state);
        out.writeNullUTF(this.country);
        out.writeNullUTF(this.zip);
        out.writeCompressedInt(this.disableLog);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_118) >= 0) {
            out.writeBoolean(this.canSwitchUsers);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_44) >= 0) {
            out.writeNullUTF(this.supportCode);
        }
    }

    @Override
    public boolean canSetPassword() {
        return this.disableLog == -1;
    }

    public List<AdministratorPermission> getPermissions() throws IOException, SQLException {
        return this.table.getConnector().getMaster().getAdministratorPermission().getPermissions(this);
    }

    public boolean hasPermission(Permission permission) throws IOException, SQLException {
        return this.hasPermission(permission.getName());
    }

    public boolean hasPermission(Permission.Name permission) throws IOException, SQLException {
        return this.hasPermission(permission.name());
    }

    public boolean hasPermission(String permission) throws IOException, SQLException {
        return this.table.getConnector().getMaster().getAdministratorPermission().hasPermission(this, permission);
    }

    @Override
    public int compareTo(Administrator o) {
        return this.pkey.compareTo(o.pkey);
    }
}

