/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.account;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.net.Email;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.SimpleAoservClient;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.CachedTableUserNameKey;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Date;
import java.sql.SQLException;
import java.util.List;

public final class AdministratorTable
extends CachedTableUserNameKey<Administrator> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("username", true)};

    AdministratorTable(AoservConnector connector) {
        super(connector, Administrator.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    void addAdministrator(final User username, final String name, String title, final Date birthday, final boolean isPrivate, final String workPhone, String homePhone, String cellPhone, String fax, final Email email, String address1, String address2, String city, String state, String country, String zip, final boolean enableEmailSupport) throws IOException, SQLException {
        if (title != null && title.length() == 0) {
            title = null;
        }
        final String finalTitle = title;
        if (homePhone != null && homePhone.length() == 0) {
            homePhone = null;
        }
        final String finalHomePhone = homePhone;
        if (cellPhone != null && cellPhone.length() == 0) {
            cellPhone = null;
        }
        final String finalCellPhone = cellPhone;
        if (fax != null && fax.length() == 0) {
            fax = null;
        }
        final String finalFax = fax;
        if (address1 != null && address1.length() == 0) {
            address1 = null;
        }
        final String finalAddress1 = address1;
        if (address2 != null && address2.length() == 0) {
            address2 = null;
        }
        final String finalAddress2 = address2;
        if (city != null && city.length() == 0) {
            city = null;
        }
        final String finalCity = city;
        if (state != null && state.length() == 0) {
            state = null;
        }
        final String finalState = state;
        if (country != null && country.length() == 0) {
            country = null;
        }
        final String finalCountry = country;
        if (zip != null && zip.length() == 0) {
            zip = null;
        }
        final String finalZip = zip;
        this.connector.requestUpdate(true, AoservProtocol.CommandId.ADD, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.BUSINESS_ADMINISTRATORS.ordinal());
                out.writeUTF(username.getUsername().toString());
                out.writeUTF(name);
                out.writeBoolean(finalTitle != null);
                if (finalTitle != null) {
                    out.writeUTF(finalTitle);
                }
                out.writeLong(birthday == null ? -1L : birthday.getTime());
                out.writeBoolean(isPrivate);
                out.writeUTF(workPhone);
                out.writeBoolean(finalHomePhone != null);
                if (finalHomePhone != null) {
                    out.writeUTF(finalHomePhone);
                }
                out.writeBoolean(finalCellPhone != null);
                if (finalCellPhone != null) {
                    out.writeUTF(finalCellPhone);
                }
                out.writeBoolean(finalFax != null);
                if (finalFax != null) {
                    out.writeUTF(finalFax);
                }
                out.writeUTF(email.toString());
                out.writeBoolean(finalAddress1 != null);
                if (finalAddress1 != null) {
                    out.writeUTF(finalAddress1);
                }
                out.writeBoolean(finalAddress2 != null);
                if (finalAddress2 != null) {
                    out.writeUTF(finalAddress2);
                }
                out.writeBoolean(finalCity != null);
                if (finalCity != null) {
                    out.writeUTF(finalCity);
                }
                out.writeBoolean(finalState != null);
                if (finalState != null) {
                    out.writeUTF(finalState);
                }
                out.writeBoolean(finalCountry != null);
                if (finalCountry != null) {
                    out.writeUTF(finalCountry);
                }
                out.writeBoolean(finalZip != null);
                if (finalZip != null) {
                    out.writeUTF(finalZip);
                }
                out.writeBoolean(enableEmailSupport);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                AdministratorTable.this.connector.tablesUpdated(this.invalidateList);
            }
        });
    }

    @Override
    public Administrator get(User.Name username) throws IOException, SQLException {
        return (Administrator)this.getUniqueRow(0, username);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BUSINESS_ADMINISTRATORS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_business_administrator")) {
            if (Aosh.checkParamCount("add_business_administrator", args, 17, (PrintWriter)err)) {
                this.connector.getSimpleClient().addAdministrator(Aosh.parseUserName(args[1], "username"), args[2], args[3], args[4].length() == 0 ? null : Aosh.parseDate(args[4], "birthday"), Aosh.parseBoolean(args[5], "is_private"), args[6], args[7], args[8], args[9], Aosh.parseEmail(args[10], "email"), args[11], args[12], args[13], args[14], args[15], args[16], Aosh.parseBoolean(args[17], "enable_email_support"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_business_administrator_password")) {
            List<PasswordChecker.Result> results;
            if (Aosh.checkParamCount("check_business_administrator_password", args, 2, (PrintWriter)err) && PasswordChecker.hasResults(results = SimpleAoservClient.checkAdministratorPassword(Aosh.parseUserName(args[1], "username"), args[2]))) {
                PasswordChecker.printResults(results, (Appendable)out);
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_business_administrator")) {
            if (Aosh.checkParamCount("disable_business_administrator", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disableAdministrator(Aosh.parseUserName(args[1], "username"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_business_administrator")) {
            if (Aosh.checkParamCount("enable_business_administrator", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().enableAdministrator(Aosh.parseUserName(args[1], "username"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_business_administrator_password_set")) {
            if (Aosh.checkParamCount("is_business_administrator_password_set", args, 1, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().isAdministratorPasswordSet(Aosh.parseUserName(args[1], "username")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_business_administrator")) {
            if (Aosh.checkParamCount("remove_business_administrator", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeAdministrator(Aosh.parseUserName(args[1], "username"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_business_administrator_password")) {
            if (Aosh.checkParamCount("set_business_administrator_password", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setAdministratorPassword(Aosh.parseUserName(args[1], "username"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_business_administrator_profile")) {
            if (Aosh.checkParamCount("set_business_administrator_profile", args, 16, (PrintWriter)err)) {
                this.connector.getSimpleClient().setAdministratorProfile(Aosh.parseUserName(args[1], "username"), args[2], args[3], Aosh.parseDate(args[4], "birthday"), Aosh.parseBoolean(args[5], "is_private"), args[6], args[7], args[8], args[9], Aosh.parseEmail(args[10], "email"), args[11], args[12], args[13], args[14], args[15], args[16]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("crypt")) {
            if (Aosh.checkRangeParamCount("crypt", args, 1, 2, (PrintWriter)err)) {
                String encrypted = SimpleAoservClient.crypt(args[1], args.length == 3 ? args[2] : null);
                out.println(encrypted);
            }
            return true;
        }
        return false;
    }
}

