/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.account;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public final class DisableLog
extends CachedObjectIntegerKey<DisableLog> {
    static final int COLUMN_PKEY = 0;
    static final String COLUMN_TIME_name = "time";
    static final String COLUMN_ACCOUNTING_name = "accounting";
    static final String COLUMN_PKEY_name = "pkey";
    private UnmodifiableTimestamp time;
    private Account.Name accounting;
    private User.Name disabledBy;
    private String disableReason;

    @Deprecated
    public DisableLog() {
    }

    public boolean canEnable() throws SQLException, IOException {
        Administrator disabledBy = this.getDisabledBy();
        return disabledBy != null && this.table.getConnector().getCurrentAdministrator().getUsername().getPackage().getAccount().isAccountOrParentOf(disabledBy.getUsername().getPackage().getAccount());
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        if (i == 1) {
            return this.time;
        }
        if (i == 2) {
            return this.accounting;
        }
        if (i == 3) {
            return this.disabledBy;
        }
        if (i == 4) {
            return this.disableReason;
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Account.Name getAccount_name() {
        return this.accounting;
    }

    public Account getAccount() throws SQLException, IOException {
        Account obj = this.table.getConnector().getAccount().getAccount().get(this.accounting);
        if (obj == null) {
            throw new SQLException("Unable to find Account: " + this.accounting);
        }
        return obj;
    }

    public UnmodifiableTimestamp getTime() {
        return this.time;
    }

    public User.Name getDisabledByUsername() {
        return this.disabledBy;
    }

    public Administrator getDisabledBy() throws IOException, SQLException {
        return this.table.getConnector().getAccount().getAdministrator().get(this.disabledBy);
    }

    public String getDisableReason() {
        return this.disableReason;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.DISABLE_LOG;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.time = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(2));
            this.accounting = Account.Name.valueOf(result.getString(3));
            this.disabledBy = User.Name.valueOf(result.getString(4));
            this.disableReason = result.getString(5);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.time = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.accounting = Account.Name.valueOf(in.readUTF()).intern();
            this.disabledBy = User.Name.valueOf(in.readUTF()).intern();
            this.disableReason = in.readNullUTF();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.time.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.time, (DataOutputStream)out);
        }
        out.writeUTF(this.accounting.toString());
        out.writeUTF(this.disabledBy.toString());
        out.writeNullUTF(this.disableReason);
    }
}

