/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.account;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;

public final class DisableLogTable
extends CachedTableIntegerKey<DisableLog> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("time", true), new AoservTable.OrderBy("accounting", true), new AoservTable.OrderBy("pkey", true)};

    DisableLogTable(AoservConnector connector) {
        super(connector, DisableLog.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addDisableLog(final Account bu, final String disableReason) throws IOException, SQLException {
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private IntList invalidateList;
            private int result;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.DISABLE_LOG.ordinal());
                out.writeUTF(bu.getName().toString());
                out.writeBoolean(disableReason != null);
                if (disableReason != null) {
                    out.writeUTF(disableReason);
                }
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.result = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                DisableLogTable.this.connector.tablesUpdated(this.invalidateList);
                return this.result;
            }
        });
    }

    @Override
    public DisableLog get(int pkey) throws IOException, SQLException {
        return (DisableLog)this.getUniqueRow(0, pkey);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.DISABLE_LOG;
    }
}

