/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.account;

import com.aoapps.collections.AoCollections;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.Strings;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.Email;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.payment.CountryCode;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class Profile
extends CachedObjectIntegerKey<Profile> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_ACCOUNTING = 1;
    static final String COLUMN_ACCOUNTING_name = "accounting";
    static final String COLUMN_PRIORITY_name = "priority";
    private Account.Name accounting;
    private int priority;
    private String name;
    private boolean isPrivate;
    private String phone;
    private String fax;
    private String address1;
    private String address2;
    private String city;
    private String state;
    private String country;
    private String zip;
    private boolean sendInvoice;
    private UnmodifiableTimestamp created;
    private String billingContact;
    private Set<Email> billingEmail;
    private EmailFormat billingEmailFormat;
    private String technicalContact;
    private Set<Email> technicalEmail;
    private EmailFormat technicalEmailFormat;

    @Deprecated
    public Profile() {
    }

    public String getAddress1() {
        return this.address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public String getBillingContact() {
        return this.billingContact;
    }

    public Set<Email> getBillingEmail() {
        return this.billingEmail;
    }

    public EmailFormat getBillingEmailFormat() {
        return this.billingEmailFormat;
    }

    public Account.Name getAccount_name() {
        return this.accounting;
    }

    public Account getAccount() throws SQLException, IOException {
        Account obj = this.table.getConnector().getAccount().getAccount().get(this.accounting);
        if (obj == null) {
            throw new SQLException("Unable to find Account: " + this.accounting);
        }
        return obj;
    }

    public String getCity() {
        return this.city;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.accounting;
            }
            case 2: {
                return this.priority;
            }
            case 3: {
                return this.name;
            }
            case 4: {
                return this.isPrivate;
            }
            case 5: {
                return this.phone;
            }
            case 6: {
                return this.fax;
            }
            case 7: {
                return this.address1;
            }
            case 8: {
                return this.address2;
            }
            case 9: {
                return this.city;
            }
            case 10: {
                return this.state;
            }
            case 11: {
                return this.country;
            }
            case 12: {
                return this.zip;
            }
            case 13: {
                return this.sendInvoice;
            }
            case 14: {
                return this.created;
            }
            case 15: {
                return this.billingContact;
            }
            case 16: {
                return Strings.join(this.billingEmail, (String)", ");
            }
            case 17: {
                return this.billingEmailFormat;
            }
            case 18: {
                return this.technicalContact;
            }
            case 19: {
                return Strings.join(this.technicalEmail, (String)", ");
            }
            case 20: {
                return this.technicalEmailFormat;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getCountry_code() {
        return this.country;
    }

    public CountryCode getCountry() throws SQLException, IOException {
        CountryCode countryCode = this.table.getConnector().getPayment().getCountryCode().get(this.country);
        if (countryCode == null) {
            throw new SQLException("CountryCode not found: " + this.country);
        }
        return countryCode;
    }

    public UnmodifiableTimestamp getCreated() {
        return this.created;
    }

    public String getFax() {
        return this.fax;
    }

    public String getName() {
        return this.name;
    }

    public String getPhone() {
        return this.phone;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getState() {
        return this.state;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BUSINESS_PROFILES;
    }

    public String getTechnicalContact() {
        return this.technicalContact;
    }

    public Set<Email> getTechnicalEmail() {
        return this.technicalEmail;
    }

    public EmailFormat getTechnicalEmailFormat() {
        return this.technicalEmailFormat;
    }

    public String getZip() {
        return this.zip;
    }

    public static Set<Email> splitEmails(String value) throws ValidationException {
        List split = Strings.splitCommaSpace((String)value);
        LinkedHashSet emails = AoCollections.newLinkedHashSet((int)split.size());
        for (String s : split) {
            if ((s = s.trim()).isEmpty()) continue;
            emails.add(Email.valueOf((String)s));
        }
        return AoCollections.optimalUnmodifiableSet((Set)emails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Email> getEmailSet(Array array) throws SQLException, ValidationException {
        try {
            LinkedHashSet<Email> set = new LinkedHashSet<Email>();
            try (ResultSet result = array.getResultSet();){
                while (result.next()) {
                    Email email = Email.valueOf((String)result.getString(2));
                    if (set.add(email)) continue;
                    throw new SQLException("Email not unique: " + email);
                }
            }
            LinkedHashSet<Email> linkedHashSet = set;
            return linkedHashSet;
        }
        finally {
            array.free();
        }
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.accounting = Account.Name.valueOf(result.getString(pos++));
            this.priority = result.getInt(pos++);
            this.name = result.getString(pos++);
            this.isPrivate = result.getBoolean(pos++);
            this.phone = result.getString(pos++);
            this.fax = result.getString(pos++);
            this.address1 = result.getString(pos++);
            this.address2 = result.getString(pos++);
            this.city = result.getString(pos++);
            this.state = result.getString(pos++);
            this.country = result.getString(pos++);
            this.zip = result.getString(pos++);
            this.sendInvoice = result.getBoolean(pos++);
            this.created = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.billingContact = result.getString(pos++);
            String billingEmailArray = result.getString(pos++);
            try {
                this.billingEmail = Profile.splitEmails(billingEmailArray);
            }
            catch (ValidationException e) {
                throw new SQLException("billing_email = " + billingEmailArray, e);
            }
            this.billingEmailFormat = EmailFormat.valueOf(result.getString(pos++));
            this.technicalContact = result.getString(pos++);
            String technicalEmailArray = result.getString(pos++);
            try {
                this.technicalEmail = Profile.splitEmails(technicalEmailArray);
            }
            catch (ValidationException e) {
                throw new SQLException("technical_email = " + technicalEmailArray, e);
            }
            this.technicalEmailFormat = EmailFormat.valueOf(result.getString(pos++));
            Set<Email> billingEmailNew = Profile.getEmailSet(result.getArray("billingEmail{}"));
            if (!billingEmailNew.equals(this.billingEmail)) {
                throw new SQLException("billingEmailNew != billingEmail: " + billingEmailNew + " != " + this.billingEmail);
            }
            Set<Email> technicalEmailNew = Profile.getEmailSet(result.getArray("technicalEmail{}"));
            if (!technicalEmailNew.equals(this.technicalEmail)) {
                throw new SQLException("technicalEmailNew != technicalEmail: " + technicalEmailNew + " != " + this.technicalEmail);
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            int i;
            this.pkey = in.readCompressedInt();
            this.accounting = Account.Name.valueOf(in.readUTF()).intern();
            this.priority = in.readCompressedInt();
            this.name = in.readUTF();
            this.isPrivate = in.readBoolean();
            this.phone = in.readUTF();
            this.fax = in.readNullUTF();
            this.address1 = in.readUTF();
            this.address2 = in.readNullUTF();
            this.city = in.readUTF();
            this.state = InternUtils.intern((String)in.readNullUTF());
            this.country = in.readUTF().intern();
            this.zip = in.readNullUTF();
            this.sendInvoice = in.readBoolean();
            this.created = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.billingContact = in.readUTF();
            int size = in.readCompressedInt();
            LinkedHashSet emails = AoCollections.newLinkedHashSet((int)size);
            for (i = 0; i < size; ++i) {
                emails.add(Email.valueOf((String)in.readUTF()));
            }
            this.billingEmail = AoCollections.optimalUnmodifiableSet((Set)emails);
            this.billingEmailFormat = (EmailFormat)in.readEnum(EmailFormat.class);
            this.technicalContact = in.readUTF();
            size = in.readCompressedInt();
            emails = AoCollections.newLinkedHashSet((int)size);
            for (i = 0; i < size; ++i) {
                emails.add(Email.valueOf((String)in.readUTF()));
            }
            this.technicalEmail = AoCollections.optimalUnmodifiableSet((Set)emails);
            this.technicalEmailFormat = (EmailFormat)in.readEnum(EmailFormat.class);
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public boolean sendInvoice() {
        return this.sendInvoice;
    }

    @Override
    public String toStringImpl() {
        return this.name + " (" + this.priority + ')';
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        int size;
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.accounting.toString());
        out.writeCompressedInt(this.priority);
        out.writeUTF(this.name);
        out.writeBoolean(this.isPrivate);
        out.writeUTF(this.phone);
        out.writeNullUTF(this.fax);
        out.writeUTF(this.address1);
        out.writeNullUTF(this.address2);
        out.writeUTF(this.city);
        out.writeNullUTF(this.state);
        out.writeUTF(this.country);
        out.writeNullUTF(this.zip);
        out.writeBoolean(this.sendInvoice);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.created.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.created, (DataOutputStream)out);
        }
        out.writeUTF(this.billingContact);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_22) < 0) {
            out.writeUTF(Strings.join(this.billingEmail, (String)", "));
        } else {
            size = this.billingEmail.size();
            out.writeCompressedInt(size);
            for (Email email : this.billingEmail) {
                out.writeUTF(email.toString());
            }
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_20) >= 0) {
            out.writeEnum((Enum)this.billingEmailFormat);
        }
        out.writeUTF(this.technicalContact);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_22) < 0) {
            out.writeUTF(Strings.join(this.technicalEmail, (String)", "));
        } else {
            size = this.technicalEmail.size();
            out.writeCompressedInt(size);
            for (Email email : this.technicalEmail) {
                out.writeUTF(email.toString());
            }
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_20) >= 0) {
            out.writeEnum((Enum)this.technicalEmailFormat);
        }
    }

    public static enum EmailFormat {
        HTML,
        HTML_ONLY,
        TEXT;

    }
}

