/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.account;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.Email;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Profile;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public final class ProfileTable
extends CachedTableIntegerKey<Profile> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("accounting", true), new AoservTable.OrderBy("priority", false)};

    ProfileTable(AoservConnector connector) {
        super(connector, Profile.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addProfile(final Account business, final String name, final boolean isPrivate, final String phone, String fax, final String address1, String address2, final String city, String state, final String country, String zip, final boolean sendInvoice, final String billingContact, final Set<Email> billingEmail, final Profile.EmailFormat billingEmailFormat, final String technicalContact, final Set<Email> technicalEmail, final Profile.EmailFormat technicalEmailFormat) throws IOException, SQLException {
        if (fax != null && fax.length() == 0) {
            fax = null;
        }
        final String finalFax = fax;
        if (address2 != null && address2.length() == 0) {
            address2 = null;
        }
        final String finalAddress2 = address2;
        if (state != null && state.length() == 0) {
            state = null;
        }
        final String finalState = state;
        if (zip != null && zip.length() == 0) {
            zip = null;
        }
        final String finalZip = zip;
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.BUSINESS_PROFILES.ordinal());
                out.writeUTF(business.getName().toString());
                out.writeUTF(name);
                out.writeBoolean(isPrivate);
                out.writeUTF(phone);
                out.writeBoolean(finalFax != null);
                if (finalFax != null) {
                    out.writeUTF(finalFax);
                }
                out.writeUTF(address1);
                out.writeBoolean(finalAddress2 != null);
                if (finalAddress2 != null) {
                    out.writeUTF(finalAddress2);
                }
                out.writeUTF(city);
                out.writeBoolean(finalState != null);
                if (finalState != null) {
                    out.writeUTF(finalState);
                }
                out.writeUTF(country);
                out.writeBoolean(finalZip != null);
                if (finalZip != null) {
                    out.writeUTF(finalZip);
                }
                out.writeBoolean(sendInvoice);
                out.writeUTF(billingContact);
                out.writeCompressedInt(billingEmail.size());
                for (Email email : billingEmail) {
                    out.writeUTF(email.toString());
                }
                out.writeEnum((Enum)billingEmailFormat);
                out.writeUTF(technicalContact);
                out.writeCompressedInt(technicalEmail.size());
                for (Email email : technicalEmail) {
                    out.writeUTF(email.toString());
                }
                out.writeEnum((Enum)technicalEmailFormat);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                ProfileTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }

    @Override
    public Profile get(int pkey) throws IOException, SQLException {
        return (Profile)this.getUniqueRow(0, pkey);
    }

    Profile getProfile(Account account) throws IOException, SQLException {
        Account.Name account_name = account.getName();
        List cached = this.getRows();
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            Profile profile = (Profile)cached.get(c);
            if (!profile.getAccount_name().equals(account_name)) continue;
            return profile;
        }
        return null;
    }

    List<Profile> getProfiles(Account business) throws IOException, SQLException {
        return this.getIndexedRows(1, business.getName());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BUSINESS_PROFILES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) {
        String command = args[0];
        if (command.equalsIgnoreCase("add_business_profile")) {
            if (Aosh.checkParamCount("add_business_profile", args, 18, (PrintWriter)err)) {
                try {
                    out.println(this.connector.getSimpleClient().addProfile(Aosh.parseAccountingCode(args[1], "business"), args[2], Aosh.parseBoolean(args[3], "is_secure"), args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], Aosh.parseBoolean(args[12], "send_invoice"), args[13], Profile.splitEmails(args[14]), args[15], args[16], Profile.splitEmails(args[17]), args[18]));
                    out.flush();
                }
                catch (ValidationException | IOException | IllegalArgumentException | SQLException iae) {
                    err.print("aosh: add_business_profile: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        return false;
    }
}

