/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.account;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.io.FastExternalizable;
import com.aoapps.lang.io.FastObjectInput;
import com.aoapps.lang.io.FastObjectOutput;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoapps.net.Email;
import com.aoindustries.aoserv.client.CachedObject;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.CachedObjectUserNameKey;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.dto.UserName;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.Shell;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.linux.UserType;
import com.aoindustries.aoserv.client.mysql.User;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.password.PasswordProtected;
import com.aoindustries.aoserv.client.postgresql.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class User
extends CachedObjectUserNameKey<User>
implements PasswordProtected,
Removable,
Disablable {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, User.class);
    static final int COLUMN_USERNAME = 0;
    static final int COLUMN_PACKAGE = 1;
    static final String COLUMN_USERNAME_name = "username";
    private Account.Name packageName;
    private int disableLog;

    @Deprecated
    public User() {
    }

    public void addAdministrator(String name, String title, Date birthday, boolean isPrivate, String workPhone, String homePhone, String cellPhone, String fax, Email email, String address1, String address2, String city, String state, String country, String zip, boolean enableEmailSupport) throws IOException, SQLException {
        this.table.getConnector().getAccount().getAdministrator().addAdministrator(this, name, title, birthday, isPrivate, workPhone, homePhone, cellPhone, fax, email, address1, address2, city, state, country, zip, enableEmailSupport);
    }

    public void addLinuxAccount(Group primaryGroup, User.Gecos name, User.Gecos officeLocation, User.Gecos officePhone, User.Gecos homePhone, UserType typeObject, Shell shellObject) throws IOException, SQLException {
        this.addLinuxAccount(primaryGroup.getName(), name, officeLocation, officePhone, homePhone, typeObject.getName(), shellObject.getPath());
    }

    public void addLinuxAccount(Group.Name primaryGroup, User.Gecos name, User.Gecos officeLocation, User.Gecos officePhone, User.Gecos homePhone, String type, PosixPath shell) throws IOException, SQLException {
        this.table.getConnector().getLinux().getUser().addLinuxAccount(this, primaryGroup, name, officeLocation, officePhone, homePhone, type, shell);
    }

    public void addMysqlUser() throws IOException, SQLException {
        try {
            this.table.getConnector().getMysql().getUser().addMysqlUser(User.Name.valueOf(this.pkey.toString()));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public void addPostgresUser() throws IOException, SQLException {
        try {
            this.table.getConnector().getPostgresql().getUser().addPostgresUser(User.Name.valueOf(this.pkey.toString()));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int arePasswordsSet() throws IOException, SQLException {
        com.aoindustries.aoserv.client.postgresql.User pu;
        com.aoindustries.aoserv.client.mysql.User mu;
        com.aoindustries.aoserv.client.linux.User la;
        ArrayList<CachedObject> pps = new ArrayList<CachedObject>();
        Administrator ba = this.getAdministrator();
        if (ba != null) {
            pps.add(ba);
        }
        if ((la = this.getLinuxAccount()) != null) {
            pps.add(la);
        }
        if ((mu = this.getMysqlUser()) != null) {
            pps.add(mu);
        }
        if ((pu = this.getPostgresUser()) != null) {
            pps.add(pu);
        }
        return User.groupPasswordsSet(pps);
    }

    @Override
    public boolean canDisable() throws IOException, SQLException {
        if (this.disableLog != -1) {
            return false;
        }
        com.aoindustries.aoserv.client.linux.User la = this.getLinuxAccount();
        if (la != null && !la.isDisabled()) {
            return false;
        }
        com.aoindustries.aoserv.client.mysql.User mu = this.getMysqlUser();
        if (mu != null && !mu.isDisabled()) {
            return false;
        }
        com.aoindustries.aoserv.client.postgresql.User pu = this.getPostgresUser();
        return pu == null || pu.isDisabled();
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getPackage().isDisabled();
    }

    @Override
    public List<PasswordChecker.Result> checkPassword(String password) throws IOException, SQLException {
        List<PasswordChecker.Result> results;
        List<PasswordChecker.Result> results2;
        List<PasswordChecker.Result> results3;
        List<PasswordChecker.Result> results4;
        Administrator ba = this.getAdministrator();
        if (ba != null && PasswordChecker.hasResults(results4 = ba.checkPassword(password))) {
            return results4;
        }
        com.aoindustries.aoserv.client.linux.User la = this.getLinuxAccount();
        if (la != null && PasswordChecker.hasResults(results3 = la.checkPassword(password))) {
            return results3;
        }
        com.aoindustries.aoserv.client.mysql.User mu = this.getMysqlUser();
        if (mu != null && PasswordChecker.hasResults(results2 = mu.checkPassword(password))) {
            return results2;
        }
        com.aoindustries.aoserv.client.postgresql.User pu = this.getPostgresUser();
        if (pu != null && PasswordChecker.hasResults(results = pu.checkPassword(password))) {
            return results;
        }
        return PasswordChecker.getAllGoodResults();
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.USERNAMES, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.USERNAMES, this.pkey});
    }

    public Administrator getAdministrator() throws IOException, SQLException {
        return this.table.getConnector().getAccount().getAdministrator().get(this.pkey);
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.packageName;
            }
            case 2: {
                return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public com.aoindustries.aoserv.client.linux.User getLinuxAccount() throws IOException, SQLException {
        String username = this.pkey.toString();
        if (User.Name.validate(username).isValid()) {
            try {
                return this.table.getConnector().getLinux().getUser().get(User.Name.valueOf(username));
            }
            catch (ValidationException e) {
                throw new AssertionError("Already validated", e);
            }
        }
        return null;
    }

    public com.aoindustries.aoserv.client.mysql.User getMysqlUser() throws IOException, SQLException {
        String username = this.pkey.toString();
        if (User.Name.validate(username).isValid()) {
            try {
                return this.table.getConnector().getMysql().getUser().get(User.Name.valueOf(username));
            }
            catch (ValidationException e) {
                throw new AssertionError("Already validated", e);
            }
        }
        return null;
    }

    public Account.Name getPackage_name() {
        return this.packageName;
    }

    public Package getPackage() throws SQLException, IOException {
        Package packageObject = this.table.getConnector().getBilling().getPackage().get(this.packageName);
        if (packageObject == null) {
            throw new SQLException("Unable to find Package: " + this.packageName);
        }
        return packageObject;
    }

    public com.aoindustries.aoserv.client.postgresql.User getPostgresUser() throws IOException, SQLException {
        String username = this.pkey.toString();
        if (User.Name.validate(username).isValid()) {
            try {
                return this.table.getConnector().getPostgresql().getUser().get(User.Name.valueOf(username));
            }
            catch (ValidationException e) {
                throw new AssertionError("Already validated", e);
            }
        }
        return null;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.USERNAMES;
    }

    public Name getUsername() {
        return this.pkey;
    }

    public static int groupPasswordsSet(List<? extends PasswordProtected> pps) throws IOException, SQLException {
        int totalAll = 0;
        for (int c = 0; c < pps.size(); ++c) {
            int result = pps.get(c).arePasswordsSet();
            if (result == 1) {
                return 1;
            }
            if (result != 2) continue;
            ++totalAll;
        }
        return totalAll == pps.size() ? 2 : (totalAll == 0 ? 0 : 1);
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = Name.valueOf(result.getString(1));
            this.packageName = Account.Name.valueOf(result.getString(2));
            this.disableLog = result.getInt(3);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public boolean isUsed() throws IOException, SQLException {
        return this.getLinuxAccount() != null || this.getAdministrator() != null || this.getMysqlUser() != null || this.getPostgresUser() != null;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = Name.valueOf(in.readUTF()).intern();
            this.packageName = Account.Name.valueOf(in.readUTF()).intern();
            this.disableLog = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() throws SQLException, IOException {
        com.aoindustries.aoserv.client.postgresql.User pu;
        com.aoindustries.aoserv.client.mysql.User mu;
        Administrator ba;
        ArrayList reasons = new ArrayList();
        com.aoindustries.aoserv.client.linux.User la = this.getLinuxAccount();
        if (la != null) {
            reasons.add(new CannotRemoveReason<com.aoindustries.aoserv.client.linux.User>("Used by Linux account: " + la.getUsername().getUsername(), la));
        }
        if ((ba = this.getAdministrator()) != null) {
            reasons.add(new CannotRemoveReason<Administrator>("Used by Administrator: " + ba.getUsername().getUsername(), ba));
        }
        if ((mu = this.getMysqlUser()) != null) {
            reasons.add(new CannotRemoveReason<com.aoindustries.aoserv.client.mysql.User>("Used by MySQL user: " + mu.getUsername().getUsername(), mu));
        }
        if ((pu = this.getPostgresUser()) != null) {
            reasons.add(new CannotRemoveReason<com.aoindustries.aoserv.client.postgresql.User>("Used by PostgreSQL user: " + pu.getUsername().getUsername(), pu));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.USERNAMES, this.pkey});
    }

    @Override
    public void setPassword(String password) throws SQLException, IOException {
        com.aoindustries.aoserv.client.postgresql.User pu;
        com.aoindustries.aoserv.client.mysql.User mu;
        com.aoindustries.aoserv.client.linux.User la;
        Administrator ba = this.getAdministrator();
        if (ba != null) {
            ba.setPassword(password);
        }
        if ((la = this.getLinuxAccount()) != null) {
            la.setPassword(password);
        }
        if ((mu = this.getMysqlUser()) != null) {
            mu.setPassword(password);
        }
        if ((pu = this.getPostgresUser()) != null) {
            pu.setPassword(password);
        }
    }

    @Override
    public boolean canSetPassword() throws IOException, SQLException {
        if (this.disableLog != -1) {
            return false;
        }
        Administrator ba = this.getAdministrator();
        if (ba != null && !ba.canSetPassword()) {
            return false;
        }
        com.aoindustries.aoserv.client.linux.User la = this.getLinuxAccount();
        if (la != null && !la.canSetPassword()) {
            return false;
        }
        com.aoindustries.aoserv.client.mysql.User mu = this.getMysqlUser();
        if (mu != null && !mu.canSetPassword()) {
            return false;
        }
        com.aoindustries.aoserv.client.postgresql.User pu = this.getPostgresUser();
        if (pu != null && !pu.canSetPassword()) {
            return false;
        }
        return ba != null || la != null || mu != null || pu != null;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey.toString());
        out.writeUTF(this.packageName.toString());
        out.writeCompressedInt(this.disableLog);
    }

    public static class Name
    implements Comparable<Name>,
    FastExternalizable,
    DtoFactory<UserName>,
    Internable<Name> {
        public static final int MAX_LENGTH = 255;
        private static final ConcurrentMap<String, Name> interned = new ConcurrentHashMap<String, Name>();
        protected String name;
        private static final long serialVersionUID = -837866431257794645L;

        public static ValidationResult validate(String name) {
            ValidationResult result;
            if (name == null) {
                return new InvalidResult(RESOURCES, "Name.validate.isNull");
            }
            int len = name.length();
            if (len == 0) {
                return new InvalidResult(RESOURCES, "Name.validate.isEmpty");
            }
            if (len > 255) {
                return new InvalidResult(RESOURCES, "Name.validate.tooLong", new Serializable[]{Integer.valueOf(255), Integer.valueOf(len)});
            }
            char ch = name.charAt(0);
            if (ch < 'a' || ch > 'z') {
                return new InvalidResult(RESOURCES, "Name.validate.startAToZ");
            }
            boolean hasAt = false;
            block16: for (int c = 1; c < len; ++c) {
                ch = name.charAt(c);
                if (ch == ' ') {
                    return new InvalidResult(RESOURCES, "Name.validate.noSpace");
                }
                if (ch <= '!' || ch > '\u007f') {
                    return new InvalidResult(RESOURCES, "Name.validate.specialCharacter");
                }
                if (ch >= 'A' && ch <= 'Z') {
                    return new InvalidResult(RESOURCES, "Name.validate.noCapital");
                }
                switch (ch) {
                    case ',': {
                        return new InvalidResult(RESOURCES, "Name.validate.comma");
                    }
                    case ':': {
                        return new InvalidResult(RESOURCES, "Name.validate.colon");
                    }
                    case '(': {
                        return new InvalidResult(RESOURCES, "Name.validate.leftParen");
                    }
                    case ')': {
                        return new InvalidResult(RESOURCES, "Name.validate.rightParen");
                    }
                    case '[': {
                        return new InvalidResult(RESOURCES, "Name.validate.leftSquare");
                    }
                    case ']': {
                        return new InvalidResult(RESOURCES, "Name.validate.rightSquare");
                    }
                    case '\'': {
                        return new InvalidResult(RESOURCES, "Name.validate.apostrophe");
                    }
                    case '\"': {
                        return new InvalidResult(RESOURCES, "Name.validate.quote");
                    }
                    case '|': {
                        return new InvalidResult(RESOURCES, "Name.validate.verticalBar");
                    }
                    case '&': {
                        return new InvalidResult(RESOURCES, "Name.validate.ampersand");
                    }
                    case ';': {
                        return new InvalidResult(RESOURCES, "Name.validate.semicolon");
                    }
                    case '\\': {
                        return new InvalidResult(RESOURCES, "Name.validate.backslash");
                    }
                    case '/': {
                        return new InvalidResult(RESOURCES, "Name.validate.slash");
                    }
                    case '@': {
                        hasAt = true;
                        continue block16;
                    }
                }
            }
            if (hasAt && !(result = Email.validate((String)name)).isValid()) {
                return result;
            }
            return ValidResult.getInstance();
        }

        public static Name valueOf(String name) throws ValidationException {
            if (name == null) {
                return null;
            }
            return new Name(name, true);
        }

        protected Name(String name, boolean validate) throws ValidationException {
            this.name = name;
            if (validate) {
                this.validate();
            }
        }

        protected Name(String name) {
            ValidationResult result;
            assert ((result = Name.validate(name)).isValid()) : result.toString();
            this.name = name;
        }

        protected void validate() throws ValidationException {
            ValidationResult result = Name.validate(this.name);
            if (!result.isValid()) {
                throw new ValidationException(result);
            }
        }

        public final boolean equals(Object obj) {
            return obj instanceof Name && this.name.equals(((Name)obj).name);
        }

        public final int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public final int compareTo(Name other) {
            return this == other ? 0 : this.name.compareTo(other.name);
        }

        public final String toString() {
            return this.name;
        }

        public Name intern() {
            Name addMe;
            String internedId;
            Name existing = (Name)interned.get(this.name);
            if (existing == null && (existing = interned.putIfAbsent(internedId, addMe = this.name == (internedId = this.name.intern()) ? this : new Name(internedId))) == null) {
                existing = addMe;
            }
            return existing;
        }

        public UserName getDto() {
            return new UserName(this.name);
        }

        @Deprecated
        public Name() {
        }

        public long getSerialVersionUID() {
            return -837866431257794645L;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            FastObjectOutput fastOut = FastObjectOutput.wrap((ObjectOutput)out);
            try {
                fastOut.writeFastUTF(this.name);
            }
            finally {
                fastOut.unwrap();
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            if (this.name != null) {
                throw new IllegalStateException();
            }
            FastObjectInput fastIn = FastObjectInput.wrap((ObjectInput)in);
            try {
                this.name = fastIn.readFastUTF();
            }
            finally {
                fastIn.unwrap();
            }
            try {
                this.validate();
            }
            catch (ValidationException err) {
                InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
                newErr.initCause(err);
                throw newErr;
            }
        }
    }
}

