/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.account;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.validation.ValidationResult;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.account.CachedTableUserNameKey;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class UserTable
extends CachedTableUserNameKey<User> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("username", true)};

    UserTable(AoservConnector connector) {
        super(connector, User.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public void addUsername(Package packageObject, User.Name username) throws IOException, SQLException {
        this.connector.requestUpdateInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.USERNAMES, packageObject.getName(), username});
    }

    @Override
    public User get(User.Name username) throws IOException, SQLException {
        return (User)this.getUniqueRow(0, username);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.USERNAMES;
    }

    public List<User> getUsernames(Package pack) throws IOException, SQLException {
        return this.getIndexedRows(1, pack.getName());
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_username")) {
            if (Aosh.checkParamCount("add_username", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().addUsername(Aosh.parseAccountingCode(args[1], "package"), Aosh.parseUserName(args[2], "username"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("are_username_passwords_set")) {
            if (Aosh.checkParamCount("are_username_passwords_set", args, 1, (PrintWriter)err)) {
                int result = this.connector.getSimpleClient().areUsernamePasswordsSet(Aosh.parseUserName(args[1], "username"));
                if (result == 0) {
                    out.println("none");
                } else if (result == 1) {
                    out.println("some");
                } else if (result == 2) {
                    out.println("all");
                } else {
                    throw new RuntimeException("Unexpected value for result: " + result);
                }
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_username")) {
            if (Aosh.checkParamCount("check_username", args, 1, (PrintWriter)err)) {
                ValidationResult validationResult = User.Name.validate(args[1]);
                out.println(validationResult.isValid());
                out.flush();
                if (!validationResult.isValid()) {
                    err.print("aosh: check_username: ");
                    err.println(validationResult.toString());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_username_password")) {
            List<PasswordChecker.Result> results;
            if (Aosh.checkParamCount("check_username_password", args, 2, (PrintWriter)err) && PasswordChecker.hasResults(results = this.connector.getSimpleClient().checkUsernamePassword(Aosh.parseUserName(args[1], "username"), args[2]))) {
                PasswordChecker.printResults(results, (Appendable)out);
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_username")) {
            if (Aosh.checkParamCount("disable_username", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disableUsername(Aosh.parseUserName(args[1], "username"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_username")) {
            if (Aosh.checkParamCount("enable_username", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().enableUsername(Aosh.parseUserName(args[1], "username"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_username_available")) {
            if (Aosh.checkParamCount("is_username_available", args, 1, (PrintWriter)err)) {
                try {
                    out.println(this.connector.getSimpleClient().isUsernameAvailable(Aosh.parseUserName(args[1], "username")));
                    out.flush();
                }
                catch (IllegalArgumentException iae) {
                    err.print("aosh: is_username_available: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_username")) {
            if (Aosh.checkParamCount("remove_username", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeUsername(Aosh.parseUserName(args[1], "username"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_username_password")) {
            if (Aosh.checkParamCount("set_username_password", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setUsernamePassword(Aosh.parseUserName(args[1], "username"), args[2]);
            }
            return true;
        }
        return false;
    }

    public boolean isUsernameAvailable(User.Name username) throws SQLException, IOException {
        return this.connector.requestBooleanQuery(true, AoservProtocol.CommandId.IS_USERNAME_AVAILABLE, username);
    }
}

