/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.accounting;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectStringKey;
import com.aoindustries.aoserv.client.accounting.Bank;
import com.aoindustries.aoserv.client.accounting.BankTransaction;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public final class BankAccount
extends CachedObjectStringKey<BankAccount> {
    static final int COLUMN_NAME = 0;
    static final String COLUMN_NAME_name = "name";
    private String display;
    private String bank;
    private int depositDelay;
    private int withdrawalDelay;

    @Deprecated
    public BankAccount() {
    }

    public Bank getBank(long maximumCacheAge) throws SQLException, IOException {
        Bank bankObject = this.table.getConnector().getAccounting().getBank().get(this.bank);
        if (bankObject == null) {
            throw new SQLException("Bank not found: " + this.bank);
        }
        return bankObject;
    }

    public List<BankTransaction> getBankTransactions() throws IOException, SQLException {
        return this.table.getConnector().getAccounting().getBankTransaction().getBankTransactions(this);
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        if (i == 1) {
            return this.display;
        }
        if (i == 2) {
            return this.bank;
        }
        if (i == 3) {
            return this.depositDelay;
        }
        if (i == 4) {
            return this.withdrawalDelay;
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getDepositDelay() {
        return this.depositDelay;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getName() {
        return this.pkey;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BANK_ACCOUNTS;
    }

    public int getWithdrawalDelay() {
        return this.withdrawalDelay;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getString(1);
        this.display = result.getString(2);
        this.bank = result.getString(3);
        this.depositDelay = result.getInt(4);
        this.withdrawalDelay = result.getInt(5);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readUTF();
        this.display = in.readUTF();
        this.bank = in.readUTF();
        this.depositDelay = in.readCompressedInt();
        this.withdrawalDelay = in.readCompressedInt();
    }

    @Override
    public String toStringImpl() {
        return this.display;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        out.writeUTF(this.display);
        out.writeUTF(this.bank);
        out.writeCompressedInt(this.depositDelay);
        out.writeCompressedInt(this.withdrawalDelay);
    }
}

