/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.accounting;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.SQLUtility;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservObject;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.SingleTableObject;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.accounting.BankAccount;
import com.aoindustries.aoserv.client.accounting.BankTransactionType;
import com.aoindustries.aoserv.client.accounting.ExpenseCategory;
import com.aoindustries.aoserv.client.master.User;
import com.aoindustries.aoserv.client.payment.Processor;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public final class BankTransaction
extends AoservObject<Integer, BankTransaction>
implements SingleTableObject<Integer, BankTransaction> {
    static final int COLUMN_ID = 0;
    static final String COLUMN_ID_name = "id";
    static final String COLUMN_TIME_name = "time";
    private AoservTable<Integer, BankTransaction> table;
    private int id;
    private UnmodifiableTimestamp time;
    private String account;
    private String processor;
    private User.Name administrator;
    private String type;
    private String expenseCategory;
    private String description;
    private String checkNo;
    private int amount;
    private boolean confirmed;

    @Deprecated
    public BankTransaction() {
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof BankTransaction && ((BankTransaction)obj).id == this.id;
    }

    public User getAdministrator() throws SQLException, IOException {
        User obj = this.table.getConnector().getMaster().getUser().get(this.administrator);
        if (obj == null) {
            throw new SQLException("Unable to find MasterUser: " + this.administrator);
        }
        return obj;
    }

    public int getAmount() {
        return this.amount;
    }

    public BankAccount getBankAccount() throws SQLException, IOException {
        BankAccount bankAccountObject = this.table.getConnector().getAccounting().getBankAccount().get(this.account);
        if (bankAccountObject == null) {
            throw new SQLException("BankAccount not found: " + this.account);
        }
        return bankAccountObject;
    }

    public BankTransactionType getBankTransactionType() throws SQLException, IOException {
        BankTransactionType typeObject = this.table.getConnector().getAccounting().getBankTransactionType().get(this.type);
        if (typeObject == null) {
            throw new SQLException("BankTransactionType not found: " + this.type);
        }
        return typeObject;
    }

    public String getCheckNo() {
        return this.checkNo;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.time;
            }
            case 2: {
                return this.account;
            }
            case 3: {
                return this.processor;
            }
            case 4: {
                return this.administrator;
            }
            case 5: {
                return this.type;
            }
            case 6: {
                return this.expenseCategory;
            }
            case 7: {
                return this.description;
            }
            case 8: {
                return this.checkNo;
            }
            case 9: {
                return this.amount;
            }
            case 10: {
                return this.confirmed;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getDescription() {
        return this.description;
    }

    public ExpenseCategory getExpenseCategory() throws SQLException, IOException {
        if (this.expenseCategory == null) {
            return null;
        }
        ExpenseCategory cat = this.table.getConnector().getAccounting().getExpenseCategory().get(this.expenseCategory);
        if (cat == null) {
            throw new SQLException("ExpenseCategory not found: " + this.expenseCategory);
        }
        return cat;
    }

    public Processor getCreditCardProcessor() throws SQLException, IOException {
        if (this.processor == null) {
            return null;
        }
        Processor ccProcessor = this.table.getConnector().getPayment().getProcessor().get(this.processor);
        if (ccProcessor == null) {
            throw new SQLException("CreditCardProcessor not found: " + this.processor);
        }
        return ccProcessor;
    }

    @Override
    public Integer getKey() {
        return this.id;
    }

    @Override
    public AoservTable<Integer, BankTransaction> getTable() {
        return this.table;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BANK_TRANSACTIONS;
    }

    public int getId() {
        return this.id;
    }

    public UnmodifiableTimestamp getTime() {
        return this.time;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.id = result.getInt(pos++);
            this.time = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.account = result.getString(pos++);
            this.processor = result.getString(pos++);
            this.administrator = User.Name.valueOf(result.getString(pos++));
            this.type = result.getString(pos++);
            this.expenseCategory = result.getString(pos++);
            this.description = result.getString(pos++);
            this.checkNo = result.getString(pos++);
            this.amount = SQLUtility.parseDecimal2((String)result.getString(pos++));
            this.confirmed = result.getBoolean(pos++);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.id = in.readCompressedInt();
            this.time = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.account = in.readUTF().intern();
            this.processor = InternUtils.intern((String)in.readNullUTF());
            this.administrator = User.Name.valueOf(in.readUTF()).intern();
            this.type = in.readUTF().intern();
            this.expenseCategory = InternUtils.intern((String)in.readNullUTF());
            this.description = in.readUTF();
            this.checkNo = in.readNullUTF();
            this.amount = in.readCompressedInt();
            this.confirmed = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setTable(AoservTable<Integer, BankTransaction> table) {
        if (this.table != null) {
            throw new IllegalStateException("table already set");
        }
        this.table = table;
    }

    @Override
    public String toStringImpl() {
        return this.id + "|" + this.administrator + '|' + this.type + '|' + SQLUtility.formatDecimal2((int)this.amount);
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_17) <= 0) {
            out.writeLong(this.time.getTime());
            out.writeCompressedInt(this.id);
        } else {
            out.writeCompressedInt(this.id);
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
                out.writeLong(this.time.getTime());
            } else {
                SQLStreamables.writeTimestamp((Timestamp)this.time, (DataOutputStream)out);
            }
        }
        out.writeUTF(this.account);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_29) < 0) {
            out.writeNullUTF(null);
        } else {
            out.writeNullUTF(this.processor);
        }
        out.writeUTF(this.administrator.toString());
        out.writeUTF(this.type);
        out.writeNullUTF(this.expenseCategory);
        out.writeUTF(this.description);
        out.writeNullUTF(this.checkNo);
        out.writeCompressedInt(this.amount);
        out.writeBoolean(this.confirmed);
    }
}

