/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.aosh;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.util.ShellInterpreter;
import com.aoapps.lang.SysExits;
import com.aoapps.lang.exception.ConfigurationException;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoapps.net.Email;
import com.aoapps.net.HostAddress;
import com.aoapps.net.InetAddress;
import com.aoapps.net.Port;
import com.aoapps.net.Protocol;
import com.aoapps.sql.SQLUtility;
import com.aoindustries.aoserv.client.AoservClientConfiguration;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservObject;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.aosh.Command;
import com.aoindustries.aoserv.client.aosh.CommandTable;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.mysql.Database;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.mysql.User;
import com.aoindustries.aoserv.client.net.FirewallZone;
import com.aoindustries.aoserv.client.postgresql.Database;
import com.aoindustries.aoserv.client.postgresql.Server;
import com.aoindustries.aoserv.client.postgresql.User;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.schema.TableTable;
import com.aoindustries.aoserv.client.schema.Type;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.Console;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Aosh
extends ShellInterpreter {
    private static final Logger logger = Logger.getLogger(Aosh.class.getName());
    private static final Reader nullInput = new CharArrayReader(new char[0]);
    private final AoservConnector connector;
    private static final int numTables = Table.TableId.values().length;

    public Aosh(AoservConnector connector, Reader in, TerminalWriter out, TerminalWriter err) {
        super(in, out, err);
        this.connector = connector;
    }

    public Aosh(AoservConnector connector, Reader in, TerminalWriter out, TerminalWriter err, String ... args) {
        super(in, out, err, args);
        this.connector = connector;
    }

    public static boolean checkMinParamCount(String function, String[] args, int minCount, PrintWriter err) {
        int paramCount = args.length - 1;
        if (paramCount < minCount) {
            err.print("aosh: ");
            err.print(function);
            err.println(": not enough parameters");
            err.flush();
            return false;
        }
        return true;
    }

    public static boolean checkParamCount(String function, String[] args, int requiredCount, PrintWriter err) {
        return Aosh.checkRangeParamCount(function, args, requiredCount, requiredCount, err);
    }

    public static boolean checkRangeParamCount(String function, String[] args, int minCount, int maxCount, PrintWriter err) {
        int paramCount = args.length - 1;
        if (paramCount < minCount) {
            err.print("aosh: ");
            err.print(function);
            err.println(": not enough parameters");
            err.flush();
            return false;
        }
        if (paramCount > maxCount) {
            err.print("aosh: ");
            err.print(function);
            err.println(": too many parameters");
            err.flush();
            return false;
        }
        return true;
    }

    private void echo(String[] args) {
        for (int c = 1; c < args.length; ++c) {
            if (c > 1) {
                this.out.print(' ');
            }
            this.out.print(args[c]);
        }
        this.out.println();
        this.out.flush();
    }

    public static String executeCommand(AoservConnector connector, String[] args) throws IOException, SQLException {
        StringWriter buff = new StringWriter();
        TerminalWriter out = new TerminalWriter((Writer)buff);
        out.setEnabled(false);
        Aosh sh = new Aosh(connector, nullInput, out, out);
        sh.handleCommand(args);
        out.flush();
        return buff.toString();
    }

    protected String getName() {
        return "aosh";
    }

    protected String getPrompt() throws SQLException, IOException {
        return '[' + this.connector.getCurrentAdministrator().toString() + '@' + this.connector.getHostname() + "]$ ";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleCommand(String[] args) throws IOException, SQLException {
        int argCount = args.length;
        if (argCount <= 0) return true;
        String command = args[0];
        if ("exit".equalsIgnoreCase(command)) {
            if (argCount == 1) return false;
            this.err.println("aosh: exit: too many parameters");
            this.err.flush();
            return true;
        } else if ("clear".equalsIgnoreCase(command)) {
            this.clear(args);
            return true;
        } else if ("echo".equalsIgnoreCase(command)) {
            this.echo(args);
            return true;
        } else if ("invalidate".equalsIgnoreCase(command)) {
            this.invalidate(args);
            return true;
        } else if ("jobs".equalsIgnoreCase(command)) {
            this.jobs(args);
            return true;
        } else if ("ping".equalsIgnoreCase(command)) {
            this.ping(args);
            return true;
        } else if ("repeat".equalsIgnoreCase(command)) {
            this.repeat(args);
            return true;
        } else if ("sleep".equalsIgnoreCase(command)) {
            this.sleep(args);
            return true;
        } else if ("su".equalsIgnoreCase(command)) {
            this.su(args);
            return true;
        } else if ("time".equalsIgnoreCase(command)) {
            this.time(args);
            return true;
        } else if ("whoami".equalsIgnoreCase(command)) {
            this.whoami(args);
            return true;
        } else {
            AoservTable<?, AoservObject<?, ?>> table;
            boolean done = false;
            CommandTable commandTable = this.connector.getAosh().getCommand();
            Command aoshCommand = commandTable.get(command);
            if (aoshCommand == null) {
                for (Command com : commandTable.getRows()) {
                    if (!com.getCommand().equalsIgnoreCase(command)) continue;
                    aoshCommand = com;
                    break;
                }
            }
            if (aoshCommand != null && !(done = (table = aoshCommand.getTable(this.connector).getAoservTable(this.connector)).handleCommand(args, this.in, this.out, this.err, this.isInteractive()))) {
                throw new RuntimeException("Command found, but command not processed.  command='" + command + "', table='" + table.getTableName() + '\'');
            }
            if (done) return true;
            this.err.println("aosh: " + command + ": command not found");
            this.err.flush();
        }
        return true;
    }

    private void invalidate(String[] args) throws IllegalArgumentException, SQLException, IOException {
        if (Aosh.checkRangeParamCount("invalidate", args, 1, 2, (PrintWriter)this.err)) {
            String tableName = args[1];
            TableTable schemaTableTable = this.connector.getSchema().getTable();
            int tableId = -1;
            for (int d = 0; d < numTables; ++d) {
                if (!schemaTableTable.get(d).getName().equalsIgnoreCase(tableName)) continue;
                tableId = d;
                break;
            }
            if (tableId >= 0) {
                this.connector.getSimpleClient().invalidate(tableId, args.length > 2 ? args[2] : null);
            } else {
                this.err.print("aosh: invalidate: unable to find table: ");
                this.err.println(tableName);
                this.err.flush();
            }
        }
    }

    public static void main(String[] args) {
        TerminalWriter out = new TerminalWriter((Writer)new BufferedWriter(new OutputStreamWriter(System.out)));
        TerminalWriter err = System.out == System.err ? out : new TerminalWriter((Writer)new BufferedWriter(new OutputStreamWriter(System.err)));
        try {
            User.Name username = Aosh.getConfigUsername(System.in, err);
            String password = Aosh.getConfigPassword(System.in, err);
            AoservConnector connector = AoservConnector.getConnector(username, password);
            Aosh aosh = new Aosh(connector, new BufferedReader(new InputStreamReader(System.in)), out, err, args);
            aosh.run();
            if (aosh.isInteractive()) {
                out.println();
                out.flush();
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINE, null, t);
            err.println("aosh: unable to connect: " + t.getMessage());
            err.flush();
            System.exit(SysExits.getSysExit((Throwable)t));
        }
    }

    public static User.Name getConfigUsername(InputStream in, TerminalWriter err) throws ConfigurationException, IOException {
        User.Name username = AoservClientConfiguration.getUsername();
        if (username == null) {
            try {
                String prompt = "Username: ";
                Console console = System.console();
                if (console == null) {
                    err.print(prompt);
                    err.flush();
                    username = User.Name.valueOf(Aosh.readLine(in));
                    err.flush();
                } else {
                    username = User.Name.valueOf(console.readLine(prompt, new Object[0]));
                    if (username == null) {
                        throw new EOFException("End-of-file reading username");
                    }
                }
            }
            catch (ValidationException e) {
                throw new IOException(e);
            }
        }
        return username;
    }

    public static String getConfigPassword(InputStream in, TerminalWriter err) throws ConfigurationException, IOException {
        String password = AoservClientConfiguration.getPassword();
        if (password == null || password.isEmpty()) {
            String prompt = "Password: ";
            Console console = System.console();
            if (console == null) {
                err.print(prompt);
                err.flush();
                password = Aosh.readLine(in);
                err.flush();
            } else {
                char[] pwchars = console.readPassword(prompt, new Object[0]);
                if (pwchars == null) {
                    throw new EOFException("End-of-file reading password");
                }
                password = new String(pwchars);
            }
        }
        return password;
    }

    protected Aosh newShellInterpreter(Reader in, TerminalWriter out, TerminalWriter err, String[] args) {
        return new Aosh(this.connector, in, out, err, args);
    }

    public static Account.Name parseAccountingCode(String s, String field) {
        try {
            return Account.Name.valueOf(s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for accounting (" + field + "): " + s, err);
        }
    }

    public static BigDecimal parseBigDecimal(String s, String field) {
        try {
            return new BigDecimal(s);
        }
        catch (NumberFormatException err) {
            throw new IllegalArgumentException("Invalid argument for big_decimal (" + field + "): " + s, err);
        }
    }

    public static boolean parseBoolean(String s, String field) {
        if ("true".equalsIgnoreCase(s) || "t".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "y".equalsIgnoreCase(s) || "vang".equalsIgnoreCase(s) || "da".equalsIgnoreCase(s) || "si".equalsIgnoreCase(s) || "oui".equalsIgnoreCase(s) || "ja".equalsIgnoreCase(s) || "nam".equalsIgnoreCase(s)) {
            return true;
        }
        if ("false".equalsIgnoreCase(s) || "f".equalsIgnoreCase(s) || "no".equalsIgnoreCase(s) || "n".equalsIgnoreCase(s) || "khong".equalsIgnoreCase(s) || "nyet".equalsIgnoreCase(s) || "non".equalsIgnoreCase(s) || "nien".equalsIgnoreCase(s) || "la".equalsIgnoreCase(s)) {
            return false;
        }
        throw new IllegalArgumentException("Invalid argument for boolean (" + field + "): " + s);
    }

    public static Date parseDate(String s, String field) {
        try {
            return SQLUtility.parseDate((String)s, (TimeZone)Type.DATE_TIME_ZONE);
        }
        catch (NumberFormatException err) {
            throw new IllegalArgumentException("Invalid argument for date (" + field + "): " + s, err);
        }
    }

    public static FirewallZone.Name parseFirewalldZoneName(String s, String field) {
        try {
            return FirewallZone.Name.valueOf(s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for firewalld zone (" + field + "): " + s, err);
        }
    }

    public static HostAddress parseHostAddress(String s, String field) {
        try {
            return HostAddress.valueOf((String)s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for host address (" + field + "): " + s, err);
        }
    }

    public static int parseInt(String s, String field) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException err) {
            throw new IllegalArgumentException("Invalid argument for int (" + field + "): " + s, err);
        }
    }

    public static float parseFloat(String s, String field) {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException err) {
            throw new IllegalArgumentException("Invalid argument for float (" + field + "): " + s, err);
        }
    }

    public static long parseLong(String s, String field) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException err) {
            throw new IllegalArgumentException("Invalid argument for long (" + field + "): " + s, err);
        }
    }

    public static int parseDecimal3(String s, String field) {
        try {
            return SQLUtility.parseDecimal3((String)s);
        }
        catch (NumberFormatException err) {
            throw new IllegalArgumentException("Invalid argument for decimal (" + field + "): " + s, err);
        }
    }

    public static int parseOctalInt(String s, String field) {
        try {
            return Integer.parseInt(s, 8);
        }
        catch (NumberFormatException err) {
            throw new IllegalArgumentException("Invalid argument for octal int (" + field + "): " + s, err);
        }
    }

    public static long parseOctalLong(String s, String field) {
        try {
            return Long.parseLong(s, 8);
        }
        catch (NumberFormatException err) {
            throw new IllegalArgumentException("Invalid argument for octal long (" + field + "): " + s, err);
        }
    }

    public static int parseDecimal2(String s, String field) {
        try {
            return SQLUtility.parseDecimal2((String)s);
        }
        catch (NumberFormatException err) {
            throw new IllegalArgumentException("Invalid argument for decimal (" + field + "): " + s, err);
        }
    }

    public static short parseShort(String s, String field) {
        try {
            return Short.parseShort(s);
        }
        catch (NumberFormatException err) {
            throw new IllegalArgumentException("Invalid argument for short (" + field + "): " + s, err);
        }
    }

    public static DomainName parseDomainName(String s, String field) {
        try {
            return DomainName.valueOf((String)s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for domain_name (" + field + "): " + s, err);
        }
    }

    public static Email parseEmail(String s, String field) {
        try {
            return Email.valueOf((String)s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for email address (" + field + "): " + s, err);
        }
    }

    public static User.Gecos parseGecos(String s, String field) {
        try {
            return User.Gecos.valueOf(s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for gecos (" + field + "): " + s, err);
        }
    }

    public static Group.Name parseGroupName(String s, String field) {
        try {
            return Group.Name.valueOf(s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for group (" + field + "): " + s, err);
        }
    }

    public static InetAddress parseInetAddress(String s, String field) {
        try {
            return InetAddress.valueOf((String)s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for ip_address (" + field + "): " + s, err);
        }
    }

    public static User.Name parseLinuxUserName(String s, String field) {
        try {
            return User.Name.valueOf(s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for Linux username (" + field + "): " + s, err);
        }
    }

    public static Database.Name parseMysqlDatabaseName(String s, String field) {
        try {
            return Database.Name.valueOf(s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for MySQL database name (" + field + "): " + s, err);
        }
    }

    public static Server.Name parseMysqlServerName(String s, String field) {
        try {
            return Server.Name.valueOf(s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for MySQL server name (" + field + "): " + s, err);
        }
    }

    public static User.Name parseMysqlUserName(String s, String field) {
        try {
            return User.Name.valueOf(s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for MySQL username (" + field + "): " + s, err);
        }
    }

    public static Port parsePort(String port, String portField, String protocol, String protocolField) {
        Protocol protocolObj;
        int portInt = Aosh.parseInt(port, portField);
        try {
            protocolObj = Protocol.valueOf((String)protocol.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid argument for protocol (" + protocolField + "): " + protocol, e);
        }
        try {
            return Port.valueOf((int)portInt, (Protocol)protocolObj);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for port (" + portField + "): " + port, err);
        }
    }

    public static Database.Name parsePostgresDatabaseName(String s, String field) {
        try {
            return Database.Name.valueOf(s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for PostgreSQL database name (" + field + "): " + s, err);
        }
    }

    public static Server.Name parsePostgresServerName(String s, String field) {
        try {
            return Server.Name.valueOf(s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for PostgreSQL server name (" + field + "): " + s, err);
        }
    }

    public static User.Name parsePostgresUserName(String s, String field) {
        try {
            return User.Name.valueOf(s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for PostgreSQL username (" + field + "): " + s, err);
        }
    }

    public static PosixPath parseUnixPath(String s, String field) {
        try {
            return PosixPath.valueOf(s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for POSIX path (" + field + "): " + s, err);
        }
    }

    public static User.Name parseUserName(String s, String field) {
        try {
            return User.Name.valueOf(s);
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Invalid argument for username (" + field + "): " + s, err);
        }
    }

    private void ping(String[] args) throws IOException, SQLException {
        if (Aosh.checkParamCount("ping", args, 0, (PrintWriter)this.err)) {
            this.out.print(this.connector.getSimpleClient().ping());
            this.out.println(" ms");
            this.out.flush();
        }
    }

    public static String readLine(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        Aosh.readLine(in, sb);
        return sb.toString();
    }

    public static void readLine(InputStream in, StringBuilder sb) throws IOException {
        int ch;
        sb.setLength(0);
        while ((ch = in.read()) != -1 && ch != 10) {
            if (ch == 13) continue;
            sb.append((char)ch);
        }
    }

    private void repeat(String[] args) throws IOException, SQLException {
        block6: {
            int argCount = args.length;
            if (argCount > 2) {
                try {
                    int count = Integer.parseInt(args[1]);
                    if (count >= 0) {
                        String[] newArgs = new String[argCount - 2];
                        System.arraycopy(args, 2, newArgs, 0, argCount - 2);
                        for (int c = 0; c < count; ++c) {
                            this.handleCommand(newArgs);
                        }
                        break block6;
                    }
                    this.err.print("aosh: repeat: invalid loop count: ");
                    this.err.println(count);
                    this.err.flush();
                }
                catch (NumberFormatException nfe) {
                    this.err.print("aosh: repeat: invalid loop count: ");
                    this.err.println(args[1]);
                    this.err.flush();
                }
            } else {
                this.err.println("aosh: repeat: not enough parameters");
                this.err.flush();
            }
        }
    }

    private void sleep(String[] args) {
        if (args.length > 1) {
            try {
                for (int c = 1; c < args.length; ++c) {
                    try {
                        long time = 1000L * (long)Integer.parseInt(args[c]);
                        if (time < 0L) {
                            this.err.println("aosh: sleep: invalid time interval: " + args[c]);
                            this.err.flush();
                            continue;
                        }
                        Thread.sleep(time);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        this.err.println("aosh: sleep: invalid time interval: " + args[c]);
                        this.err.flush();
                    }
                }
            }
            catch (InterruptedException ie) {
                this.status = "Interrupted";
                this.err.println("aosh: sleep: interrupted");
                this.err.flush();
                Thread.currentThread().interrupt();
            }
        } else {
            this.err.println("aosh: sleep: too few arguments");
            this.err.flush();
        }
    }

    private void su(String[] args) throws IOException {
        int argCount = args.length;
        if (argCount >= 2) {
            try {
                String[] newArgs = new String[argCount + (this.isInteractive() ? 0 : -1)];
                int pos = 0;
                if (this.isInteractive()) {
                    newArgs[pos++] = "-i";
                }
                newArgs[pos++] = "--";
                System.arraycopy(args, 2, newArgs, pos, argCount - 2);
                new Aosh(this.connector.switchUsers(User.Name.valueOf(args[1])), this.in, this.out, this.err, newArgs).run();
            }
            catch (ValidationException e) {
                this.err.println("aosh: su: " + e.getResult().toString());
                this.err.flush();
            }
        } else {
            this.err.println("aosh: su: not enough parameters");
            this.err.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void time(String[] args) throws IOException, SQLException {
        int argCount = args.length;
        if (argCount > 1) {
            String[] newArgs = new String[argCount - 1];
            System.arraycopy(args, 1, newArgs, 0, argCount - 1);
            long startTime = System.currentTimeMillis();
            try {
                this.handleCommand(newArgs);
            }
            finally {
                long timeSpan = System.currentTimeMillis() - startTime;
                int mins = (int)(timeSpan / 60000L);
                int secs = (int)(timeSpan % 60000L);
                this.out.println();
                this.out.print("real    ");
                this.out.print(mins);
                this.out.print('m');
                this.out.print(SQLUtility.formatDecimal3((int)secs));
                this.out.println('s');
                this.out.flush();
            }
        } else {
            this.err.println("aosh: time: not enough parameters");
            this.err.flush();
        }
    }

    private void whoami(String[] args) throws SQLException, IOException {
        if (args.length == 1) {
            this.out.println((Object)this.connector.getCurrentAdministrator().getUsername().getUsername());
            this.out.flush();
        } else {
            this.err.println("aosh: whoami: too many parameters");
            this.err.flush();
        }
    }
}

