/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.aosh;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.GlobalTableStringKey;
import com.aoindustries.aoserv.client.aosh.Command;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.schema.TableTable;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CommandTable
extends GlobalTableStringKey<Command> {
    private static final String GLOBAL_COMMANDS = "[[GLOBAL]]";
    private final Map<String, List<Command>> tableCommands = new HashMap<String, List<Command>>();
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("command", true)};
    private static final int numTables = Table.TableId.values().length;

    CommandTable(AoservConnector connector) {
        super(connector, Command.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Command> getAoshCommands(Table table) throws IOException, SQLException {
        CommandTable commandTable = this;
        synchronized (commandTable) {
            String name = table == null ? GLOBAL_COMMANDS : table.getName();
            List<Command> list = this.tableCommands.get(name);
            if (list != null) {
                return list;
            }
            List cached = this.getRows();
            ArrayList<Command> matches = new ArrayList();
            int size = cached.size();
            for (int c = 0; c < size; ++c) {
                Command command = (Command)cached.get(c);
                if (!(table == null ? command.getTable_name() == null : name.equals(command.getTable_name()))) continue;
                matches.add(command);
            }
            matches = Collections.unmodifiableList(matches);
            this.tableCommands.put(name, matches);
            return matches;
        }
    }

    public List<Command> getGlobalAoshCommands() throws IOException, SQLException {
        return this.getAoshCommands(null);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.AOSH_COMMANDS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("help") || "?".equals(command)) {
            int argCount = args.length;
            if (argCount == 1) {
                TableTable schemaTableTable = this.connector.getSchema().getTable();
                for (int c = -1; c < numTables; ++c) {
                    List<Command> commands;
                    String title;
                    if (c == -1) {
                        title = "Global Commands:";
                        commands = this.getGlobalAoshCommands();
                    } else {
                        Table schemaTable = schemaTableTable.get(c);
                        title = schemaTable.getDisplay() + ':';
                        commands = schemaTable.getAoshCommands(this.connector);
                    }
                    this.printHelpList(out, title, commands, true, c >= 0);
                }
                out.flush();
            } else if (argCount == 2) {
                if ("syntax".equalsIgnoreCase(args[1])) {
                    TableTable schemaTableTable = this.connector.getSchema().getTable();
                    for (int c = -1; c < numTables; ++c) {
                        List<Command> commands;
                        String title;
                        if (c == -1) {
                            title = "Global Commands:";
                            commands = this.getGlobalAoshCommands();
                        } else {
                            Table schemaTable = schemaTableTable.get(c);
                            title = schemaTable.getDisplay() + ':';
                            commands = schemaTable.getAoshCommands(this.connector);
                        }
                        this.printHelpList(out, title, commands, false, c >= 0);
                    }
                    out.flush();
                } else {
                    String comName = args[1];
                    Command aoshCommand = this.get(comName);
                    if (aoshCommand == null) {
                        for (Command com : this.getRows()) {
                            if (!com.getCommand().equalsIgnoreCase(comName)) continue;
                            aoshCommand = com;
                            break;
                        }
                    }
                    if (aoshCommand != null) {
                        aoshCommand.printCommandHelp(out);
                        out.flush();
                    } else {
                        err.print("aosh: help: help on command not found: ");
                        err.println(comName);
                        err.flush();
                    }
                }
            } else {
                err.println("aosh: help: too many parameters");
                err.flush();
            }
            return true;
        }
        return false;
    }

    private void printHelpList(TerminalWriter out, String title, List<Command> commands, boolean shortOrSchema, boolean println) throws IOException {
        int len = commands.size();
        if (len > 0) {
            if (println) {
                out.println();
            }
            out.boldOn();
            out.println(title);
            out.attributesOff();
            for (int c = 0; c < len; ++c) {
                Command aoshCom = commands.get(c);
                String command = aoshCom.getCommand();
                out.print("    ");
                out.print(command);
                int space = Math.max(1, 40 - command.length());
                for (int d = 0; d < space; ++d) {
                    out.print((char)(d > 0 && d < space - 1 ? 46 : 32));
                }
                String desc = shortOrSchema ? aoshCom.getDescription() : aoshCom.getSyntax();
                Command.printNoHtml(out, desc);
                out.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        CommandTable commandTable = this;
        synchronized (commandTable) {
            this.tableCommands.clear();
        }
    }

    @Override
    public Command get(String command) throws IOException, SQLException {
        return (Command)this.getUniqueRow(0, command);
    }
}

