/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class BackupPartition
extends CachedObjectIntegerKey<BackupPartition> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_AO_SERVER = 1;
    static final String COLUMN_AO_SERVER_name = "ao_server";
    static final String COLUMN_PATH_name = "path";
    private int aoServer;
    private PosixPath path;
    private boolean enabled;
    private boolean quotaEnabled;

    @Deprecated
    public BackupPartition() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.aoServer;
            }
            case 2: {
                return this.path;
            }
            case 3: {
                return this.enabled;
            }
            case 4: {
                return this.quotaEnabled;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public long getDiskTotalSize() throws IOException, SQLException {
        return this.table.getConnector().requestLongQuery(true, AoservProtocol.CommandId.GET_BACKUP_PARTITION_DISK_TOTAL_SIZE, this.pkey);
    }

    public long getDiskUsedSize() throws IOException, SQLException {
        return this.table.getConnector().requestLongQuery(true, AoservProtocol.CommandId.GET_BACKUP_PARTITION_DISK_USED_SIZE, this.pkey);
    }

    public Server getLinuxServer() throws SQLException, IOException {
        Server ao = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (ao == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return ao;
    }

    public PosixPath getPath() {
        return this.path;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BACKUP_PARTITIONS;
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getLinuxServer().getHostname() + ":" + this.path;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.aoServer = result.getInt(2);
            this.path = PosixPath.valueOf(result.getString(3));
            this.enabled = result.getBoolean(4);
            this.quotaEnabled = result.getBoolean(5);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isQuotaEnabled() {
        return this.quotaEnabled;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.aoServer = in.readCompressedInt();
            this.path = PosixPath.valueOf(in.readUTF()).intern();
            this.enabled = in.readBoolean();
            this.quotaEnabled = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.aoServer);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeUTF(this.path.toString());
        }
        out.writeUTF(this.path.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeLong(0x20000000L);
            out.writeLong(0x40000000L);
        }
        out.writeBoolean(this.enabled);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_117) >= 0 && protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeCompressedInt(1);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_31) >= 0) {
            out.writeBoolean(this.quotaEnabled);
        }
    }
}

