/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.backup.BackupPartition;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class BackupPartitionTable
extends CachedTableIntegerKey<BackupPartition> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("ao_server.hostname", true), new AoservTable.OrderBy("path", true)};

    BackupPartitionTable(AoservConnector connector) {
        super(connector, BackupPartition.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public BackupPartition get(int pkey) throws IOException, SQLException {
        return (BackupPartition)this.getUniqueRow(0, pkey);
    }

    public List<BackupPartition> getBackupPartitions(Server ao) throws IOException, SQLException {
        return this.getIndexedRows(1, ao.getPkey());
    }

    public BackupPartition getBackupPartitionForPath(Server ao, String path) throws IOException, SQLException {
        List<BackupPartition> cached = this.getBackupPartitions(ao);
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            BackupPartition bp = cached.get(c);
            if (!bp.getPath().toString().equals(path)) continue;
            return bp;
        }
        return null;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BACKUP_PARTITIONS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("get_backup_partition_total_size")) {
            if (Aosh.checkParamCount("get_backup_partition_total_size", args, 2, (PrintWriter)err)) {
                long size = this.connector.getSimpleClient().getBackupPartitionTotalSize(args[1], args[2]);
                if (size == -1L) {
                    out.println("Server unavailable");
                } else {
                    out.println(size);
                }
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("get_backup_partition_used_size")) {
            if (Aosh.checkParamCount("get_backup_partition_used_size", args, 2, (PrintWriter)err)) {
                long size = this.connector.getSimpleClient().getBackupPartitionUsedSize(args[1], args[2]);
                if (size == -1L) {
                    out.println("Server unavailable");
                } else {
                    out.println(size);
                }
                out.flush();
            }
            return true;
        }
        return false;
    }
}

