/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservObject;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.SingleTableObject;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class BackupReport
extends AoservObject<Integer, BackupReport>
implements SingleTableObject<Integer, BackupReport> {
    static final int COLUMN_PKEY = 0;
    static final String COLUMN_DATE_name = "date";
    static final String COLUMN_SERVER_name = "server";
    static final String COLUMN_PACKAGE_name = "package";
    public static final int BACKUP_REPORT_HOUR = 2;
    public static final int BACKUP_REPORT_MINUTE = 15;
    public static final int MAX_REPORT_AGE = 1827;
    private int pkey;
    private int host_id;
    private int package_id;
    private long date;
    private int fileCount;
    private long diskSize;
    private AoservTable<Integer, BackupReport> table;

    @Deprecated
    public BackupReport() {
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof BackupReport && ((BackupReport)obj).pkey == this.pkey;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.host_id;
            }
            case 2: {
                return this.package_id;
            }
            case 3: {
                return this.getDate();
            }
            case 4: {
                return this.fileCount;
            }
            case 5: {
                return this.diskSize;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getPkey() {
        return this.pkey;
    }

    public int getHost_id() {
        return this.host_id;
    }

    public Host getHost() throws SQLException, IOException {
        Host se = this.table.getConnector().getNet().getHost().get(this.host_id);
        if (se == null) {
            throw new SQLException("Unable to find Host: " + this.host_id);
        }
        return se;
    }

    public int getPackage_id() {
        return this.package_id;
    }

    public Package getPackage() throws IOException, SQLException {
        Package pk = this.table.getConnector().getBilling().getPackage().get(this.package_id);
        if (pk == null) {
            throw new SQLException("Unable to find Package: " + this.package_id);
        }
        return pk;
    }

    public Date getDate() {
        return new Date(this.date);
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public long getDiskSize() {
        return this.diskSize;
    }

    @Override
    public Integer getKey() {
        return this.pkey;
    }

    @Override
    public AoservTable<Integer, BackupReport> getTable() {
        return this.table;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BACKUP_REPORTS;
    }

    @Override
    public int hashCode() {
        return this.pkey;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.host_id = result.getInt(2);
        this.package_id = result.getInt(3);
        this.date = result.getDate(4).getTime();
        this.fileCount = result.getInt(5);
        this.diskSize = result.getLong(6);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.host_id = in.readCompressedInt();
        this.package_id = in.readCompressedInt();
        this.date = in.readLong();
        this.fileCount = in.readInt();
        this.diskSize = in.readLong();
    }

    @Override
    public void setTable(AoservTable<Integer, BackupReport> table) {
        if (this.table != null) {
            throw new IllegalStateException("table already set");
        }
        this.table = table;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.host_id);
        out.writeCompressedInt(this.package_id);
        out.writeLong(this.date);
        out.writeInt(this.fileCount);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeLong(0L);
            out.writeLong(0L);
        }
        out.writeLong(this.diskSize);
    }
}

