/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.backup.BackupReport;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class BackupReportTable
extends AoservTable<Integer, BackupReport> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("date", false), new AoservTable.OrderBy("server.package.name", true), new AoservTable.OrderBy("server.name", true), new AoservTable.OrderBy("package.name", true)};

    BackupReportTable(AoservConnector connector) {
        super(connector, BackupReport.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    @Deprecated
    public BackupReport get(Object pkey) throws IOException, SQLException {
        if (pkey == null) {
            return null;
        }
        return this.get((Integer)pkey);
    }

    public BackupReport get(int pkey) throws IOException, SQLException {
        return (BackupReport)this.getObject(true, AoservProtocol.CommandId.GET_OBJECT, new Object[]{Table.TableId.BACKUP_REPORTS, pkey});
    }

    public List<BackupReport> getBackupReports(Package pk) throws IOException, SQLException {
        int package_id = pk.getPkey();
        List cached = this.getRows();
        int size = cached.size();
        ArrayList<BackupReport> matches = new ArrayList<BackupReport>(size);
        for (int c = 0; c < size; ++c) {
            BackupReport br = (BackupReport)cached.get(c);
            if (br.getPackage_id() != package_id) continue;
            matches.add(br);
        }
        return matches;
    }

    public List<BackupReport> getBackupReports(Host host) throws IOException, SQLException {
        int host_id = host.getPkey();
        List cached = this.getRows();
        int size = cached.size();
        ArrayList<BackupReport> matches = new ArrayList<BackupReport>(size);
        for (int c = 0; c < size; ++c) {
            BackupReport br = (BackupReport)cached.get(c);
            if (br.getHost_id() != host_id) continue;
            matches.add(br);
        }
        return matches;
    }

    @Override
    public List<BackupReport> getRowsCopy() throws IOException, SQLException {
        ArrayList<BackupReport> list = new ArrayList<BackupReport>();
        this.getObjects(true, list, AoservProtocol.CommandId.GET_TABLE, new Object[]{Table.TableId.BACKUP_REPORTS});
        return list;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BACKUP_REPORTS;
    }

    @Override
    protected BackupReport getUniqueRowImpl(int col, Object value) throws IOException, SQLException {
        if (col == 0) {
            return this.get(value);
        }
        throw new IllegalArgumentException("Not a unique column: " + col);
    }
}

