/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoapps.hodgepodge.io.BitRateProvider;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.HostAddress;
import com.aoapps.net.InetAddress;
import com.aoapps.net.Port;
import com.aoapps.net.Protocol;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.backup.BackupPartition;
import com.aoindustries.aoserv.client.backup.BackupRetention;
import com.aoindustries.aoserv.client.backup.FileReplicationLog;
import com.aoindustries.aoserv.client.backup.FileReplicationSchedule;
import com.aoindustries.aoserv.client.backup.FileReplicationSetting;
import com.aoindustries.aoserv.client.backup.MysqlReplication;
import com.aoindustries.aoserv.client.linux.LinuxId;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public final class FileReplication
extends CachedObjectIntegerKey<FileReplication>
implements BitRateProvider {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_SERVER = 1;
    static final String COLUMN_SERVER_name = "server";
    static final String COLUMN_BACKUP_PARTITION_name = "backup_partition";
    private int server;
    private int backupPartition;
    private Long maxBitRate;
    private boolean useCompression;
    private short retention;
    private HostAddress connectAddress;
    private InetAddress connectFrom;
    private boolean enabled;
    private LinuxId quotaGid;

    @Deprecated
    public FileReplication() {
    }

    public int addFailoverFileLog(long startTime, long endTime, int scanned, int updated, long bytes, boolean isSuccessful) throws IOException, SQLException {
        return this.table.getConnector().getBackup().getFileReplicationLog().addFailoverFileLog(this, startTime, endTime, scanned, updated, bytes, isSuccessful);
    }

    public Long getBitRate() {
        return this.maxBitRate;
    }

    public void setBitRate(Long bitRate) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_FAILOVER_FILE_REPLICATION_BIT_RATE, this.pkey, bitRate == null ? -1L : bitRate);
    }

    public int getBlockSize() {
        return 4096;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.server;
            }
            case 2: {
                return this.backupPartition;
            }
            case 3: {
                return this.maxBitRate;
            }
            case 4: {
                return this.useCompression;
            }
            case 5: {
                return this.retention;
            }
            case 6: {
                return this.connectAddress;
            }
            case 7: {
                return this.connectFrom;
            }
            case 8: {
                return this.enabled;
            }
            case 9: {
                return this.quotaGid;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public List<FileReplicationSchedule> getFailoverFileSchedules() throws IOException, SQLException {
        return this.table.getConnector().getBackup().getFileReplicationSchedule().getFailoverFileSchedules(this);
    }

    public Host getHost() throws SQLException, IOException {
        Host se = this.table.getConnector().getNet().getHost().get(this.server);
        if (se == null) {
            throw new SQLException("Unable to find Host: " + this.server);
        }
        return se;
    }

    public BackupPartition getBackupPartition() throws SQLException, IOException {
        return this.table.getConnector().getBackup().getBackupPartition().get(this.backupPartition);
    }

    public List<FileReplicationLog> getFailoverFileLogs(int maxRows) throws IOException, SQLException {
        return this.table.getConnector().getBackup().getFileReplicationLog().getFailoverFileLogs(this, maxRows);
    }

    public List<MysqlReplication> getFailoverMysqlReplications() throws IOException, SQLException {
        return this.table.getConnector().getBackup().getMysqlReplication().getFailoverMysqlReplications(this);
    }

    public boolean getUseCompression() {
        return this.useCompression;
    }

    public BackupRetention getRetention() throws SQLException, IOException {
        BackupRetention br = this.table.getConnector().getBackup().getBackupRetention().get(this.retention);
        if (br == null) {
            throw new SQLException("Unable to find BackupRetention: " + this.retention);
        }
        return br;
    }

    public HostAddress getConnectAddress() {
        return this.connectAddress;
    }

    public InetAddress getConnectFrom() {
        return this.connectFrom;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public LinuxId getQuotaGid() {
        return this.quotaGid;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.FAILOVER_FILE_REPLICATIONS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.server = result.getInt(pos++);
            this.backupPartition = result.getInt(pos++);
            long maxBitRateLong = result.getLong(pos++);
            this.maxBitRate = result.wasNull() ? null : Long.valueOf(maxBitRateLong);
            this.useCompression = result.getBoolean(pos++);
            this.retention = result.getShort(pos++);
            this.connectAddress = HostAddress.valueOf((String)result.getString(pos++));
            this.connectFrom = InetAddress.valueOf((String)result.getString(pos++));
            this.enabled = result.getBoolean(pos++);
            int i = result.getInt(pos++);
            this.quotaGid = result.wasNull() ? null : LinuxId.valueOf(i);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.server = in.readCompressedInt();
            this.backupPartition = in.readCompressedInt();
            long maxBitRateLong = in.readLong();
            this.maxBitRate = maxBitRateLong == -1L ? null : Long.valueOf(maxBitRateLong);
            this.useCompression = in.readBoolean();
            this.retention = in.readShort();
            this.connectAddress = (HostAddress)InternUtils.intern((Internable)HostAddress.valueOf((String)in.readNullUTF()));
            this.connectFrom = (InetAddress)InternUtils.intern((Internable)InetAddress.valueOf((String)in.readNullUTF()));
            this.enabled = in.readBoolean();
            int i = in.readCompressedInt();
            this.quotaGid = i == -1 ? null : LinuxId.valueOf(i);
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getHost().toStringImpl() + "->" + this.getBackupPartition().toStringImpl();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.server);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeCompressedInt(149);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_31) >= 0) {
            out.writeCompressedInt(this.backupPartition);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_105) >= 0 && protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_61) <= 0) {
            int maxBitRateInt;
            if (this.maxBitRate == null) {
                maxBitRateInt = -1;
            } else if (this.maxBitRate > Integer.MAX_VALUE) {
                maxBitRateInt = Integer.MAX_VALUE;
            } else {
                if (this.maxBitRate < 0L) {
                    throw new IOException("Illegal bit rate: " + this.maxBitRate);
                }
                maxBitRateInt = this.maxBitRate.intValue();
            }
            out.writeInt(maxBitRateInt);
        } else if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_62) >= 0) {
            out.writeLong(this.maxBitRate == null ? -1L : this.maxBitRate);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeLong(-1L);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_9) >= 0) {
            out.writeBoolean(this.useCompression);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_13) >= 0) {
            out.writeShort((int)this.retention);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_14) >= 0) {
            out.writeNullUTF(Objects.toString(this.connectAddress, null));
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_22) >= 0) {
            out.writeNullUTF(Objects.toString(this.connectFrom, null));
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_15) >= 0) {
            out.writeBoolean(this.enabled);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_17) >= 0 && protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeUTF("/var/backup");
            out.writeBoolean(false);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_31) >= 0) {
            out.writeCompressedInt(this.quotaGid == null ? -1 : this.quotaGid.getId());
        }
    }

    public int addFileBackupSetting(String path, boolean backupEnabled, boolean required) throws IOException, SQLException {
        return this.table.getConnector().getBackup().getFileReplicationSetting().addFileBackupSetting(this, path, backupEnabled, required);
    }

    public FileReplicationSetting getFileBackupSetting(String path) throws IOException, SQLException {
        return this.table.getConnector().getBackup().getFileReplicationSetting().getFileBackupSetting(this, path);
    }

    public List<FileReplicationSetting> getFileBackupSettings() throws IOException, SQLException {
        return this.table.getConnector().getBackup().getFileReplicationSetting().getFileBackupSettings(this);
    }

    public void setFailoverFileSchedules(List<Short> hours, List<Short> minutes) throws IOException, SQLException {
        this.table.getConnector().getBackup().getFileReplicationSchedule().setFailoverFileSchedules(this, hours, minutes);
    }

    public void setFileBackupSettings(List<String> paths, List<Boolean> backupEnableds, List<Boolean> requireds) throws IOException, SQLException {
        this.table.getConnector().getBackup().getFileReplicationSetting().setFileBackupSettings(this, paths, backupEnableds, requireds);
    }

    public Server.DaemonAccess requestReplicationDaemonAccess() throws IOException, SQLException {
        return this.table.getConnector().requestResult(true, AoservProtocol.CommandId.REQUEST_REPLICATION_DAEMON_ACCESS, new AoservConnector.ResultRequest<Server.DaemonAccess>(){
            private Server.DaemonAccess daemonAccess;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(FileReplication.this.pkey);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code == 1) {
                    try {
                        this.daemonAccess = new Server.DaemonAccess(in.readUTF(), HostAddress.valueOf((String)in.readUTF()), Port.valueOf((int)in.readCompressedInt(), (Protocol)Protocol.TCP), in.readLong());
                    }
                    catch (ValidationException e) {
                        throw new IOException(e);
                    }
                } else {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
            }

            @Override
            public Server.DaemonAccess afterRelease() {
                return this.daemonAccess;
            }
        });
    }

    public Activity getActivity() throws IOException, SQLException {
        return this.table.getConnector().requestResult(true, AoservProtocol.CommandId.GET_FAILOVER_FILE_REPLICATION_ACTIVITY, new AoservConnector.ResultRequest<Activity>(){
            private Activity activity;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(FileReplication.this.pkey);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.activity = new Activity(in.readLong(), in.readUTF());
            }

            @Override
            public Activity afterRelease() {
                return this.activity;
            }
        });
    }

    public static class Activity {
        private final long timeSince;
        private final String message;

        private Activity(long timeSince, String message) {
            this.timeSince = timeSince;
            this.message = message;
        }

        public long getTimeSince() {
            return this.timeSince;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

