/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservObject;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.SingleTableObject;
import com.aoindustries.aoserv.client.backup.FileReplication;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public final class FileReplicationLog
extends AoservObject<Integer, FileReplicationLog>
implements SingleTableObject<Integer, FileReplicationLog> {
    static final int COLUMN_PKEY = 0;
    static final String COLUMN_REPLICATION_name = "replication";
    static final String COLUMN_END_TIME_name = "end_time";
    private AoservTable<Integer, FileReplicationLog> table;
    private int pkey;
    private int replication;
    private UnmodifiableTimestamp startTime;
    private UnmodifiableTimestamp endTime;
    private int scanned;
    private int updated;
    private long bytes;
    private boolean isSuccessful;

    @Deprecated
    public FileReplicationLog() {
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof FileReplicationLog && ((FileReplicationLog)obj).pkey == this.pkey;
    }

    public long getBytes() {
        return this.bytes;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.replication;
            }
            case 2: {
                return this.startTime;
            }
            case 3: {
                return this.endTime;
            }
            case 4: {
                return this.scanned;
            }
            case 5: {
                return this.updated;
            }
            case 6: {
                return this.bytes;
            }
            case 7: {
                return this.isSuccessful;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public UnmodifiableTimestamp getStartTime() {
        return this.startTime;
    }

    public UnmodifiableTimestamp getEndTime() {
        return this.endTime;
    }

    public int getPkey() {
        return this.pkey;
    }

    @Override
    public Integer getKey() {
        return this.pkey;
    }

    public int getScanned() {
        return this.scanned;
    }

    public FileReplication getFailoverFileReplication() throws SQLException, IOException {
        FileReplication ffr = this.table.getConnector().getBackup().getFileReplication().get(this.replication);
        if (ffr == null) {
            throw new SQLException("Unable to find FailoverFileReplication: " + this.replication);
        }
        return ffr;
    }

    @Override
    public AoservTable<Integer, FileReplicationLog> getTable() {
        return this.table;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.FAILOVER_FILE_LOG;
    }

    public int getUpdated() {
        return this.updated;
    }

    @Override
    public int hashCode() {
        return this.pkey;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.replication = result.getInt(2);
        this.startTime = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(3));
        this.endTime = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(4));
        this.scanned = result.getInt(5);
        this.updated = result.getInt(6);
        this.bytes = result.getLong(7);
        this.isSuccessful = result.getBoolean(8);
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.replication = in.readCompressedInt();
        this.startTime = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
        this.endTime = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
        this.scanned = in.readCompressedInt();
        this.updated = in.readCompressedInt();
        this.bytes = in.readLong();
        this.isSuccessful = in.readBoolean();
    }

    @Override
    public void setTable(AoservTable<Integer, FileReplicationLog> table) {
        if (this.table != null) {
            throw new IllegalStateException("table already set");
        }
        this.table = table;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.replication);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.startTime.getTime());
            out.writeLong(this.endTime.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.startTime, (DataOutputStream)out);
            SQLStreamables.writeTimestamp((Timestamp)this.endTime, (DataOutputStream)out);
        }
        out.writeCompressedInt(this.scanned);
        out.writeCompressedInt(this.updated);
        out.writeLong(this.bytes);
        out.writeBoolean(this.isSuccessful);
    }
}

