/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.backup.FileReplication;
import com.aoindustries.aoserv.client.backup.FileReplicationLog;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class FileReplicationLogTable
extends AoservTable<Integer, FileReplicationLog> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("end_time", false), new AoservTable.OrderBy("replication.server.package.name", true), new AoservTable.OrderBy("replication.server.name", true), new AoservTable.OrderBy("replication.backup_partition.ao_server.hostname", true), new AoservTable.OrderBy("replication.backup_partition.path", true)};

    FileReplicationLogTable(AoservConnector connector) {
        super(connector, FileReplicationLog.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addFailoverFileLog(FileReplication replication, long startTime, long endTime, int scanned, int updated, long bytes, boolean isSuccessful) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.FAILOVER_FILE_LOG, replication.getPkey(), startTime, endTime, scanned, updated, bytes, isSuccessful});
    }

    @Override
    @Deprecated
    public FileReplicationLog get(Object pkey) throws IOException, SQLException {
        if (pkey == null) {
            return null;
        }
        return this.get((Integer)pkey);
    }

    public FileReplicationLog get(int pkey) throws IOException, SQLException {
        return (FileReplicationLog)this.getObject(true, AoservProtocol.CommandId.GET_OBJECT, new Object[]{Table.TableId.FAILOVER_FILE_LOG, pkey});
    }

    @Override
    public List<FileReplicationLog> getRowsCopy() throws IOException, SQLException {
        ArrayList<FileReplicationLog> list = new ArrayList<FileReplicationLog>();
        this.getObjects(true, list, AoservProtocol.CommandId.GET_TABLE, new Object[]{Table.TableId.FAILOVER_FILE_LOG});
        return list;
    }

    List<FileReplicationLog> getFailoverFileLogs(FileReplication replication, int maxRows) throws IOException, SQLException {
        ArrayList<FileReplicationLog> list = new ArrayList<FileReplicationLog>();
        this.getObjectsNoProgress(true, list, AoservProtocol.CommandId.GET_FAILOVER_FILE_LOGS_FOR_REPLICATION, replication.getPkey(), maxRows);
        return list;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.FAILOVER_FILE_LOG;
    }

    @Override
    protected FileReplicationLog getUniqueRowImpl(int col, Object value) throws IOException, SQLException {
        if (col == 0) {
            return this.get(value);
        }
        throw new IllegalArgumentException("Not a unique column: " + col);
    }
}

