/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.backup.FileReplication;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class FileReplicationSchedule
extends CachedObjectIntegerKey<FileReplicationSchedule> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_REPLICATION = 1;
    static final String COLUMN_REPLICATION_name = "replication";
    static final String COLUMN_HOUR_name = "hour";
    static final String COLUMN_MINUTE_name = "minute";
    private int replication;
    private short hour;
    private short minute;
    private boolean enabled;

    @Deprecated
    public FileReplicationSchedule() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.replication;
            }
            case 2: {
                return this.hour;
            }
            case 3: {
                return this.minute;
            }
            case 4: {
                return this.enabled;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public FileReplication getFailoverFileReplication() throws SQLException, IOException {
        FileReplication ffr = this.table.getConnector().getBackup().getFileReplication().get(this.replication);
        if (ffr == null) {
            throw new SQLException("Unable to find FailoverFileReplication: " + this.replication);
        }
        return ffr;
    }

    public short getHour() {
        return this.hour;
    }

    public short getMinute() {
        return this.minute;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.FAILOVER_FILE_SCHEDULE;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.replication = result.getInt(2);
        this.hour = result.getShort(3);
        this.minute = result.getShort(4);
        this.enabled = result.getBoolean(5);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.replication = in.readCompressedInt();
        this.hour = in.readShort();
        this.minute = in.readShort();
        this.enabled = in.readBoolean();
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFailoverFileReplication().toStringImpl());
        sb.append('@');
        if (this.hour < 10) {
            sb.append('0');
        }
        sb.append(this.hour);
        sb.append(':');
        if (this.minute < 10) {
            sb.append('0');
        }
        sb.append(this.minute);
        return sb.toString();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.replication);
        out.writeShort((int)this.hour);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_31) >= 0) {
            out.writeShort((int)this.minute);
        }
        out.writeBoolean(this.enabled);
    }
}

