/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.backup.FileReplication;
import com.aoindustries.aoserv.client.backup.FileReplicationSchedule;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public final class FileReplicationScheduleTable
extends CachedTableIntegerKey<FileReplicationSchedule> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("replication.server.package.name", true), new AoservTable.OrderBy("replication.server.name", true), new AoservTable.OrderBy("replication.backup_partition.ao_server.hostname", true), new AoservTable.OrderBy("replication.backup_partition.path", true), new AoservTable.OrderBy("hour", true), new AoservTable.OrderBy("minute", true)};

    FileReplicationScheduleTable(AoservConnector connector) {
        super(connector, FileReplicationSchedule.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    List<FileReplicationSchedule> getFailoverFileSchedules(FileReplication replication) throws IOException, SQLException {
        return this.getIndexedRows(1, replication.getPkey());
    }

    @Override
    public FileReplicationSchedule get(int pkey) throws IOException, SQLException {
        return (FileReplicationSchedule)this.getUniqueRow(0, pkey);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.FAILOVER_FILE_SCHEDULE;
    }

    void setFailoverFileSchedules(final FileReplication ffr, final List<Short> hours, final List<Short> minutes) throws IOException, SQLException {
        if (hours.size() != minutes.size()) {
            throw new IllegalArgumentException("hours.size() != minutes.size(): " + hours.size() + " != " + minutes.size());
        }
        this.connector.requestUpdate(true, AoservProtocol.CommandId.SET_FAILOVER_FILE_SCHEDULES, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(ffr.getPkey());
                int size = hours.size();
                out.writeCompressedInt(size);
                for (int c = 0; c < size; ++c) {
                    out.writeShort((int)((Short)hours.get(c)).shortValue());
                    out.writeShort((int)((Short)minutes.get(c)).shortValue());
                }
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                FileReplicationScheduleTable.this.connector.tablesUpdated(this.invalidateList);
            }
        });
    }
}

