/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.backup.FileReplication;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class FileReplicationSetting
extends CachedObjectIntegerKey<FileReplicationSetting>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_REPLICATION = 1;
    static final String COLUMN_REPLICATION_name = "replication";
    static final String COLUMN_PATH_name = "path";
    private int replication;
    private String path;
    private boolean backupEnabled;
    private boolean required;

    @Deprecated
    public FileReplicationSetting() {
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.replication;
            }
            case 2: {
                return this.path;
            }
            case 3: {
                return this.backupEnabled;
            }
            case 4: {
                return this.required;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public FileReplication getReplication() throws SQLException, IOException {
        FileReplication ffr = this.table.getConnector().getBackup().getFileReplication().get(this.replication);
        if (ffr == null) {
            throw new SQLException("Unable to find FailoverFileReplication: " + this.replication);
        }
        return ffr;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getBackupEnabled() {
        return this.backupEnabled;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.FILE_BACKUP_SETTINGS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.replication = result.getInt(2);
        this.path = result.getString(3);
        this.backupEnabled = result.getBoolean(4);
        this.required = result.getBoolean(5);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.replication = in.readCompressedInt();
        this.path = in.readUTF();
        this.backupEnabled = in.readBoolean();
        this.required = in.readBoolean();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.FILE_BACKUP_SETTINGS, this.pkey});
    }

    public void setSettings(String path, boolean backupEnabled, boolean required) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_FILE_BACKUP_SETTINGS, this.pkey, path, backupEnabled, required);
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_31) >= 0) {
            out.writeCompressedInt(this.replication);
        } else {
            out.writeCompressedInt(-1);
        }
        out.writeUTF(this.path);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_31) >= 0) {
            out.writeBoolean(this.backupEnabled);
        } else {
            out.writeCompressedInt(308);
            out.writeShort(this.backupEnabled ? 1 : 0);
            out.writeShort(7);
            out.writeBoolean(this.backupEnabled);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_62) >= 0) {
            out.writeBoolean(this.required);
        }
    }
}

