/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.backup.FileReplication;
import com.aoindustries.aoserv.client.backup.FileReplicationSetting;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class FileReplicationSettingTable
extends CachedTableIntegerKey<FileReplicationSetting> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("replication.server.package.name", true), new AoservTable.OrderBy("replication.server.name", true), new AoservTable.OrderBy("replication.backup_partition.ao_server.hostname", true), new AoservTable.OrderBy("replication.backup_partition.path", true), new AoservTable.OrderBy("path", true)};

    FileReplicationSettingTable(AoservConnector connector) {
        super(connector, FileReplicationSetting.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addFileBackupSetting(FileReplication replication, String path, boolean backupEnabled, boolean required) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.FILE_BACKUP_SETTINGS, replication.getPkey(), path, backupEnabled, required});
    }

    @Override
    public FileReplicationSetting get(int pkey) throws IOException, SQLException {
        return (FileReplicationSetting)this.getUniqueRow(0, pkey);
    }

    FileReplicationSetting getFileBackupSetting(FileReplication ffr, String path) throws IOException, SQLException {
        for (FileReplicationSetting fbs : this.getFileBackupSettings(ffr)) {
            if (!fbs.getPath().equals(path)) continue;
            return fbs;
        }
        return null;
    }

    List<FileReplicationSetting> getFileBackupSettings(FileReplication ffr) throws IOException, SQLException {
        return this.getIndexedRows(1, ffr.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.FILE_BACKUP_SETTINGS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_file_backup_setting")) {
            if (Aosh.checkParamCount("add_file_backup_setting", args, 4, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addFileBackupSetting(Aosh.parseInt(args[1], "replication"), args[2], Aosh.parseBoolean(args[3], "backup_enabled"), Aosh.parseBoolean(args[4], "required")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_file_backup_setting")) {
            if (Aosh.checkParamCount("remove_file_backup_setting", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeFileBackupSetting(Aosh.parseInt(args[1], "replication"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_file_backup_setting")) {
            if (Aosh.checkParamCount("set_file_backup_setting", args, 4, (PrintWriter)err)) {
                this.connector.getSimpleClient().setFileBackupSetting(Aosh.parseInt(args[1], "replication"), args[2], Aosh.parseBoolean(args[3], "backup_enabled"), Aosh.parseBoolean(args[4], "required"));
            }
            return true;
        }
        return false;
    }

    void setFileBackupSettings(final FileReplication ffr, final List<String> paths, final List<Boolean> backupEnableds, final List<Boolean> requireds) throws IOException, SQLException {
        if (paths.size() != backupEnableds.size()) {
            throw new IllegalArgumentException("paths.size() != backupEnableds.size(): " + paths.size() + " != " + backupEnableds.size());
        }
        if (paths.size() != requireds.size()) {
            throw new IllegalArgumentException("paths.size() != requireds.size(): " + paths.size() + " != " + requireds.size());
        }
        this.connector.requestUpdate(true, AoservProtocol.CommandId.SET_FILE_BACKUP_SETTINGS_ALL_AT_ONCE, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(ffr.getPkey());
                int size = paths.size();
                out.writeCompressedInt(size);
                for (int c = 0; c < size; ++c) {
                    out.writeUTF((String)paths.get(c));
                    out.writeBoolean(((Boolean)backupEnableds.get(c)).booleanValue());
                    out.writeBoolean(((Boolean)requireds.get(c)).booleanValue());
                }
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                FileReplicationSettingTable.this.connector.tablesUpdated(this.invalidateList);
            }
        });
    }
}

