/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.Strings;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.backup.FileReplication;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class FileReplicationTable
extends CachedTableIntegerKey<FileReplication> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("server.package.name", true), new AoservTable.OrderBy("server.name", true), new AoservTable.OrderBy("backup_partition.ao_server.hostname", true), new AoservTable.OrderBy("backup_partition.path", true)};

    FileReplicationTable(AoservConnector connector) {
        super(connector, FileReplication.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public List<FileReplication> getFailoverFileReplications(Host server) throws IOException, SQLException {
        return this.getIndexedRows(1, server.getPkey());
    }

    @Override
    public FileReplication get(int pkey) throws IOException, SQLException {
        return (FileReplication)this.getUniqueRow(0, pkey);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.FAILOVER_FILE_REPLICATIONS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("get_failover_file_replication_activity")) {
            if (Aosh.checkParamCount("get_failover_file_replication_activity", args, 3, (PrintWriter)err)) {
                FileReplication.Activity activity = this.connector.getSimpleClient().getFailoverFileReplicationActivity(args[1], args[2], args[3]);
                long timeSince = activity.getTimeSince();
                if (timeSince == -1L) {
                    out.println("No activity available");
                } else {
                    out.println(Strings.getDecimalTimeLengthString((long)timeSince));
                    out.println(activity.getMessage());
                }
                out.flush();
            }
            return true;
        }
        return false;
    }
}

