/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.backup.FileReplication;
import com.aoindustries.aoserv.client.monitoring.AlertLevel;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class MysqlReplication
extends CachedObjectIntegerKey<MysqlReplication> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_AO_SERVER = 1;
    static final int COLUMN_REPLICATION = 2;
    static final int COLUMN_MYSQL_SERVER = 3;
    static final String COLUMN_AO_SERVER_name = "ao_server";
    static final String COLUMN_REPLICATION_name = "replication";
    static final String COLUMN_MYSQL_SERVER_name = "mysql_server";
    private int aoServer;
    private int replication;
    private int mysqlServer;
    private int monitoringSecondsBehindLow;
    private int monitoringSecondsBehindMedium;
    private int monitoringSecondsBehindHigh;
    private int monitoringSecondsBehindCritical;
    private AlertLevel maxAlertLevel;

    @Deprecated
    public MysqlReplication() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.aoServer == -1 ? null : Integer.valueOf(this.aoServer);
            }
            case 2: {
                return this.replication == -1 ? null : Integer.valueOf(this.replication);
            }
            case 3: {
                return this.mysqlServer;
            }
            case 4: {
                return this.monitoringSecondsBehindLow == -1 ? null : Integer.valueOf(this.monitoringSecondsBehindLow);
            }
            case 5: {
                return this.monitoringSecondsBehindMedium == -1 ? null : Integer.valueOf(this.monitoringSecondsBehindMedium);
            }
            case 6: {
                return this.monitoringSecondsBehindHigh == -1 ? null : Integer.valueOf(this.monitoringSecondsBehindHigh);
            }
            case 7: {
                return this.monitoringSecondsBehindCritical == -1 ? null : Integer.valueOf(this.monitoringSecondsBehindCritical);
            }
            case 8: {
                return this.maxAlertLevel.name();
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public com.aoindustries.aoserv.client.linux.Server getLinuxServer() throws SQLException, IOException {
        if (this.aoServer == -1) {
            return null;
        }
        com.aoindustries.aoserv.client.linux.Server ao = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (ao == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return ao;
    }

    public FileReplication getFailoverFileReplication() throws SQLException, IOException {
        if (this.replication == -1) {
            return null;
        }
        FileReplication ffr = this.table.getConnector().getBackup().getFileReplication().get(this.replication);
        if (ffr == null) {
            throw new SQLException("Unable to find FailoverFileReplication: " + this.replication);
        }
        return ffr;
    }

    public Server getMysqlServer() throws IOException, SQLException {
        Server ms = this.table.getConnector().getMysql().getServer().get(this.mysqlServer);
        if (ms == null) {
            throw new SQLException("Unable to find MysqlServer: " + this.mysqlServer);
        }
        return ms;
    }

    public int getMonitoringSecondsBehindLow() {
        return this.monitoringSecondsBehindLow;
    }

    public int getMonitoringSecondsBehindMedium() {
        return this.monitoringSecondsBehindMedium;
    }

    public int getMonitoringSecondsBehindHigh() {
        return this.monitoringSecondsBehindHigh;
    }

    public int getMonitoringSecondsBehindCritical() {
        return this.monitoringSecondsBehindCritical;
    }

    public boolean isMonitoringEnabled() throws SQLException, IOException {
        com.aoindustries.aoserv.client.linux.Server linuxServer = this.aoServer != -1 ? this.getLinuxServer() : this.getFailoverFileReplication().getBackupPartition().getLinuxServer();
        return linuxServer.getHost().isMonitoringEnabled();
    }

    public AlertLevel getMaxAlertLevel() {
        return this.maxAlertLevel;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.FAILOVER_MYSQL_REPLICATIONS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.aoServer = result.getInt(pos++);
        if (result.wasNull()) {
            this.aoServer = -1;
        }
        this.replication = result.getInt(pos++);
        if (result.wasNull()) {
            this.replication = -1;
        }
        this.mysqlServer = result.getInt(pos++);
        this.monitoringSecondsBehindLow = result.getInt(pos++);
        if (result.wasNull()) {
            this.monitoringSecondsBehindLow = -1;
        }
        this.monitoringSecondsBehindMedium = result.getInt(pos++);
        if (result.wasNull()) {
            this.monitoringSecondsBehindMedium = -1;
        }
        this.monitoringSecondsBehindHigh = result.getInt(pos++);
        if (result.wasNull()) {
            this.monitoringSecondsBehindHigh = -1;
        }
        this.monitoringSecondsBehindCritical = result.getInt(pos++);
        if (result.wasNull()) {
            this.monitoringSecondsBehindCritical = -1;
        }
        this.maxAlertLevel = AlertLevel.valueOf(result.getString(pos++));
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.aoServer = in.readCompressedInt();
        this.replication = in.readCompressedInt();
        this.mysqlServer = in.readCompressedInt();
        this.monitoringSecondsBehindLow = in.readCompressedInt();
        this.monitoringSecondsBehindMedium = in.readCompressedInt();
        this.monitoringSecondsBehindHigh = in.readCompressedInt();
        this.monitoringSecondsBehindCritical = in.readCompressedInt();
        this.maxAlertLevel = AlertLevel.valueOf(in.readCompressedUTF());
    }

    @Override
    public String toStringImpl() throws IOException, SQLException {
        if (this.aoServer != -1) {
            return this.getMysqlServer().toStringImpl() + "->" + this.getLinuxServer().toStringImpl();
        }
        return this.getMysqlServer().toStringImpl() + "->" + this.getFailoverFileReplication().toStringImpl();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_59) >= 0) {
            out.writeCompressedInt(this.aoServer);
        }
        out.writeCompressedInt(this.replication);
        out.writeCompressedInt(this.mysqlServer);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_56) >= 0) {
            out.writeCompressedInt(this.monitoringSecondsBehindLow);
            out.writeCompressedInt(this.monitoringSecondsBehindMedium);
            out.writeCompressedInt(this.monitoringSecondsBehindHigh);
            out.writeCompressedInt(this.monitoringSecondsBehindCritical);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_74) >= 0) {
            out.writeCompressedUTF(this.maxAlertLevel.name());
        }
    }

    public SlaveStatus getSlaveStatus() throws IOException, SQLException {
        return this.table.getConnector().requestResult(true, AoservProtocol.CommandId.GET_MYSQL_SLAVE_STATUS, new AoservConnector.ResultRequest<SlaveStatus>(){
            private SlaveStatus result;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(MysqlReplication.this.pkey);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code == 0) {
                    this.result = new SlaveStatus(in.readNullUTF(), in.readNullUTF(), in.readNullUTF(), in.readNullUTF(), in.readNullUTF(), in.readNullUTF(), in.readNullUTF(), in.readNullUTF(), in.readNullUTF(), in.readNullUTF(), in.readNullUTF(), in.readNullUTF(), in.readNullUTF(), in.readNullUTF());
                } else if (code == 1) {
                    this.result = null;
                } else {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
            }

            @Override
            public SlaveStatus afterRelease() {
                return this.result;
            }
        });
    }

    public static final class SlaveStatus {
        private final String slaveIoState;
        private final String masterLogFile;
        private final String readMasterLogPos;
        private final String relayLogFile;
        private final String relayLogPos;
        private final String relayMasterLogFile;
        private final String slaveIoRunning;
        private final String slaveSqlRunning;
        private final String lastErrno;
        private final String lastError;
        private final String skipCounter;
        private final String execMasterLogPos;
        private final String relayLogSpace;
        private final String secondsBehindMaster;

        public SlaveStatus(String slaveIoState, String masterLogFile, String readMasterLogPos, String relayLogFile, String relayLogPos, String relayMasterLogFile, String slaveIoRunning, String slaveSqlRunning, String lastErrno, String lastError, String skipCounter, String execMasterLogPos, String relayLogSpace, String secondsBehindMaster) {
            this.slaveIoState = slaveIoState;
            this.masterLogFile = masterLogFile;
            this.readMasterLogPos = readMasterLogPos;
            this.relayLogFile = relayLogFile;
            this.relayLogPos = relayLogPos;
            this.relayMasterLogFile = relayMasterLogFile;
            this.slaveIoRunning = slaveIoRunning;
            this.slaveSqlRunning = slaveSqlRunning;
            this.lastErrno = lastErrno;
            this.lastError = lastError;
            this.skipCounter = skipCounter;
            this.execMasterLogPos = execMasterLogPos;
            this.relayLogSpace = relayLogSpace;
            this.secondsBehindMaster = secondsBehindMaster;
        }

        public String getSlaveIoState() {
            return this.slaveIoState;
        }

        public String getMasterLogFile() {
            return this.masterLogFile;
        }

        public String getReadMasterLogPos() {
            return this.readMasterLogPos;
        }

        public String getRelayLogFile() {
            return this.relayLogFile;
        }

        public String getRelayLogPos() {
            return this.relayLogPos;
        }

        public String getRelayMasterLogFile() {
            return this.relayMasterLogFile;
        }

        public String getSlaveIoRunning() {
            return this.slaveIoRunning;
        }

        public String getSlaveSqlRunning() {
            return this.slaveSqlRunning;
        }

        public String getLastErrno() {
            return this.lastErrno;
        }

        public String getLastError() {
            return this.lastError;
        }

        public String getSkipCounter() {
            return this.skipCounter;
        }

        public String getExecMasterLogPos() {
            return this.execMasterLogPos;
        }

        public String getRelayLogSpace() {
            return this.relayLogSpace;
        }

        public String getSecondsBehindMaster() {
            return this.secondsBehindMaster;
        }
    }
}

